/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CipherSuite;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContextImpl;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    TlsServerContextImpl tlsServerContext = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsCredentials serverCredentials = null;
    protected CertificateRequest certificateRequest = null;
    protected TlsHandshakeHash prepareFinishHash = null;

    public TlsServerProtocol() {
    }

    public TlsServerProtocol(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("'accept' can only be called once");
        }
        this.tlsServer = tlsServer;
        this.securityParameters = new SecurityParameters();
        this.securityParameters.entity = 0;
        this.tlsServerContext = new TlsServerContextImpl(tlsServer.getCrypto(), this.securityParameters);
        this.securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(tlsServer.shouldUseGMTUnixTime(), this.tlsServerContext);
        this.tlsServer.init(this.tlsServerContext);
        this.recordStream.init(this.tlsServerContext);
        this.recordStream.setRestrictReadVersion(false);
        this.blockForHandshake();
    }

    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.keyExchange = null;
        this.serverCredentials = null;
        this.certificateRequest = null;
        this.prepareFinishHash = null;
    }

    protected TlsContext getContext() {
        return this.tlsServerContext;
    }

    AbstractTlsContext getContextAdmin() {
        return this.tlsServerContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    protected void handleHandshakeMessage(short s, ByteArrayInputStream byteArrayInputStream) throws IOException {
        block0 : switch (s) {
            case 1: {
                switch (this.connection_state) {
                    case 0: {
                        Object object;
                        this.receiveClientHelloMessage(byteArrayInputStream);
                        this.connection_state = 1;
                        this.invalidateSession();
                        this.tlsSession = TlsUtils.importSession(TlsUtils.EMPTY_BYTES, null);
                        this.sessionParameters = null;
                        this.sendServerHelloMessage();
                        this.connection_state = (short)2;
                        this.recordStream.notifyHelloComplete();
                        Vector vector = this.tlsServer.getServerSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                        }
                        this.connection_state = (short)3;
                        this.keyExchange = this.tlsServer.getKeyExchange();
                        this.keyExchange.init(this.getContext());
                        this.serverCredentials = TlsServerProtocol.validateCredentials(this.tlsServer.getCredentials());
                        Certificate certificate = null;
                        if (this.serverCredentials == null) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(this.serverCredentials);
                            certificate = this.serverCredentials.getCertificate();
                            this.sendCertificateMessage(certificate);
                        }
                        this.connection_state = (short)4;
                        if (certificate == null || certificate.isEmpty()) {
                            this.allowCertificateStatus = false;
                        }
                        if (this.allowCertificateStatus && (object = this.tlsServer.getCertificateStatus()) != null) {
                            this.sendCertificateStatusMessage((CertificateStatus)object);
                        }
                        this.connection_state = (short)5;
                        object = this.keyExchange.generateServerKeyExchange();
                        if (object != null) {
                            this.sendServerKeyExchangeMessage((byte[])object);
                        }
                        this.connection_state = (short)6;
                        if (this.serverCredentials != null) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (this.certificateRequest != null) {
                                if (TlsUtils.isTLSv12(this.getContext()) != (this.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                                    throw new TlsFatalAlert(80);
                                }
                                this.certificateRequest = TlsUtils.validateCertificateRequest(this.certificateRequest, this.keyExchange);
                                this.sendCertificateRequestMessage(this.certificateRequest);
                                TlsUtils.trackHashAlgorithms(this.recordStream.getHandshakeHash(), this.certificateRequest.getSupportedSignatureAlgorithms());
                            }
                        }
                        this.connection_state = (short)7;
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)8;
                        boolean bl = false;
                        TlsUtils.sealHandshakeHash(this.getContext(), this.recordStream.getHandshakeHash(), bl);
                        break block0;
                    }
                    case 16: {
                        this.refuseRenegotiation();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 23: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(byteArrayInputStream));
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 11: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest == null) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateMessage(byteArrayInputStream);
                        this.connection_state = (short)10;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 16: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            if (TlsUtils.isTLSv12(this.getContext())) {
                                throw new TlsFatalAlert(10);
                            }
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
                    case 10: {
                        this.receiveClientKeyExchangeMessage(byteArrayInputStream);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 11: {
                        if (!this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateVerifyMessage(byteArrayInputStream);
                        this.connection_state = (short)12;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 11: {
                        if (this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 12: {
                        this.processFinishedMessage(byteArrayInputStream);
                        this.connection_state = (short)13;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                        }
                        this.connection_state = (short)14;
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        this.connection_state = (short)15;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleAlertWarningMessage(short s) throws IOException {
        super.handleAlertWarningMessage(s);
        switch (s) {
            case 41: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void notifyClientCertificate(Certificate certificate) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        if (this.peerCertificate != null) {
            throw new TlsFatalAlert(10);
        }
        this.peerCertificate = certificate;
        if (certificate.isEmpty()) {
            this.keyExchange.skipClientCredentials();
        } else {
            this.keyExchange.processClientCertificate(certificate);
        }
        this.tlsServer.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Certificate certificate = Certificate.parse(this.getContext(), byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        TlsContext tlsContext = this.getContext();
        DigitallySigned digitallySigned = DigitallySigned.parse(tlsContext, byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verifyCertificateVerify(tlsContext, this.certificateRequest, this.peerCertificate, digitallySigned, this.prepareFinishHash);
    }

    protected void receiveClientHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray;
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        this.recordStream.setWriteVersion(protocolVersion);
        if (protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray2 = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray3 = TlsUtils.readOpaque8(byteArrayInputStream);
        if (byArray3.length > 32) {
            throw new TlsFatalAlert(47);
        }
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n < 2 || (n & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        this.offeredCipherSuites = TlsUtils.readUint16Array(n / 2, byteArrayInputStream);
        short s = TlsUtils.readUint8(byteArrayInputStream);
        if (s < 1) {
            throw new TlsFatalAlert(47);
        }
        this.offeredCompressionMethods = TlsUtils.readUint8Array(s, byteArrayInputStream);
        this.clientExtensions = TlsServerProtocol.readExtensions(byteArrayInputStream);
        this.securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.clientExtensions);
        this.getContextAdmin().setClientVersion(protocolVersion);
        this.tlsServer.notifyClientVersion(protocolVersion);
        this.tlsServer.notifyFallback(Arrays.contains((int[])this.offeredCipherSuites, (int)22016));
        this.securityParameters.clientRandom = byArray2;
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        this.tlsServer.notifyOfferedCompressionMethods(this.offeredCompressionMethods);
        if (Arrays.contains((int[])this.offeredCipherSuites, (int)255)) {
            this.secure_renegotiation = true;
        }
        if ((byArray = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo)) != null) {
            this.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])byArray, (byte[])TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsServer.notifySecureRenegotiation(this.secure_renegotiation);
        if (this.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(this.clientExtensions);
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.keyExchange.processClientKeyExchange(byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        this.prepareFinishHash = this.recordStream.prepareToFinish();
        this.securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(this.prepareFinishHash);
        TlsServerProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
        this.recordStream.setPendingConnectionState(this.getPeer().getCompression(), this.getPeer().getCipher());
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(13);
        certificateRequest.encode(handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }

    protected void sendCertificateStatusMessage(CertificateStatus certificateStatus) throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(22);
        certificateStatus.encode(handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(4);
        newSessionTicket.encode(handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }

    protected void sendServerHelloMessage() throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(2);
        ProtocolVersion protocolVersion = this.tlsServer.getServerVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(this.getContext().getClientVersion())) {
            throw new TlsFatalAlert(80);
        }
        this.recordStream.setReadVersion(protocolVersion);
        this.recordStream.setWriteVersion(protocolVersion);
        this.recordStream.setRestrictReadVersion(true);
        this.getContextAdmin().setServerVersion(protocolVersion);
        TlsUtils.writeVersion(protocolVersion, handshakeMessage);
        handshakeMessage.write(this.securityParameters.serverRandom);
        TlsUtils.writeOpaque8(this.tlsSession.getSessionID(), handshakeMessage);
        int n = this.tlsServer.getSelectedCipherSuite();
        if (!Arrays.contains((int[])this.offeredCipherSuites, (int)n) || n == 0 || CipherSuite.isSCSV(n) || !TlsUtils.isValidCipherSuiteForVersion(n, this.getContext().getServerVersion())) {
            throw new TlsFatalAlert(80);
        }
        this.securityParameters.cipherSuite = n;
        short s = this.tlsServer.getSelectedCompressionMethod();
        if (!Arrays.contains((short[])this.offeredCompressionMethods, (short)s)) {
            throw new TlsFatalAlert(80);
        }
        this.securityParameters.compressionAlgorithm = s;
        TlsUtils.writeUint16(n, handshakeMessage);
        TlsUtils.writeUint8(s, (OutputStream)handshakeMessage);
        this.serverExtensions = this.tlsServer.getServerExtensions();
        if (this.secure_renegotiation) {
            boolean bl;
            byte[] byArray = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
            boolean bl2 = bl = null == byArray;
            if (bl) {
                this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (this.securityParameters.isExtendedMasterSecret()) {
            this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.serverExtensions);
        }
        if (this.serverExtensions != null) {
            this.securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(this.serverExtensions);
            this.securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(this.clientExtensions, this.serverExtensions, (short)80);
            this.securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(this.serverExtensions);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80);
            this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
            TlsServerProtocol.writeExtensions(handshakeMessage, this.serverExtensions);
        }
        this.securityParameters.prfAlgorithm = TlsServerProtocol.getPRFAlgorithm(this.getContext(), this.securityParameters.getCipherSuite());
        this.securityParameters.verifyDataLength = 12;
        this.applyMaxFragmentLengthExtension();
        handshakeMessage.writeToRecordStream();
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        byte[] byArray = new byte[4];
        TlsUtils.writeUint8((short)14, byArray, 0);
        TlsUtils.writeUint24(0, byArray, 1);
        this.writeHandshakeMessage(byArray, 0, byArray.length);
    }

    protected void sendServerKeyExchangeMessage(byte[] byArray) throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(12, byArray.length);
        handshakeMessage.write(byArray);
        handshakeMessage.writeToRecordStream();
    }

    protected boolean expectCertificateVerifyMessage() {
        return this.peerCertificate != null && !this.peerCertificate.isEmpty() && this.keyExchange.requiresCertificateVerify();
    }
}

