/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.pop3;

import gnu.inet.pop3.POP3Connection;
import gnu.mail.providers.pop3.POP3Message;
import gnu.mail.providers.pop3.POP3Store;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.UIDFolder;

public final class POP3Folder
extends Folder {
    boolean readonly = false;
    boolean open = false;
    int type;
    Folder inbox;
    List deleted;

    protected POP3Folder(Store store, int type) {
        super(store);
        this.type = type;
    }

    public String getName() {
        switch (this.type) {
            case 2: {
                return "/";
            }
            case 1: {
                return "INBOX";
            }
        }
        return "(Unknown)";
    }

    public String getFullName() {
        return this.getName();
    }

    public int getType() throws MessagingException {
        return this.type;
    }

    public boolean exists() throws MessagingException {
        return this.type == 1;
    }

    public boolean hasNewMessages() throws MessagingException {
        return this.getNewMessageCount() > 0;
    }

    public void open(int mode) throws MessagingException {
        switch (mode) {
            case 2: {
                this.readonly = false;
                this.deleted = new ArrayList();
                break;
            }
            case 1: {
                this.readonly = true;
            }
        }
        this.mode = mode;
        this.open = true;
        this.notifyConnectionListeners(1);
    }

    public void close(boolean expunge) throws MessagingException {
        if (!this.open) {
            throw new MessagingException("Folder is not open");
        }
        if (expunge) {
            this.expunge();
        }
        this.deleted = null;
        this.open = false;
        this.notifyConnectionListeners(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] expunge() throws MessagingException {
        POP3Connection connection;
        if (!this.open) {
            throw new MessagingException("Folder is not open");
        }
        if (this.readonly) {
            throw new MessagingException("Folder was opened read-only");
        }
        POP3Connection pOP3Connection = connection = ((POP3Store)this.store).connection;
        synchronized (pOP3Connection) {
            try {
                for (Message msg : this.deleted) {
                    int msgnum = msg.getMessageNumber();
                    connection.dele(msgnum);
                }
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
        Message[] d = new Message[this.deleted.size()];
        this.deleted.toArray(d);
        this.deleted.clear();
        return d;
    }

    public boolean isOpen() {
        return this.open;
    }

    public Flags getPermanentFlags() {
        return new Flags();
    }

    public int getMessageCount() throws MessagingException {
        POP3Connection connection;
        POP3Connection pOP3Connection = connection = ((POP3Store)this.store).connection;
        synchronized (pOP3Connection) {
            try {
                return connection.stat();
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
    }

    public Message getMessage(int msgnum) throws MessagingException {
        POP3Connection connection;
        if (!this.open) {
            throw new MessagingException("Folder is not open");
        }
        POP3Connection pOP3Connection = connection = ((POP3Store)this.store).connection;
        synchronized (pOP3Connection) {
            try {
                int size = connection.list(msgnum);
                return new POP3Message(this, msgnum, size);
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
    }

    public void appendMessages(Message[] messages) throws MessagingException {
        throw new IllegalWriteException();
    }

    public void fetch(Message[] messages, FetchProfile fp) throws MessagingException {
        int i;
        boolean fetchHeaders = false;
        boolean fetchContent = false;
        boolean fetchUid = false;
        FetchProfile.Item[] items = fp.getItems();
        for (i = 0; i < items.length; ++i) {
            if (items[i] == UIDFolder.FetchProfileItem.UID) {
                fetchUid = true;
                continue;
            }
            if (items[i] == FetchProfile.Item.CONTENT_INFO) {
                fetchContent = true;
                continue;
            }
            fetchHeaders = true;
        }
        if (fp.getHeaderNames().length > 0) {
            fetchHeaders = true;
        }
        if (!(fetchHeaders || fetchContent || fetchUid)) {
            return;
        }
        for (i = 0; i < messages.length; ++i) {
            if (!(messages[i] instanceof POP3Message)) continue;
            POP3Message m = (POP3Message)messages[i];
            if (fetchUid) {
                m.fetchUid();
            }
            if (fetchContent) {
                m.fetchContent();
                continue;
            }
            m.fetchHeaders();
        }
    }

    public Folder[] list() throws MessagingException {
        switch (this.type) {
            case 2: {
                if (this.inbox == null) {
                    this.inbox = new POP3Folder(this.store, 1);
                }
                Folder[] folders = new Folder[]{this.inbox};
                return folders;
            }
        }
        throw new MessagingException("This folder can't contain subfolders");
    }

    public Folder[] list(String pattern) throws MessagingException {
        return this.list();
    }

    public Folder getParent() throws MessagingException {
        switch (this.type) {
            case 1: {
                return ((POP3Store)this.store).root;
            }
        }
        return null;
    }

    public Folder getFolder(String s) throws MessagingException {
        switch (this.type) {
            case 2: {
                if (this.inbox == null) {
                    this.inbox = new POP3Folder(this.store, 1);
                }
                return this.inbox;
            }
        }
        throw new MessagingException("This folder can't contain subfolders");
    }

    public char getSeparator() throws MessagingException {
        return '\u0000';
    }

    public boolean create(int i) throws MessagingException {
        throw new IllegalWriteException();
    }

    public boolean delete(boolean flag) throws MessagingException {
        throw new IllegalWriteException("Folder can't be deleted");
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        throw new IllegalWriteException("Folder can't be renamed");
    }

    public String getUID(Message message) throws MessagingException {
        if (message instanceof POP3Message) {
            return ((POP3Message)message).getUID();
        }
        return null;
    }
}

