/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SparseFixedBitSet;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.IngestActionForwarder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.update.TransportUpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportBulkAction
extends HandledTransportAction<BulkRequest, BulkResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final ClusterService clusterService;
    private final IngestService ingestService;
    private final TransportShardBulkAction shardBulkAction;
    private final TransportCreateIndexAction createIndexAction;
    private final LongSupplier relativeTimeProvider;
    private final IngestActionForwarder ingestForwarder;

    @Inject
    public TransportBulkAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, TransportShardBulkAction shardBulkAction, TransportCreateIndexAction createIndexAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex) {
        this(settings, threadPool, transportService, clusterService, ingestService, shardBulkAction, createIndexAction, actionFilters, indexNameExpressionResolver, autoCreateIndex, System::nanoTime);
    }

    public TransportBulkAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, TransportShardBulkAction shardBulkAction, TransportCreateIndexAction createIndexAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex, LongSupplier relativeTimeProvider) {
        super(settings, "indices:data/write/bulk", threadPool, transportService, actionFilters, indexNameExpressionResolver, BulkRequest::new);
        Objects.requireNonNull(relativeTimeProvider);
        this.clusterService = clusterService;
        this.ingestService = ingestService;
        this.shardBulkAction = shardBulkAction;
        this.createIndexAction = createIndexAction;
        this.autoCreateIndex = autoCreateIndex;
        this.relativeTimeProvider = relativeTimeProvider;
        this.ingestForwarder = new IngestActionForwarder(transportService);
        clusterService.addStateApplier(this.ingestForwarder);
    }

    public static IndexRequest getIndexWriteRequest(DocWriteRequest docWriteRequest) {
        IndexRequest indexRequest = null;
        if (docWriteRequest instanceof IndexRequest) {
            indexRequest = (IndexRequest)docWriteRequest;
        } else if (docWriteRequest instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)docWriteRequest;
            indexRequest = updateRequest.docAsUpsert() ? updateRequest.doc() : updateRequest.upsertRequest();
        }
        return indexRequest;
    }

    @Override
    protected final void doExecute(BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        throw new UnsupportedOperationException("task parameter is required for this operation");
    }

    @Override
    protected void doExecute(final Task task, final BulkRequest bulkRequest, final ActionListener<BulkResponse> listener) {
        final long startTime = this.relativeTime();
        final AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        boolean hasIndexRequestsWithPipelines = false;
        MetaData metaData = this.clusterService.state().getMetaData();
        ImmutableOpenMap<String, IndexMetaData> indicesMetaData = metaData.indices();
        for (DocWriteRequest<?> actionRequest : bulkRequest.requests) {
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(actionRequest);
            if (indexRequest == null) continue;
            String pipeline = indexRequest.getPipeline();
            if (pipeline == null) {
                AliasOrIndex indexOrAlias;
                Object indexMetaData = indicesMetaData.get(actionRequest.index());
                if (indexMetaData == null && indexRequest.index() != null && (indexOrAlias = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(indexRequest.index())) != null && indexOrAlias.isAlias()) {
                    AliasOrIndex.Alias alias = (AliasOrIndex.Alias)indexOrAlias;
                    indexMetaData = alias.getWriteIndex();
                }
                if (indexMetaData != null) {
                    String defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(((IndexMetaData)indexMetaData).getSettings());
                    indexRequest.setPipeline(defaultPipeline);
                    if ("_none".equals(defaultPipeline)) continue;
                    hasIndexRequestsWithPipelines = true;
                    continue;
                }
                if (indexRequest.index() == null) continue;
                List<IndexTemplateMetaData> templates = MetaDataIndexTemplateService.findTemplates(metaData, indexRequest.index());
                assert (templates != null);
                String defaultPipeline = "_none";
                for (IndexTemplateMetaData template : templates) {
                    Settings settings = template.settings();
                    if (!IndexSettings.DEFAULT_PIPELINE.exists(settings)) continue;
                    defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(settings);
                    break;
                }
                indexRequest.setPipeline(defaultPipeline);
                if ("_none".equals(defaultPipeline)) continue;
                hasIndexRequestsWithPipelines = true;
                continue;
            }
            if ("_none".equals(pipeline)) continue;
            hasIndexRequestsWithPipelines = true;
        }
        if (hasIndexRequestsWithPipelines) {
            try {
                if (this.clusterService.localNode().isIngestNode()) {
                    this.processBulkIndexIngestRequest(task, bulkRequest, listener);
                } else {
                    this.ingestForwarder.forwardIngestRequest(BulkAction.INSTANCE, bulkRequest, listener);
                }
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            return;
        }
        if (this.needToCheck()) {
            Set indices = bulkRequest.requests.stream().filter(request -> request.opType() != DocWriteRequest.OpType.DELETE || request.versionType() == VersionType.EXTERNAL || request.versionType() == VersionType.EXTERNAL_GTE).map(DocWriteRequest::index).collect(Collectors.toSet());
            final HashMap<String, IndexNotFoundException> indicesThatCannotBeCreated = new HashMap<String, IndexNotFoundException>();
            HashSet<String> autoCreateIndices = new HashSet<String>();
            ClusterState state = this.clusterService.state();
            for (String index : indices) {
                boolean shouldAutoCreate;
                try {
                    shouldAutoCreate = this.shouldAutoCreate(index, state);
                }
                catch (IndexNotFoundException e) {
                    shouldAutoCreate = false;
                    indicesThatCannotBeCreated.put(index, e);
                }
                if (!shouldAutoCreate) continue;
                autoCreateIndices.add(index);
            }
            if (autoCreateIndices.isEmpty()) {
                this.executeBulk(task, bulkRequest, startTime, listener, responses, indicesThatCannotBeCreated);
            } else {
                final AtomicInteger counter = new AtomicInteger(autoCreateIndices.size());
                for (final String index : autoCreateIndices) {
                    this.createIndex(index, bulkRequest.timeout(), new ActionListener<CreateIndexResponse>(){

                        @Override
                        public void onResponse(CreateIndexResponse result) {
                            if (counter.decrementAndGet() == 0) {
                                TransportBulkAction.this.executeBulk(task, bulkRequest, startTime, listener, responses, indicesThatCannotBeCreated);
                            }
                        }

                        @Override
                        public void onFailure(Exception e) {
                            if (!(ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException)) {
                                for (int i = 0; i < bulkRequest.requests.size(); ++i) {
                                    DocWriteRequest<?> request = bulkRequest.requests.get(i);
                                    if (request == null || !TransportBulkAction.this.setResponseFailureIfIndexMatches(responses, i, request, index, e)) continue;
                                    bulkRequest.requests.set(i, null);
                                }
                            }
                            if (counter.decrementAndGet() == 0) {
                                TransportBulkAction.this.executeBulk(task, bulkRequest, startTime, ActionListener.wrap(listener::onResponse, inner -> {
                                    inner.addSuppressed(e);
                                    listener.onFailure((Exception)inner);
                                }), responses, indicesThatCannotBeCreated);
                            }
                        }
                    });
                }
            }
        } else {
            this.executeBulk(task, bulkRequest, startTime, listener, responses, Collections.emptyMap());
        }
    }

    boolean needToCheck() {
        return this.autoCreateIndex.needToCheck();
    }

    boolean shouldAutoCreate(String index, ClusterState state) {
        return this.autoCreateIndex.shouldAutoCreate(index, state);
    }

    void createIndex(String index, TimeValue timeout, ActionListener<CreateIndexResponse> listener) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest();
        createIndexRequest.index(index);
        createIndexRequest.cause("auto(bulk api)");
        createIndexRequest.masterNodeTimeout(timeout);
        this.createIndexAction.execute(createIndexRequest, listener);
    }

    private boolean setResponseFailureIfIndexMatches(AtomicArray<BulkItemResponse> responses, int idx, DocWriteRequest request, String index, Exception e) {
        if (index.equals(request.index())) {
            responses.set(idx, new BulkItemResponse(idx, request.opType(), new BulkItemResponse.Failure(request.index(), request.type(), request.id(), e)));
            return true;
        }
        return false;
    }

    private long buildTookInMillis(long startTimeNanos) {
        return TimeUnit.NANOSECONDS.toMillis(this.relativeTime() - startTimeNanos);
    }

    void executeBulk(Task task, BulkRequest bulkRequest, long startTimeNanos, ActionListener<BulkResponse> listener, AtomicArray<BulkItemResponse> responses, Map<String, IndexNotFoundException> indicesThatCannotBeCreated) {
        new BulkOperation(task, bulkRequest, listener, responses, startTimeNanos, indicesThatCannotBeCreated).run();
    }

    private long relativeTime() {
        return this.relativeTimeProvider.getAsLong();
    }

    void processBulkIndexIngestRequest(Task task, BulkRequest original, ActionListener<BulkResponse> listener) {
        long ingestStartTimeInNanos = System.nanoTime();
        BulkRequestModifier bulkRequestModifier = new BulkRequestModifier(original);
        this.ingestService.executeBulkRequest(() -> bulkRequestModifier, (indexRequest, exception) -> {
            this.logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}/{}]", new Object[]{indexRequest.getPipeline(), indexRequest.index(), indexRequest.type(), indexRequest.id()}), (Throwable)exception);
            bulkRequestModifier.markCurrentItemAsFailed((Exception)exception);
        }, exception -> {
            if (exception != null) {
                this.logger.error("failed to execute pipeline for a bulk request", (Throwable)exception);
                listener.onFailure((Exception)exception);
            } else {
                long ingestTookInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - ingestStartTimeInNanos);
                BulkRequest bulkRequest = bulkRequestModifier.getBulkRequest();
                ActionListener<BulkResponse> actionListener = bulkRequestModifier.wrapActionListenerIfNeeded(ingestTookInMillis, listener);
                if (bulkRequest.requests().isEmpty()) {
                    actionListener.onResponse(new BulkResponse(new BulkItemResponse[0], 0L));
                } else {
                    this.doExecute(task, bulkRequest, actionListener);
                }
            }
        }, indexRequest -> bulkRequestModifier.markCurrentItemAsDropped());
    }

    static final class IngestBulkResponseListener
    implements ActionListener<BulkResponse> {
        private final long ingestTookInMillis;
        private final int[] originalSlots;
        private final List<BulkItemResponse> itemResponses;
        private final ActionListener<BulkResponse> actionListener;

        IngestBulkResponseListener(long ingestTookInMillis, int[] originalSlots, List<BulkItemResponse> itemResponses, ActionListener<BulkResponse> actionListener) {
            this.ingestTookInMillis = ingestTookInMillis;
            this.itemResponses = itemResponses;
            this.actionListener = actionListener;
            this.originalSlots = originalSlots;
        }

        @Override
        public void onResponse(BulkResponse response) {
            BulkItemResponse[] items = response.getItems();
            for (int i = 0; i < items.length; ++i) {
                this.itemResponses.add(this.originalSlots[i], response.getItems()[i]);
            }
            this.actionListener.onResponse(new BulkResponse(this.itemResponses.toArray(new BulkItemResponse[this.itemResponses.size()]), response.getTook().getMillis(), this.ingestTookInMillis));
        }

        @Override
        public void onFailure(Exception e) {
            this.actionListener.onFailure(e);
        }
    }

    static final class BulkRequestModifier
    implements Iterator<DocWriteRequest<?>> {
        final BulkRequest bulkRequest;
        final SparseFixedBitSet failedSlots;
        final List<BulkItemResponse> itemResponses;
        int currentSlot = -1;
        int[] originalSlots;

        BulkRequestModifier(BulkRequest bulkRequest) {
            this.bulkRequest = bulkRequest;
            this.failedSlots = new SparseFixedBitSet(bulkRequest.requests().size());
            this.itemResponses = new ArrayList<BulkItemResponse>(bulkRequest.requests().size());
        }

        @Override
        public DocWriteRequest next() {
            return this.bulkRequest.requests().get(++this.currentSlot);
        }

        @Override
        public boolean hasNext() {
            return this.currentSlot + 1 < this.bulkRequest.requests().size();
        }

        BulkRequest getBulkRequest() {
            if (this.itemResponses.isEmpty()) {
                return this.bulkRequest;
            }
            BulkRequest modifiedBulkRequest = new BulkRequest();
            modifiedBulkRequest.setRefreshPolicy(this.bulkRequest.getRefreshPolicy());
            modifiedBulkRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
            modifiedBulkRequest.timeout(this.bulkRequest.timeout());
            int slot = 0;
            List<DocWriteRequest<?>> requests = this.bulkRequest.requests();
            this.originalSlots = new int[requests.size()];
            for (int i = 0; i < requests.size(); ++i) {
                DocWriteRequest<?> request = requests.get(i);
                if (this.failedSlots.get(i)) continue;
                modifiedBulkRequest.add(request);
                this.originalSlots[slot++] = i;
            }
            return modifiedBulkRequest;
        }

        ActionListener<BulkResponse> wrapActionListenerIfNeeded(long ingestTookInMillis, ActionListener<BulkResponse> actionListener) {
            if (this.itemResponses.isEmpty()) {
                return ActionListener.wrap(response -> actionListener.onResponse(new BulkResponse(response.getItems(), response.getTook().getMillis(), ingestTookInMillis)), actionListener::onFailure);
            }
            return new IngestBulkResponseListener(ingestTookInMillis, this.originalSlots, this.itemResponses, actionListener);
        }

        void markCurrentItemAsDropped() {
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(this.bulkRequest.requests().get(this.currentSlot));
            this.failedSlots.set(this.currentSlot);
            this.itemResponses.add(new BulkItemResponse(this.currentSlot, indexRequest.opType(), new UpdateResponse(new ShardId(indexRequest.index(), "_na_", 0), indexRequest.type(), indexRequest.id(), indexRequest.version(), DocWriteResponse.Result.NOOP)));
        }

        void markCurrentItemAsFailed(Exception e) {
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(this.bulkRequest.requests().get(this.currentSlot));
            this.failedSlots.set(this.currentSlot);
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), e);
            this.itemResponses.add(new BulkItemResponse(this.currentSlot, indexRequest.opType(), failure));
        }
    }

    private static class ConcreteIndices {
        private final ClusterState state;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final Map<String, Index> indices = new HashMap<String, Index>();

        ConcreteIndices(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver) {
            this.state = state;
            this.indexNameExpressionResolver = indexNameExpressionResolver;
        }

        Index getConcreteIndex(String indexOrAlias) {
            return this.indices.get(indexOrAlias);
        }

        Index resolveIfAbsent(DocWriteRequest request) {
            Index concreteIndex = this.indices.get(request.index());
            if (concreteIndex == null) {
                concreteIndex = this.indexNameExpressionResolver.concreteWriteIndex(this.state, request);
                this.indices.put(request.index(), concreteIndex);
            }
            return concreteIndex;
        }
    }

    private final class BulkOperation
    extends AbstractRunnable {
        private final Task task;
        private final BulkRequest bulkRequest;
        private final ActionListener<BulkResponse> listener;
        private final AtomicArray<BulkItemResponse> responses;
        private final long startTimeNanos;
        private final ClusterStateObserver observer;
        private final Map<String, IndexNotFoundException> indicesThatCannotBeCreated;

        BulkOperation(Task task, BulkRequest bulkRequest, ActionListener<BulkResponse> listener, AtomicArray<BulkItemResponse> responses, long startTimeNanos, Map<String, IndexNotFoundException> indicesThatCannotBeCreated) {
            this.task = task;
            this.bulkRequest = bulkRequest;
            this.listener = listener;
            this.responses = responses;
            this.startTimeNanos = startTimeNanos;
            this.indicesThatCannotBeCreated = indicesThatCannotBeCreated;
            this.observer = new ClusterStateObserver(TransportBulkAction.this.clusterService, bulkRequest.timeout(), TransportBulkAction.this.logger, TransportBulkAction.this.threadPool.getThreadContext());
        }

        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        @Override
        protected void doRun() throws Exception {
            ClusterState clusterState = this.observer.setAndGetObservedState();
            if (this.handleBlockExceptions(clusterState)) {
                return;
            }
            final ConcreteIndices concreteIndices = new ConcreteIndices(clusterState, TransportBulkAction.this.indexNameExpressionResolver);
            MetaData metaData = clusterState.metaData();
            block7: for (int i = 0; i < this.bulkRequest.requests.size(); ++i) {
                DocWriteRequest<?> docWriteRequest = this.bulkRequest.requests.get(i);
                if (docWriteRequest == null || this.addFailureIfIndexIsUnavailable(docWriteRequest, i, concreteIndices, metaData)) continue;
                Index concreteIndex = concreteIndices.resolveIfAbsent(docWriteRequest);
                try {
                    switch (docWriteRequest.opType()) {
                        case CREATE: 
                        case INDEX: {
                            IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                            IndexMetaData indexMetaData = metaData.index(concreteIndex);
                            MappingMetaData mappingMd = indexMetaData.mappingOrDefault(indexMetaData.resolveDocumentType(indexRequest.type()));
                            Version indexCreated = indexMetaData.getCreationVersion();
                            indexRequest.resolveRouting(metaData);
                            indexRequest.process(indexCreated, mappingMd, concreteIndex.getName());
                            break;
                        }
                        case UPDATE: {
                            TransportUpdateAction.resolveAndValidateRouting(metaData, concreteIndex.getName(), (UpdateRequest)docWriteRequest);
                            break;
                        }
                        case DELETE: {
                            docWriteRequest.routing(metaData.resolveWriteIndexRouting(docWriteRequest.parent(), docWriteRequest.routing(), docWriteRequest.index()));
                            if (docWriteRequest.routing() != null || !metaData.routingRequired(concreteIndex.getName(), docWriteRequest.type())) continue block7;
                            throw new RoutingMissingException(concreteIndex.getName(), docWriteRequest.type(), docWriteRequest.id());
                        }
                        default: {
                            throw new AssertionError((Object)("request type not supported: [" + (Object)((Object)docWriteRequest.opType()) + "]"));
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException | ElasticsearchParseException | RoutingMissingException e) {
                    BulkItemResponse.Failure failure = new BulkItemResponse.Failure(concreteIndex.getName(), docWriteRequest.type(), docWriteRequest.id(), e);
                    BulkItemResponse bulkItemResponse = new BulkItemResponse(i, docWriteRequest.opType(), failure);
                    this.responses.set(i, bulkItemResponse);
                    this.bulkRequest.requests.set(i, null);
                }
            }
            HashMap<ShardId, List> requestsByShard = new HashMap<ShardId, List>();
            for (int i = 0; i < this.bulkRequest.requests.size(); ++i) {
                DocWriteRequest<?> request = this.bulkRequest.requests.get(i);
                if (request == null) continue;
                String concreteIndex = concreteIndices.getConcreteIndex(request.index()).getName();
                ShardId shardId = TransportBulkAction.this.clusterService.operationRouting().indexShards(clusterState, concreteIndex, request.id(), request.routing()).shardId();
                List shardRequests = requestsByShard.computeIfAbsent(shardId, shard -> new ArrayList());
                shardRequests.add(new BulkItemRequest(i, request));
            }
            if (requestsByShard.isEmpty()) {
                this.listener.onResponse(new BulkResponse(this.responses.toArray((BulkItemResponse[])new BulkItemResponse[this.responses.length()]), TransportBulkAction.this.buildTookInMillis(this.startTimeNanos)));
                return;
            }
            final AtomicInteger counter = new AtomicInteger(requestsByShard.size());
            String nodeId = TransportBulkAction.this.clusterService.localNode().getId();
            for (Map.Entry entry : requestsByShard.entrySet()) {
                ShardId shardId = (ShardId)entry.getKey();
                final List requests = (List)entry.getValue();
                BulkShardRequest bulkShardRequest = new BulkShardRequest(shardId, this.bulkRequest.getRefreshPolicy(), requests.toArray(new BulkItemRequest[requests.size()]));
                bulkShardRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
                bulkShardRequest.timeout(this.bulkRequest.timeout());
                if (this.task != null) {
                    bulkShardRequest.setParentTask(nodeId, this.task.getId());
                }
                TransportBulkAction.this.shardBulkAction.execute(bulkShardRequest, new ActionListener<BulkShardResponse>(){

                    @Override
                    public void onResponse(BulkShardResponse bulkShardResponse) {
                        for (BulkItemResponse bulkItemResponse : bulkShardResponse.getResponses()) {
                            if (bulkItemResponse.getResponse() != null) {
                                ((ReplicationResponse)bulkItemResponse.getResponse()).setShardInfo(bulkShardResponse.getShardInfo());
                            }
                            BulkOperation.this.responses.set(bulkItemResponse.getItemId(), bulkItemResponse);
                        }
                        if (counter.decrementAndGet() == 0) {
                            this.finishHim();
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        for (BulkItemRequest request : requests) {
                            String indexName = concreteIndices.getConcreteIndex(request.index()).getName();
                            DocWriteRequest docWriteRequest = request.request();
                            BulkOperation.this.responses.set(request.id(), new BulkItemResponse(request.id(), docWriteRequest.opType(), new BulkItemResponse.Failure(indexName, docWriteRequest.type(), docWriteRequest.id(), e)));
                        }
                        if (counter.decrementAndGet() == 0) {
                            this.finishHim();
                        }
                    }

                    private void finishHim() {
                        BulkOperation.this.listener.onResponse(new BulkResponse(BulkOperation.this.responses.toArray(new BulkItemResponse[BulkOperation.this.responses.length()]), TransportBulkAction.this.buildTookInMillis(BulkOperation.this.startTimeNanos)));
                    }
                });
            }
        }

        private boolean handleBlockExceptions(ClusterState state) {
            ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
            if (blockException != null) {
                if (blockException.retryable()) {
                    TransportBulkAction.this.logger.trace("cluster is blocked, scheduling a retry", (Throwable)blockException);
                    this.retry(blockException);
                } else {
                    this.onFailure(blockException);
                }
                return true;
            }
            return false;
        }

        void retry(Exception failure) {
            assert (failure != null);
            if (this.observer.isTimedOut()) {
                this.onFailure(failure);
                return;
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    BulkOperation.this.run();
                }

                @Override
                public void onClusterServiceClose() {
                    BulkOperation.this.onFailure(new NodeClosedException(TransportBulkAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    BulkOperation.this.run();
                }
            });
        }

        private boolean addFailureIfIndexIsUnavailable(DocWriteRequest request, int idx, ConcreteIndices concreteIndices, MetaData metaData) {
            IndexMetaData indexMetaData;
            IndexNotFoundException cannotCreate = this.indicesThatCannotBeCreated.get(request.index());
            if (cannotCreate != null) {
                this.addFailure(request, idx, cannotCreate);
                return true;
            }
            Index concreteIndex = concreteIndices.getConcreteIndex(request.index());
            if (concreteIndex == null) {
                try {
                    concreteIndex = concreteIndices.resolveIfAbsent(request);
                }
                catch (IndexNotFoundException | IndexClosedException ex) {
                    this.addFailure(request, idx, ex);
                    return true;
                }
            }
            if ((indexMetaData = metaData.getIndexSafe(concreteIndex)).getState() == IndexMetaData.State.CLOSE) {
                this.addFailure(request, idx, new IndexClosedException(concreteIndex));
                return true;
            }
            return false;
        }

        private void addFailure(DocWriteRequest request, int idx, Exception unavailableException) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(request.index(), request.type(), request.id(), unavailableException);
            BulkItemResponse bulkItemResponse = new BulkItemResponse(idx, request.opType(), failure);
            this.responses.set(idx, bulkItemResponse);
            this.bulkRequest.requests.set(idx, null);
        }
    }
}

