/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.EndpointInfo;
import com.zeroc.Ice.EndpointParseException;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.IPEndpointInfo;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.OutputStream;
import com.zeroc.IceInternal.Connector;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.EndpointI_connectors;
import com.zeroc.IceInternal.HashUtil;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.NetworkProxy;
import com.zeroc.IceInternal.ProtocolInstance;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public abstract class IPEndpointI
extends EndpointI {
    protected ProtocolInstance _instance;
    protected String _host;
    protected int _port;
    protected InetSocketAddress _sourceAddr;
    protected String _connectionId;
    private boolean _hashInitialized;
    private int _hashValue;

    protected IPEndpointI(ProtocolInstance instance, String host, int port, InetSocketAddress sourceAddr, String connectionId) {
        this._instance = instance;
        this._host = host;
        this._port = port;
        this._sourceAddr = sourceAddr;
        this._connectionId = connectionId;
        this._hashInitialized = false;
    }

    protected IPEndpointI(ProtocolInstance instance) {
        this._instance = instance;
        this._host = null;
        this._port = 0;
        this._sourceAddr = null;
        this._connectionId = "";
        this._hashInitialized = false;
    }

    protected IPEndpointI(ProtocolInstance instance, InputStream s) {
        this._instance = instance;
        this._host = s.readString();
        this._port = s.readInt();
        this._sourceAddr = null;
        this._connectionId = "";
        this._hashInitialized = false;
    }

    @Override
    public EndpointInfo getInfo() {
        IPEndpointInfo info = new IPEndpointInfo(){

            @Override
            public short type() {
                return IPEndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return IPEndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return IPEndpointI.this.secure();
            }
        };
        this.fillEndpointInfo(info);
        return info;
    }

    @Override
    public short type() {
        return this._instance.type();
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public boolean secure() {
        return this._instance.secure();
    }

    @Override
    public String connectionId() {
        return this._connectionId;
    }

    @Override
    public EndpointI connectionId(String connectionId) {
        if (connectionId.equals(this._connectionId)) {
            return this;
        }
        return this.createEndpoint(this._host, this._port, connectionId);
    }

    @Override
    public void connectors_async(EndpointSelectionType selType, EndpointI_connectors callback) {
        this._instance.resolve(this._host, this._port, selType, this, callback);
    }

    @Override
    public List<EndpointI> expandIfWildcard() {
        ArrayList<EndpointI> endps = new ArrayList<EndpointI>();
        ArrayList<String> hosts = Network.getHostsForEndpointExpand(this._host, this._instance.protocolSupport(), false);
        if (hosts == null || hosts.isEmpty()) {
            endps.add(this);
        } else {
            for (String h : hosts) {
                endps.add(this.createEndpoint(h, this._port, this._connectionId));
            }
        }
        return endps;
    }

    @Override
    public EndpointI.ExpandHostResult expandHost() {
        EndpointI.ExpandHostResult result = new EndpointI.ExpandHostResult();
        if (this._host.isEmpty()) {
            result.endpoints = new ArrayList<EndpointI>();
            result.endpoints.add(this);
            return result;
        }
        result.publish = this._port > 0 ? this : null;
        List<InetSocketAddress> addresses = Network.getAddresses(this._host, this._port, this._instance.protocolSupport(), EndpointSelectionType.Ordered, this._instance.preferIPv6(), true);
        result.endpoints = new ArrayList<EndpointI>();
        if (addresses.size() == 1) {
            result.endpoints.add(this);
        } else {
            for (InetSocketAddress addr : addresses) {
                result.endpoints.add(this.createEndpoint(addr.getAddress().getHostAddress(), addr.getPort(), this._connectionId));
            }
        }
        return result;
    }

    @Override
    public boolean equivalent(EndpointI endpoint) {
        if (!(endpoint instanceof IPEndpointI)) {
            return false;
        }
        IPEndpointI ipEndpointI = (IPEndpointI)endpoint;
        return ipEndpointI.type() == this.type() && ipEndpointI._host.equals(this._host) && ipEndpointI._port == this._port && Network.compareAddress(ipEndpointI._sourceAddr, this._sourceAddr) == 0;
    }

    public List<Connector> connectors(List<InetSocketAddress> addresses, NetworkProxy proxy) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (InetSocketAddress p : addresses) {
            connectors.add(this.createConnector(p, proxy));
        }
        return connectors;
    }

    public synchronized int hashCode() {
        if (!this._hashInitialized) {
            this._hashValue = 5381;
            this._hashValue = HashUtil.hashAdd(this._hashValue, this.type());
            this._hashValue = this.hashInit(this._hashValue);
            this._hashInitialized = true;
        }
        return this._hashValue;
    }

    @Override
    public String options() {
        String s = "";
        if (this._host != null && this._host.length() > 0) {
            boolean addQuote;
            s = s + " -h ";
            boolean bl = addQuote = this._host.indexOf(58) != -1;
            if (addQuote) {
                s = s + "\"";
            }
            s = s + this._host;
            if (addQuote) {
                s = s + "\"";
            }
        }
        s = s + " -p " + this._port;
        if (this._sourceAddr != null) {
            s = s + " --sourceAddress " + this._sourceAddr.getAddress().getHostAddress();
        }
        return s;
    }

    @Override
    public int compareTo(EndpointI obj) {
        if (!(obj instanceof IPEndpointI)) {
            return this.type() < obj.type() ? -1 : 1;
        }
        IPEndpointI p = (IPEndpointI)obj;
        if (this == p) {
            return 0;
        }
        int v = this._host.compareTo(p._host);
        if (v != 0) {
            return v;
        }
        if (this._port < p._port) {
            return -1;
        }
        if (p._port < this._port) {
            return 1;
        }
        int rc = Network.compareAddress(this._sourceAddr, p._sourceAddr);
        if (rc != 0) {
            return rc;
        }
        return this._connectionId.compareTo(p._connectionId);
    }

    @Override
    public void streamWriteImpl(OutputStream s) {
        s.writeString(this._host);
        s.writeInt(this._port);
    }

    public int hashInit(int h) {
        h = HashUtil.hashAdd(h, this._host);
        h = HashUtil.hashAdd(h, this._port);
        if (this._sourceAddr != null) {
            h = HashUtil.hashAdd(h, this._sourceAddr.getAddress().getHostAddress());
        }
        h = HashUtil.hashAdd(h, this._connectionId);
        return h;
    }

    public void fillEndpointInfo(IPEndpointInfo info) {
        info.timeout = this.timeout();
        info.compress = this.compress();
        info.host = this._host;
        info.port = this._port;
        info.sourceAddress = this._sourceAddr == null ? "" : this._sourceAddr.getAddress().getHostAddress();
    }

    public void initWithOptions(ArrayList<String> args, boolean oaEndpoint) {
        super.initWithOptions(args);
        if (this._host == null || this._host.length() == 0) {
            this._host = this._instance.defaultHost();
        } else if (this._host.equals("*")) {
            if (oaEndpoint) {
                this._host = "";
            } else {
                throw new EndpointParseException("`-h *' not valid for proxy endpoint `" + this.toString() + "'");
            }
        }
        if (this._host == null) {
            this._host = "";
        }
        if (this._sourceAddr == null) {
            if (!oaEndpoint) {
                this._sourceAddr = this._instance.defaultSourceAddress();
            }
        } else if (oaEndpoint) {
            throw new EndpointParseException("`--sourceAddress' not valid for object adapter endpoint `" + this.toString() + "'");
        }
    }

    @Override
    protected boolean checkOption(String option, String argument, String endpoint) {
        if (option.equals("-h")) {
            if (argument == null) {
                throw new EndpointParseException("no argument provided for -h option in endpoint " + endpoint);
            }
            this._host = argument;
        } else if (option.equals("-p")) {
            if (argument == null) {
                throw new EndpointParseException("no argument provided for -p option in endpoint " + endpoint);
            }
            try {
                this._port = Integer.parseInt(argument);
            }
            catch (NumberFormatException ex) {
                throw new EndpointParseException("invalid port value `" + argument + "' in endpoint " + endpoint);
            }
            if (this._port < 0 || this._port > 65535) {
                throw new EndpointParseException("port value `" + argument + "' out of range in endpoint " + endpoint);
            }
        } else if (option.equals("--sourceAddress")) {
            if (argument == null) {
                throw new EndpointParseException("no argument provided for --sourceAddress option in endpoint " + endpoint);
            }
            this._sourceAddr = Network.getNumericAddress(argument);
            if (this._sourceAddr == null) {
                throw new EndpointParseException("invalid IP address provided for --sourceAddress option in endpoint " + endpoint);
            }
        } else {
            return false;
        }
        return true;
    }

    protected abstract Connector createConnector(InetSocketAddress var1, NetworkProxy var2);

    protected abstract IPEndpointI createEndpoint(String var1, int var2, String var3);
}

