/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.calc;

import javajs.util.BS;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.util.TriangleData;

public class MarchingCubes
extends TriangleData {
    protected VertexDataServer surfaceReader;
    protected VolumeData volumeData;
    protected int contourType;
    protected boolean isContoured;
    protected float cutoff;
    protected boolean isCutoffAbsolute;
    protected boolean isSquared;
    protected boolean isXLowToHigh;
    protected int cubeCountX;
    protected int cubeCountY;
    protected int cubeCountZ;
    protected int nY;
    protected int nZ;
    protected int yzCount;
    protected boolean colorDensity;
    protected boolean integrateSquared = true;
    public BS bsVoxels;
    protected BS bsExcludedVertices;
    protected BS bsExcludedTriangles;
    protected BS bsExcludedPlanes;
    protected SB edgeData = new SB();
    private boolean excludePartialCubes = true;
    protected int mode;
    protected static final int MODE_CUBE = 1;
    protected static final int MODE_JVXL = 2;
    protected static final int MODE_PLANES = 3;
    protected final float[] vertexValues = new float[8];
    protected int edgeCount;
    protected final V3[] voxelVertexVectors = new V3[8];
    protected final V3[] edgeVectors = new V3[12];
    protected static int[] yzPlanePts;
    protected final int[] edgePointIndexes;
    protected int[][][] isoPointIndexPlanes;
    protected float[][] yzPlanes;
    private P4 mappingPlane;
    private boolean allInside;
    private boolean isInside;
    private P3i offset;
    private float[][][] voxelData;
    protected int nTriangles;
    protected BS bsValues;
    protected final P3 pt0;
    protected final P3 pointA;
    protected static final int[] edgeVertexPointersLowToHigh;
    protected static final int[] edgeVertexPointersHighToLow;
    protected int[] edgeVertexPointers;
    protected static final int[] edgeVertexPlanesLowToHigh;
    protected static final int[] edgeVertexPlanesHighToLow;
    protected int[] edgeVertexPlanes;
    protected float[] fReturn;
    protected static final V3[] cubeVertexVectors;
    protected static final int[] edgeTypeTable;
    protected final int[] linearOffsets;
    protected static final short[] insideMaskTable;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        yzPlanePts = nArray;
        int[] nArray2 = new int[12];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[4] = 5;
        nArray2[5] = 5;
        nArray2[6] = 6;
        nArray2[7] = 4;
        nArray2[9] = 1;
        nArray2[10] = 2;
        nArray2[11] = 3;
        edgeVertexPointersLowToHigh = nArray2;
        int[] nArray3 = new int[12];
        nArray3[1] = 1;
        nArray3[2] = 3;
        nArray3[4] = 4;
        nArray3[5] = 5;
        nArray3[6] = 7;
        nArray3[7] = 4;
        nArray3[9] = 1;
        nArray3[10] = 2;
        nArray3[11] = 3;
        edgeVertexPointersHighToLow = nArray3;
        int[] nArray4 = new int[12];
        nArray4[0] = 1;
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArray4[4] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArray4[9] = 1;
        nArray4[10] = 1;
        edgeVertexPlanesLowToHigh = nArray4;
        int[] nArray5 = new int[12];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[6] = 1;
        nArray5[7] = 1;
        nArray5[8] = 1;
        nArray5[11] = 1;
        edgeVertexPlanesHighToLow = nArray5;
        cubeVertexVectors = new V3[]{V3.new3(0.0f, 0.0f, 0.0f), V3.new3(1.0f, 0.0f, 0.0f), V3.new3(1.0f, 0.0f, 1.0f), V3.new3(0.0f, 0.0f, 1.0f), V3.new3(0.0f, 1.0f, 0.0f), V3.new3(1.0f, 1.0f, 0.0f), V3.new3(1.0f, 1.0f, 1.0f), V3.new3(0.0f, 1.0f, 1.0f)};
        int[] nArray6 = new int[12];
        nArray6[1] = 2;
        nArray6[3] = 2;
        nArray6[5] = 2;
        nArray6[7] = 2;
        nArray6[8] = 1;
        nArray6[9] = 1;
        nArray6[10] = 1;
        nArray6[11] = 1;
        edgeTypeTable = nArray6;
        short[] sArray = new short[256];
        sArray[1] = 265;
        sArray[2] = 515;
        sArray[3] = 778;
        sArray[4] = 1030;
        sArray[5] = 1295;
        sArray[6] = 1541;
        sArray[7] = 1804;
        sArray[8] = 2060;
        sArray[9] = 2309;
        sArray[10] = 2575;
        sArray[11] = 2822;
        sArray[12] = 3082;
        sArray[13] = 3331;
        sArray[14] = 3593;
        sArray[15] = 3840;
        sArray[16] = 400;
        sArray[17] = 153;
        sArray[18] = 915;
        sArray[19] = 666;
        sArray[20] = 1430;
        sArray[21] = 1183;
        sArray[22] = 1941;
        sArray[23] = 1692;
        sArray[24] = 2460;
        sArray[25] = 2197;
        sArray[26] = 2975;
        sArray[27] = 2710;
        sArray[28] = 3482;
        sArray[29] = 3219;
        sArray[30] = 3993;
        sArray[31] = 3728;
        sArray[32] = 560;
        sArray[33] = 825;
        sArray[34] = 51;
        sArray[35] = 314;
        sArray[36] = 1590;
        sArray[37] = 1855;
        sArray[38] = 1077;
        sArray[39] = 1340;
        sArray[40] = 2620;
        sArray[41] = 2869;
        sArray[42] = 2111;
        sArray[43] = 2358;
        sArray[44] = 3642;
        sArray[45] = 3891;
        sArray[46] = 3129;
        sArray[47] = 3376;
        sArray[48] = 928;
        sArray[49] = 681;
        sArray[50] = 419;
        sArray[51] = 170;
        sArray[52] = 1958;
        sArray[53] = 1711;
        sArray[54] = 1445;
        sArray[55] = 1196;
        sArray[56] = 2988;
        sArray[57] = 2725;
        sArray[58] = 2479;
        sArray[59] = 2214;
        sArray[60] = 4010;
        sArray[61] = 3747;
        sArray[62] = 3497;
        sArray[63] = 3232;
        sArray[64] = 1120;
        sArray[65] = 1385;
        sArray[66] = 1635;
        sArray[67] = 1898;
        sArray[68] = 102;
        sArray[69] = 367;
        sArray[70] = 613;
        sArray[71] = 876;
        sArray[72] = 3180;
        sArray[73] = 3429;
        sArray[74] = 3695;
        sArray[75] = 3942;
        sArray[76] = 2154;
        sArray[77] = 2403;
        sArray[78] = 2665;
        sArray[79] = 2912;
        sArray[80] = 1520;
        sArray[81] = 1273;
        sArray[82] = 2035;
        sArray[83] = 1786;
        sArray[84] = 502;
        sArray[85] = 255;
        sArray[86] = 1013;
        sArray[87] = 764;
        sArray[88] = 3580;
        sArray[89] = 3317;
        sArray[90] = 4095;
        sArray[91] = 3830;
        sArray[92] = 2554;
        sArray[93] = 2291;
        sArray[94] = 3065;
        sArray[95] = 2800;
        sArray[96] = 1616;
        sArray[97] = 1881;
        sArray[98] = 1107;
        sArray[99] = 1370;
        sArray[100] = 598;
        sArray[101] = 863;
        sArray[102] = 85;
        sArray[103] = 348;
        sArray[104] = 3676;
        sArray[105] = 3925;
        sArray[106] = 3167;
        sArray[107] = 3414;
        sArray[108] = 2650;
        sArray[109] = 2899;
        sArray[110] = 2137;
        sArray[111] = 2384;
        sArray[112] = 1984;
        sArray[113] = 1737;
        sArray[114] = 1475;
        sArray[115] = 1226;
        sArray[116] = 966;
        sArray[117] = 719;
        sArray[118] = 453;
        sArray[119] = 204;
        sArray[120] = 4044;
        sArray[121] = 3781;
        sArray[122] = 3535;
        sArray[123] = 3270;
        sArray[124] = 3018;
        sArray[125] = 2755;
        sArray[126] = 2505;
        sArray[127] = 2240;
        sArray[128] = 2240;
        sArray[129] = 2505;
        sArray[130] = 2755;
        sArray[131] = 3018;
        sArray[132] = 3270;
        sArray[133] = 3535;
        sArray[134] = 3781;
        sArray[135] = 4044;
        sArray[136] = 204;
        sArray[137] = 453;
        sArray[138] = 719;
        sArray[139] = 966;
        sArray[140] = 1226;
        sArray[141] = 1475;
        sArray[142] = 1737;
        sArray[143] = 1984;
        sArray[144] = 2384;
        sArray[145] = 2137;
        sArray[146] = 2899;
        sArray[147] = 2650;
        sArray[148] = 3414;
        sArray[149] = 3167;
        sArray[150] = 3925;
        sArray[151] = 3676;
        sArray[152] = 348;
        sArray[153] = 85;
        sArray[154] = 863;
        sArray[155] = 598;
        sArray[156] = 1370;
        sArray[157] = 1107;
        sArray[158] = 1881;
        sArray[159] = 1616;
        sArray[160] = 2800;
        sArray[161] = 3065;
        sArray[162] = 2291;
        sArray[163] = 2554;
        sArray[164] = 3830;
        sArray[165] = 4095;
        sArray[166] = 3317;
        sArray[167] = 3580;
        sArray[168] = 764;
        sArray[169] = 1013;
        sArray[170] = 255;
        sArray[171] = 502;
        sArray[172] = 1786;
        sArray[173] = 2035;
        sArray[174] = 1273;
        sArray[175] = 1520;
        sArray[176] = 2912;
        sArray[177] = 2665;
        sArray[178] = 2403;
        sArray[179] = 2154;
        sArray[180] = 3942;
        sArray[181] = 3695;
        sArray[182] = 3429;
        sArray[183] = 3180;
        sArray[184] = 876;
        sArray[185] = 613;
        sArray[186] = 367;
        sArray[187] = 102;
        sArray[188] = 1898;
        sArray[189] = 1635;
        sArray[190] = 1385;
        sArray[191] = 1120;
        sArray[192] = 3232;
        sArray[193] = 3497;
        sArray[194] = 3747;
        sArray[195] = 4010;
        sArray[196] = 2214;
        sArray[197] = 2479;
        sArray[198] = 2725;
        sArray[199] = 2988;
        sArray[200] = 1196;
        sArray[201] = 1445;
        sArray[202] = 1711;
        sArray[203] = 1958;
        sArray[204] = 170;
        sArray[205] = 419;
        sArray[206] = 681;
        sArray[207] = 928;
        sArray[208] = 3376;
        sArray[209] = 3129;
        sArray[210] = 3891;
        sArray[211] = 3642;
        sArray[212] = 2358;
        sArray[213] = 2111;
        sArray[214] = 2869;
        sArray[215] = 2620;
        sArray[216] = 1340;
        sArray[217] = 1077;
        sArray[218] = 1855;
        sArray[219] = 1590;
        sArray[220] = 314;
        sArray[221] = 51;
        sArray[222] = 825;
        sArray[223] = 560;
        sArray[224] = 3728;
        sArray[225] = 3993;
        sArray[226] = 3219;
        sArray[227] = 3482;
        sArray[228] = 2710;
        sArray[229] = 2975;
        sArray[230] = 2197;
        sArray[231] = 2460;
        sArray[232] = 1692;
        sArray[233] = 1941;
        sArray[234] = 1183;
        sArray[235] = 1430;
        sArray[236] = 666;
        sArray[237] = 915;
        sArray[238] = 153;
        sArray[239] = 400;
        sArray[240] = 3840;
        sArray[241] = 3593;
        sArray[242] = 3331;
        sArray[243] = 3082;
        sArray[244] = 2822;
        sArray[245] = 2575;
        sArray[246] = 2309;
        sArray[247] = 2060;
        sArray[248] = 1804;
        sArray[249] = 1541;
        sArray[250] = 1295;
        sArray[251] = 1030;
        sArray[252] = 778;
        sArray[253] = 515;
        sArray[254] = 265;
        insideMaskTable = sArray;
    }

    public MarchingCubes() {
        int n = 12;
        while (--n >= 0) {
            this.edgeVectors[n] = new V3();
        }
        this.edgePointIndexes = new int[12];
        this.bsValues = new BS();
        this.pt0 = new P3();
        this.pointA = new P3();
        this.fReturn = new float[1];
        this.linearOffsets = new int[8];
    }

    public MarchingCubes(VertexDataServer vertexDataServer, VolumeData volumeData, Parameters parameters, BS bS) {
        int n = 12;
        while (--n >= 0) {
            this.edgeVectors[n] = new V3();
        }
        this.edgePointIndexes = new int[12];
        this.bsValues = new BS();
        this.pt0 = new P3();
        this.pointA = new P3();
        this.fReturn = new float[1];
        this.linearOffsets = new int[8];
        this.excludePartialCubes = true;
        this.surfaceReader = vertexDataServer;
        this.bsVoxels = bS;
        BS[] bSArray = parameters.bsExcluded;
        this.bsExcludedVertices = bSArray[0] == null ? new BS() : bSArray[0];
        this.bsExcludedPlanes = bSArray[2] == null ? new BS() : bSArray[2];
        BS bS2 = this.bsExcludedTriangles = bSArray[3] == null ? new BS() : bSArray[3];
        this.mode = volumeData.getVoxelData() != null || volumeData.mappingPlane != null ? 1 : (bS != null ? 2 : 3);
        this.setParameters(volumeData, parameters);
    }

    protected void setParameters(VolumeData volumeData, Parameters parameters) {
        this.volumeData = volumeData;
        this.colorDensity = parameters.colorDensity;
        this.isContoured = parameters.thePlane == null && parameters.isContoured && !this.colorDensity;
        this.cutoff = parameters.cutoff;
        this.isCutoffAbsolute = parameters.isCutoffAbsolute;
        this.contourType = parameters.contourType;
        this.isSquared = parameters.isSquared;
        this.isXLowToHigh = parameters.isXLowToHigh;
        this.cubeCountX = volumeData.voxelCounts[0] - 1;
        this.cubeCountY = volumeData.voxelCounts[1] - 1;
        this.cubeCountZ = volumeData.voxelCounts[2] - 1;
        volumeData.getYzCount();
        if (parameters.mapLattice != null) {
            this.cubeCountX = (int)((float)this.cubeCountX * Math.abs(parameters.mapLattice.x));
            this.cubeCountY = (int)((float)this.cubeCountY * Math.abs(parameters.mapLattice.y));
            this.cubeCountZ = (int)((float)this.cubeCountZ * Math.abs(parameters.mapLattice.z));
        }
        this.nY = this.cubeCountY + 1;
        this.nZ = this.cubeCountZ + 1;
        this.yzCount = this.nY * this.nZ;
        if (this.bsVoxels == null) {
            this.bsVoxels = new BS();
        }
        this.edgeVertexPointers = this.isXLowToHigh ? edgeVertexPointersLowToHigh : edgeVertexPointersHighToLow;
        this.edgeVertexPlanes = this.isXLowToHigh ? edgeVertexPlanesLowToHigh : edgeVertexPlanesHighToLow;
        this.isoPointIndexPlanes = new int[2][this.yzCount][3];
        this.yzPlanes = this.mode == 3 ? new float[2][this.yzCount] : null;
        this.setLinearOffsets();
        this.calcVoxelVertexVectors();
    }

    protected void calcVoxelVertexVectors() {
        int n = 8;
        while (--n >= 0) {
            this.voxelVertexVectors[n] = new V3();
            this.volumeData.transform(cubeVertexVectors[n], this.voxelVertexVectors[n]);
        }
        n = 12;
        while (--n >= 0) {
            this.edgeVectors[n].sub2(this.voxelVertexVectors[edgeVertexes[n + n + 1]], this.voxelVertexVectors[edgeVertexes[n + n]]);
        }
    }

    protected int[][] resetIndexPlane(int[][] nArray) {
        int n = 0;
        while (n < this.yzCount) {
            int n2 = 0;
            while (n2 < 3) {
                nArray[n][n2] = Integer.MIN_VALUE;
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    public String getEdgeData() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.cubeCountX < 0 || this.cubeCountY < 0 || this.cubeCountZ < 0) {
            return "";
        }
        this.mappingPlane = this.volumeData.mappingPlane;
        this.edgeCount = 0;
        if (this.isXLowToHigh) {
            n5 = 0;
            n4 = this.cubeCountX + (this.colorDensity ? 1 : 0);
            if (this.colorDensity) {
                n4 = this.cubeCountX + 1;
                n3 = this.yzCount - 1;
            } else {
                n4 = this.cubeCountX;
                n3 = this.yzCount - 1 - this.nZ - 1;
            }
            n2 = 1;
            n = this.yzCount;
        } else {
            if (this.colorDensity) {
                n5 = this.cubeCountX;
                n3 = (this.cubeCountX + 1) * this.yzCount - 1;
            } else {
                n5 = this.cubeCountX - 1;
                n3 = this.cubeCountX * this.yzCount - 1 - this.nZ - 1;
            }
            n4 = -1;
            n2 = -1;
            n = -this.yzCount;
        }
        int n6 = n3;
        this.resetIndexPlane(this.isoPointIndexPlanes[1]);
        this.voxelData = null;
        int n7 = this.cubeCountY + (this.colorDensity ? 1 : 0);
        int n8 = this.cubeCountZ + (this.colorDensity ? 1 : 0);
        switch (this.mode) {
            case 3: {
                this.getPlane(n5, false);
                break;
            }
            case 1: {
                this.voxelData = this.volumeData.getVoxelData();
            }
        }
        this.allInside = this.colorDensity && (this.cutoff == 0.0f || this.mode == 2 && this.bsVoxels.nextSetBit(0) < 0);
        boolean bl = this.colorDensity && this.cutoff == 0.0f;
        float f = 0.0f;
        int n9 = n5;
        while (n9 != n4) {
            if (this.mode == 3 && n9 + n2 <= n4) {
                this.getPlane(n9 + n2, true);
            }
            if (!this.bsExcludedPlanes.get(n9) || !this.bsExcludedPlanes.get(n9 + n2)) {
                int n10;
                if (this.colorDensity) {
                    int n11 = n7;
                    while (--n11 >= 0) {
                        n10 = n8;
                        while (--n10 >= 0) {
                            f = this.getValue(n9, n11, n10, n6, 0);
                            if (bl || this.isInside) {
                                this.addVertex(n9, n11, n10, n6, f);
                            }
                            --n6;
                        }
                    }
                } else {
                    int[][] nArray = this.isoPointIndexPlanes[0];
                    this.isoPointIndexPlanes[0] = this.isoPointIndexPlanes[1];
                    this.isoPointIndexPlanes[1] = this.resetIndexPlane(nArray);
                    n10 = 1;
                    int n12 = n7;
                    while (--n12 >= 0) {
                        int n13 = n8;
                        while (--n13 >= 0) {
                            int n14 = 0;
                            int n15 = 8;
                            while (--n15 >= 0) {
                                f = this.getValue(n9, n12, n13, n6, n15);
                                if (!this.isInside) continue;
                                n14 |= Pwr2[n15];
                            }
                            if (n10 != 0 && !Float.isNaN(f)) {
                                n10 = 0;
                            }
                            if (n14 != 0 && n14 != 255 && this.processOneCubical(n14, n9, n12, n13, n6) && !this.isContoured && !this.colorDensity) {
                                this.processTriangles(n14);
                            }
                            --n6;
                        }
                        --n6;
                    }
                    if (n10 != 0) {
                        this.bsExcludedPlanes.set(n9);
                    }
                }
            }
            n9 += n2;
            n6 = n3 += n;
        }
        return this.edgeData.toString();
    }

    private float getValue(int n, int n2, int n3, int n4, int n5) {
        float f;
        this.offset = cubeVertexOffsets[n5];
        int n6 = n4 + this.linearOffsets[n5];
        switch (this.mode) {
            case 3: {
                f = this.vertexValues[n5] = this.getValueArray(n + this.offset.x, n2 + this.offset.y, n3 + this.offset.z, n6, this.yzPlanes[yzPlanePts[n5]]);
                this.isInside = this.allInside || this.bsVoxels.get(n6);
                break;
            }
            case 2: {
                boolean bl = this.isInside = this.allInside || this.bsVoxels.get(n6);
                this.vertexValues[n5] = this.bsExcludedVertices.get(n6) ? Float.NaN : (float)(this.isInside ? 1 : 0);
                f = this.vertexValues[n5];
                break;
            }
            default: {
                if (this.mappingPlane == null) {
                    f = this.vertexValues[n5] = this.voxelData[n + this.offset.x][n2 + this.offset.y][n3 + this.offset.z];
                } else {
                    this.volumeData.voxelPtToXYZ(n + this.offset.x, n2 + this.offset.y, n3 + this.offset.z, this.pt0);
                    f = this.vertexValues[n5] = this.volumeData.distanceToMappingPlane(this.pt0);
                }
                if (this.isSquared) {
                    int n7 = n5;
                    this.vertexValues[n7] = this.vertexValues[n7] * this.vertexValues[n5];
                }
                boolean bl = this.isInside = this.allInside ? true : MarchingCubes.isInside(this.vertexValues[n5], this.cutoff, this.isCutoffAbsolute);
                if (!this.isInside) break;
                this.bsVoxels.set(n6);
            }
        }
        return f;
    }

    private void getPlane(int n, boolean bl) {
        if (n < 0 || n > this.cubeCountX) {
            return;
        }
        this.surfaceReader.getPlane(n);
        if (bl) {
            float[] fArray = this.yzPlanes[0];
            this.yzPlanes[0] = this.yzPlanes[1];
            this.yzPlanes[1] = fArray;
        }
    }

    protected void processTriangles(int n) {
        byte[] byArray = triangleTable2[n];
        int n2 = byArray.length;
        while ((n2 -= 4) >= 0) {
            this.addTriangle(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
        }
    }

    protected void addVertex(int n, int n2, int n3, int n4, float f) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.pt0);
        if (this.surfaceReader.addVertexCopy(this.pt0, f, -4, true) < 0) {
            this.bsExcludedVertices.set(n4);
        }
    }

    protected void addTriangle(int n, int n2, int n3, int n4) {
        if (!this.bsExcludedTriangles.get(this.nTriangles) && this.surfaceReader.addTriangleCheck(this.edgePointIndexes[n], this.edgePointIndexes[n2], this.edgePointIndexes[n3], n4, 0, this.isCutoffAbsolute, 0) < 0) {
            this.bsExcludedTriangles.set(this.nTriangles);
        }
        ++this.nTriangles;
    }

    protected float getValueArray(int n, int n2, int n3, int n4, float[] fArray) {
        int n5 = n4 % this.yzCount;
        this.bsValues.set(n4);
        float f = this.surfaceReader.getValue(n, n2, n3, n5);
        if (this.isSquared) {
            f *= f;
        }
        fArray[n5] = f;
        if (MarchingCubes.isInside(f, this.cutoff, this.isCutoffAbsolute)) {
            this.bsVoxels.set(n4);
        }
        return f;
    }

    public static boolean isInside(float f, float f2, boolean bl) {
        return f2 > 0.0f && (bl ? Math.abs(f) : f) >= f2 || f2 <= 0.0f && f <= f2;
    }

    protected boolean processOneCubical(int n, int n2, int n3, int n4, int n5) {
        short s = insideMaskTable[n];
        boolean bl = false;
        int n6 = 12;
        while (--n6 >= 0) {
            int n7 = Pwr2[n6];
            if ((s & n7) == 0) continue;
            int n8 = this.edgeVertexPlanes[n6];
            int n9 = (n5 + this.linearOffsets[this.edgeVertexPointers[n6]]) % this.yzCount;
            int n10 = edgeTypeTable[n6];
            this.edgePointIndexes[n6] = this.isoPointIndexPlanes[n8][n9][n10];
            int n11 = this.edgePointIndexes[n6];
            if (n11 != Integer.MIN_VALUE) {
                if (n11 != -1) continue;
                bl = this.excludePartialCubes;
                continue;
            }
            byte by = edgeVertexes[n6 << 1];
            byte by2 = edgeVertexes[(n6 << 1) + 1];
            float f = this.vertexValues[by];
            float f2 = this.vertexValues[by2];
            this.calcVertexPoint(n2, n3, n4, by, this.pointA);
            ++this.edgeCount;
            int n12 = this.surfaceReader.getSurfacePointIndexAndFraction(this.cutoff, this.isCutoffAbsolute, n2, n3, n4, cubeVertexOffsets[by], by, by2, f, f2, this.pointA, this.edgeVectors[n6], n10 == this.contourType, this.fReturn);
            this.isoPointIndexPlanes[n8][n9][n10] = n12;
            this.edgePointIndexes[n6] = n12;
            int n13 = n12;
            this.addEdgeData(n13 < 0 ? Float.NaN : this.fReturn[0]);
            if (!Float.isNaN(this.fReturn[0]) && n13 >= 0) continue;
            bl = this.excludePartialCubes;
        }
        return !bl;
    }

    protected void addEdgeData(float f) {
        char c = JvxlCoder.jvxlFractionAsCharacter(f);
        this.edgeData.appendC(c);
    }

    public void calcVertexPoint(int n, int n2, int n3, int n4, P3 p3) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.pt0);
        p3.add2(this.pt0, this.voxelVertexVectors[n4]);
    }

    protected void setLinearOffsets() {
        this.linearOffsets[0] = 0;
        this.linearOffsets[1] = this.yzCount;
        this.linearOffsets[2] = this.yzCount + 1;
        this.linearOffsets[3] = 1;
        this.linearOffsets[4] = this.nZ;
        this.linearOffsets[5] = this.yzCount + this.nZ;
        this.linearOffsets[6] = this.yzCount + this.nZ + 1;
        this.linearOffsets[7] = this.nZ + 1;
    }

    public int getLinearOffset(int n, int n2, int n3, int n4) {
        return n * this.yzCount + n2 * this.nZ + n3 + this.linearOffsets[n4];
    }
}

