/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import javajs.util.BS;
import javajs.util.Lst;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.forcefield.AtomType;
import org.jmol.modelset.Atom;

public class MinAtom {
    int index;
    public String sType;
    public Atom atom;
    public AtomType ffAtomType;
    public int ffType;
    public Integer vdwKey;
    public double[] coord = new double[3];
    public double[] force = new double[3];
    private Lst<MinBond> bonds = new Lst();
    public int nBonds;
    public int hCount;
    public double partialCharge;
    public BS bsVdw = new BS();
    public BS bs14 = new BS();
    int[] bondedAtoms;

    public String toString() {
        return "#" + this.index + " " + this.sType;
    }

    MinAtom(int n, Atom atom, double[] dArray, int n2) {
        this.index = n;
        this.atom = atom;
        this.coord = dArray;
        this.bsVdw.setBits(n + 1, n2);
        this.bsVdw.clear(n);
        this.hCount = atom.getCovalentHydrogenCount();
    }

    void set() {
        this.coord[0] = this.atom.x;
        this.coord[1] = this.atom.y;
        this.coord[2] = this.atom.z;
    }

    public MinBond getBondTo(int n) {
        this.getBondedAtomIndexes();
        int n2 = 0;
        while (n2 < this.nBonds) {
            if (this.bondedAtoms[n2] == n) {
                return (MinBond)this.bonds.get(n2);
            }
            ++n2;
        }
        return null;
    }

    public int[] getBondedAtomIndexes() {
        if (this.bondedAtoms == null) {
            this.bondedAtoms = new int[this.nBonds];
            int n = this.nBonds;
            while (--n >= 0) {
                this.bondedAtoms[n] = ((MinBond)this.bonds.get(n)).getOtherAtom(this.index);
            }
        }
        return this.bondedAtoms;
    }

    public String getIdentity() {
        return this.atom.getInfo();
    }

    public void addBond(MinBond minBond, int n) {
        this.bonds.addLast(minBond);
        ++this.nBonds;
        this.bsVdw.clear(n);
    }

    public int getBondIndex(int n) {
        return ((MinBond)this.bonds.get((int)n)).index;
    }

    public static boolean isLinear(MinAtom minAtom) {
        switch (minAtom.ffType) {
            case 4: 
            case 53: 
            case 61: {
                return true;
            }
        }
        return false;
    }
}

