/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Arrays;
import javajs.util.AU;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.PolyhedronStereoSorter;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.VTemp;
import org.jmol.util.Edge;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;

public class SmilesStereo {
    private int chiralClass = Integer.MIN_VALUE;
    int chiralOrder = Integer.MIN_VALUE;
    int atomCount;
    private String details;
    private SmilesSearch search;
    private Node[] jmolAtoms;
    private String directives;
    public static final int DEFAULT = 0;
    public static final int POLYHEDRAL = 1;
    public static final int ALLENE = 2;
    public static final int TRIGONAL_PYRAMIDAL = 3;
    public static final int TETRAHEDRAL = 4;
    public static final int TRIGONAL_BIPYRAMIDAL = 5;
    public static final int OCTAHEDRAL = 6;
    public static final int SQUARE_PLANAR = 7;
    public static final int T_SHAPED = 8;
    public static final int SEESAW = 9;
    private static final int[] PERM_TB;
    private static final int[] PERM_OCT;
    private static final int[] PERM_SS;
    VTemp v;
    private int[][] polyhedralOrders;
    private boolean isNot;
    private PolyhedronStereoSorter sorter;

    static {
        int[] nArray = new int[60];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[4] = -1;
        nArray[5] = 4;
        nArray[7] = 1;
        nArray[8] = 3;
        nArray[10] = -1;
        nArray[11] = 3;
        nArray[13] = 1;
        nArray[14] = 2;
        nArray[16] = -1;
        nArray[17] = 2;
        nArray[19] = 1;
        nArray[20] = 1;
        nArray[22] = -1;
        nArray[23] = 1;
        nArray[24] = 1;
        nArray[25] = 1;
        nArray[26] = 4;
        nArray[27] = 1;
        nArray[28] = 1;
        nArray[29] = 3;
        nArray[30] = 1;
        nArray[31] = -1;
        nArray[32] = 4;
        nArray[33] = 1;
        nArray[34] = -1;
        nArray[35] = 3;
        nArray[36] = 1;
        nArray[37] = 1;
        nArray[38] = 2;
        nArray[39] = 1;
        nArray[40] = -1;
        nArray[41] = 2;
        nArray[42] = 2;
        nArray[43] = 1;
        nArray[44] = 4;
        nArray[45] = 2;
        nArray[46] = 1;
        nArray[47] = 3;
        nArray[48] = 3;
        nArray[49] = 1;
        nArray[50] = 4;
        nArray[51] = 3;
        nArray[52] = -1;
        nArray[53] = 4;
        nArray[54] = 2;
        nArray[55] = -1;
        nArray[56] = 3;
        nArray[57] = 2;
        nArray[58] = -1;
        nArray[59] = 4;
        PERM_TB = nArray;
        int[] nArray2 = new int[90];
        nArray2[1] = 1;
        nArray2[2] = 5;
        nArray2[4] = -1;
        nArray2[5] = 5;
        nArray2[7] = 1;
        nArray2[8] = 4;
        nArray2[10] = 3;
        nArray2[11] = 5;
        nArray2[13] = 3;
        nArray2[14] = 4;
        nArray2[16] = 1;
        nArray2[17] = 3;
        nArray2[19] = 3;
        nArray2[20] = 3;
        nArray2[22] = 2;
        nArray2[23] = 5;
        nArray2[25] = 2;
        nArray2[26] = 4;
        nArray2[28] = -2;
        nArray2[29] = 5;
        nArray2[31] = -2;
        nArray2[32] = 4;
        nArray2[34] = 2;
        nArray2[35] = 3;
        nArray2[37] = -2;
        nArray2[38] = 3;
        nArray2[40] = -3;
        nArray2[41] = 5;
        nArray2[43] = -3;
        nArray2[44] = 4;
        nArray2[46] = -1;
        nArray2[47] = 4;
        nArray2[49] = -3;
        nArray2[50] = 3;
        nArray2[52] = -1;
        nArray2[53] = 3;
        nArray2[55] = 1;
        nArray2[56] = 2;
        nArray2[58] = 3;
        nArray2[59] = 2;
        nArray2[61] = 2;
        nArray2[62] = 2;
        nArray2[64] = -2;
        nArray2[65] = 2;
        nArray2[67] = -3;
        nArray2[68] = 2;
        nArray2[70] = -1;
        nArray2[71] = 2;
        nArray2[73] = 1;
        nArray2[74] = 1;
        nArray2[76] = 3;
        nArray2[77] = 1;
        nArray2[79] = 2;
        nArray2[80] = 1;
        nArray2[82] = -2;
        nArray2[83] = 1;
        nArray2[85] = -3;
        nArray2[86] = 1;
        nArray2[88] = -1;
        nArray2[89] = 1;
        PERM_OCT = nArray2;
        int[] nArray3 = new int[36];
        nArray3[1] = 1;
        nArray3[2] = 3;
        nArray3[4] = -1;
        nArray3[5] = 3;
        nArray3[7] = 1;
        nArray3[8] = 2;
        nArray3[10] = -1;
        nArray3[11] = 2;
        nArray3[13] = 1;
        nArray3[14] = 1;
        nArray3[16] = -1;
        nArray3[17] = 1;
        nArray3[18] = 1;
        nArray3[19] = 1;
        nArray3[20] = 3;
        nArray3[21] = 1;
        nArray3[22] = -1;
        nArray3[23] = 3;
        nArray3[24] = 1;
        nArray3[25] = 1;
        nArray3[26] = 2;
        nArray3[27] = 1;
        nArray3[28] = -1;
        nArray3[29] = 2;
        nArray3[30] = 2;
        nArray3[31] = 1;
        nArray3[32] = 3;
        nArray3[33] = 2;
        nArray3[34] = -1;
        nArray3[35] = 3;
        PERM_SS = nArray3;
    }

    private static int getChiralityClass(String string) {
        return ("0;PH;AL;TP;TH;TB;OH;SP;TS;SS;".indexOf(string) + 1) / 3;
    }

    public static SmilesStereo newStereo(SmilesSearch smilesSearch) throws InvalidSmilesException {
        SmilesStereo smilesStereo = new SmilesStereo(0, 0, 0, null, null);
        smilesStereo.search = smilesSearch;
        return smilesStereo;
    }

    SmilesStereo(int n, int n2, int n3, String string, String string2) throws InvalidSmilesException {
        this.chiralClass = n;
        this.chiralOrder = n2;
        this.atomCount = n3;
        this.details = string;
        this.directives = string2;
        if (n == 1) {
            this.getPolyhedralOrders();
        }
    }

    public int getChiralClass(SmilesAtom smilesAtom) {
        if (this.chiralClass == 0) {
            this.setChiralClass(smilesAtom);
        }
        return this.chiralClass;
    }

    private int setChiralClass(SmilesAtom smilesAtom) {
        int n = Math.max(smilesAtom.explicitHydrogenCount, 0) + smilesAtom.getBondCount();
        if (this.chiralClass == 0) {
            switch (n) {
                case 2: {
                    this.chiralClass = 2;
                    break;
                }
                case 3: {
                    this.chiralClass = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.chiralClass = n;
                }
            }
        }
        return n;
    }

    void fixStereo(SmilesAtom smilesAtom) throws InvalidSmilesException {
        int n = this.setChiralClass(smilesAtom);
        int n2 = Math.max(smilesAtom.explicitHydrogenCount, 0);
        if (n2 <= 1) {
            switch (this.chiralClass) {
                case 2: {
                    if (n == 2) break;
                    smilesAtom.stereo = null;
                    break;
                }
                case 3: 
                case 8: {
                    if (n == 3) break;
                    smilesAtom.stereo = null;
                    break;
                }
                case 4: 
                case 7: {
                    if (n == 4) break;
                    smilesAtom.stereo = null;
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    if (n == (this.chiralClass == 9 ? 4 : this.chiralClass) && this.normalizeClass(smilesAtom)) break;
                    smilesAtom.stereo = null;
                    break;
                }
                case 1: {
                    if (n == 0 || n == this.atomCount) break;
                    smilesAtom.stereo = null;
                    break;
                }
                default: {
                    smilesAtom.stereo = null;
                }
            }
        }
        if (smilesAtom.stereo == null) {
            throw new InvalidSmilesException("Incorrect number of bonds for stereochemistry descriptor");
        }
    }

    private boolean normalizeClass(SmilesAtom smilesAtom) {
        int n;
        int[] nArray;
        int n2;
        SmilesBond[] smilesBondArray;
        block18: {
            block17: {
                smilesBondArray = smilesAtom.bonds;
                if (this.chiralOrder >= 3) break block17;
                return true;
            }
            n2 = (this.chiralOrder - 1) * 3;
            switch (this.chiralClass) {
                case 9: {
                    nArray = PERM_SS;
                    n = 3;
                    break;
                }
                case 5: {
                    nArray = PERM_TB;
                    n = 4;
                    break;
                }
                case 6: {
                    nArray = PERM_OCT;
                    n = 5;
                    break;
                }
                default: {
                    return true;
                }
            }
            if (this.chiralOrder <= nArray.length) break block18;
            return false;
        }
        try {
            int n3;
            SmilesBond smilesBond;
            boolean bl;
            int n4 = nArray[n2];
            int n5 = nArray[n2 + 2];
            int n6 = Math.abs(nArray[n2 + 1]);
            boolean bl2 = bl = nArray[n2 + 1] < 0;
            if (n4 != 0) {
                smilesBond = smilesBondArray[n4];
                n3 = n4;
                while (n3 > 0) {
                    smilesBondArray[n3] = smilesBondArray[n3 - 1];
                    --n3;
                }
                smilesBondArray[0] = smilesBond;
            }
            if (n5 != n) {
                smilesBond = smilesBondArray[n5];
                n3 = n5;
                while (n3 < n) {
                    smilesBondArray[n3] = smilesBondArray[n3 + 1];
                    ++n3;
                }
                smilesBondArray[n] = smilesBond;
            }
            switch (n6) {
                case 1: {
                    break;
                }
                default: {
                    smilesBond = smilesBondArray[n6 + 1];
                    smilesBondArray[n6 + 1] = smilesBondArray[n6];
                    smilesBondArray[n6] = smilesBond;
                }
            }
            this.chiralOrder = bl ? 2 : 1;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean setTopoCoordinates(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, SmilesAtom smilesAtom3, Node[] nodeArray) {
        int[] nArray;
        int n = smilesAtom.stereo.chiralClass;
        int n2 = smilesAtom.stereo.chiralOrder;
        smilesAtom.set(0.0f, 0.0f, 0.0f);
        if (this.jmolAtoms == null) {
            int[] nArray2 = new int[4];
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray = nArray2;
        } else {
            smilesAtom = (SmilesAtom)this.jmolAtoms[smilesAtom2.getMatchingAtomIndex()];
            smilesAtom.set(0.0f, 0.0f, 0.0f);
            SmilesAtom smilesAtom4 = (SmilesAtom)(n == 2 ? this.jmolAtoms[smilesAtom3.getMatchingAtomIndex()] : null);
            nArray = this.getMappedTopoAtoms(smilesAtom, smilesAtom4, nodeArray);
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                if (n2 == 2) {
                    int n3 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n3;
                }
                nodeArray[nArray[0]].set(0.0f, 0.0f, 1.0f);
                nodeArray[nArray[1]].set(1.0f, 0.0f, -1.0f);
                nodeArray[nArray[2]].set(0.0f, 1.0f, -1.0f);
                nodeArray[nArray[3]].set(-1.0f, -1.0f, -1.0f);
                break;
            }
            case 7: {
                switch (n2) {
                    case 1: {
                        nodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[1]].set(0.0f, 1.0f, 0.0f);
                        nodeArray[nArray[2]].set(-1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        nodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[1]].set(-1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[2]].set(0.0f, 1.0f, 0.0f);
                        nodeArray[nArray[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 3: {
                        nodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[1]].set(0.0f, 1.0f, 0.0f);
                        nodeArray[nArray[2]].set(0.0f, -1.0f, 0.0f);
                        nodeArray[nArray[3]].set(-1.0f, 0.0f, 0.0f);
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        int n4 = nArray[2];
                        nArray[2] = nArray[1];
                        nArray[1] = n4;
                        break;
                    }
                    case 3: {
                        int n5 = nArray[0];
                        nArray[0] = nArray[1];
                        nArray[1] = n5;
                    }
                }
                nodeArray[nArray[0]].set(0.0f, 0.0f, -1.0f);
                nodeArray[nArray[1]].set(0.0f, 1.0f, 0.0f);
                nodeArray[nArray[2]].set(0.0f, 0.0f, 1.0f);
                break;
            }
            case 9: {
                if (n2 == 2) {
                    int n6 = nArray[0];
                    nArray[0] = nArray[3];
                    nArray[3] = n6;
                }
                nodeArray[nArray[0]].set(0.0f, 0.0f, 1.0f);
                nodeArray[nArray[1]].set(0.0f, 1.0f, 0.0f);
                nodeArray[nArray[1]].set(1.0f, 1.0f, 0.0f);
                nodeArray[nArray[2]].set(0.0f, 0.0f, -1.0f);
                break;
            }
            case 5: 
            case 6: {
                int n7 = nArray.length;
                if (n2 == 2) {
                    int n8 = nArray[0];
                    nArray[0] = nArray[n7 - 1];
                    nArray[n7 - 1] = n8;
                }
                nodeArray[nArray[0]].set(0.0f, 0.0f, 1.0f);
                nodeArray[nArray[n7 - 1]].set(0.0f, 0.0f, -1.0f);
                nodeArray[nArray[1]].set(1.0f, 0.0f, 0.0f);
                nodeArray[nArray[2]].set(0.0f, 1.0f, 0.0f);
                nodeArray[nArray[3]].set(-1.0f, 0.0f, 0.0f);
                if (n7 != 6) break;
                nodeArray[nArray[4]].set(0.0f, -1.0f, 0.0f);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private int[] getMappedTopoAtoms(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, Node[] nodeArray) {
        int[] nArray = new int[nodeArray[4] == null ? 4 : (nodeArray[5] == null ? 5 : 6)];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = nodeArray[n] == null ? 10004 + n * 10000 : nodeArray[n].getIndex();
            ++n;
        }
        SmilesBond[] smilesBondArray = smilesAtom.bonds;
        SmilesBond[] smilesBondArray2 = (SmilesBond[])(smilesAtom2 == null ? null : smilesAtom2.getEdges());
        int n2 = 0;
        while (n2 < nArray.length) {
            SmilesAtom smilesAtom3 = (SmilesAtom)nodeArray[n2];
            if (!SmilesStereo.getTopoMapPt(nArray, n2, smilesAtom, smilesAtom3, smilesBondArray, 10000)) {
                SmilesStereo.getTopoMapPt(nArray, n2, smilesAtom2, smilesAtom3, smilesBondArray2, 30000);
            }
            ++n2;
        }
        Arrays.sort(nArray);
        n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = nArray[n2] % 10;
            ++n2;
        }
        return nArray;
    }

    private static boolean getTopoMapPt(int[] nArray, int n, SmilesAtom smilesAtom, SmilesAtom smilesAtom2, SmilesBond[] smilesBondArray, int n2) {
        if (smilesAtom2.index == Integer.MIN_VALUE) {
            nArray[n] = (smilesBondArray[0].isFromPreviousTo(smilesAtom) ? 100 : 0) + n2 + n;
            return true;
        }
        int n3 = smilesBondArray.length;
        int n4 = 0;
        while (n4 < n3) {
            SmilesAtom smilesAtom3 = (SmilesAtom)smilesBondArray[n4].getOtherNode(smilesAtom);
            if (smilesAtom3 == smilesAtom2) {
                nArray[n] = (n4 + 1) * 10 + n2 + n;
                return true;
            }
            ++n4;
        }
        return false;
    }

    private Node getJmolAtom(int n) {
        return n < 0 || n >= this.jmolAtoms.length ? null : this.jmolAtoms[n];
    }

    void sortBondsByStereo(SimpleNode simpleNode, SimpleNode simpleNode2, T3 t3, SimpleEdge[] simpleEdgeArray, V3 v3) {
        if (simpleEdgeArray.length < 2 || !(simpleNode instanceof T3)) {
            return;
        }
        if (simpleNode2 == null) {
            simpleNode2 = simpleEdgeArray[0].getOtherNode(simpleNode);
        }
        Object[][] objectArray = new Object[simpleEdgeArray.length][0];
        if (this.sorter == null) {
            this.sorter = new PolyhedronStereoSorter();
        }
        v3.sub2((T3)((Object)simpleNode2), t3);
        this.sorter.setRef(v3);
        int n = simpleEdgeArray.length;
        while (--n >= 0) {
            float f;
            SimpleNode simpleNode3 = simpleEdgeArray[n].getOtherNode(simpleNode);
            float f2 = simpleNode3 == simpleNode2 ? 0.0f : (f = this.sorter.isAligned((T3)((Object)simpleNode3), t3, (T3)((Object)simpleNode2)) ? -999.0f : Measure.computeTorsion((T3)((Object)simpleNode), (T3)((Object)simpleNode2), t3, (T3)((Object)simpleNode3), true));
            if (simpleEdgeArray.length > 2) {
                f += 360.0f;
            }
            objectArray[n] = new Object[]{simpleEdgeArray[n], Float.valueOf(f), simpleNode3};
        }
        Arrays.sort(objectArray, this.sorter);
        if (Logger.debugging) {
            Logger.info(Escape.e(objectArray));
        }
        n = simpleEdgeArray.length;
        while (--n >= 0) {
            simpleEdgeArray[n] = (Edge)objectArray[n][0];
        }
    }

    boolean checkStereoChemistry(SmilesSearch smilesSearch, VTemp vTemp) {
        this.v = vTemp;
        this.search = smilesSearch;
        this.jmolAtoms = smilesSearch.targetAtoms;
        boolean bl = smilesSearch.haveTopo;
        boolean bl2 = smilesSearch.invertStereochemistry;
        if (Logger.debugging) {
            Logger.debug("checking stereochemistry...");
        }
        int n = 0;
        while (n < smilesSearch.ac) {
            SmilesAtom smilesAtom = smilesSearch.patternAtoms[n];
            if (smilesAtom.stereo != null) {
                boolean bl3 = smilesAtom.not ^ bl2;
                Node node = smilesAtom.getMatchingAtom();
                switch (this.checkStereoForAtom(smilesAtom, node, bl3, bl)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return true;
                    }
                    case -1: {
                        return false;
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public int checkStereoForAtom(SmilesAtom smilesAtom, Node node, boolean bl, boolean bl2) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        Node node5 = null;
        Node node6 = null;
        Node node7 = null;
        SmilesAtom smilesAtom2 = null;
        SmilesAtom smilesAtom3 = null;
        if (bl2) {
            smilesAtom3 = (SmilesAtom)node;
        }
        int n = Math.max(smilesAtom.explicitHydrogenCount, 0);
        int n2 = smilesAtom.stereo.chiralOrder;
        int n3 = smilesAtom.stereo.chiralClass;
        if (bl2 && smilesAtom3.getChiralClass() != n3) {
            return -1;
        }
        if (Logger.debugging) {
            Logger.debug("...type " + n3 + " for pattern atom \n " + smilesAtom + "\n " + node);
        }
        switch (n3) {
            case 1: {
                if (smilesAtom.stereo.isNot) {
                    boolean bl3 = bl = !bl;
                }
                if (n > 1 || smilesAtom.bondCount == 0) {
                    return 0;
                }
                if (bl2) {
                    return 0;
                }
                SmilesBond[] smilesBondArray = smilesAtom.bonds;
                int n4 = -1;
                if (n == 1) {
                    int n5 = n4 = smilesAtom.isFirst ? 0 : 1;
                    if (smilesAtom.getBondCount() != 3) {
                        return -1;
                    }
                    this.v.vA.set(0.0f, 0.0f, 0.0f);
                    int n6 = 0;
                    while (n6 < 3) {
                        this.v.vA.add((T3)((Object)smilesBondArray[n6].getOtherAtom(smilesAtom3).getMatchingAtom()));
                        ++n6;
                    }
                    this.v.vA.scale(0.3333f);
                    this.v.vA.sub2((T3)((Object)node), this.v.vA);
                    this.v.vA.add((T3)((Object)node));
                }
                int[][] nArray = smilesAtom.stereo.polyhedralOrders;
                int n7 = nArray.length;
                while (--n7 >= 0) {
                    int[] nArray2 = nArray[n7];
                    if (nArray2 == null || nArray2.length < 2) continue;
                    int n8 = n7 > n4 ? n7 - n : n7;
                    V3 v3 = n7 == n4 ? this.v.vA : (T3)((Object)smilesBondArray[n8].getOtherAtom(smilesAtom).getMatchingAtom());
                    float f = bl ? Float.MAX_VALUE : 0.0f;
                    V3 v32 = null;
                    int n9 = 0;
                    while (n9 < nArray2.length) {
                        T3 t3;
                        n8 = nArray2[n9];
                        if (n8 == n4) {
                            t3 = this.v.vA;
                        } else {
                            if (n8 > n4) {
                                --n8;
                            }
                            t3 = (T3)((Object)smilesBondArray[n8].getOtherAtom(smilesAtom).getMatchingAtom());
                        }
                        if (n9 == 0) {
                            v32 = t3;
                        } else {
                            float f2 = Measure.computeTorsion(t3, v3, (T3)((Object)node), v32, true);
                            if (Float.isNaN(f2)) {
                                f2 = 180.0f;
                            }
                            if (nArray2.length == 2) {
                                return f2 < 0.0f != bl ? 1 : -1;
                            }
                            if (f2 < 0.0f) {
                                f2 += 360.0f;
                            }
                            if (f2 < f != bl) {
                                return -1;
                            }
                            f = f2;
                        }
                        ++n9;
                    }
                }
                return 0;
            }
            case 2: {
                Node[] nodeArray = this.getAlleneAtoms(smilesAtom, null);
                if (nodeArray == null) {
                    return 0;
                }
                if (bl2 && !this.setTopoCoordinates(smilesAtom3, smilesAtom, smilesAtom2, nodeArray)) {
                    return -1;
                }
                if (!SmilesStereo.checkStereochemistryAll(bl, node, n3, n2, nodeArray[0], nodeArray[1], nodeArray[2], nodeArray[3], null, null, this.v)) {
                    return -1;
                }
                return 0;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                node2 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(0));
                switch (n) {
                    case 0: {
                        node3 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(1));
                        break;
                    }
                    case 1: {
                        node3 = this.search.findImplicitHydrogen(smilesAtom.getMatchingAtom());
                        if (!smilesAtom.isFirst) break;
                        Node node8 = node3;
                        node3 = node2;
                        node2 = node8;
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                node4 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(2 - n));
                node5 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(3 - n));
                node6 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(4 - n));
                node7 = this.getJmolAtom(smilesAtom.getMatchingBondedAtom(5 - n));
                if (bl2 && !this.setTopoCoordinates(smilesAtom3, smilesAtom, null, new Node[]{node2, node3, node4, node5, node6, node7})) {
                    return -1;
                }
                if (!SmilesStereo.checkStereochemistryAll(bl, node, n3, n2, node2, node3, node4, node5, node6, node7, this.v)) {
                    return -1;
                }
                return 0;
            }
        }
        return 0;
    }

    public Node[] getAlleneAtoms(SmilesAtom smilesAtom, SmilesAtom smilesAtom2) {
        SmilesBond smilesBond;
        Object object;
        SmilesAtom smilesAtom3;
        if (smilesAtom2 == null) {
            smilesAtom2 = smilesAtom.getBond(0).getOtherAtom(smilesAtom);
        }
        if ((smilesAtom3 = smilesAtom.getBond(1).getOtherAtom(smilesAtom)) == smilesAtom2) {
            smilesAtom3 = smilesAtom.getBond(0).getOtherAtom(smilesAtom);
        }
        if (smilesAtom2 == null || smilesAtom3 == null) {
            return null;
        }
        SmilesAtom smilesAtom4 = smilesAtom;
        SmilesAtom smilesAtom5 = smilesAtom;
        while (smilesAtom2.getBondCount() == 2 && smilesAtom3.getBondCount() == 2 && smilesAtom2.getValence() == 4 && smilesAtom3.getValence() == 4) {
            object = smilesAtom2.getBondNotTo(smilesAtom4, true);
            smilesAtom4 = smilesAtom2;
            smilesAtom2 = ((SmilesBond)object).getOtherAtom(smilesAtom2);
            object = smilesAtom3.getBondNotTo(smilesAtom5, true);
            smilesAtom5 = smilesAtom3;
            smilesAtom3 = ((SmilesBond)object).getOtherAtom(smilesAtom3);
        }
        smilesAtom = smilesAtom2;
        object = new Node[6];
        object[4] = new SmilesAtom().setIndex(60004);
        int n = smilesAtom.getBondCount();
        if (n != 2 && n != 3) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            smilesBond = smilesAtom.bonds[n2];
            smilesAtom2 = smilesBond.getOtherAtom(smilesAtom);
            if (smilesBond.getMatchingBond().getCovalentOrder() == 2) {
                if (smilesAtom3 == null) {
                    smilesAtom3 = smilesAtom2;
                }
            } else {
                if (!(smilesBond.atom1 != smilesAtom2 || smilesBond.isConnection && smilesAtom2.index <= smilesAtom.index)) {
                    n3 = 0;
                } else if (object[1] == null) {
                    n3 = 1;
                } else {
                    n3 = 1;
                    object[0] = object[1];
                }
                object[n3] = smilesAtom2.getMatchingAtom();
            }
            ++n2;
        }
        if (smilesAtom3 == null) {
            return null;
        }
        n = smilesAtom3.getBondCount();
        if (n != 2 && n != 3) {
            return null;
        }
        n2 = 0;
        n3 = 0;
        while (n3 < n) {
            smilesBond = smilesAtom3.bonds[n3];
            smilesAtom2 = smilesBond.getOtherAtom(smilesAtom3);
            if (smilesBond.getMatchingBond().getCovalentOrder() != 2) {
                if (!(smilesBond.atom1 != smilesAtom2 || smilesBond.isConnection && smilesAtom2.index <= smilesAtom3.index)) {
                    n2 = 2;
                } else if (object[3] == null) {
                    n2 = 3;
                } else {
                    n2 = 3;
                    object[2] = object[3];
                }
                object[n2] = smilesAtom2.getMatchingAtom();
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < 4) {
            if (object[n2] == null) {
                this.addAlleneLonePair(n2 < 2 ? smilesAtom : smilesAtom3, (Node[])object, n2);
            }
            ++n2;
        }
        return object;
    }

    private void addAlleneLonePair(SmilesAtom smilesAtom, Node[] nodeArray, int n) {
        Node node = smilesAtom.getMatchingAtom();
        nodeArray[n] = this.search.findImplicitHydrogen(node);
        if (nodeArray[n] != null) {
            return;
        }
        V3 v3 = new V3();
        int n2 = 0;
        while (n2 < 4) {
            if (nodeArray[n2] != null) {
                v3.sub((P3)((Object)nodeArray[n2]));
            }
            ++n2;
        }
        if (v3.length() == 0.0f) {
            v3.setT((P3)((Object)nodeArray[4]));
        } else {
            v3.scaleAdd2(2.0f, (P3)((Object)smilesAtom.getMatchingAtom()), v3);
        }
        nodeArray[n] = new SmilesAtom().setIndex(Integer.MIN_VALUE);
        ((P3)((Object)nodeArray[n])).setT(v3);
    }

    static String getStereoFlag(SimpleNode simpleNode, SimpleNode[] simpleNodeArray, int n, VTemp vTemp) {
        SimpleNode simpleNode2 = simpleNodeArray[0];
        SimpleNode simpleNode3 = simpleNodeArray[1];
        SimpleNode simpleNode4 = simpleNodeArray[2];
        SimpleNode simpleNode5 = simpleNodeArray[3];
        SimpleNode simpleNode6 = simpleNodeArray[4];
        SimpleNode simpleNode7 = simpleNodeArray[5];
        int n2 = 4;
        switch (n) {
            default: {
                return SmilesStereo.checkStereochemistryAll(false, simpleNode, n2, 1, simpleNode2, simpleNode3, simpleNode4, simpleNode5, simpleNode6, simpleNode7, vTemp) ? "@" : "@@";
            }
            case 2: 
            case 4: 
        }
        if (simpleNode4 == null || simpleNode5 == null) {
            return "";
        }
        float f = Measure.getNormalThroughPoints((P3)((Object)simpleNode2), (P3)((Object)simpleNode3), (P3)((Object)simpleNode4), vTemp.vTemp, vTemp.vA);
        if (Math.abs(Measure.distanceToPlaneV(vTemp.vTemp, f, (P3)((Object)simpleNode5))) < 0.2f) {
            n2 = 7;
            if (SmilesStereo.checkStereochemistryAll(false, simpleNode, n2, 1, simpleNode2, simpleNode3, simpleNode4, simpleNode5, simpleNode6, simpleNode7, vTemp)) {
                return "@SP1";
            }
            if (SmilesStereo.checkStereochemistryAll(false, simpleNode, n2, 2, simpleNode2, simpleNode3, simpleNode4, simpleNode5, simpleNode6, simpleNode7, vTemp)) {
                return "@SP2";
            }
            if (SmilesStereo.checkStereochemistryAll(false, simpleNode, n2, 3, simpleNode2, simpleNode3, simpleNode4, simpleNode5, simpleNode6, simpleNode7, vTemp)) {
                return "@SP3";
            }
        } else {
            return SmilesStereo.checkStereochemistryAll(false, simpleNode, n2, 1, simpleNode2, simpleNode3, simpleNode4, simpleNode5, simpleNode6, simpleNode7, vTemp) ? "@" : "@@";
        }
        return "";
    }

    private static boolean checkStereochemistryAll(boolean bl, SimpleNode simpleNode, int n, int n2, SimpleNode simpleNode2, SimpleNode simpleNode3, SimpleNode simpleNode4, SimpleNode simpleNode5, SimpleNode simpleNode6, SimpleNode simpleNode7, VTemp vTemp) {
        switch (n) {
            default: {
                return true;
            }
            case 2: 
            case 4: {
                return bl == (SmilesStereo.getHandedness(simpleNode3, simpleNode4, simpleNode5, simpleNode2, vTemp) != n2);
            }
            case 7: {
                SmilesStereo.getPlaneNormals((P3)((Object)simpleNode2), (P3)((Object)simpleNode3), (P3)((Object)simpleNode4), (P3)((Object)simpleNode5), vTemp);
                return vTemp.vNorm2.dot(vTemp.vNorm3) < 0.0f ? bl == (n2 != 3) : (vTemp.vNorm3.dot(vTemp.vNorm4) < 0.0f ? bl == (n2 != 2) : bl == (n2 != 1));
            }
            case 3: {
                return bl == (SmilesStereo.getHandedness(simpleNode2, simpleNode3, simpleNode4, simpleNode, vTemp) != n2);
            }
            case 5: {
                if (!SmilesStereo.isDiaxial(simpleNode, simpleNode, simpleNode6, simpleNode2, vTemp, -0.95f)) {
                    return false;
                }
                return bl == (SmilesStereo.getHandedness(simpleNode3, simpleNode4, simpleNode5, simpleNode2, vTemp) != n2);
            }
            case 8: {
                switch (n2) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        simpleNode4 = simpleNode3;
                        break;
                    }
                    case 3: {
                        simpleNode2 = simpleNode3;
                    }
                }
                return bl == !SmilesStereo.isDiaxial(simpleNode, simpleNode, simpleNode2, simpleNode4, vTemp, -0.95f);
            }
            case 9: {
                if (!SmilesStereo.isDiaxial(simpleNode, simpleNode, simpleNode5, simpleNode2, vTemp, -0.95f)) {
                    return false;
                }
                return bl == (SmilesStereo.getHandedness(simpleNode3, simpleNode4, simpleNode5, simpleNode2, vTemp) != n2);
            }
            case 6: {
                if (!(SmilesStereo.isDiaxial(simpleNode, simpleNode, simpleNode7, simpleNode2, vTemp, -0.95f) && SmilesStereo.isDiaxial(simpleNode, simpleNode, simpleNode3, simpleNode5, vTemp, -0.95f) && SmilesStereo.isDiaxial(simpleNode, simpleNode, simpleNode4, simpleNode6, vTemp, -0.95f))) {
                    return false;
                }
                SmilesStereo.getPlaneNormals((P3)((Object)simpleNode3), (P3)((Object)simpleNode4), (P3)((Object)simpleNode5), (P3)((Object)simpleNode6), vTemp);
                if (vTemp.vNorm2.dot(vTemp.vNorm3) < 0.0f || vTemp.vNorm3.dot(vTemp.vNorm4) < 0.0f) {
                    return false;
                }
                vTemp.vNorm3.sub2((P3)((Object)simpleNode), (P3)((Object)simpleNode2));
                return bl == ((vTemp.vNorm2.dot(vTemp.vNorm3) < 0.0f ? 2 : 1) == n2);
            }
            case 1: 
        }
        return true;
    }

    static boolean isDiaxial(SimpleNode simpleNode, SimpleNode simpleNode2, SimpleNode simpleNode3, SimpleNode simpleNode4, VTemp vTemp, float f) {
        vTemp.vA.sub2((P3)((Object)simpleNode), (P3)((Object)simpleNode3));
        vTemp.vB.sub2((P3)((Object)simpleNode2), (P3)((Object)simpleNode4));
        vTemp.vA.normalize();
        vTemp.vB.normalize();
        return vTemp.vA.dot(vTemp.vB) < f;
    }

    static int getHandedness(SimpleNode simpleNode, SimpleNode simpleNode2, SimpleNode simpleNode3, SimpleNode simpleNode4, VTemp vTemp) {
        float f = Measure.getNormalThroughPoints((P3)((Object)simpleNode), (P3)((Object)simpleNode2), (P3)((Object)simpleNode3), vTemp.vTemp, vTemp.vA);
        return (f = Measure.distanceToPlaneV(vTemp.vTemp, f, (P3)((Object)simpleNode4))) > 0.0f ? 1 : 2;
    }

    private static void getPlaneNormals(P3 p3, P3 p32, P3 p33, P3 p34, VTemp vTemp) {
        Measure.getNormalThroughPoints(p3, p32, p33, vTemp.vNorm2, vTemp.vTemp1);
        Measure.getNormalThroughPoints(p32, p33, p34, vTemp.vNorm3, vTemp.vTemp1);
        Measure.getNormalThroughPoints(p33, p34, p3, vTemp.vNorm4, vTemp.vTemp1);
    }

    static int checkChirality(SmilesSearch smilesSearch, String string, int n, SmilesAtom smilesAtom) throws InvalidSmilesException {
        int n2 = 0;
        int n3 = Integer.MIN_VALUE;
        int n4 = string.length();
        String string2 = null;
        String string3 = null;
        int n5 = 0;
        n2 = 0;
        n3 = 1;
        boolean bl = false;
        if (++n < n4) {
            char c = string.charAt(n);
            switch (c) {
                case '@': {
                    n3 = 2;
                    ++n;
                    break;
                }
                case '+': 
                case '-': 
                case 'H': {
                    break;
                }
                case 'P': {
                    bl = true;
                }
                case 'A': 
                case 'O': 
                case 'S': 
                case 'T': {
                    n2 = n + 1 < n4 ? SmilesStereo.getChiralityClass(string.substring(n, n + 2)) : -1;
                    n += 2;
                    break;
                }
                default: {
                    n3 = PT.isDigit(c) ? 1 : -1;
                }
            }
            int n6 = n;
            if (n3 == 1 || bl) {
                while (n6 < n4 && PT.isDigit(string.charAt(n6))) {
                    ++n6;
                }
                if (n6 > n) {
                    try {
                        int n7 = Integer.parseInt(string.substring(n, n6));
                        if (bl) {
                            n5 = n7;
                            if (n6 < n4 && string.charAt(n6) == '(') {
                                string2 = SmilesParser.getSubPattern(string, n6, '(');
                                n6 += string2.length() + 2;
                            }
                            if (n6 < n4 && string.charAt(n6) == '/') {
                                string3 = SmilesParser.getSubPattern(string, n6, '/');
                                n6 += string3.length() + 2;
                            }
                        } else {
                            n3 = n7;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = -1;
                    }
                    n = n6;
                }
            }
            if (n3 < 1 || n2 < 0) {
                throw new InvalidSmilesException("Invalid stereochemistry descriptor");
            }
        }
        smilesAtom.stereo = new SmilesStereo(n2, n3, n5, string2, string3);
        smilesAtom.stereo.search = smilesSearch;
        if (SmilesParser.getChar(string, n) == '?') {
            Logger.info("Ignoring '?' in stereochemistry");
            ++n;
        }
        return n;
    }

    private void getPolyhedralOrders() throws InvalidSmilesException {
        this.polyhedralOrders = AU.newInt2(this.atomCount);
        int[][] nArray = this.polyhedralOrders;
        if (this.details == null) {
            return;
        }
        int[] nArray2 = new int[this.details.length()];
        int[] nArray3 = new int[1];
        String string = null;
        int n = 0;
        String string2 = String.valueOf(this.details) + "/";
        int n2 = 0;
        int n3 = string2.length();
        int n4 = 0;
        int n5 = 0;
        do {
            char c = string2.charAt(n4);
            switch (c) {
                case '!': {
                    this.isNot = true;
                    ++n4;
                    break;
                }
                case '.': 
                case '/': {
                    n = n5;
                    if (n >= this.atomCount) {
                        string = "Too many descriptors";
                        break;
                    }
                    nArray[n5] = new int[n2];
                    int[] nArray4 = nArray[n5];
                    while (--n2 >= 0) {
                        nArray4[n2] = nArray2[n2];
                    }
                    n2 = 0;
                    if (Logger.debugging) {
                        Logger.info(PT.toJSON("@PH" + this.atomCount + "[" + n5 + "]", nArray4));
                    }
                    n4 = c == '/' ? Integer.MAX_VALUE : ++n4;
                    ++n5;
                    break;
                }
                default: {
                    n4 = SmilesParser.getRingNumber(string2, n4, c, nArray3);
                    int n6 = n2++;
                    int n7 = nArray3[0] - 1;
                    nArray2[n6] = n7;
                    n = n7;
                    if (n == n5) {
                        string = "Atom cannot connect to itself";
                        break;
                    }
                    if (n < 0 || n >= this.atomCount) {
                        string = "Connection number outside of range (1-" + this.atomCount + ")";
                        break;
                    }
                    if (n2 < this.atomCount) break;
                    string = "Too many connections indicated";
                }
            }
            if (string == null) continue;
            string = String.valueOf(string) + ": " + string2.substring(0, n4) + "<<";
            throw new InvalidSmilesException(string);
        } while (n4 < n3);
    }
}

