/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.model;

import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.model.Pair;
import com.github.cereda.arara.utils.CommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Language {
    private final String code;
    private static final Map<String, Pair<String, Locale>> languages = new HashMap<String, Pair<String, Locale>>();
    private static final LanguageController messages = LanguageController.getInstance();

    public static void init() {
        languages.put("en", new Pair<String, Locale>("English", new Locale("en")));
        languages.put("de", new Pair<String, Locale>("German", new Locale("de")));
        languages.put("nl", new Pair<String, Locale>("Dutch", new Locale("nl")));
        languages.put("qn", new Pair<String, Locale>("Broad Norfolk", new Locale("en", "QN")));
        languages.put("ptbr", new Pair<String, Locale>("Brazilian Portuguese", new Locale("pt", "BR")));
        languages.put("it", new Pair<String, Locale>("Italian", new Locale("it")));
    }

    public Language(String code) throws AraraException {
        if (!languages.containsKey(code)) {
            throw new AraraException(messages.getMessage(Messages.ERROR_LANGUAGE_INVALID_CODE, Language.getLanguagesList()));
        }
        this.code = code;
    }

    public String getName() {
        return languages.get(this.code).getFirstElement();
    }

    public Locale getLocale() {
        return languages.get(this.code).getSecondElement();
    }

    public static String getLanguagesList() {
        ArrayList<String> entries = new ArrayList<String>();
        for (String key : languages.keySet()) {
            entries.add(languages.get(key).getFirstElement().concat(": ").concat(key));
        }
        return CommonUtils.getCollectionElements(entries, "(", ")", ", ");
    }
}

