/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java;

import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import java.util.Objects;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;

public abstract class PrimitiveNode
extends HeapViewerNode {
    private String fieldName;

    public String getFieldName() {
        if (this.fieldName == null) {
            this.fieldName = this.computeFieldName();
        }
        return this.fieldName;
    }

    protected abstract String computeFieldName();

    public abstract String getType();

    public abstract String getValue();

    public String toString() {
        return this.getFieldName();
    }

    protected Object getValue(DataType type, Heap heap) {
        if (type == DataType.NAME) {
            return this.getFieldName();
        }
        if (type == DataType.OWN_SIZE) {
            return DataType.OWN_SIZE.getNoValue();
        }
        if (type == DataType.RETAINED_SIZE) {
            return DataType.RETAINED_SIZE.getNoValue();
        }
        if (type == DataType.OBJECT_ID) {
            return DataType.OBJECT_ID.getNoValue();
        }
        return super.getValue(type, heap);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public static class ArrayItem
    extends PrimitiveNode {
        private final int index;
        private final String type;
        private final String value;
        private final Instance owner;

        public ArrayItem(int index, String type, String value, Instance owner) {
            this.index = index;
            this.type = type;
            this.value = value;
            this.owner = owner;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayItem)) {
                return false;
            }
            ArrayItem oo = (ArrayItem)((Object)o);
            return this.owner.equals(oo.owner) && this.index == oo.index;
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.index);
        }

        @Override
        protected String computeFieldName() {
            return "[" + this.index + "]";
        }
    }

    public static class Field
    extends PrimitiveNode {
        private final FieldValue field;

        public Field(FieldValue field) {
            this.field = field;
        }

        @Override
        public String getType() {
            return this.field.getField().getType().getName();
        }

        @Override
        public String getValue() {
            return this.field.getValue();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            return this.field.equals(((Field)((Object)o)).field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        @Override
        protected String computeFieldName() {
            return (this.field.getField().isStatic() ? "static " : "") + this.field.getField().getName();
        }
    }
}

