/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Icons;
import esmska.utils.L10N;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.DefaultEditorKit;

public class ClipboardPopupMenu
extends JPopupMenu {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static ClipboardPopupMenu instance;
    private static PopupListener popupListener;

    private ClipboardPopupMenu() {
        JMenuItem menuItem = null;
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText(l10n.getString("ClipboardPopupMenu.Cut"));
        menuItem.setIcon(Icons.get("cut-16.png"));
        this.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText(l10n.getString("ClipboardPopupMenu.Copy"));
        menuItem.setIcon(Icons.get("copy-16.png"));
        this.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText(l10n.getString("ClipboardPopupMenu.Paste"));
        menuItem.setIcon(Icons.get("paste-16.png"));
        this.add(menuItem);
        popupListener = new PopupListener();
    }

    public static void register(JComponent component) {
        if (instance == null) {
            instance = new ClipboardPopupMenu();
        }
        component.addMouseListener(popupListener);
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Component comp = e.getComponent();
                if (comp != null && !comp.isFocusOwner()) {
                    comp.requestFocusInWindow();
                }
                ClipboardPopupMenu.this.show(comp, e.getX(), e.getY());
            }
        }
    }
}

