/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
#include"getput.h"
#include"longtools.h"


int INFO_LEVEL;
int SFLAG;


main (int argc, char *argv[])
{

	matrix_TYP **A, **B, **X;
        int i, Aanz, Banz;


        read_header(argc, argv);
        if(FILEANZ != 1 && FILEANZ != 2)
        {
           printf("Usage: %s 'file1' ['file2']\n", argv[0]);
           printf("\n");
           printf("file1: matrix_TYP containing the matrices A_i\n");
           printf("file2: matrix_TYP containing the matrices B_i\n");
           printf("\n");
           printf("Calculates matrices X_i such that A_i X_i = B_i for all matrices\n");
           printf("A_i in file1. If 'file2' is omitted the B_i are assumed to be 0.\n");
           printf("\n");
           printf("Cf. Gauss.\n");
           if (is_option('h')){
              exit(0);
           }
           else{
              exit(31);
           }
        }

        if (is_option('h')){ INFO_LEVEL = optionnumber('h');}
        if (INFO_LEVEL & 8){
           SFLAG = 1;
        }

	A = mget_mat (FILENAMES[0], &Aanz);
        if(FILEANZ == 2){
           B = mget_mat(FILENAMES[1], &Banz);
        }
        else{
           Banz = 0;
        }
        if(Aanz > 1)
          printf("#%d\n", Aanz);
        for(i=0;i<Aanz;i++)
        {
            if(i<Banz)
              X = long_solve_mat(A[i], B[i]);
            else
              X = long_solve_mat(A[i], NULL);
            if(X[0] != 0)
            {
               put_mat(X[0], NULL, "inhomogenous solution", 2);
               free_mat(X[0]);
            }
            else if (i<Banz && B[i] != NULL){
               printf("there does not exists an inhomogenous solution\n");
            }
            if(X[1] != NULL)
            {
               put_mat(X[1], NULL, "homogenous solutions as columns", 0);
               free_mat(X[1]);
            }
            free(X);
        }

        for (i=0;i<Aanz;i++) free_mat(A[i]);
        for (i=0;i<Banz;i++) free_mat(B[i]);
        free(A);
        if (B!=NULL) free(B);
        if (INFO_LEVEL & 8){
           pointer_statistics(0,0);
        }

   exit(0);
}
