/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementVisitorVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InlinedLambdasCollector;", "Lorg/jetbrains/kotlin/backend/common/IrElementVisitorVoidWithContext;", "()V", "inlinedLambdasInNonPublicContexts", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isInlineNonpublicContext", "", "scopeStack", "", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFunctionAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "backend"})
final class InlinedLambdasCollector
extends IrElementVisitorVoidWithContext {
    private final Set<IrFunction> inlinedLambdasInNonPublicContexts;

    /*
     * WARNING - void declaration
     */
    public final boolean isInlineNonpublicContext(@NotNull List<ScopeWithIr> scopeStack) {
        Object v1;
        Object v0;
        block4: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(scopeStack, (String)"scopeStack");
            Iterable iterable = $receiver$iv = (Iterable)scopeStack;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ScopeWithIr scopeWithIr = (ScopeWithIr)item$iv$iv;
                Collection collection = destination$iv$iv;
                IrElement irElement = it.getIrElement();
                collection.add(irElement);
            }
            $receiver$iv = (List)destination$iv$iv;
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                IrElement it = (IrElement)element$iv;
                if (!(it instanceof IrFunction)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof IrFunction)) {
            v1 = null;
        }
        IrFunction irFunction = v1;
        if (irFunction == null) {
            return false;
        }
        IrFunction currentFunction = irFunction;
        return currentFunction.isInline() && SetsKt.setOf((Object[])new Visibility[]{Visibilities.PRIVATE, Visibilities.PROTECTED}).contains(currentFunction.getVisibility()) || this.inlinedLambdasInNonPublicContexts.contains(currentFunction);
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrFunction callTarget = expression2.getSymbol().getOwner();
        if (callTarget.isInline() && this.isInlineNonpublicContext(this.getAllScopes())) {
            int n = 0;
            int n2 = expression2.getValueArgumentsCount();
            while (n < n2) {
                IrExpression argument;
                void i;
                IrExpression irExpression = expression2.getValueArgument((int)i);
                IrExpression irExpression2 = argument = irExpression != null ? IrUtilsKt.removeBlocks(irExpression) : null;
                if (argument instanceof IrFunctionReference && Intrinsics.areEqual((Object)((IrFunctionReference)argument).getSymbol().getOwner().getOrigin(), (Object)IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE) && !callTarget.getValueParameters().get((int)i).isNoinline()) {
                    this.inlinedLambdasInNonPublicContexts.add(((IrFunctionReference)argument).getSymbol().getOwner());
                }
                ++i;
            }
        }
        super.visitFunctionAccess(expression2);
    }

    public InlinedLambdasCollector() {
        Set set;
        InlinedLambdasCollector inlinedLambdasCollector = this;
        inlinedLambdasCollector.inlinedLambdasInNonPublicContexts = set = (Set)new LinkedHashSet();
    }
}

