/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.gui.NumericTextField;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.IconTheme;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class AppearanceOptionPane
extends AbstractOptionPane
implements ItemListener {
    public static final String[] builtInIconThemes = new String[]{"tango", "old"};
    private UIManager.LookAndFeelInfo[] lfs;
    private JComboBox<String> lookAndFeel;
    private FontSelector primaryFont;
    private FontSelector secondaryFont;
    private FontSelector helpViewerFont;
    private JTextField history;
    private JTextField menuSpillover;
    private JCheckBox showTips;
    private JCheckBox showSplash;
    private JCheckBox textColors;
    private JCheckBox decorateFrames;
    private JCheckBox decorateDialogs;
    private JComboBox<String> iconThemes;
    private JCheckBox systemTrayIcon;
    private boolean lnfChanged = false;

    public AppearanceOptionPane() {
        super("appearance");
    }

    @Override
    protected void _init() {
        this.lfs = UIManager.getInstalledLookAndFeels();
        String[] stringArray = new String[this.lfs.length];
        String string = UIManager.getLookAndFeel().getClass().getName();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.lfs[i].getName();
            if (!string.equals(this.lfs[i].getClassName())) continue;
            n = i;
        }
        this.lookAndFeel = new JComboBox<String>(stringArray);
        this.lookAndFeel.setSelectedIndex(n);
        this.lookAndFeel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppearanceOptionPane.this.updateEnabled();
            }
        });
        this.lookAndFeel.addItemListener(this);
        this.addComponent(jEdit.getProperty("options.appearance.lf"), this.lookAndFeel);
        String[] stringArray2 = IconTheme.builtInNames();
        this.iconThemes = new JComboBox<String>(stringArray2);
        this.addComponent(jEdit.getProperty("options.appearance.iconTheme"), this.iconThemes);
        String string2 = IconTheme.get();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equals(string2)) continue;
            this.iconThemes.setSelectedIndex(i);
            break;
        }
        Font font = jEdit.getFontProperty("metal.primary.font");
        this.primaryFont = new FontSelector(font);
        this.addComponent(jEdit.getProperty("options.appearance.primaryFont"), (Component)this.primaryFont);
        this.secondaryFont = new FontSelector(jEdit.getFontProperty("metal.secondary.font"));
        this.addComponent(jEdit.getProperty("options.appearance.secondaryFont"), (Component)this.secondaryFont);
        this.helpViewerFont = new FontSelector(jEdit.getFontProperty("helpviewer.font", font));
        this.addComponent(jEdit.getProperty("options.appearance.helpViewerFont"), (Component)this.helpViewerFont);
        this.updateEnabled();
        this.history = new NumericTextField(jEdit.getProperty("history"), true);
        this.addComponent(jEdit.getProperty("options.appearance.history"), (Component)this.history);
        this.menuSpillover = new NumericTextField(jEdit.getProperty("menu.spillover"), true);
        this.addComponent(jEdit.getProperty("options.appearance.menuSpillover"), (Component)this.menuSpillover);
        this.systemTrayIcon = new JCheckBox(jEdit.getProperty("options.general.systrayicon", "Show the systray icon"));
        this.systemTrayIcon.setSelected(jEdit.getBooleanProperty("systrayicon", true));
        this.addComponent(this.systemTrayIcon);
        this.addSeparator("options.appearance.startup.label");
        this.showSplash = new JCheckBox(jEdit.getProperty("options.appearance.showSplash"));
        String string3 = jEdit.getSettingsDirectory();
        if (string3 == null) {
            this.showSplash.setSelected(true);
        } else {
            this.showSplash.setSelected(!new File(string3, "nosplash").exists());
        }
        this.addComponent(this.showSplash);
        this.showTips = new JCheckBox(jEdit.getProperty("options.appearance.showTips"));
        this.showTips.setSelected(jEdit.getBooleanProperty("tip.show"));
        this.addComponent(this.showTips);
        this.addSeparator("options.appearance.experimental.label");
        this.addComponent(GUIUtilities.createMultilineLabel(jEdit.getProperty("options.appearance.experimental.caption")));
        this.textColors = new JCheckBox(jEdit.getProperty("options.appearance.textColors"));
        this.textColors.setSelected(jEdit.getBooleanProperty("textColors"));
        this.addComponent(this.textColors);
        this.decorateFrames = new JCheckBox(jEdit.getProperty("options.appearance.decorateFrames"));
        this.decorateFrames.setSelected(jEdit.getBooleanProperty("decorate.frames"));
        this.addComponent(this.decorateFrames);
        this.decorateDialogs = new JCheckBox(jEdit.getProperty("options.appearance.decorateDialogs"));
        this.decorateDialogs.setSelected(jEdit.getBooleanProperty("decorate.dialogs"));
        this.addComponent(this.decorateDialogs);
        this.lnfChanged = false;
    }

    @Override
    protected void _save() {
        if (this.lnfChanged) {
            String string = this.lfs[this.lookAndFeel.getSelectedIndex()].getClassName();
            jEdit.setProperty("lookAndFeel", string);
        }
        jEdit.setFontProperty("metal.primary.font", this.primaryFont.getFont());
        jEdit.setFontProperty("metal.secondary.font", this.secondaryFont.getFont());
        jEdit.setFontProperty("helpviewer.font", this.helpViewerFont.getFont());
        jEdit.setProperty("history", this.history.getText());
        jEdit.setProperty("menu.spillover", this.menuSpillover.getText());
        jEdit.setBooleanProperty("tip.show", this.showTips.isSelected());
        jEdit.setBooleanProperty("systrayicon", this.systemTrayIcon.isSelected());
        IconTheme.set(this.iconThemes.getSelectedItem().toString());
        this.setFileFlag("nosplash", !this.showSplash.isSelected());
        jEdit.setBooleanProperty("textColors", this.textColors.isSelected());
        jEdit.setBooleanProperty("decorate.frames", this.decorateFrames.isSelected());
        jEdit.setBooleanProperty("decorate.dialogs", this.decorateDialogs.isSelected());
    }

    private void updateEnabled() {
        String string = this.lfs[this.lookAndFeel.getSelectedIndex()].getClassName();
        if (string.equals("javax.swing.plaf.metal.MetalLookAndFeel") || string.equals("com.incors.plaf.kunststoff.KunststoffLookAndFeel")) {
            this.primaryFont.setEnabled(true);
            this.secondaryFont.setEnabled(true);
        } else {
            this.primaryFont.setEnabled(false);
            this.secondaryFont.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFileFlag(String string, boolean bl) {
        String string2 = jEdit.getSettingsDirectory();
        if (string2 == null) return;
        File file = new File(string2, string);
        if (!bl) {
            file.delete();
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(10);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                Log.log(9, this, iOException);
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(fileOutputStream);
                throw throwable;
            }
            IOUtilities.closeQuietly(fileOutputStream);
            return;
        }
        IOUtilities.closeQuietly(fileOutputStream);
        return;
    }

    @Override
    public final void itemStateChanged(ItemEvent itemEvent) {
        this.lnfChanged = true;
    }
}

