<!--
    print.dsl.in - stylesheets for hardcopy output.

    $Id: print.dsl.in,v 1.3 2000/04/26 17:06:02 cdegroot Exp $

    SGMLtools - an SGML toolkit.
    Copyright (C) 1998 Cees A. de Groot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  --> 
<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA dsssl>
]>
<style-sheet>

<style-specification id="print" use="docbook">
<style-specification-body> 

    ;; this is necessary because right now jadetex does not understand
    ;; symbolic entities, whereas things work well with numeric entities.
    (declare-characteristic preserve-sdata?
	      "UNREGISTERED::James Clark//Characteristic::preserve-sdata?"
	      #f)

    (define %two-side% #f)
    (define %section-autolabel% #t)
    (define %visual-acuity% "normal")

    ;;
    ;;  Graphical admonitions.
    ;;
    (define %admon-graphics% #t)
    (define %admon-graphics-path%
      "/usr/local/share/sgml/stylesheets/docbook/images/")
    (define ($admon-graphic$ #!optional (nd (current-node)))
      (cond ((equal? (gi nd) (normalize "tip"))
	     (string-append %admon-graphics-path% "tip."
			    %graphic-default-extension%))
	    ((equal? (gi nd) (normalize "note"))
	     (string-append %admon-graphics-path% "note."
			    %graphic-default-extension%))
	    ((equal? (gi nd) (normalize "important"))
	     (string-append %admon-graphics-path% "important."
			    %graphic-default-extension%))
	    ((equal? (gi nd) (normalize "caution"))
	     (string-append %admon-graphics-path% "caution."
	                    %graphic-default-extension%))
	    ((equal? (gi nd) (normalize "warning"))
	     (string-append %admon-graphics-path% "warning." 
                            %graphic-default-extension%))
	    (else (error (string-append (gi nd) " is not an admonition.")))))
     
</style-specification-body>
</style-specification>
    
<style-specification id="print.ps" use="print">
<style-specification-body>
    (define %graphic-default-extension% "eps")
</style-specification-body>
</style-specification>

<style-specification id="print.pdf" use="print">
<style-specification-body>
    (define %graphic-default-extension% "pdf")
</style-specification-body>
</style-specification>

<style-specification id="howto" use="print">
<style-specification-body>
    ;;
    ;;  A paper-saving stylesheet that mimics the SGMLtools 1.0 howto style.
    ;;  Not two-sided, because most people won't print two-sided.
    ;;
    (define %visual-acuity% "normal")
    (define %two-side% #f)
    (define %left-margin% 3pi)
    (define %right-margin% 4pi)
    (define %body-start-indent% 2pi)
    (define %generate-article-toc% #t)
    ;;
    ;;  Gnuishly correct fonts...
    ;;
    (define %body-font-family% "Computer Modern Roman")
    (define %mono-font-family% "Computer Modern Typewriter")
    (define %title-font-family% "Computer Modern Sans");
    (define %admon-font-family% "Computer Modern Sans");
    (define %guilabel-font-family% "Computer Modern Sans");
    
</style-specification-body>
</style-specification>

<external-specification id="docbook" document="docbook.dsl">
</style-sheet>
