/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BackgroundSound;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.View;

public abstract class Sound
extends Leaf {
    public static final int ALLOW_SOUND_DATA_READ = 12;
    public static final int ALLOW_SOUND_DATA_WRITE = 13;
    public static final int ALLOW_INITIAL_GAIN_READ = 14;
    public static final int ALLOW_INITIAL_GAIN_WRITE = 15;
    public static final int ALLOW_LOOP_READ = 16;
    public static final int ALLOW_LOOP_WRITE = 17;
    public static final int ALLOW_RELEASE_READ = 18;
    public static final int ALLOW_RELEASE_WRITE = 19;
    public static final int ALLOW_CONT_PLAY_READ = 20;
    public static final int ALLOW_CONT_PLAY_WRITE = 21;
    public static final int ALLOW_ENABLE_READ = 22;
    public static final int ALLOW_ENABLE_WRITE = 23;
    public static final int ALLOW_SCHEDULING_BOUNDS_READ = 24;
    public static final int ALLOW_SCHEDULING_BOUNDS_WRITE = 25;
    public static final int ALLOW_PRIORITY_READ = 26;
    public static final int ALLOW_PRIORITY_WRITE = 27;
    public static final int ALLOW_DURATION_READ = 28;
    public static final int ALLOW_IS_READY_READ = 29;
    public static final int ALLOW_IS_PLAYING_READ = 30;
    public static final int ALLOW_CHANNELS_USED_READ = 31;
    public static final int ALLOW_MUTE_READ = 40;
    public static final int ALLOW_MUTE_WRITE = 41;
    public static final int ALLOW_PAUSE_READ = 42;
    public static final int ALLOW_PAUSE_WRITE = 43;
    public static final int ALLOW_RATE_SCALE_FACTOR_READ = 44;
    public static final int ALLOW_RATE_SCALE_FACTOR_WRITE = 45;
    public static final float NO_FILTER = -1.0f;
    public static final int DURATION_UNKNOWN = -1;
    public static final int INFINITE_LOOPS = -1;
    private static final int[] readCapabilities = new int[]{31, 20, 28, 22, 14, 30, 29, 16, 40, 42, 26, 44, 18, 24, 12};

    public Sound() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Sound(MediaContainer mediaContainer, float f) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((SoundRetained)this.retained).setSoundData(mediaContainer);
        ((SoundRetained)this.retained).setInitialGain(f);
    }

    public Sound(MediaContainer mediaContainer, float f, int n, boolean bl, boolean bl2, boolean bl3, Bounds bounds, float f2) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((SoundRetained)this.retained).setSoundData(mediaContainer);
        ((SoundRetained)this.retained).setInitialGain(f);
        ((SoundRetained)this.retained).setLoop(n);
        ((SoundRetained)this.retained).setReleaseEnable(bl);
        ((SoundRetained)this.retained).setContinuousEnable(bl2);
        ((SoundRetained)this.retained).setEnable(bl3);
        ((SoundRetained)this.retained).setSchedulingBounds(bounds);
        ((SoundRetained)this.retained).setPriority(f2);
    }

    public Sound(MediaContainer mediaContainer, float f, int n, boolean bl, boolean bl2, boolean bl3, Bounds bounds, float f2, float f3) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((SoundRetained)this.retained).setSoundData(mediaContainer);
        ((SoundRetained)this.retained).setInitialGain(f);
        ((SoundRetained)this.retained).setLoop(n);
        ((SoundRetained)this.retained).setReleaseEnable(bl);
        ((SoundRetained)this.retained).setContinuousEnable(bl2);
        ((SoundRetained)this.retained).setEnable(bl3);
        ((SoundRetained)this.retained).setSchedulingBounds(bounds);
        ((SoundRetained)this.retained).setPriority(f2);
        ((SoundRetained)this.retained).setRateScaleFactor(f3);
    }

    public void setSoundData(MediaContainer mediaContainer) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound0"));
        }
        if (this instanceof BackgroundSound) {
            ((SoundRetained)this.retained).setSoundData(mediaContainer);
        } else {
            ((PointSoundRetained)this.retained).setSoundData(mediaContainer);
        }
    }

    public MediaContainer getSoundData() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound1"));
        }
        return ((SoundRetained)this.retained).getSoundData();
    }

    public void setInitialGain(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound2"));
        }
        ((SoundRetained)this.retained).setInitialGain(f);
    }

    public float getInitialGain() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound3"));
        }
        return ((SoundRetained)this.retained).getInitialGain();
    }

    public void setLoop(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound4"));
        }
        ((SoundRetained)this.retained).setLoop(n);
    }

    public int getLoop() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound5"));
        }
        return ((SoundRetained)this.retained).getLoop();
    }

    public void setReleaseEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound6"));
        }
        ((SoundRetained)this.retained).setReleaseEnable(bl);
    }

    public boolean getReleaseEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound7"));
        }
        return ((SoundRetained)this.retained).getReleaseEnable();
    }

    public void setContinuousEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound8"));
        }
        ((SoundRetained)this.retained).setContinuousEnable(bl);
    }

    public boolean getContinuousEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound9"));
        }
        return ((SoundRetained)this.retained).getContinuousEnable();
    }

    public void setEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound10"));
        }
        if (this instanceof BackgroundSound) {
            ((SoundRetained)this.retained).setEnable(bl);
        } else {
            ((PointSoundRetained)this.retained).setEnable(bl);
        }
    }

    public boolean getEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound21"));
        }
        return ((SoundRetained)this.retained).getEnable();
    }

    public void setSchedulingBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound11"));
        }
        ((SoundRetained)this.retained).setSchedulingBounds(bounds);
    }

    public Bounds getSchedulingBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound12"));
        }
        return ((SoundRetained)this.retained).getSchedulingBounds();
    }

    public void setSchedulingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound11"));
        }
        ((SoundRetained)this.retained).setSchedulingBoundingLeaf(boundingLeaf);
    }

    public BoundingLeaf getSchedulingBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound12"));
        }
        return ((SoundRetained)this.retained).getSchedulingBoundingLeaf();
    }

    public void setPriority(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(27)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound15"));
        }
        ((SoundRetained)this.retained).setPriority(f);
    }

    public float getPriority() {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound16"));
        }
        return ((SoundRetained)this.retained).getPriority();
    }

    public long getDuration() {
        if (this.isLiveOrCompiled() && !this.getCapability(28)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound17"));
        }
        return ((SoundRetained)this.retained).getDuration();
    }

    public boolean isReady() {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound22"));
        }
        return ((SoundRetained)this.retained).isReady();
    }

    public boolean isReady(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound22"));
        }
        return ((SoundRetained)this.retained).isReady(view);
    }

    public boolean isPlaying() {
        if (this.isLiveOrCompiled() && !this.getCapability(30)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound18"));
        }
        return ((SoundRetained)this.retained).isPlaying();
    }

    public boolean isPlaying(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(30)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound18"));
        }
        return ((SoundRetained)this.retained).isPlaying(view);
    }

    public boolean isPlayingSilently() {
        if (this.isLiveOrCompiled() && !this.getCapability(30)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound18"));
        }
        return ((SoundRetained)this.retained).isPlayingSilently();
    }

    public boolean isPlayingSilently(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(30)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound18"));
        }
        return ((SoundRetained)this.retained).isPlayingSilently(view);
    }

    public int getNumberOfChannelsUsed() {
        if (this.isLiveOrCompiled() && !this.getCapability(31)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound20"));
        }
        return ((SoundRetained)this.retained).getNumberOfChannelsUsed();
    }

    public int getNumberOfChannelsUsed(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(31)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound20"));
        }
        return ((SoundRetained)this.retained).getNumberOfChannelsUsed(view);
    }

    public void setMute(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(41)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound23"));
        }
        ((SoundRetained)this.retained).setMute(bl);
    }

    public boolean getMute() {
        if (this.isLiveOrCompiled() && !this.getCapability(40)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound24"));
        }
        return ((SoundRetained)this.retained).getMute();
    }

    public void setPause(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(43)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound25"));
        }
        ((SoundRetained)this.retained).setPause(bl);
    }

    public boolean getPause() {
        if (this.isLiveOrCompiled() && !this.getCapability(42)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound26"));
        }
        return ((SoundRetained)this.retained).getPause();
    }

    public void setRateScaleFactor(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(45)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound27"));
        }
        ((SoundRetained)this.retained).setRateScaleFactor(f);
    }

    public float getRateScaleFactor() {
        if (this.isLiveOrCompiled() && !this.getCapability(44)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound28"));
        }
        return ((SoundRetained)this.retained).getRateScaleFactor();
    }

    @Override
    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        SoundRetained soundRetained = (SoundRetained)node.retained;
        SoundRetained soundRetained2 = (SoundRetained)this.retained;
        soundRetained2.setSoundData((MediaContainer)this.getNodeComponent(soundRetained.getSoundData(), bl, node.nodeHashtable));
        soundRetained2.setInitialGain(soundRetained.getInitialGain());
        soundRetained2.setLoop(soundRetained.getLoop());
        soundRetained2.setReleaseEnable(soundRetained.getReleaseEnable());
        soundRetained2.setContinuousEnable(soundRetained.getContinuousEnable());
        soundRetained2.setSchedulingBounds(soundRetained.getSchedulingBounds());
        soundRetained2.setPriority(soundRetained.getPriority());
        soundRetained2.setEnable(soundRetained.getEnable());
        soundRetained2.setSchedulingBoundingLeaf(soundRetained.getSchedulingBoundingLeaf());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        SceneGraphObject sceneGraphObject;
        super.updateNodeReferences(nodeReferenceTable);
        SoundRetained soundRetained = (SoundRetained)this.retained;
        BoundingLeaf boundingLeaf = soundRetained.getSchedulingBoundingLeaf();
        if (boundingLeaf != null) {
            sceneGraphObject = nodeReferenceTable.getNewObjectReference(boundingLeaf);
            soundRetained.setSchedulingBoundingLeaf((BoundingLeaf)sceneGraphObject);
        }
        if ((sceneGraphObject = soundRetained.getSoundData()) != null) {
            soundRetained.setSoundData((MediaContainer)sceneGraphObject);
        }
    }
}

