/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI;

import com.zeroc.Ice.Current;
import com.zeroc.IceGrid.AdapterDynamicInfo;
import com.zeroc.IceGrid.NodeDynamicInfo;
import com.zeroc.IceGrid.NodeObserver;
import com.zeroc.IceGrid.ServerDynamicInfo;
import com.zeroc.IceGridGUI.Coordinator;
import javax.swing.SwingUtilities;

class NodeObserverI
implements NodeObserver {
    private final Coordinator _coordinator;
    private final boolean _trace;

    NodeObserverI(Coordinator coordinator) {
        this._coordinator = coordinator;
        this._trace = this._coordinator.traceObservers();
    }

    public void nodeInit(NodeDynamicInfo[] nodes, Current current) {
        if (this._trace) {
            if (nodes.length == 0) {
                this._coordinator.traceObserver("nodeInit (no node)");
            } else {
                String names = "";
                for (NodeDynamicInfo node : nodes) {
                    names = names + " " + node.info.name;
                }
                this._coordinator.traceObserver("nodeInit for node" + (nodes.length == 1 ? "" : "s") + names);
            }
        }
        SwingUtilities.invokeLater(() -> {
            for (NodeDynamicInfo node : nodes) {
                this._coordinator.nodeUp(node);
            }
        });
    }

    public void nodeUp(NodeDynamicInfo nodeInfo, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("nodeUp for node " + nodeInfo.info.name);
        }
        SwingUtilities.invokeLater(() -> this._coordinator.nodeUp(nodeInfo));
    }

    public void nodeDown(String nodeName, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("nodeUp for node " + nodeName);
        }
        SwingUtilities.invokeLater(() -> this._coordinator.nodeDown(nodeName));
    }

    public void updateServer(String node, ServerDynamicInfo updatedInfo, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("updateServer for server " + updatedInfo.id + " on node " + node + "; new state is " + updatedInfo.state.toString());
        }
        SwingUtilities.invokeLater(() -> this._coordinator.updateServer(node, updatedInfo));
    }

    public void updateAdapter(String node, AdapterDynamicInfo updatedInfo, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("updateAdapter for adapter " + updatedInfo.id + " on node " + node + "; new proxy is " + (updatedInfo.proxy == null ? "null" : updatedInfo.proxy.toString()));
        }
        SwingUtilities.invokeLater(() -> this._coordinator.updateAdapter(node, updatedInfo));
    }
}

