/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.osmand.StateChangedListener;
import net.osmand.data.LatLon;
import net.osmand.data.PointDescription;
import net.osmand.plus.ApplicationMode;
import net.osmand.plus.access.AccessibilityMode;
import net.osmand.plus.access.RelativeDirectionStyle;
import net.osmand.plus.api.SettingsAPI;
import net.osmand.plus.helpers.SearchHistoryHelper;
import net.osmand.plus.routing.RouteProvider;
import net.sourceforge.offroad.OsmWindow;

public class OsmandSettings {
    private static final String SHARED_PREFERENCES_NAME = "net.osmand.settings";
    private SettingsAPI settingsAPI;
    private Object globalPreferences;
    private Object defaultProfilePreferences;
    private Object profilePreferences;
    private ApplicationMode currentMode;
    private Map<String, OsmandPreference<?>> registeredPreferences = new LinkedHashMap();
    private long lastTimeInternetConnectionChecked = 0L;
    private boolean internetConnectionAvailable = true;
    private OsmWindow ctx;
    public ApplicationMode LAST_ROUTING_APPLICATION_MODE = null;
    public final OsmandPreference<ApplicationMode> APPLICATION_MODE = new PreferenceWithListener<ApplicationMode>(){

        @Override
        public String getId() {
            return "application_mode";
        }

        @Override
        public ApplicationMode get() {
            return OsmandSettings.this.currentMode;
        }

        @Override
        public void overrideDefaultValue(ApplicationMode newDefaultValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resetToDefault() {
            this.set(ApplicationMode.DEFAULT);
        }

        @Override
        public boolean isSet() {
            return true;
        }

        @Override
        public boolean set(ApplicationMode val) {
            ApplicationMode oldMode = OsmandSettings.this.currentMode;
            boolean changed = OsmandSettings.this.settingsAPI.edit(OsmandSettings.this.globalPreferences).putString(this.getId(), val.getStringKey()).commit();
            if (changed) {
                OsmandSettings.this.currentMode = val;
                OsmandSettings.this.profilePreferences = OsmandSettings.this.getProfilePreferences(OsmandSettings.this.currentMode);
                this.fireEvent(oldMode);
            }
            return changed;
        }

        @Override
        public ApplicationMode getModeValue(ApplicationMode m) {
            return m;
        }

        @Override
        public boolean setModeValue(ApplicationMode m, ApplicationMode obj) {
            throw new UnsupportedOperationException();
        }
    };
    private final OsmandPreference<String> PLUGINS = new StringPreference("enabled_plugins", "").makeGlobal();
    public final CommonPreference<Boolean> USE_FAST_RECALCULATION = new BooleanPreference("use_fast_recalculation", true).makeGlobal().cache();
    public final CommonPreference<Boolean> SHOW_CARD_TO_CHOOSE_DRAWER = new BooleanPreference("show_card_to_choose_drawer", false).makeGlobal();
    public final CommonPreference<Boolean> SHOW_DASHBOARD_ON_START = new BooleanPreference("should_show_dashboard_on_start", false).makeGlobal();
    public final CommonPreference<Boolean> SHOW_DASHBOARD_ON_MAP_SCREEN = new BooleanPreference("show_dashboard_on_map_screen", false).makeGlobal();
    public final CommonPreference<Boolean> USE_INTERNET_TO_DOWNLOAD_TILES = new BooleanPreference("use_internet_to_download_tiles", true).makeGlobal().cache();
    public final OsmandPreference<String> AVAILABLE_APP_MODES = new StringPreference("available_application_modes", "car,bicycle,pedestrian,").makeGlobal().cache();
    public final OsmandPreference<String> LAST_FAV_CATEGORY_ENTERED = new StringPreference("last_fav_category", "").makeGlobal();
    public final OsmandPreference<ApplicationMode> DEFAULT_APPLICATION_MODE = new CommonPreference<ApplicationMode>("default_application_mode_string", ApplicationMode.DEFAULT){
        {
            this.makeGlobal();
        }

        @Override
        protected ApplicationMode getValue(Object prefs, ApplicationMode defaultValue) {
            String key = OsmandSettings.this.settingsAPI.getString(prefs, this.getId(), defaultValue.getStringKey());
            return ApplicationMode.valueOfStringKey(key, defaultValue);
        }

        @Override
        protected boolean setValue(Object prefs, ApplicationMode val) {
            return OsmandSettings.this.settingsAPI.edit(prefs).putString(this.getId(), val.getStringKey()).commit();
        }
    };
    public final OsmandPreference<Boolean> FIRST_MAP_IS_DOWNLOADED = new BooleanPreference("first_map_is_downloaded", false);
    public final OsmandPreference<DrivingRegion> DRIVING_REGION = new EnumIntPreference<DrivingRegion>("default_driving_region", DrivingRegion.EUROPE_ASIA, DrivingRegion.values()){

        @Override
        protected boolean setValue(Object prefs, DrivingRegion val) {
            if (val != null) {
                OsmandSettings.this.METRIC_SYSTEM.set(val.defMetrics);
            }
            return super.setValue(prefs, val);
        }

        @Override
        protected DrivingRegion getDefaultValue() {
            Locale df = Locale.getDefault();
            if (df == null) {
                return DrivingRegion.EUROPE_ASIA;
            }
            if (df.getCountry().equalsIgnoreCase(Locale.US.getCountry())) {
                return DrivingRegion.US;
            }
            if (df.getCountry().equalsIgnoreCase(Locale.CANADA.getCountry())) {
                return DrivingRegion.CANADA;
            }
            if (df.getCountry().equalsIgnoreCase(Locale.JAPAN.getCountry())) {
                return DrivingRegion.JAPAN;
            }
            return DrivingRegion.EUROPE_ASIA;
        }
    }.makeGlobal().cache();
    public final OsmandPreference<MetricsConstants> METRIC_SYSTEM = new EnumIntPreference<MetricsConstants>("default_metric_system", MetricsConstants.KILOMETERS_AND_METERS, MetricsConstants.values()){

        @Override
        protected MetricsConstants getDefaultValue() {
            return OsmandSettings.this.DRIVING_REGION.get().defMetrics;
        }
    }.makeGlobal().cache();
    public final OsmandPreference<SpeedConstants> SPEED_SYSTEM = new EnumIntPreference<SpeedConstants>("default_speed_system", SpeedConstants.KILOMETERS_PER_HOUR, SpeedConstants.values()){

        @Override
        public SpeedConstants getProfileDefaultValue(ApplicationMode mode) {
            MetricsConstants mc = OsmandSettings.this.METRIC_SYSTEM.get();
            if (mode.isDerivedRoutingFrom(ApplicationMode.PEDESTRIAN)) {
                if (mc == MetricsConstants.KILOMETERS_AND_METERS) {
                    return SpeedConstants.MINUTES_PER_KILOMETER;
                }
                return SpeedConstants.MILES_PER_HOUR;
            }
            if (mode.isDerivedRoutingFrom(ApplicationMode.BOAT)) {
                return SpeedConstants.NAUTICALMILES_PER_HOUR;
            }
            if (mc == MetricsConstants.NAUTICAL_MILES) {
                return SpeedConstants.NAUTICALMILES_PER_HOUR;
            }
            if (mc == MetricsConstants.KILOMETERS_AND_METERS) {
                return SpeedConstants.KILOMETERS_PER_HOUR;
            }
            return SpeedConstants.MILES_PER_HOUR;
        }
    }.makeProfile().cache();
    public final OsmandPreference<RelativeDirectionStyle> DIRECTION_STYLE = new EnumIntPreference(this, "direction_style", RelativeDirectionStyle.SIDEWISE, RelativeDirectionStyle.values()).makeGlobal().cache();
    public final OsmandPreference<AccessibilityMode> ACCESSIBILITY_MODE = new EnumIntPreference(this, "accessibility_mode", AccessibilityMode.DEFAULT, AccessibilityMode.values()).makeGlobal().cache();
    public final OsmandPreference<Float> SPEECH_RATE = new FloatPreference("speech_rate", 1.0f).makeGlobal();
    public final OsmandPreference<Float> ARRIVAL_DISTANCE_FACTOR = new FloatPreference("arrival_distance_factor", 1.0f).makeProfile();
    public final OsmandPreference<Float> SPEED_LIMIT_EXCEED = new FloatPreference("speed_limit_exceed", 5.0f).makeProfile();
    public final OsmandPreference<Boolean> USE_TRACKBALL_FOR_MOVEMENTS = new BooleanPreference("use_trackball_for_movements", true).makeGlobal();
    public final OsmandPreference<Boolean> ZOOM_BY_TRACKBALL = new BooleanAccessibilityPreference("zoom_by_trackball", false).makeGlobal();
    public final OsmandPreference<Boolean> SCROLL_MAP_BY_GESTURES = new BooleanAccessibilityPreference("scroll_map_by_gestures", true).makeGlobal();
    public final OsmandPreference<Boolean> USE_SHORT_OBJECT_NAMES = new BooleanAccessibilityPreference("use_short_object_names", false).makeGlobal();
    public final OsmandPreference<Boolean> ACCESSIBILITY_EXTENSIONS = new BooleanAccessibilityPreference("accessibility_extensions", false).makeGlobal();
    public final OsmandPreference<Boolean> USE_MAGNETIC_FIELD_SENSOR_COMPASS = new BooleanPreference("use_magnetic_field_sensor_compass", false).makeGlobal().cache();
    public final OsmandPreference<Boolean> USE_KALMAN_FILTER_FOR_COMPASS = new BooleanPreference("use_kalman_filter_compass", true).makeGlobal().cache();
    public final CommonPreference<Float> TEXT_SCALE = new FloatPreference("text_scale", 1.0f).makeProfile().cache();
    public final CommonPreference<Float> MAP_DENSITY;
    public final OsmandPreference<Boolean> SHOW_POI_LABEL;
    public final OsmandPreference<String> PREFERRED_LOCALE;
    public static final String TRANSPORT_STOPS_OVER_MAP = "transportStops";
    public final OsmandPreference<String> MAP_PREFERRED_LOCALE;
    public final OsmandPreference<String> USER_NAME;
    public final OsmandPreference<String> BILLING_USER_ID;
    public final OsmandPreference<String> BILLING_USER_NAME;
    public final OsmandPreference<String> BILLING_USER_EMAIL;
    public final OsmandPreference<String> BILLING_USER_COUNTRY;
    public final OsmandPreference<String> BILLING_USER_COUNTRY_DOWNLOAD_NAME;
    public final OsmandPreference<Boolean> BILLING_HIDE_USER_NAME;
    public final OsmandPreference<Boolean> BILLING_PURCHASE_TOKEN_SENT;
    public final OsmandPreference<Boolean> LIVE_UPDATES_PURCHASED;
    public final OsmandPreference<String> USER_OSM_BUG_NAME;
    public final OsmandPreference<String> USER_PASSWORD;
    public final OsmandPreference<Boolean> OFFLINE_EDITION;
    public final CommonPreference<DayNightMode> DAYNIGHT_MODE;
    public final OsmandPreference<RouteProvider.RouteService> ROUTER_SERVICE;
    public final CommonPreference<AutoZoomMap> AUTO_ZOOM_MAP;
    public final CommonPreference<Integer> DELAY_TO_START_NAVIGATION;
    public final CommonPreference<Boolean> SNAP_TO_ROAD;
    public final CommonPreference<Boolean> INTERRUPT_MUSIC;
    public final CommonPreference<String> PROXY_HOST;
    public final CommonPreference<Integer> PROXY_PORT;
    public static final String SAVE_CURRENT_TRACK = "save_current_track";
    public final CommonPreference<Boolean> SAVE_GLOBAL_TRACK_TO_GPX;
    public final CommonPreference<Integer> SAVE_GLOBAL_TRACK_INTERVAL;
    public final CommonPreference<Boolean> SAVE_GLOBAL_TRACK_REMEMBER;
    public final CommonPreference<Boolean> SAVE_TRACK_TO_GPX;
    public final CommonPreference<Boolean> DISABLE_RECORDING_ONCE_APP_KILLED;
    public final OsmandPreference<Boolean> FAST_ROUTE_MODE;
    public final CommonPreference<Boolean> DISABLE_COMPLEX_ROUTING;
    public final CommonPreference<Boolean> SHOW_TRAFFIC_WARNINGS;
    public final CommonPreference<Boolean> SHOW_PEDESTRIAN;
    public final OsmandPreference<Boolean> SHOW_CAMERAS;
    public final CommonPreference<Boolean> SHOW_LANES;
    public final OsmandPreference<Boolean> SHOW_WPT;
    public final OsmandPreference<Boolean> SHOW_NEARBY_FAVORITES;
    public final OsmandPreference<Boolean> SHOW_NEARBY_POI;
    public final OsmandPreference<Boolean> SPEAK_STREET_NAMES;
    public final OsmandPreference<Boolean> SPEAK_TRAFFIC_WARNINGS;
    public final OsmandPreference<Boolean> SPEAK_PEDESTRIAN;
    public final OsmandPreference<Boolean> SPEAK_SPEED_LIMIT;
    public final OsmandPreference<Boolean> SPEAK_SPEED_CAMERA;
    public final OsmandPreference<Boolean> ANNOUNCE_WPT;
    public final OsmandPreference<Boolean> ANNOUNCE_NEARBY_FAVORITES;
    public final OsmandPreference<Boolean> ANNOUNCE_NEARBY_POI;
    public final OsmandPreference<Boolean> GPX_ROUTE_CALC_OSMAND_PARTS;
    public final OsmandPreference<Boolean> GPX_CALCULATE_RTEPT;
    public final OsmandPreference<Boolean> GPX_ROUTE_CALC;
    public final OsmandPreference<Boolean> AVOID_TOLL_ROADS;
    public final OsmandPreference<Boolean> AVOID_MOTORWAY;
    public final OsmandPreference<Boolean> AVOID_UNPAVED_ROADS;
    public final OsmandPreference<Boolean> AVOID_FERRIES;
    public final OsmandPreference<Boolean> PREFER_MOTORWAYS;
    public final OsmandPreference<Long> LAST_UPDATES_CARD_REFRESH;
    public final CommonPreference<Integer> SAVE_TRACK_INTERVAL;
    public final CommonPreference<Boolean> LIVE_MONITORING;
    public final CommonPreference<Integer> LIVE_MONITORING_INTERVAL;
    public final CommonPreference<String> LIVE_MONITORING_URL;
    public final CommonPreference<String> GPS_STATUS_APP;
    public final OsmandPreference<Boolean> SHOW_OSM_BUGS;
    public final OsmandPreference<String> MAP_INFO_CONTROLS;
    public final OsmandPreference<String> OSMO_DEVICE_KEY;
    public final OsmandPreference<String> OSMO_USER_NAME;
    public final OsmandPreference<String> OSMO_USER_PWD;
    public final OsmandPreference<Boolean> OSMO_AUTO_CONNECT;
    public final OsmandPreference<Long> OSMO_LAST_PING;
    public final OsmandPreference<Boolean> OSMO_SEND_LOCATIONS_STATE;
    public final OsmandPreference<Boolean> OSMO_SHOW_GROUP_NOTIFICATIONS;
    public final CommonPreference<Integer> OSMO_SAVE_TRACK_INTERVAL;
    public final OsmandPreference<String> OSMO_GROUPS;
    public final OsmandPreference<Boolean> DEBUG_RENDERING_INFO;
    public final OsmandPreference<Boolean> SHOW_FAVORITES;
    public final CommonPreference<Boolean> SHOW_ZOOM_BUTTONS_NAVIGATION;
    public final OsmandPreference<String> SELECTED_GPX;
    public final OsmandPreference<Integer> MAP_SCREEN_ORIENTATION;
    public final CommonPreference<Integer> AUTO_FOLLOW_ROUTE;
    public final CommonPreference<Integer> KEEP_INFORMING;
    public final CommonPreference<Integer> WAKE_ON_VOICE_INT;
    public static final int ROTATE_MAP_NONE = 0;
    public static final int ROTATE_MAP_BEARING = 1;
    public static final int ROTATE_MAP_COMPASS = 2;
    public final CommonPreference<Integer> ROTATE_MAP;
    public static final int CENTER_CONSTANT = 0;
    public static final int BOTTOM_CONSTANT = 1;
    public final CommonPreference<Boolean> CENTER_POSITION_ON_MAP;
    public final OsmandPreference<Integer> MAX_LEVEL_TO_DOWNLOAD_TILE;
    public final OsmandPreference<Integer> LEVEL_TO_SWITCH_VECTOR_RASTER;
    public final OsmandPreference<Integer> AUDIO_STREAM_GUIDANCE;
    public final CommonPreference<Boolean> MAP_ONLINE_DATA;
    public final CommonPreference<Boolean> SHOW_DESTINATION_ARROW;
    public final CommonPreference<String> MAP_OVERLAY;
    public final CommonPreference<String> MAP_UNDERLAY;
    public final CommonPreference<Integer> MAP_OVERLAY_TRANSPARENCY;
    public final CommonPreference<Integer> MAP_TRANSPARENCY;
    public final CommonPreference<Boolean> SHOW_LAYER_TRANSPARENCY_SEEKBAR;
    public final CommonPreference<String> MAP_OVERLAY_PREVIOUS;
    public final CommonPreference<String> MAP_UNDERLAY_PREVIOUS;
    public CommonPreference<String> PREVIOUS_INSTALLED_VERSION;
    public final OsmandPreference<Boolean> SHOULD_SHOW_FREE_VERSION_BANNER;
    public final OsmandPreference<Boolean> USE_MAP_MARKERS;
    public final CommonPreference<MapMarkersMode> MAP_MARKERS_MODE;
    public final OsmandPreference<Boolean> ROUTE_MAP_MARKERS_START_MY_LOC;
    public static final String EXTERNAL_STORAGE_DIR = "external_storage_dir";
    public static final String EXTERNAL_STORAGE_DIR_V19 = "external_storage_dir_V19";
    public static final String EXTERNAL_STORAGE_DIR_TYPE_V19 = "external_storage_dir_type_V19";
    public static final int EXTERNAL_STORAGE_TYPE_DEFAULT = 0;
    public static final int EXTERNAL_STORAGE_TYPE_EXTERNAL_FILE = 1;
    public static final int EXTERNAL_STORAGE_TYPE_INTERNAL_FILE = 2;
    public static final int EXTERNAL_STORAGE_TYPE_OBB = 3;
    public static final int EXTERNAL_STORAGE_TYPE_SPECIFIED = 4;
    public static final String LAST_KNOWN_MAP_LAT = "last_known_map_lat";
    public static final String LAST_KNOWN_MAP_LON = "last_known_map_lon";
    public static final String LAST_KNOWN_MAP_ZOOM = "last_known_map_zoom";
    public static final String MAP_LABEL_TO_SHOW = "map_label_to_show";
    public static final String MAP_LAT_TO_SHOW = "map_lat_to_show";
    public static final String MAP_LON_TO_SHOW = "map_lon_to_show";
    public static final String MAP_ZOOM_TO_SHOW = "map_zoom_to_show";
    private Object objectToShow;
    public static final String POINT_NAVIGATE_LAT = "point_navigate_lat";
    public static final String POINT_NAVIGATE_LON = "point_navigate_lon";
    public static final String POINT_NAVIGATE_ROUTE = "point_navigate_route_integer";
    public static final int NAVIGATE = 1;
    public static final String POINT_NAVIGATE_DESCRIPTION = "point_navigate_description";
    public static final String START_POINT_LAT = "start_point_lat";
    public static final String START_POINT_LON = "start_point_lon";
    public static final String START_POINT_DESCRIPTION = "start_point_description";
    public static final String INTERMEDIATE_POINTS = "intermediate_points";
    public static final String INTERMEDIATE_POINTS_DESCRIPTION = "intermediate_points_description";
    private IntermediatePointsStorage intermediatePointsStorage;
    public static final String POINT_NAVIGATE_LAT_BACKUP = "point_navigate_lat_backup";
    public static final String POINT_NAVIGATE_LON_BACKUP = "point_navigate_lon_backup";
    public static final String POINT_NAVIGATE_DESCRIPTION_BACKUP = "point_navigate_description_backup";
    public static final String START_POINT_LAT_BACKUP = "start_point_lat_backup";
    public static final String START_POINT_LON_BACKUP = "start_point_lon_backup";
    public static final String START_POINT_DESCRIPTION_BACKUP = "start_point_description_backup";
    public static final String INTERMEDIATE_POINTS_BACKUP = "intermediate_points_backup";
    public static final String INTERMEDIATE_POINTS_DESCRIPTION_BACKUP = "intermediate_points_description_backup";
    public static final String MAP_MARKERS_POINT = "map_markers_point";
    public static final String MAP_MARKERS_COLOR = "map_markers_color";
    public static final String MAP_MARKERS_DESCRIPTION = "map_markers_description";
    public static final String MAP_MARKERS_POSITION = "map_markers_position";
    public static final String MAP_MARKERS_SELECTION = "map_markers_selection";
    public static final String MAP_MARKERS_HISTORY_POINT = "map_markers_history_point";
    public static final String MAP_MARKERS_HISTORY_DESCRIPTION = "map_markers_history_description";
    public static final int MAP_MARKERS_HISTORY_LIMIT = 30;
    private MapMarkersStorage mapMarkersStorage;
    private MapMarkersHistoryStorage mapMarkersHistoryStorage;
    public final CommonPreference<Boolean> USE_INTERMEDIATE_POINTS_NAVIGATION;
    public static final String LAST_SEARCHED_REGION = "last_searched_region";
    public static final String LAST_SEARCHED_CITY = "last_searched_city";
    public static final String LAST_SEARCHED_CITY_NAME = "last_searched_city_name";
    public static final String LAST_SEARCHED_POSTCODE = "last_searched_postcode";
    public static final String LAST_SEARCHED_STREET = "last_searched_street";
    public static final String LAST_SEARCHED_BUILDING = "last_searched_building";
    public static final String LAST_SEARCHED_INTERSECTED_STREET = "last_searched_intersected_street";
    public static final String LAST_SEARCHED_LAT = "last_searched_lat";
    public static final String LAST_SEARCHED_LON = "last_searched_lon";
    public final OsmandPreference<String> SELECTED_POI_FILTER_FOR_MAP;
    public final OsmandPreference<String> SELECTED_POI_FILTER_STRING_FOR_MAP;
    public static final String VOICE_PROVIDER_NOT_USE = "VOICE_PROVIDER_NOT_USE";
    public static final String[] TTS_AVAILABLE_VOICES = new String[]{"de", "en", "es", "fr", "it", "ja", "nl", "pl", "pt", "ru", "zh"};
    public final OsmandPreference<String> VOICE_PROVIDER;
    public final CommonPreference<String> RENDERER;
    Map<String, CommonPreference<String>> customRendersProps;
    Map<String, CommonPreference<Boolean>> customBooleanRendersProps;
    Map<String, CommonPreference<String>> customRoutingProps;
    Map<String, CommonPreference<Boolean>> customBooleanRoutingProps;
    public final OsmandPreference<Boolean> USE_OSM_LIVE_FOR_ROUTING;
    public final OsmandPreference<Boolean> VOICE_MUTE;
    public final OsmandPreference<Boolean> MAP_ACTIVITY_ENABLED;
    public final OsmandPreference<Boolean> SAFE_MODE;
    public final OsmandPreference<Boolean> NATIVE_RENDERING_FAILED;
    public final OsmandPreference<Boolean> USE_OPENGL_RENDER;
    public final OsmandPreference<Boolean> OPENGL_RENDER_FAILED;
    public static final String SERVICE_OFF_ENABLED = "service_off_enabled";
    public final OsmandPreference<Integer> SERVICE_OFF_INTERVAL;
    public final OsmandPreference<String> CONTRIBUTION_INSTALL_APP_DATE;
    public final OsmandPreference<Integer> COORDINATES_FORMAT;
    public final OsmandPreference<Boolean> FOLLOW_THE_ROUTE;
    public final OsmandPreference<String> FOLLOW_THE_GPX_ROUTE;
    public final OsmandPreference<Boolean> SHOW_ARRIVAL_TIME_OTHERWISE_EXPECTED_TIME;
    public final OsmandPreference<Long> AGPS_DATA_LAST_TIME_DOWNLOADED;
    public final OsmandPreference<Boolean> IS_LIVE_UPDATES_ON;
    public final OsmandPreference<Integer> LIVE_UPDATES_RETRIES;
    public final CommonPreference<Boolean> TRANSPARENT_MAP_THEME;
    public final CommonPreference<Boolean> SHOW_STREET_NAME;
    public static final int OSMAND_DARK_THEME = 0;
    public static final int OSMAND_LIGHT_THEME = 1;
    public final CommonPreference<Integer> SEARCH_TAB;
    public final CommonPreference<Integer> FAVORITES_TAB;
    public final CommonPreference<Integer> OSMAND_THEME;
    public final CommonPreference<Boolean> FLUORESCENT_OVERLAYS;
    public final CommonPreference<Boolean> SHOW_RULER;
    public final OsmandPreference<Integer> NUMBER_OF_FREE_DOWNLOADS;
    public final OsmandPreference<Long> LAST_DISPLAY_TIME;
    public final OsmandPreference<Long> LAST_CHECKED_UPDATES;
    public final OsmandPreference<Integer> NUMBER_OF_APPLICATION_STARTS;

    public OsmandSettings(OsmWindow pCtx, SettingsAPI settinsAPI) {
        this.TEXT_SCALE.setModeDefaultValue(ApplicationMode.CAR, Float.valueOf(1.25f));
        this.MAP_DENSITY = new FloatPreference("map_density_n", 1.0f).makeProfile().cache();
        this.MAP_DENSITY.setModeDefaultValue(ApplicationMode.CAR, Float.valueOf(1.5f));
        this.SHOW_POI_LABEL = new BooleanPreference("show_poi_label", false).makeGlobal();
        this.PREFERRED_LOCALE = new StringPreference("preferred_locale", "").makeGlobal();
        this.MAP_PREFERRED_LOCALE = new StringPreference("map_preferred_locale", "").makeGlobal().cache();
        this.USER_NAME = new StringPreference("user_name", "").makeGlobal();
        this.BILLING_USER_ID = new StringPreference("billing_user_id", "").makeGlobal();
        this.BILLING_USER_NAME = new StringPreference("billing_user_name", "").makeGlobal();
        this.BILLING_USER_EMAIL = new StringPreference("billing_user_email", "").makeGlobal();
        this.BILLING_USER_COUNTRY = new StringPreference("billing_user_country", "").makeGlobal();
        this.BILLING_USER_COUNTRY_DOWNLOAD_NAME = new StringPreference("billing_user_country_download_name", "").makeGlobal();
        this.BILLING_HIDE_USER_NAME = new BooleanPreference("billing_hide_user_name", false).makeGlobal();
        this.BILLING_PURCHASE_TOKEN_SENT = new BooleanPreference("billing_purchase_token_sent", false).makeGlobal();
        this.LIVE_UPDATES_PURCHASED = new BooleanPreference("billing_live_updates_purchased", false).makeGlobal();
        this.USER_OSM_BUG_NAME = new StringPreference("user_osm_bug_name", "NoName/OsmAnd").makeGlobal();
        this.USER_PASSWORD = new StringPreference("user_password", "").makeGlobal();
        this.OFFLINE_EDITION = new BooleanPreference("offline_osm_editing", true).makeGlobal();
        this.DAYNIGHT_MODE = new EnumIntPreference<DayNightMode>(this, "daynight_mode", DayNightMode.DAY, DayNightMode.values());
        this.DAYNIGHT_MODE.makeProfile().cache();
        this.DAYNIGHT_MODE.setModeDefaultValue(ApplicationMode.CAR, DayNightMode.AUTO);
        this.DAYNIGHT_MODE.setModeDefaultValue(ApplicationMode.BICYCLE, DayNightMode.AUTO);
        this.DAYNIGHT_MODE.setModeDefaultValue(ApplicationMode.PEDESTRIAN, DayNightMode.DAY);
        this.ROUTER_SERVICE = new EnumIntPreference(this, "router_service", RouteProvider.RouteService.OSMAND, RouteProvider.RouteService.values()).makeProfile();
        this.AUTO_ZOOM_MAP = new EnumIntPreference(this, "auto_zoom_map_new", AutoZoomMap.NONE, AutoZoomMap.values()).makeProfile().cache();
        this.AUTO_ZOOM_MAP.setModeDefaultValue(ApplicationMode.CAR, AutoZoomMap.FAR);
        this.AUTO_ZOOM_MAP.setModeDefaultValue(ApplicationMode.BICYCLE, AutoZoomMap.NONE);
        this.AUTO_ZOOM_MAP.setModeDefaultValue(ApplicationMode.PEDESTRIAN, AutoZoomMap.NONE);
        this.DELAY_TO_START_NAVIGATION = new IntPreference("delay_to_start_navigation", -1){

            @Override
            protected Integer getDefaultValue() {
                if (OsmandSettings.this.DEFAULT_APPLICATION_MODE.get().isDerivedRoutingFrom(ApplicationMode.CAR)) {
                    return 10;
                }
                return -1;
            }
        }.makeGlobal().cache();
        this.SNAP_TO_ROAD = new BooleanPreference("snap_to_road", false).makeProfile().cache();
        this.SNAP_TO_ROAD.setModeDefaultValue(ApplicationMode.CAR, true);
        this.SNAP_TO_ROAD.setModeDefaultValue(ApplicationMode.BICYCLE, true);
        this.INTERRUPT_MUSIC = new BooleanPreference("interrupt_music", false).makeGlobal();
        this.PROXY_HOST = new StringPreference("proxy_host", "127.0.0.1").makeGlobal();
        this.PROXY_PORT = new IntPreference("proxy_port", 8118).makeGlobal();
        this.SAVE_GLOBAL_TRACK_TO_GPX = new BooleanPreference("save_global_track_to_gpx", false).makeGlobal().cache();
        this.SAVE_GLOBAL_TRACK_INTERVAL = new IntPreference("save_global_track_interval", 5000).makeGlobal().cache();
        this.SAVE_GLOBAL_TRACK_REMEMBER = new BooleanPreference("save_global_track_remember", false).makeGlobal().cache();
        this.SAVE_TRACK_TO_GPX = new BooleanPreference("save_track_to_gpx", false).makeProfile().cache();
        this.SAVE_TRACK_TO_GPX.setModeDefaultValue(ApplicationMode.CAR, false);
        this.SAVE_TRACK_TO_GPX.setModeDefaultValue(ApplicationMode.BICYCLE, false);
        this.SAVE_TRACK_TO_GPX.setModeDefaultValue(ApplicationMode.PEDESTRIAN, false);
        this.DISABLE_RECORDING_ONCE_APP_KILLED = new BooleanPreference("disable_recording_once_app_killed", false).makeGlobal();
        this.FAST_ROUTE_MODE = new BooleanPreference("fast_route_mode", true).makeProfile();
        this.DISABLE_COMPLEX_ROUTING = new BooleanPreference("disable_complex_routing", false).makeGlobal();
        this.SHOW_TRAFFIC_WARNINGS = new BooleanPreference("show_traffic_warnings", false).makeProfile().cache();
        this.SHOW_TRAFFIC_WARNINGS.setModeDefaultValue(ApplicationMode.CAR, true);
        this.SHOW_PEDESTRIAN = new BooleanPreference("show_pedestrian", false).makeProfile().cache();
        this.SHOW_PEDESTRIAN.setModeDefaultValue(ApplicationMode.CAR, true);
        this.SHOW_CAMERAS = new BooleanPreference("show_cameras", false).makeProfile().cache();
        this.SHOW_LANES = new BooleanPreference("show_lanes", false).makeProfile().cache();
        this.SHOW_LANES.setModeDefaultValue(ApplicationMode.CAR, true);
        this.SHOW_LANES.setModeDefaultValue(ApplicationMode.BICYCLE, true);
        this.SHOW_WPT = new BooleanPreference("show_gpx_wpt", true).makeGlobal().cache();
        this.SHOW_NEARBY_FAVORITES = new BooleanPreference("show_nearby_favorites", false).makeGlobal().cache();
        this.SHOW_NEARBY_POI = new BooleanPreference("show_nearby_poi", false).makeGlobal().cache();
        this.SPEAK_STREET_NAMES = new BooleanPreference("speak_street_names", true).makeProfile().cache();
        this.SPEAK_TRAFFIC_WARNINGS = new BooleanPreference("speak_traffic_warnings", true).makeProfile().cache();
        this.SPEAK_PEDESTRIAN = new BooleanPreference("speak_pedestrian", true).makeProfile().cache();
        this.SPEAK_SPEED_LIMIT = new BooleanPreference("speak_speed_limit", true).makeProfile().cache();
        this.SPEAK_SPEED_CAMERA = new BooleanPreference("speak_cameras", false).makeProfile().cache();
        this.ANNOUNCE_WPT = new BooleanPreference("announce_wpt", true).makeGlobal().cache();
        this.ANNOUNCE_NEARBY_FAVORITES = new BooleanPreference("announce_nearby_favorites", false).makeProfile().cache();
        this.ANNOUNCE_NEARBY_POI = new BooleanPreference("announce_nearby_poi", false).makeProfile().cache();
        this.GPX_ROUTE_CALC_OSMAND_PARTS = new BooleanPreference("gpx_routing_calculate_osmand_route", true).makeGlobal().cache();
        this.GPX_CALCULATE_RTEPT = new BooleanPreference("gpx_routing_calculate_rtept", true).makeGlobal().cache();
        this.GPX_ROUTE_CALC = new BooleanPreference("calc_gpx_route", false).makeGlobal().cache();
        this.AVOID_TOLL_ROADS = new BooleanPreference("avoid_toll_roads", false).makeProfile().cache();
        this.AVOID_MOTORWAY = new BooleanPreference("avoid_motorway", false).makeProfile().cache();
        this.AVOID_UNPAVED_ROADS = new BooleanPreference("avoid_unpaved_roads", false).makeProfile().cache();
        this.AVOID_FERRIES = new BooleanPreference("avoid_ferries", false).makeProfile().cache();
        this.PREFER_MOTORWAYS = new BooleanPreference("prefer_motorways", false).makeProfile().cache();
        this.LAST_UPDATES_CARD_REFRESH = new LongPreference("last_updates_card_refresh", 0L).makeGlobal();
        this.SAVE_TRACK_INTERVAL = new IntPreference("save_track_interval", 5000).makeProfile();
        this.SAVE_TRACK_INTERVAL.setModeDefaultValue(ApplicationMode.CAR, 3000);
        this.SAVE_TRACK_INTERVAL.setModeDefaultValue(ApplicationMode.BICYCLE, 7000);
        this.SAVE_TRACK_INTERVAL.setModeDefaultValue(ApplicationMode.PEDESTRIAN, 10000);
        this.LIVE_MONITORING = new BooleanPreference("live_monitoring", false).makeGlobal();
        this.LIVE_MONITORING_INTERVAL = new IntPreference("live_monitoring_interval", 5000).makeGlobal();
        this.LIVE_MONITORING_URL = new StringPreference("live_monitoring_url", "http://example.com?lat={0}&lon={1}&timestamp={2}&hdop={3}&altitude={4}&speed={5}").makeGlobal();
        this.GPS_STATUS_APP = new StringPreference("gps_status_app", "").makeGlobal();
        this.SHOW_OSM_BUGS = new BooleanPreference("show_osm_bugs", false).makeGlobal();
        this.MAP_INFO_CONTROLS = new StringPreference("map_info_controls", "").makeProfile();
        this.OSMO_DEVICE_KEY = new StringPreference("osmo_device_token", "").makeGlobal();
        this.OSMO_USER_NAME = new StringPreference("osmo_user_name", "").makeGlobal();
        this.OSMO_USER_PWD = new StringPreference("osmo_user_pwd", null).makeGlobal();
        this.OSMO_AUTO_CONNECT = new BooleanPreference("osmo_automatically_connect", false).makeGlobal();
        this.OSMO_LAST_PING = new LongPreference("osmo_last_ping", 0L).makeGlobal().cache();
        this.OSMO_SEND_LOCATIONS_STATE = new BooleanPreference("osmo_send_locations", false).cache().makeGlobal();
        this.OSMO_SHOW_GROUP_NOTIFICATIONS = new BooleanPreference("osmo_show_toast_notifications", true).makeGlobal();
        this.OSMO_SAVE_TRACK_INTERVAL = new IntPreference("osmo_save_track_interval", 10000).makeGlobal().cache();
        this.OSMO_GROUPS = new StringPreference("osmo_groups", "{}").makeGlobal();
        this.DEBUG_RENDERING_INFO = new BooleanPreference("debug_rendering", false).makeGlobal();
        this.SHOW_FAVORITES = new BooleanPreference("show_favorites", true).makeGlobal().cache();
        this.SHOW_ZOOM_BUTTONS_NAVIGATION = new BooleanPreference("show_zoom_buttons_navigation", false).makeProfile().cache();
        this.SHOW_ZOOM_BUTTONS_NAVIGATION.setModeDefaultValue(ApplicationMode.PEDESTRIAN, true);
        this.SELECTED_GPX = new StringPreference("selected_gpx", "").makeGlobal();
        this.MAP_SCREEN_ORIENTATION = new IntPreference("map_screen_orientation", -1).makeGlobal();
        this.AUTO_FOLLOW_ROUTE = new IntPreference("auto_follow_route", 0).makeProfile();
        this.AUTO_FOLLOW_ROUTE.setModeDefaultValue(ApplicationMode.CAR, 15);
        this.AUTO_FOLLOW_ROUTE.setModeDefaultValue(ApplicationMode.BICYCLE, 15);
        this.AUTO_FOLLOW_ROUTE.setModeDefaultValue(ApplicationMode.PEDESTRIAN, 0);
        this.KEEP_INFORMING = new IntPreference("keep_informing", 0).makeProfile();
        this.KEEP_INFORMING.setModeDefaultValue(ApplicationMode.CAR, 0);
        this.KEEP_INFORMING.setModeDefaultValue(ApplicationMode.BICYCLE, 0);
        this.KEEP_INFORMING.setModeDefaultValue(ApplicationMode.PEDESTRIAN, 0);
        this.WAKE_ON_VOICE_INT = new IntPreference("wake_on_voice_int", 0).makeProfile();
        this.WAKE_ON_VOICE_INT.setModeDefaultValue(ApplicationMode.CAR, 0);
        this.WAKE_ON_VOICE_INT.setModeDefaultValue(ApplicationMode.BICYCLE, 0);
        this.WAKE_ON_VOICE_INT.setModeDefaultValue(ApplicationMode.PEDESTRIAN, 0);
        this.ROTATE_MAP = new IntPreference("rotate_map", 0).makeProfile().cache();
        this.ROTATE_MAP.setModeDefaultValue(ApplicationMode.CAR, 1);
        this.ROTATE_MAP.setModeDefaultValue(ApplicationMode.BICYCLE, 1);
        this.ROTATE_MAP.setModeDefaultValue(ApplicationMode.PEDESTRIAN, 2);
        this.CENTER_POSITION_ON_MAP = new BooleanPreference("center_position_on_map", false).makeProfile();
        this.MAX_LEVEL_TO_DOWNLOAD_TILE = new IntPreference("max_level_download_tile", 20).makeProfile().cache();
        this.LEVEL_TO_SWITCH_VECTOR_RASTER = new IntPreference("level_to_switch_vector_raster", 1).makeGlobal().cache();
        this.AUDIO_STREAM_GUIDANCE = new IntPreference("audio_stream", 3).makeGlobal();
        this.MAP_ONLINE_DATA = new BooleanPreference("map_online_data", false).makeGlobal();
        this.SHOW_DESTINATION_ARROW = new BooleanPreference("show_destination_arrow", false).makeProfile();
        this.SHOW_DESTINATION_ARROW.setModeDefaultValue(ApplicationMode.PEDESTRIAN, true);
        this.MAP_OVERLAY = new StringPreference("map_overlay", null).makeGlobal().cache();
        this.MAP_UNDERLAY = new StringPreference("map_underlay", null).makeGlobal().cache();
        this.MAP_OVERLAY_TRANSPARENCY = new IntPreference("overlay_transparency", 100).makeGlobal().cache();
        this.MAP_TRANSPARENCY = new IntPreference("map_transparency", 255).makeGlobal().cache();
        this.SHOW_LAYER_TRANSPARENCY_SEEKBAR = new BooleanPreference("show_layer_transparency_seekbar", false).makeGlobal();
        this.MAP_OVERLAY_PREVIOUS = new StringPreference("map_overlay_previous", null).makeGlobal().cache();
        this.MAP_UNDERLAY_PREVIOUS = new StringPreference("map_underlay_previous", null).makeGlobal().cache();
        this.PREVIOUS_INSTALLED_VERSION = new StringPreference("previous_installed_version", "").makeGlobal();
        this.SHOULD_SHOW_FREE_VERSION_BANNER = new BooleanPreference("should_show_free_version_banner", false).makeGlobal().cache();
        this.USE_MAP_MARKERS = new BooleanPreference("use_map_markers", true).makeGlobal().cache();
        this.MAP_MARKERS_MODE = new EnumIntPreference<MapMarkersMode>(this, "map_markers_mode", MapMarkersMode.TOOLBAR, MapMarkersMode.values());
        this.MAP_MARKERS_MODE.makeProfile().cache();
        this.MAP_MARKERS_MODE.setModeDefaultValue(ApplicationMode.DEFAULT, MapMarkersMode.TOOLBAR);
        this.MAP_MARKERS_MODE.setModeDefaultValue(ApplicationMode.CAR, MapMarkersMode.TOOLBAR);
        this.MAP_MARKERS_MODE.setModeDefaultValue(ApplicationMode.BICYCLE, MapMarkersMode.TOOLBAR);
        this.MAP_MARKERS_MODE.setModeDefaultValue(ApplicationMode.PEDESTRIAN, MapMarkersMode.TOOLBAR);
        this.ROUTE_MAP_MARKERS_START_MY_LOC = new BooleanPreference("route_map_markers_start_my_loc", false).makeGlobal().cache();
        this.intermediatePointsStorage = new IntermediatePointsStorage();
        this.mapMarkersStorage = new MapMarkersStorage();
        this.mapMarkersHistoryStorage = new MapMarkersHistoryStorage();
        this.USE_INTERMEDIATE_POINTS_NAVIGATION = new BooleanPreference("use_intermediate_points_navigation", false).makeGlobal().cache();
        this.SELECTED_POI_FILTER_FOR_MAP = new StringPreference("selected_poi_filter_for_map", null).makeGlobal().cache();
        this.SELECTED_POI_FILTER_STRING_FOR_MAP = new StringPreference("selected_poi_filter_string_for_map", null).makeGlobal().cache();
        this.VOICE_PROVIDER = new StringPreference("voice_provider", null){

            @Override
            protected String getDefaultValue() {
                return "en-tts";
            }
        }.makeGlobal();
        this.RENDERER = new StringPreference("renderer", "OsmAnd"){
            {
                this.makeProfile();
            }

            @Override
            protected boolean setValue(Object prefs, String val) {
                val = "OsmAnd";
                super.setValue(prefs, val);
                return true;
            }
        };
        this.customRendersProps = new LinkedHashMap<String, CommonPreference<String>>();
        CommonPreference<String> pref = this.getCustomRenderProperty("appMode");
        pref.setModeDefaultValue(ApplicationMode.CAR, "car");
        pref.setModeDefaultValue(ApplicationMode.PEDESTRIAN, "pedestrian");
        pref.setModeDefaultValue(ApplicationMode.BICYCLE, "bicycle");
        this.customBooleanRendersProps = new LinkedHashMap<String, CommonPreference<Boolean>>();
        this.customRoutingProps = new LinkedHashMap<String, CommonPreference<String>>();
        this.customBooleanRoutingProps = new LinkedHashMap<String, CommonPreference<Boolean>>();
        this.USE_OSM_LIVE_FOR_ROUTING = new BooleanPreference("enable_osmc_routing", false).makeGlobal();
        this.VOICE_MUTE = new BooleanPreference("voice_mute", false).makeGlobal();
        this.MAP_ACTIVITY_ENABLED = new BooleanPreference("map_activity_enabled", false).makeGlobal();
        this.SAFE_MODE = new BooleanPreference("safe_mode", false).makeGlobal();
        this.NATIVE_RENDERING_FAILED = new BooleanPreference("native_rendering_failed_init", false).makeGlobal();
        this.USE_OPENGL_RENDER = new BooleanPreference("use_opengl_render", false).makeGlobal().cache();
        this.OPENGL_RENDER_FAILED = new BooleanPreference("opengl_render_failed", false).makeGlobal().cache();
        this.SERVICE_OFF_INTERVAL = new IntPreference("service_off_interval", 0).makeGlobal();
        this.CONTRIBUTION_INSTALL_APP_DATE = new StringPreference("CONTRIBUTION_INSTALL_APP_DATE", null).makeGlobal();
        this.COORDINATES_FORMAT = new IntPreference("coordinates_format", 0).makeGlobal();
        this.FOLLOW_THE_ROUTE = new BooleanPreference("follow_to_route", false).makeGlobal();
        this.FOLLOW_THE_GPX_ROUTE = new StringPreference("follow_gpx", null).makeGlobal();
        this.SHOW_ARRIVAL_TIME_OTHERWISE_EXPECTED_TIME = new BooleanPreference("show_arrival_time", true).makeGlobal();
        this.AGPS_DATA_LAST_TIME_DOWNLOADED = new LongPreference("agps_data_downloaded", 0L).makeGlobal();
        this.IS_LIVE_UPDATES_ON = new BooleanPreference("is_live_updates_on", false).makeGlobal();
        this.LIVE_UPDATES_RETRIES = new IntPreference("live_updates_retryes", 2).makeGlobal();
        this.TRANSPARENT_MAP_THEME = new BooleanPreference("transparent_map_theme", true).makeProfile();
        this.TRANSPARENT_MAP_THEME.setModeDefaultValue(ApplicationMode.CAR, false);
        this.TRANSPARENT_MAP_THEME.setModeDefaultValue(ApplicationMode.BICYCLE, false);
        this.TRANSPARENT_MAP_THEME.setModeDefaultValue(ApplicationMode.PEDESTRIAN, true);
        this.SHOW_STREET_NAME = new BooleanPreference("show_street_name", false).makeProfile();
        this.SHOW_STREET_NAME.setModeDefaultValue(ApplicationMode.CAR, true);
        this.SHOW_STREET_NAME.setModeDefaultValue(ApplicationMode.BICYCLE, false);
        this.SHOW_STREET_NAME.setModeDefaultValue(ApplicationMode.PEDESTRIAN, false);
        this.SEARCH_TAB = new IntPreference("SEARCH_TAB", 0).makeGlobal().cache();
        this.FAVORITES_TAB = new IntPreference("FAVORITES_TAB", 0).makeGlobal().cache();
        this.OSMAND_THEME = new IntPreference("osmand_theme", 1).makeGlobal().cache();
        this.FLUORESCENT_OVERLAYS = new BooleanPreference("fluorescent_overlays", false).makeGlobal().cache();
        this.SHOW_RULER = new BooleanPreference("show_ruler", true).makeProfile().cache();
        this.NUMBER_OF_FREE_DOWNLOADS = new IntPreference("free_downloads_v3", 0).makeGlobal();
        this.LAST_DISPLAY_TIME = new LongPreference("last_display_time", 0L).makeGlobal().cache();
        this.LAST_CHECKED_UPDATES = new LongPreference("last_checked_updates", 0L).makeGlobal();
        this.NUMBER_OF_APPLICATION_STARTS = new IntPreference("number_of_app_starts", 0).makeGlobal().cache();
        this.ctx = pCtx;
        this.settingsAPI = settinsAPI;
        this.initPrefs();
    }

    private void initPrefs() {
        this.globalPreferences = this.settingsAPI.getPreferenceObject(SHARED_PREFERENCES_NAME);
        this.defaultProfilePreferences = this.getProfilePreferences(ApplicationMode.DEFAULT);
        this.currentMode = this.readApplicationMode();
        this.profilePreferences = this.getProfilePreferences(this.currentMode);
    }

    public void setSettingsAPI(SettingsAPI settingsAPI) {
        this.settingsAPI = settingsAPI;
        this.initPrefs();
    }

    public SettingsAPI getSettingsAPI() {
        return this.settingsAPI;
    }

    public static String getSharedPreferencesName(ApplicationMode mode) {
        if (mode == null) {
            return SHARED_PREFERENCES_NAME;
        }
        return "net.osmand.settings." + mode.getStringKey().toLowerCase();
    }

    public Object getProfilePreferences(ApplicationMode mode) {
        return this.settingsAPI.getPreferenceObject(OsmandSettings.getSharedPreferencesName(mode));
    }

    public ApplicationMode getApplicationMode() {
        return this.APPLICATION_MODE.get();
    }

    protected ApplicationMode readApplicationMode() {
        String s = this.settingsAPI.getString(this.globalPreferences, this.APPLICATION_MODE.getId(), ApplicationMode.DEFAULT.getStringKey());
        return ApplicationMode.valueOfStringKey(s, ApplicationMode.DEFAULT);
    }

    public boolean isInternetConnectionAvailable() {
        return this.isInternetConnectionAvailable(false);
    }

    public boolean isInternetConnectionAvailable(boolean update) {
        long delta = System.currentTimeMillis() - this.lastTimeInternetConnectionChecked;
        if (delta < 0L || delta > 15000L || update) {
            this.internetConnectionAvailable = this.isInternetConnected();
        }
        return this.internetConnectionAvailable;
    }

    public boolean isWifiConnected() {
        return true;
    }

    private boolean isInternetConnected() {
        return true;
    }

    public Set<String> getEnabledPlugins() {
        String plugs = this.PLUGINS.get();
        StringTokenizer toks = new StringTokenizer(plugs, ",");
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            if (tok.startsWith("-")) continue;
            res.add(tok);
        }
        return res;
    }

    public Set<String> getPlugins() {
        String plugs = this.PLUGINS.get();
        StringTokenizer toks = new StringTokenizer(plugs, ",");
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        while (toks.hasMoreTokens()) {
            res.add(toks.nextToken());
        }
        return res;
    }

    public void enablePlugin(String pluginId, boolean enable) {
        Set<String> set = this.getPlugins();
        if (enable) {
            set.remove("-" + pluginId);
            set.add(pluginId);
        } else {
            set.remove(pluginId);
            set.add("-" + pluginId);
        }
        StringBuilder serialization = new StringBuilder();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            serialization.append(it.next());
            if (!it.hasNext()) continue;
            serialization.append(",");
        }
        if (!serialization.toString().equals(this.PLUGINS.get())) {
            this.PLUGINS.set(serialization.toString());
        }
    }

    public CommonPreference<Boolean> registerBooleanPreference(String id2, boolean defValue) {
        if (this.registeredPreferences.containsKey(id2)) {
            return (CommonPreference)this.registeredPreferences.get(id2);
        }
        BooleanPreference p = new BooleanPreference(id2, defValue);
        this.registeredPreferences.put(id2, p);
        return p;
    }

    public CommonPreference<String> registerStringPreference(String id2, String defValue) {
        if (this.registeredPreferences.containsKey(id2)) {
            return (CommonPreference)this.registeredPreferences.get(id2);
        }
        StringPreference p = new StringPreference(id2, defValue);
        this.registeredPreferences.put(id2, p);
        return p;
    }

    public CommonPreference<Integer> registerIntPreference(String id2, int defValue) {
        if (this.registeredPreferences.containsKey(id2)) {
            return (CommonPreference)this.registeredPreferences.get(id2);
        }
        IntPreference p = new IntPreference(id2, defValue);
        this.registeredPreferences.put(id2, p);
        return p;
    }

    public CommonPreference<Long> registerLongPreference(String id2, long defValue) {
        if (this.registeredPreferences.containsKey(id2)) {
            return (CommonPreference)this.registeredPreferences.get(id2);
        }
        LongPreference p = new LongPreference(id2, defValue);
        this.registeredPreferences.put(id2, p);
        return p;
    }

    public CommonPreference<Float> registerFloatPreference(String id2, float defValue) {
        if (this.registeredPreferences.containsKey(id2)) {
            return (CommonPreference)this.registeredPreferences.get(id2);
        }
        FloatPreference p = new FloatPreference(id2, defValue);
        this.registeredPreferences.put(id2, p);
        return p;
    }

    public boolean usingEnglishNames() {
        return this.MAP_PREFERRED_LOCALE.get().equals("en");
    }

    public static boolean isWritable(File dirToTest) {
        boolean isWriteable = false;
        try {
            dirToTest.mkdirs();
            File writeTestFile = File.createTempFile("osmand_", ".tmp", dirToTest);
            isWriteable = writeTestFile.exists();
            writeTestFile.delete();
        }
        catch (IOException e) {
            isWriteable = false;
        }
        return isWriteable;
    }

    public Object getGlobalPreferences() {
        return this.globalPreferences;
    }

    public LatLon getLastKnownMapLocation() {
        float lat = this.settingsAPI.getFloat(this.globalPreferences, LAST_KNOWN_MAP_LAT, 0.0f);
        float lon = this.settingsAPI.getFloat(this.globalPreferences, LAST_KNOWN_MAP_LON, 0.0f);
        return new LatLon(lat, lon);
    }

    public boolean isLastKnownMapLocation() {
        return this.settingsAPI.contains(this.globalPreferences, LAST_KNOWN_MAP_LAT);
    }

    public LatLon getAndClearMapLocationToShow() {
        if (!this.settingsAPI.contains(this.globalPreferences, MAP_LAT_TO_SHOW)) {
            return null;
        }
        float lat = this.settingsAPI.getFloat(this.globalPreferences, MAP_LAT_TO_SHOW, 0.0f);
        float lon = this.settingsAPI.getFloat(this.globalPreferences, MAP_LON_TO_SHOW, 0.0f);
        this.settingsAPI.edit(this.globalPreferences).remove(MAP_LAT_TO_SHOW).commit();
        return new LatLon(lat, lon);
    }

    public Object getAndClearObjectToShow() {
        Object objectToShow = this.objectToShow;
        this.objectToShow = null;
        return objectToShow;
    }

    public int getMapZoomToShow() {
        return this.settingsAPI.getInt(this.globalPreferences, MAP_ZOOM_TO_SHOW, 5);
    }

    public void setLastKnownMapLocation(double latitude, double longitude) {
        SettingsAPI.SettingsEditor edit = this.settingsAPI.edit(this.globalPreferences);
        edit.putFloat(LAST_KNOWN_MAP_LAT, (float)latitude);
        edit.putFloat(LAST_KNOWN_MAP_LON, (float)longitude);
        edit.commit();
    }

    public int getLastKnownMapZoom() {
        return this.settingsAPI.getInt(this.globalPreferences, LAST_KNOWN_MAP_ZOOM, 5);
    }

    public void setLastKnownMapZoom(int zoom) {
        this.settingsAPI.edit(this.globalPreferences).putInt(LAST_KNOWN_MAP_ZOOM, zoom).commit();
    }

    public void backupPointToStart() {
        this.settingsAPI.edit(this.globalPreferences).putFloat(START_POINT_LAT_BACKUP, this.settingsAPI.getFloat(this.globalPreferences, START_POINT_LAT, 0.0f)).putFloat(START_POINT_LON_BACKUP, this.settingsAPI.getFloat(this.globalPreferences, START_POINT_LON, 0.0f)).putString(START_POINT_DESCRIPTION_BACKUP, this.settingsAPI.getString(this.globalPreferences, START_POINT_DESCRIPTION, "")).commit();
    }

    private void backupPointToNavigate() {
        this.settingsAPI.edit(this.globalPreferences).putFloat(POINT_NAVIGATE_LAT_BACKUP, this.settingsAPI.getFloat(this.globalPreferences, POINT_NAVIGATE_LAT, 0.0f)).putFloat(POINT_NAVIGATE_LON_BACKUP, this.settingsAPI.getFloat(this.globalPreferences, POINT_NAVIGATE_LON, 0.0f)).putString(POINT_NAVIGATE_DESCRIPTION_BACKUP, this.settingsAPI.getString(this.globalPreferences, POINT_NAVIGATE_DESCRIPTION, "")).commit();
    }

    private void backupIntermediatePoints() {
        this.settingsAPI.edit(this.globalPreferences).putString(INTERMEDIATE_POINTS_BACKUP, this.settingsAPI.getString(this.globalPreferences, INTERMEDIATE_POINTS, "")).putString(INTERMEDIATE_POINTS_DESCRIPTION_BACKUP, this.settingsAPI.getString(this.globalPreferences, INTERMEDIATE_POINTS_DESCRIPTION, "")).commit();
    }

    public void backupTargetPoints() {
        this.backupPointToStart();
        this.backupPointToNavigate();
        this.backupIntermediatePoints();
    }

    public void restoreTargetPoints() {
        this.settingsAPI.edit(this.globalPreferences).putFloat(START_POINT_LAT, this.settingsAPI.getFloat(this.globalPreferences, START_POINT_LAT_BACKUP, 0.0f)).putFloat(START_POINT_LON, this.settingsAPI.getFloat(this.globalPreferences, START_POINT_LON_BACKUP, 0.0f)).putString(START_POINT_DESCRIPTION, this.settingsAPI.getString(this.globalPreferences, START_POINT_DESCRIPTION_BACKUP, "")).putFloat(POINT_NAVIGATE_LAT, this.settingsAPI.getFloat(this.globalPreferences, POINT_NAVIGATE_LAT_BACKUP, 0.0f)).putFloat(POINT_NAVIGATE_LON, this.settingsAPI.getFloat(this.globalPreferences, POINT_NAVIGATE_LON_BACKUP, 0.0f)).putString(POINT_NAVIGATE_DESCRIPTION, this.settingsAPI.getString(this.globalPreferences, POINT_NAVIGATE_DESCRIPTION_BACKUP, "")).putString(INTERMEDIATE_POINTS, this.settingsAPI.getString(this.globalPreferences, INTERMEDIATE_POINTS_BACKUP, "")).putString(INTERMEDIATE_POINTS_DESCRIPTION, this.settingsAPI.getString(this.globalPreferences, INTERMEDIATE_POINTS_DESCRIPTION_BACKUP, "")).commit();
    }

    public LatLon getPointToNavigate() {
        float lat = this.settingsAPI.getFloat(this.globalPreferences, POINT_NAVIGATE_LAT, 0.0f);
        float lon = this.settingsAPI.getFloat(this.globalPreferences, POINT_NAVIGATE_LON, 0.0f);
        if (lat == 0.0f && lon == 0.0f) {
            return null;
        }
        return new LatLon(lat, lon);
    }

    public LatLon getPointToStart() {
        float lat = this.settingsAPI.getFloat(this.globalPreferences, START_POINT_LAT, 0.0f);
        float lon = this.settingsAPI.getFloat(this.globalPreferences, START_POINT_LON, 0.0f);
        if (lat == 0.0f && lon == 0.0f) {
            return null;
        }
        return new LatLon(lat, lon);
    }

    public PointDescription getStartPointDescription() {
        return PointDescription.deserializeFromString(this.settingsAPI.getString(this.globalPreferences, START_POINT_DESCRIPTION, ""), this.getPointToStart());
    }

    public PointDescription getPointNavigateDescription() {
        return PointDescription.deserializeFromString(this.settingsAPI.getString(this.globalPreferences, POINT_NAVIGATE_DESCRIPTION, ""), this.getPointToNavigate());
    }

    public int isRouteToPointNavigateAndClear() {
        int vl = this.settingsAPI.getInt(this.globalPreferences, POINT_NAVIGATE_ROUTE, 0);
        if (vl != 0) {
            this.settingsAPI.edit(this.globalPreferences).remove(POINT_NAVIGATE_ROUTE).commit();
        }
        return vl;
    }

    public boolean clearIntermediatePoints() {
        return this.settingsAPI.edit(this.globalPreferences).remove(INTERMEDIATE_POINTS).remove(INTERMEDIATE_POINTS_DESCRIPTION).commit();
    }

    public boolean clearActiveMapMarkers() {
        return this.settingsAPI.edit(this.globalPreferences).remove(MAP_MARKERS_POINT).remove(MAP_MARKERS_DESCRIPTION).remove(MAP_MARKERS_COLOR).remove(MAP_MARKERS_POSITION).remove(MAP_MARKERS_SELECTION).commit();
    }

    public boolean clearMapMarkersHistory() {
        return this.settingsAPI.edit(this.globalPreferences).remove(MAP_MARKERS_HISTORY_POINT).remove(MAP_MARKERS_HISTORY_DESCRIPTION).commit();
    }

    public List<String> getIntermediatePointDescriptions(int sz) {
        return this.intermediatePointsStorage.getPointDescriptions(sz);
    }

    public List<LatLon> getIntermediatePoints() {
        return this.intermediatePointsStorage.getPoints();
    }

    public boolean insertIntermediatePoint(double latitude, double longitude, PointDescription historyDescription, int index) {
        return this.intermediatePointsStorage.insertPoint(latitude, longitude, historyDescription, index);
    }

    public boolean updateIntermediatePoint(double latitude, double longitude, PointDescription historyDescription) {
        return this.intermediatePointsStorage.updatePoint(latitude, longitude, historyDescription);
    }

    public boolean deleteIntermediatePoint(int index) {
        return this.intermediatePointsStorage.deletePoint(index);
    }

    public boolean saveIntermediatePoints(List<LatLon> ps, List<String> ds) {
        return this.intermediatePointsStorage.savePoints(ps, ds);
    }

    public List<String> getMapMarkersPointDescriptions(int sz) {
        return this.mapMarkersStorage.getPointDescriptions(sz);
    }

    public List<Integer> getMapMarkersColors(int sz) {
        return this.mapMarkersStorage.getColors(sz);
    }

    public List<Integer> getMapMarkersPositions(int sz) {
        return this.mapMarkersStorage.getPositions(sz);
    }

    public List<Boolean> getMapMarkersSelections(int sz) {
        return this.mapMarkersStorage.getSelections(sz);
    }

    public List<LatLon> getMapMarkersPoints() {
        return this.mapMarkersStorage.getPoints();
    }

    public boolean insertMapMarker(double latitude, double longitude, PointDescription historyDescription, int colorIndex, int pos, boolean selected, int index) {
        return this.mapMarkersStorage.insertPoint(latitude, longitude, historyDescription, colorIndex, index, selected, pos);
    }

    public boolean insertMapMarkers(double[] latitudes, double[] longitudes, List<PointDescription> historyDescriptions, int[] colorIndexes, int[] positions, boolean[] selections, int[] indexes) {
        return this.mapMarkersStorage.insertPoints(latitudes, longitudes, historyDescriptions, colorIndexes, positions, selections, indexes);
    }

    public boolean updateMapMarker(double latitude, double longitude, PointDescription historyDescription, int colorIndex, int pos, boolean selected) {
        return this.mapMarkersStorage.updatePoint(latitude, longitude, historyDescription, colorIndex, pos, selected);
    }

    public boolean deleteMapMarker(int index) {
        return this.mapMarkersStorage.deletePoint(index);
    }

    public boolean saveMapMarkers(List<LatLon> ps, List<String> ds, List<Integer> cs, List<Integer> ns, List<Boolean> bs) {
        return this.mapMarkersStorage.savePoints(ps, ds, cs, ns, bs);
    }

    public List<String> getMapMarkersHistoryPointDescriptions(int sz) {
        return this.mapMarkersHistoryStorage.getPointDescriptions(sz);
    }

    public List<LatLon> getMapMarkersHistoryPoints() {
        return this.mapMarkersHistoryStorage.getPoints();
    }

    public boolean insertMapMarkerHistory(double latitude, double longitude, PointDescription historyDescription, int colorIndex, int index) {
        return this.mapMarkersHistoryStorage.insertPoint(latitude, longitude, historyDescription, index);
    }

    public boolean updateMapMarkerHistory(double latitude, double longitude, PointDescription historyDescription, int colorIndex) {
        return this.mapMarkersHistoryStorage.updatePoint(latitude, longitude, historyDescription);
    }

    public boolean deleteMapMarkerHistory(int index) {
        return this.mapMarkersHistoryStorage.deletePoint(index);
    }

    public boolean saveMapMarkersHistory(List<LatLon> ps, List<String> ds, List<Integer> cs) {
        return this.mapMarkersHistoryStorage.savePoints(ps, ds);
    }

    public boolean clearPointToNavigate() {
        return this.settingsAPI.edit(this.globalPreferences).remove(POINT_NAVIGATE_LAT).remove(POINT_NAVIGATE_LON).remove(POINT_NAVIGATE_DESCRIPTION).commit();
    }

    public boolean clearPointToStart() {
        return this.settingsAPI.edit(this.globalPreferences).remove(START_POINT_LAT).remove(START_POINT_LON).remove(START_POINT_DESCRIPTION).commit();
    }

    public boolean setPointToNavigate(double latitude, double longitude, PointDescription p) {
        boolean add = this.settingsAPI.edit(this.globalPreferences).putFloat(POINT_NAVIGATE_LAT, (float)latitude).putFloat(POINT_NAVIGATE_LON, (float)longitude).commit();
        this.settingsAPI.edit(this.globalPreferences).putString(POINT_NAVIGATE_DESCRIPTION, PointDescription.serializeToString(p)).commit();
        if (add && p != null && !p.isSearchingAddress(this.ctx)) {
            SearchHistoryHelper.getInstance(this.ctx).addNewItemToHistory(latitude, longitude, p);
        }
        this.backupTargetPoints();
        return add;
    }

    public boolean setPointToStart(double latitude, double longitude, PointDescription p) {
        boolean add = this.settingsAPI.edit(this.globalPreferences).putFloat(START_POINT_LAT, (float)latitude).putFloat(START_POINT_LON, (float)longitude).commit();
        this.settingsAPI.edit(this.globalPreferences).putString(START_POINT_DESCRIPTION, PointDescription.serializeToString(p)).commit();
        this.backupTargetPoints();
        return add;
    }

    public boolean navigateDialog() {
        return this.settingsAPI.edit(this.globalPreferences).putInt(POINT_NAVIGATE_ROUTE, 1).commit();
    }

    public LatLon getLastSearchedPoint() {
        if (this.settingsAPI.contains(this.globalPreferences, LAST_SEARCHED_LAT) && this.settingsAPI.contains(this.globalPreferences, LAST_SEARCHED_LON)) {
            return new LatLon(this.settingsAPI.getFloat(this.globalPreferences, LAST_SEARCHED_LAT, 0.0f), this.settingsAPI.getFloat(this.globalPreferences, LAST_SEARCHED_LON, 0.0f));
        }
        return null;
    }

    public boolean setLastSearchedPoint(LatLon l) {
        if (l == null) {
            return this.settingsAPI.edit(this.globalPreferences).remove(LAST_SEARCHED_LAT).remove(LAST_SEARCHED_LON).commit();
        }
        return this.setLastSearchedPoint(l.getLatitude(), l.getLongitude());
    }

    public boolean setLastSearchedPoint(double lat, double lon) {
        return this.settingsAPI.edit(this.globalPreferences).putFloat(LAST_SEARCHED_LAT, (float)lat).putFloat(LAST_SEARCHED_LON, (float)lon).commit();
    }

    public String getLastSearchedRegion() {
        return this.settingsAPI.getString(this.globalPreferences, LAST_SEARCHED_REGION, "");
    }

    public boolean setLastSearchedRegion(String region, LatLon l) {
        SettingsAPI.SettingsEditor edit = this.settingsAPI.edit(this.globalPreferences).putString(LAST_SEARCHED_REGION, region).putLong(LAST_SEARCHED_CITY, -1L).putString(LAST_SEARCHED_CITY_NAME, "").putString(LAST_SEARCHED_POSTCODE, "").putString(LAST_SEARCHED_STREET, "").putString(LAST_SEARCHED_BUILDING, "");
        if (this.settingsAPI.contains(this.globalPreferences, LAST_SEARCHED_INTERSECTED_STREET)) {
            edit.putString(LAST_SEARCHED_INTERSECTED_STREET, "");
        }
        boolean res = edit.commit();
        this.setLastSearchedPoint(l);
        return res;
    }

    public String getLastSearchedPostcode() {
        return this.settingsAPI.getString(this.globalPreferences, LAST_SEARCHED_POSTCODE, null);
    }

    public boolean setLastSearchedPostcode(String postcode, LatLon point) {
        SettingsAPI.SettingsEditor edit = this.settingsAPI.edit(this.globalPreferences).putLong(LAST_SEARCHED_CITY, -1L).putString(LAST_SEARCHED_STREET, "").putString(LAST_SEARCHED_BUILDING, "").putString(LAST_SEARCHED_POSTCODE, postcode);
        if (this.settingsAPI.contains(this.globalPreferences, LAST_SEARCHED_INTERSECTED_STREET)) {
            edit.putString(LAST_SEARCHED_INTERSECTED_STREET, "");
        }
        boolean res = edit.commit();
        this.setLastSearchedPoint(point);
        return res;
    }

    public Long getLastSearchedCity() {
        return this.settingsAPI.getLong(this.globalPreferences, LAST_SEARCHED_CITY, -1L);
    }

    public String getLastSearchedCityName() {
        return this.settingsAPI.getString(this.globalPreferences, LAST_SEARCHED_CITY_NAME, "");
    }

    public boolean setLastSearchedCity(Long cityId, String name, LatLon point) {
        SettingsAPI.SettingsEditor edit = this.settingsAPI.edit(this.globalPreferences).putLong(LAST_SEARCHED_CITY, cityId).putString(LAST_SEARCHED_CITY_NAME, name).putString(LAST_SEARCHED_STREET, "").putString(LAST_SEARCHED_BUILDING, "").putString(LAST_SEARCHED_POSTCODE, "");
        if (this.settingsAPI.contains(this.globalPreferences, LAST_SEARCHED_INTERSECTED_STREET)) {
            edit.putString(LAST_SEARCHED_INTERSECTED_STREET, "");
        }
        boolean res = edit.commit();
        this.setLastSearchedPoint(point);
        return res;
    }

    public String getLastSearchedStreet() {
        return this.settingsAPI.getString(this.globalPreferences, LAST_SEARCHED_STREET, "");
    }

    public boolean setLastSearchedStreet(String street, LatLon point) {
        SettingsAPI.SettingsEditor edit = this.settingsAPI.edit(this.globalPreferences).putString(LAST_SEARCHED_STREET, street).putString(LAST_SEARCHED_BUILDING, "");
        if (this.settingsAPI.contains(this.globalPreferences, LAST_SEARCHED_INTERSECTED_STREET)) {
            edit.putString(LAST_SEARCHED_INTERSECTED_STREET, "");
        }
        boolean res = edit.commit();
        this.setLastSearchedPoint(point);
        return res;
    }

    public String getLastSearchedBuilding() {
        return this.settingsAPI.getString(this.globalPreferences, LAST_SEARCHED_BUILDING, "");
    }

    public boolean setLastSearchedBuilding(String building, LatLon point) {
        boolean res = this.settingsAPI.edit(this.globalPreferences).putString(LAST_SEARCHED_BUILDING, building).remove(LAST_SEARCHED_INTERSECTED_STREET).commit();
        this.setLastSearchedPoint(point);
        return res;
    }

    public String getLastSearchedIntersectedStreet() {
        if (!this.settingsAPI.contains(this.globalPreferences, LAST_SEARCHED_INTERSECTED_STREET)) {
            return null;
        }
        return this.settingsAPI.getString(this.globalPreferences, LAST_SEARCHED_INTERSECTED_STREET, "");
    }

    public boolean setLastSearchedIntersectedStreet(String street, LatLon l) {
        this.setLastSearchedPoint(l);
        return this.settingsAPI.edit(this.globalPreferences).putString(LAST_SEARCHED_INTERSECTED_STREET, street).commit();
    }

    public CommonPreference<String> getCustomRenderProperty(String attrName) {
        if (!this.customRendersProps.containsKey(attrName)) {
            this.customRendersProps.put(attrName, new StringPreference("nrenderer_" + attrName, "").makeProfile());
        }
        return this.customRendersProps.get(attrName);
    }

    public CommonPreference<Boolean> getCustomRenderBooleanProperty(String attrName) {
        if (!this.customBooleanRendersProps.containsKey(attrName)) {
            this.customBooleanRendersProps.put(attrName, new BooleanPreference("nrenderer_" + attrName, false).makeProfile());
        }
        return this.customBooleanRendersProps.get(attrName);
    }

    public CommonPreference<String> getCustomRoutingProperty(String attrName, String defValue) {
        if (!this.customRoutingProps.containsKey(attrName)) {
            this.customRoutingProps.put(attrName, new StringPreference("prouting_" + attrName, defValue).makeProfile());
        }
        return this.customRoutingProps.get(attrName);
    }

    public CommonPreference<Boolean> getCustomRoutingBooleanProperty(String attrName) {
        if (!this.customBooleanRoutingProps.containsKey(attrName)) {
            this.customBooleanRoutingProps.put(attrName, new BooleanPreference("prouting_" + attrName, false).makeProfile());
        }
        return this.customBooleanRoutingProps.get(attrName);
    }

    public boolean isLightActionBar() {
        return true;
    }

    public boolean isLightContent() {
        return this.OSMAND_THEME.get() != 0;
    }

    public static enum DrivingRegion {
        EUROPE_ASIA(0, MetricsConstants.KILOMETERS_AND_METERS, false, false),
        US(1, MetricsConstants.MILES_AND_FOOTS, false, true),
        CANADA(2, MetricsConstants.KILOMETERS_AND_METERS, false, true),
        UK_AND_OTHERS(3, MetricsConstants.MILES_AND_FOOTS, true, false),
        JAPAN(4, MetricsConstants.KILOMETERS_AND_METERS, true, false);

        public final boolean leftHandDriving;
        public final boolean americanSigns;
        public final MetricsConstants defMetrics;
        public final int name;

        private DrivingRegion(int name, MetricsConstants def, boolean leftHandDriving, boolean americanSigns) {
            this.name = name;
            this.defMetrics = def;
            this.leftHandDriving = leftHandDriving;
            this.americanSigns = americanSigns;
        }
    }

    public static enum AutoZoomMap {
        NONE(0, 0.0f, 18.0f),
        FARTHEST(1, 1.0f, 15.5f),
        FAR(2, 1.4f, 17.0f),
        CLOSE(3, 2.0f, 19.0f);

        public final float coefficient;
        public final int name;
        public final float maxZoom;

        private AutoZoomMap(int name, float coefficient, float maxZoom) {
            this.name = name;
            this.coefficient = coefficient;
            this.maxZoom = maxZoom;
        }
    }

    public static enum MetricsConstants {
        KILOMETERS_AND_METERS(0, "km-m"),
        MILES_AND_FOOTS(1, "mi-f"),
        NAUTICAL_MILES(2, "nm"),
        MILES_AND_YARDS(3, "mi-y");

        private final int key;
        private final String ttsString;

        private MetricsConstants(int key, String ttsString) {
            this.key = key;
            this.ttsString = ttsString;
        }

        public String toHumanString() {
            return "" + this.key;
        }

        public String toTTSString() {
            return this.ttsString;
        }
    }

    public static enum SpeedConstants {
        KILOMETERS_PER_HOUR(0, 0),
        MILES_PER_HOUR(1, 1),
        METERS_PER_SECOND(2, 2),
        MINUTES_PER_MILE(3, 3),
        MINUTES_PER_KILOMETER(4, 4),
        NAUTICALMILES_PER_HOUR(5, 5);

        private final int key;
        private int descr;

        private SpeedConstants(int key, int descr) {
            this.key = key;
            this.descr = descr;
        }

        public String toHumanString() {
            return "" + this.descr;
        }

        public String toShortString() {
            return "" + this.key;
        }
    }

    public static enum MapMarkersMode {
        TOOLBAR(0),
        WIDGETS(1),
        NONE(2);

        private final int key;

        private MapMarkersMode(int key) {
            this.key = key;
        }

        public String toHumanString() {
            return "" + this.key;
        }

        public boolean isToolbar() {
            return this == TOOLBAR;
        }

        public boolean isWidgets() {
            return this == WIDGETS;
        }

        public boolean isNone() {
            return this == NONE;
        }

        public static MapMarkersMode[] possibleValues() {
            return new MapMarkersMode[]{TOOLBAR, WIDGETS, NONE};
        }
    }

    public static enum DayNightMode {
        AUTO(0),
        DAY(1),
        NIGHT(2),
        SENSOR(3);

        private final int key;

        private DayNightMode(int key) {
            this.key = key;
        }

        public String toHumanString() {
            return "" + this.key;
        }

        public boolean isSensor() {
            return this == SENSOR;
        }

        public boolean isAuto() {
            return this == AUTO;
        }

        public boolean isDay() {
            return this == DAY;
        }

        public boolean isNight() {
            return this == NIGHT;
        }

        public static DayNightMode[] possibleValues() {
            return DayNightMode.values();
        }
    }

    private abstract class MapPointsStorage {
        protected String pointsKey;
        protected String descriptionsKey;

        public List<String> getPointDescriptions(int sz) {
            ArrayList<String> list = new ArrayList<String>();
            String ip = OsmandSettings.this.settingsAPI.getString(OsmandSettings.this.globalPreferences, this.descriptionsKey, "");
            if (ip.trim().length() > 0) {
                list.addAll(Arrays.asList(ip.split("--")));
            }
            while (list.size() > sz) {
                list.remove(list.size() - 1);
            }
            while (list.size() < sz) {
                list.add("");
            }
            return list;
        }

        public List<LatLon> getPoints() {
            ArrayList<LatLon> list = new ArrayList<LatLon>();
            String ip = OsmandSettings.this.settingsAPI.getString(OsmandSettings.this.globalPreferences, this.pointsKey, "");
            if (ip.trim().length() > 0) {
                StringTokenizer tok = new StringTokenizer(ip, ",");
                while (tok.hasMoreTokens()) {
                    String lat = tok.nextToken();
                    if (!tok.hasMoreTokens()) break;
                    String lon = tok.nextToken();
                    list.add(new LatLon(Float.parseFloat(lat), Float.parseFloat(lon)));
                }
            }
            return list;
        }

        public boolean insertPoint(double latitude, double longitude, PointDescription historyDescription, int index) {
            List<LatLon> ps = this.getPoints();
            List<String> ds = this.getPointDescriptions(ps.size());
            ps.add(index, new LatLon(latitude, longitude));
            ds.add(index, PointDescription.serializeToString(historyDescription));
            if (historyDescription != null && !historyDescription.isSearchingAddress(OsmandSettings.this.ctx)) {
                SearchHistoryHelper.getInstance(OsmandSettings.this.ctx).addNewItemToHistory(latitude, longitude, historyDescription);
            }
            return this.savePoints(ps, ds);
        }

        public boolean updatePoint(double latitude, double longitude, PointDescription historyDescription) {
            List<LatLon> ps = this.getPoints();
            List<String> ds = this.getPointDescriptions(ps.size());
            int i = ps.indexOf(new LatLon(latitude, longitude));
            if (i != -1) {
                ds.set(i, PointDescription.serializeToString(historyDescription));
                if (historyDescription != null && !historyDescription.isSearchingAddress(OsmandSettings.this.ctx)) {
                    SearchHistoryHelper.getInstance(OsmandSettings.this.ctx).addNewItemToHistory(latitude, longitude, historyDescription);
                }
                return this.savePoints(ps, ds);
            }
            return false;
        }

        public boolean deletePoint(int index) {
            List<LatLon> ps = this.getPoints();
            List<String> ds = this.getPointDescriptions(ps.size());
            if (index < ps.size()) {
                ps.remove(index);
                ds.remove(index);
                return this.savePoints(ps, ds);
            }
            return false;
        }

        public boolean savePoints(List<LatLon> ps, List<String> ds) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ps.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append((float)ps.get(i).getLatitude() + "").append(",").append((float)ps.get(i).getLongitude() + "");
            }
            StringBuilder tb = new StringBuilder();
            for (int i = 0; i < ds.size(); ++i) {
                if (i > 0) {
                    tb.append("--");
                }
                if (ds.get(i) == null) {
                    tb.append("");
                    continue;
                }
                tb.append(ds.get(i));
            }
            return OsmandSettings.this.settingsAPI.edit(OsmandSettings.this.globalPreferences).putString(this.pointsKey, sb.toString()).putString(this.descriptionsKey, tb.toString()).commit();
        }
    }

    private class MapMarkersStorage
    extends MapPointsStorage {
        protected String colorsKey;
        protected String posKey;
        protected String selectionKey;

        public MapMarkersStorage() {
            this.pointsKey = OsmandSettings.MAP_MARKERS_POINT;
            this.descriptionsKey = OsmandSettings.MAP_MARKERS_DESCRIPTION;
            this.colorsKey = OsmandSettings.MAP_MARKERS_COLOR;
            this.posKey = OsmandSettings.MAP_MARKERS_POSITION;
            this.selectionKey = OsmandSettings.MAP_MARKERS_SELECTION;
        }

        public List<Integer> getColors(int sz) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            String ip = OsmandSettings.this.settingsAPI.getString(OsmandSettings.this.globalPreferences, this.colorsKey, "");
            if (ip.trim().length() > 0) {
                StringTokenizer tok = new StringTokenizer(ip, ",");
                while (tok.hasMoreTokens()) {
                    String colorStr = tok.nextToken();
                    list.add(Integer.parseInt(colorStr));
                }
            }
            while (list.size() > sz) {
                list.remove(list.size() - 1);
            }
            int i = 0;
            while (list.size() < sz) {
                list.add(i % 7);
                ++i;
            }
            return list;
        }

        public List<Integer> getPositions(int sz) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int pos = 0;
            String ip = OsmandSettings.this.settingsAPI.getString(OsmandSettings.this.globalPreferences, this.posKey, "");
            if (ip.trim().length() > 0) {
                StringTokenizer tok = new StringTokenizer(ip, ",");
                while (tok.hasMoreTokens()) {
                    String indexStr = tok.nextToken();
                    int p = Integer.parseInt(indexStr);
                    list.add(p);
                    if (p <= pos) continue;
                    pos = p;
                }
            }
            while (list.size() > sz) {
                list.remove(list.size() - 1);
            }
            while (list.size() < sz) {
                list.add(++pos);
            }
            return list;
        }

        public List<Boolean> getSelections(int sz) {
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            String ip = OsmandSettings.this.settingsAPI.getString(OsmandSettings.this.globalPreferences, this.selectionKey, "");
            if (ip.trim().length() > 0) {
                StringTokenizer tok = new StringTokenizer(ip, ",");
                while (tok.hasMoreTokens()) {
                    String indexStr = tok.nextToken();
                    list.add(Boolean.parseBoolean(indexStr));
                }
            }
            while (list.size() > sz) {
                list.remove(list.size() - 1);
            }
            while (list.size() < sz) {
                list.add(false);
            }
            return list;
        }

        public boolean insertPoint(double latitude, double longitude, PointDescription historyDescription, int colorIndex, int pos, boolean selected, int index) {
            List<LatLon> ps = this.getPoints();
            List<String> ds = this.getPointDescriptions(ps.size());
            List<Integer> cs = this.getColors(ps.size());
            List<Integer> ns = this.getPositions(ps.size());
            List<Boolean> bs = this.getSelections(ps.size());
            ps.add(index, new LatLon(latitude, longitude));
            ds.add(index, PointDescription.serializeToString(historyDescription));
            cs.add(index, colorIndex);
            ns.add(index, pos);
            bs.add(index, selected);
            if (historyDescription != null && !historyDescription.isSearchingAddress(OsmandSettings.this.ctx)) {
                SearchHistoryHelper.getInstance(OsmandSettings.this.ctx).addNewItemToHistory(latitude, longitude, historyDescription);
            }
            return this.savePoints(ps, ds, cs, ns, bs);
        }

        public boolean insertPoints(double[] latitudes, double[] longitudes, List<PointDescription> historyDescriptions, int[] colorIndexes, int[] positions, boolean[] selections, int[] indexes) {
            List<LatLon> ps = this.getPoints();
            List<String> ds = this.getPointDescriptions(ps.size());
            List<Integer> cs = this.getColors(ps.size());
            List<Integer> ns = this.getPositions(ps.size());
            List<Boolean> bs = this.getSelections(ps.size());
            for (int i = 0; i < latitudes.length; ++i) {
                double latitude = latitudes[i];
                double longitude = longitudes[i];
                PointDescription historyDescription = historyDescriptions.get(i);
                int colorIndex = colorIndexes[i];
                int pos = positions[i];
                boolean selected = selections[i];
                int index = indexes[i];
                ps.add(index, new LatLon(latitude, longitude));
                ds.add(index, PointDescription.serializeToString(historyDescription));
                cs.add(index, colorIndex);
                ns.add(index, pos);
                bs.add(index, selected);
                if (historyDescription == null || historyDescription.isSearchingAddress(OsmandSettings.this.ctx)) continue;
                SearchHistoryHelper.getInstance(OsmandSettings.this.ctx).addNewItemToHistory(latitude, longitude, historyDescription);
            }
            return this.savePoints(ps, ds, cs, ns, bs);
        }

        public boolean updatePoint(double latitude, double longitude, PointDescription historyDescription, int colorIndex, int pos, boolean selected) {
            List<LatLon> ps = this.getPoints();
            List<String> ds = this.getPointDescriptions(ps.size());
            List<Integer> cs = this.getColors(ps.size());
            List<Integer> ns = this.getPositions(ps.size());
            List<Boolean> bs = this.getSelections(ps.size());
            int index = ps.indexOf(new LatLon(latitude, longitude));
            ds.set(index, PointDescription.serializeToString(historyDescription));
            if (cs.size() > index) {
                cs.set(index, colorIndex);
            }
            if (ns.size() > index) {
                ns.set(index, pos);
            }
            if (bs.size() > index) {
                bs.set(index, selected);
            }
            if (historyDescription != null && !historyDescription.isSearchingAddress(OsmandSettings.this.ctx)) {
                SearchHistoryHelper.getInstance(OsmandSettings.this.ctx).addNewItemToHistory(latitude, longitude, historyDescription);
            }
            return this.savePoints(ps, ds, cs, ns, bs);
        }

        @Override
        public boolean deletePoint(int index) {
            List<LatLon> ps = this.getPoints();
            List<String> ds = this.getPointDescriptions(ps.size());
            List<Integer> cs = this.getColors(ps.size());
            List<Integer> ns = this.getPositions(ps.size());
            List<Boolean> bs = this.getSelections(ps.size());
            ps.remove(index);
            ds.remove(index);
            if (cs.size() > index) {
                cs.remove(index);
            }
            if (ns.size() > index) {
                ns.remove(index);
            }
            if (bs.size() > index) {
                bs.remove(index);
            }
            return this.savePoints(ps, ds, cs, ns, bs);
        }

        public boolean savePoints(List<LatLon> ps, List<String> ds, List<Integer> cs, List<Integer> ns, List<Boolean> bs) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ps.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append((float)ps.get(i).getLatitude() + "").append(",").append((float)ps.get(i).getLongitude() + "");
            }
            StringBuilder tb = new StringBuilder();
            for (int i = 0; i < ds.size(); ++i) {
                if (i > 0) {
                    tb.append("--");
                }
                if (ds.get(i) == null) {
                    tb.append("");
                    continue;
                }
                tb.append(ds.get(i));
            }
            StringBuilder cb = new StringBuilder();
            for (int i = 0; i < cs.size(); ++i) {
                if (i > 0) {
                    cb.append(",");
                }
                cb.append(Integer.toString(cs.get(i)));
            }
            StringBuilder nb = new StringBuilder();
            if (ns != null) {
                for (int i = 0; i < ns.size(); ++i) {
                    if (i > 0) {
                        nb.append(",");
                    }
                    nb.append(Integer.toString(ns.get(i)));
                }
            }
            StringBuilder bb = new StringBuilder();
            if (bs != null) {
                for (int i = 0; i < bs.size(); ++i) {
                    if (i > 0) {
                        bb.append(",");
                    }
                    bb.append(Boolean.toString(bs.get(i)));
                }
            }
            return OsmandSettings.this.settingsAPI.edit(OsmandSettings.this.globalPreferences).putString(this.pointsKey, sb.toString()).putString(this.descriptionsKey, tb.toString()).putString(this.colorsKey, cb.toString()).putString(this.posKey, nb.toString()).putString(this.selectionKey, bb.toString()).commit();
        }

        @Override
        public boolean insertPoint(double latitude, double longitude, PointDescription historyDescription, int index) {
            return false;
        }

        @Override
        public boolean updatePoint(double latitude, double longitude, PointDescription historyDescription) {
            return false;
        }

        @Override
        public boolean savePoints(List<LatLon> ps, List<String> ds) {
            return false;
        }
    }

    private class MapMarkersHistoryStorage
    extends MapPointsStorage {
        public MapMarkersHistoryStorage() {
            this.pointsKey = OsmandSettings.MAP_MARKERS_HISTORY_POINT;
            this.descriptionsKey = OsmandSettings.MAP_MARKERS_HISTORY_DESCRIPTION;
        }

        @Override
        public boolean savePoints(List<LatLon> ps, List<String> ds) {
            while (ps.size() > 30) {
                ps.remove(ps.size() - 1);
                ds.remove(ds.size() - 1);
            }
            return super.savePoints(ps, ds);
        }
    }

    private class IntermediatePointsStorage
    extends MapPointsStorage {
        public IntermediatePointsStorage() {
            this.pointsKey = OsmandSettings.INTERMEDIATE_POINTS;
            this.descriptionsKey = OsmandSettings.INTERMEDIATE_POINTS_DESCRIPTION;
        }

        @Override
        public boolean savePoints(List<LatLon> ps, List<String> ds) {
            boolean res = super.savePoints(ps, ds);
            OsmandSettings.this.backupTargetPoints();
            return res;
        }
    }

    private static class EnumIntPreference<E extends Enum<E>>
    extends CommonPreference<E> {
        private final E[] values;
        final /* synthetic */ OsmandSettings this$0;

        private EnumIntPreference(String id2, E defaultValue, E[] values) {
            this.this$0 = var1_1;
            super(id2, defaultValue);
            this.values = values;
        }

        @Override
        protected E getValue(Object prefs, E defaultValue) {
            try {
                int i = this.this$0.settingsAPI.getInt(prefs, this.getId(), -1);
                if (i >= 0 && i < this.values.length) {
                    return this.values[i];
                }
            }
            catch (ClassCastException ex) {
                this.setValue(prefs, defaultValue);
            }
            return defaultValue;
        }

        @Override
        protected boolean setValue(Object prefs, E val) {
            return this.this$0.settingsAPI.edit(prefs).putInt(this.getId(), ((Enum)val).ordinal()).commit();
        }
    }

    private class StringPreference
    extends CommonPreference<String> {
        private StringPreference(String id2, String defaultValue) {
            super(id2, defaultValue);
        }

        @Override
        protected String getValue(Object prefs, String defaultValue) {
            return OsmandSettings.this.settingsAPI.getString(prefs, this.getId(), defaultValue);
        }

        @Override
        protected boolean setValue(Object prefs, String val) {
            return OsmandSettings.this.settingsAPI.edit(prefs).putString(this.getId(), val != null ? val.trim() : val).commit();
        }
    }

    private class FloatPreference
    extends CommonPreference<Float> {
        private FloatPreference(String id2, float defaultValue) {
            super(id2, Float.valueOf(defaultValue));
        }

        @Override
        protected Float getValue(Object prefs, Float defaultValue) {
            return Float.valueOf(OsmandSettings.this.settingsAPI.getFloat(prefs, this.getId(), defaultValue.floatValue()));
        }

        @Override
        protected boolean setValue(Object prefs, Float val) {
            return OsmandSettings.this.settingsAPI.edit(prefs).putFloat(this.getId(), val.floatValue()).commit();
        }
    }

    private class LongPreference
    extends CommonPreference<Long> {
        private LongPreference(String id2, long defaultValue) {
            super(id2, defaultValue);
        }

        @Override
        protected Long getValue(Object prefs, Long defaultValue) {
            return OsmandSettings.this.settingsAPI.getLong(prefs, this.getId(), defaultValue);
        }

        @Override
        protected boolean setValue(Object prefs, Long val) {
            return OsmandSettings.this.settingsAPI.edit(prefs).putLong(this.getId(), val).commit();
        }
    }

    private class IntPreference
    extends CommonPreference<Integer> {
        private IntPreference(String id2, int defaultValue) {
            super(id2, defaultValue);
        }

        @Override
        protected Integer getValue(Object prefs, Integer defaultValue) {
            return OsmandSettings.this.settingsAPI.getInt(prefs, this.getId(), defaultValue);
        }

        @Override
        protected boolean setValue(Object prefs, Integer val) {
            return OsmandSettings.this.settingsAPI.edit(prefs).putInt(this.getId(), val).commit();
        }
    }

    private class BooleanAccessibilityPreference
    extends BooleanPreference {
        private BooleanAccessibilityPreference(String id2, boolean defaultValue) {
            super(id2, defaultValue);
        }

        @Override
        protected Boolean getValue(Object prefs, Boolean defaultValue) {
            return super.getValue(prefs, defaultValue);
        }

        @Override
        protected boolean setValue(Object prefs, Boolean val) {
            return super.setValue(prefs, val);
        }
    }

    private class BooleanPreference
    extends CommonPreference<Boolean> {
        private BooleanPreference(String id2, boolean defaultValue) {
            super(id2, defaultValue);
        }

        @Override
        protected Boolean getValue(Object prefs, Boolean defaultValue) {
            return OsmandSettings.this.settingsAPI.getBoolean(prefs, this.getId(), defaultValue);
        }

        @Override
        protected boolean setValue(Object prefs, Boolean val) {
            return OsmandSettings.this.settingsAPI.edit(prefs).putBoolean(this.getId(), val).commit();
        }
    }

    public abstract class CommonPreference<T>
    extends PreferenceWithListener<T> {
        private final String id;
        private boolean global;
        private T cachedValue;
        private Object cachedPreference;
        private boolean cache;
        private Map<ApplicationMode, T> defaultValues;
        private T defaultValue;

        public CommonPreference(String id2, T defaultValue) {
            this.id = id2;
            this.defaultValue = defaultValue;
        }

        public CommonPreference<T> makeGlobal() {
            this.global = true;
            return this;
        }

        public CommonPreference<T> cache() {
            this.cache = true;
            return this;
        }

        public CommonPreference<T> makeProfile() {
            this.global = false;
            return this;
        }

        protected Object getPreferences() {
            return this.global ? OsmandSettings.this.globalPreferences : OsmandSettings.this.profilePreferences;
        }

        public void setModeDefaultValue(ApplicationMode mode, T defValue) {
            if (this.defaultValues == null) {
                this.defaultValues = new LinkedHashMap<ApplicationMode, T>();
            }
            this.defaultValues.put(mode, defValue);
        }

        @Override
        public boolean setModeValue(ApplicationMode mode, T obj) {
            if (this.global) {
                return this.set(obj);
            }
            boolean ch = this.setValue(OsmandSettings.this.getProfilePreferences(mode), obj);
            this.fireEvent((Object)obj);
            return ch;
        }

        public T getProfileDefaultValue(ApplicationMode mode) {
            if (this.global) {
                return this.defaultValue;
            }
            if (this.defaultValues != null && this.defaultValues.containsKey(mode)) {
                return this.defaultValues.get(mode);
            }
            ApplicationMode pt = mode.getParent();
            if (pt != null) {
                return this.getProfileDefaultValue(pt);
            }
            if (OsmandSettings.this.settingsAPI.contains(OsmandSettings.this.defaultProfilePreferences, this.getId())) {
                return this.getValue(OsmandSettings.this.defaultProfilePreferences, this.defaultValue);
            }
            return this.defaultValue;
        }

        protected T getDefaultValue() {
            return this.getProfileDefaultValue(OsmandSettings.this.currentMode);
        }

        @Override
        public void overrideDefaultValue(T newDefaultValue) {
            this.defaultValue = newDefaultValue;
        }

        protected abstract T getValue(Object var1, T var2);

        protected abstract boolean setValue(Object var1, T var2);

        @Override
        public T getModeValue(ApplicationMode mode) {
            if (this.global) {
                return this.get();
            }
            T defaultV = this.getProfileDefaultValue(mode);
            return this.getValue(OsmandSettings.this.getProfilePreferences(mode), defaultV);
        }

        @Override
        public T get() {
            if (this.cache && this.cachedValue != null && this.cachedPreference == this.getPreferences()) {
                return this.cachedValue;
            }
            this.cachedPreference = this.getPreferences();
            this.cachedValue = this.getValue(this.cachedPreference, this.getProfileDefaultValue(OsmandSettings.this.currentMode));
            return this.cachedValue;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void resetToDefault() {
            T o = this.getProfileDefaultValue(OsmandSettings.this.currentMode);
            this.set(o);
        }

        @Override
        public boolean set(T obj) {
            Object prefs = this.getPreferences();
            if (this.setValue(prefs, obj)) {
                this.cachedValue = obj;
                this.cachedPreference = prefs;
                this.fireEvent((Object)obj);
                return true;
            }
            return false;
        }

        @Override
        public boolean isSet() {
            return OsmandSettings.this.settingsAPI.contains(this.getPreferences(), this.getId());
        }
    }

    private abstract class PreferenceWithListener<T>
    implements OsmandPreference<T> {
        private List<WeakReference<StateChangedListener<T>>> l = null;

        private PreferenceWithListener() {
        }

        @Override
        public void addListener(StateChangedListener<T> listener) {
            if (this.l == null) {
                this.l = new LinkedList<WeakReference<StateChangedListener<T>>>();
            }
            if (!this.l.contains(new WeakReference<StateChangedListener<T>>(listener))) {
                this.l.add(new WeakReference<StateChangedListener<T>>(listener));
            }
        }

        public void fireEvent(T value) {
            if (this.l != null) {
                Iterator<WeakReference<StateChangedListener<T>>> it = this.l.iterator();
                while (it.hasNext()) {
                    StateChangedListener t = (StateChangedListener)it.next().get();
                    if (t == null) {
                        it.remove();
                        continue;
                    }
                    t.stateChanged(value);
                }
            }
        }

        @Override
        public void removeListener(StateChangedListener<T> listener) {
            if (this.l != null) {
                Iterator<WeakReference<StateChangedListener<T>>> it = this.l.iterator();
                while (it.hasNext()) {
                    StateChangedListener t = (StateChangedListener)it.next().get();
                    if (t != listener) continue;
                    it.remove();
                }
            }
        }
    }

    public static interface OsmandPreference<T> {
        public T get();

        public boolean set(T var1);

        public boolean setModeValue(ApplicationMode var1, T var2);

        public T getModeValue(ApplicationMode var1);

        public String getId();

        public void resetToDefault();

        public void overrideDefaultValue(T var1);

        public void addListener(StateChangedListener<T> var1);

        public void removeListener(StateChangedListener<T> var1);

        public boolean isSet();
    }
}

