'''OpenGL extension EXT.secondary_color

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.secondary_color to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows specifying the RGB components of the secondary
	color used in the Color Sum stage, instead of using the default
	(0,0,0,0) color. It applies only in RGBA mode and when LIGHTING is
	disabled.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/secondary_color.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.secondary_color import *
from OpenGL.raw.GL.EXT.secondary_color import _EXTENSION_NAME

def glInitSecondaryColorEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glSecondaryColor3bvEXT=wrapper.wrapper(glSecondaryColor3bvEXT).setInputArraySize(
    'v', 3
)
glSecondaryColor3dvEXT=wrapper.wrapper(glSecondaryColor3dvEXT).setInputArraySize(
    'v', 3
)
glSecondaryColor3fvEXT=wrapper.wrapper(glSecondaryColor3fvEXT).setInputArraySize(
    'v', 3
)
glSecondaryColor3ivEXT=wrapper.wrapper(glSecondaryColor3ivEXT).setInputArraySize(
    'v', 3
)
glSecondaryColor3svEXT=wrapper.wrapper(glSecondaryColor3svEXT).setInputArraySize(
    'v', 3
)
glSecondaryColor3ubvEXT=wrapper.wrapper(glSecondaryColor3ubvEXT).setInputArraySize(
    'v', 3
)
glSecondaryColor3uivEXT=wrapper.wrapper(glSecondaryColor3uivEXT).setInputArraySize(
    'v', 3
)
glSecondaryColor3usvEXT=wrapper.wrapper(glSecondaryColor3usvEXT).setInputArraySize(
    'v', 3
)
# INPUT glSecondaryColorPointerEXT.pointer size not checked against 'size,type,stride'
glSecondaryColorPointerEXT=wrapper.wrapper(glSecondaryColorPointerEXT).setInputArraySize(
    'pointer', None
)
### END AUTOGENERATED SECTION