/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByVersionRequirement$WhenMappings;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\fH\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByVersionRequirement;", "Lorg/jetbrains/kotlin/resolve/deprecation/Deprecation;", "versionRequirement", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;", "target", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)V", "deprecationLevel", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "getDeprecationLevel", "()Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "message", "", "getMessage", "()Ljava/lang/String;", "getTarget", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getVersionRequirement", "()Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "frontend"})
public final class DeprecatedByVersionRequirement
implements Deprecation {
    @NotNull
    private final VersionRequirement versionRequirement;
    @NotNull
    private final DeclarationDescriptor target;

    @Override
    @NotNull
    public DeprecationLevelValue getDeprecationLevel() {
        DeprecationLevelValue deprecationLevelValue;
        switch (DeprecatedByVersionRequirement$WhenMappings.$EnumSwitchMapping$0[this.versionRequirement.getLevel().ordinal()]) {
            case 1: {
                deprecationLevelValue = DeprecationLevelValue.WARNING;
                break;
            }
            case 2: {
                deprecationLevelValue = DeprecationLevelValue.ERROR;
                break;
            }
            case 3: {
                deprecationLevelValue = DeprecationLevelValue.HIDDEN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return deprecationLevelValue;
    }

    @Override
    @Nullable
    public String getMessage() {
        StringBuilder stringBuilder;
        String message = this.versionRequirement.getMessage();
        Integer errorCode = this.versionRequirement.getErrorCode();
        if (message == null && errorCode == null) {
            return null;
        }
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        if (message != null) {
            $receiver.append(message);
            if (errorCode != null) {
                $receiver.append(" (error code " + errorCode + ')');
            }
        } else {
            $receiver.append("Error code " + errorCode);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final VersionRequirement getVersionRequirement() {
        return this.versionRequirement;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getTarget() {
        return this.target;
    }

    public DeprecatedByVersionRequirement(@NotNull VersionRequirement versionRequirement, @NotNull DeclarationDescriptor target) {
        Intrinsics.checkParameterIsNotNull(versionRequirement, "versionRequirement");
        Intrinsics.checkParameterIsNotNull(target, "target");
        this.versionRequirement = versionRequirement;
        this.target = target;
    }

    @NotNull
    public final VersionRequirement component1() {
        return this.versionRequirement;
    }

    @NotNull
    public final DeclarationDescriptor component2() {
        return this.getTarget();
    }

    @NotNull
    public final DeprecatedByVersionRequirement copy(@NotNull VersionRequirement versionRequirement, @NotNull DeclarationDescriptor target) {
        Intrinsics.checkParameterIsNotNull(versionRequirement, "versionRequirement");
        Intrinsics.checkParameterIsNotNull(target, "target");
        return new DeprecatedByVersionRequirement(versionRequirement, target);
    }

    @NotNull
    public static /* synthetic */ DeprecatedByVersionRequirement copy$default(DeprecatedByVersionRequirement deprecatedByVersionRequirement, VersionRequirement versionRequirement, DeclarationDescriptor declarationDescriptor, int n, Object object) {
        if ((n & 1) != 0) {
            versionRequirement = deprecatedByVersionRequirement.versionRequirement;
        }
        if ((n & 2) != 0) {
            declarationDescriptor = deprecatedByVersionRequirement.getTarget();
        }
        return deprecatedByVersionRequirement.copy(versionRequirement, declarationDescriptor);
    }

    @NotNull
    public String toString() {
        return "DeprecatedByVersionRequirement(versionRequirement=" + this.versionRequirement + ", target=" + this.getTarget() + ")";
    }

    public int hashCode() {
        VersionRequirement versionRequirement = this.versionRequirement;
        DeclarationDescriptor declarationDescriptor = this.getTarget();
        return (versionRequirement != null ? versionRequirement.hashCode() : 0) * 31 + (declarationDescriptor != null ? declarationDescriptor.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DeprecatedByVersionRequirement)) break block3;
                DeprecatedByVersionRequirement deprecatedByVersionRequirement = (DeprecatedByVersionRequirement)object;
                if (!Intrinsics.areEqual(this.versionRequirement, deprecatedByVersionRequirement.versionRequirement) || !Intrinsics.areEqual(this.getTarget(), deprecatedByVersionRequirement.getTarget())) break block3;
            }
            return true;
        }
        return false;
    }
}

