/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Iterator;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyModule;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.MethodJITClassGenerator;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.collections.IntHashMap;

public class MethodCompiledJITTask
implements Runnable {
    private final JITCompiler jitCompiler;
    private final String className;
    private final CompiledIRMethod method;
    private final String methodName;

    public MethodCompiledJITTask(JITCompiler jitCompiler, CompiledIRMethod method2, String className) {
        this.jitCompiler = jitCompiler;
        this.method = method2;
        this.className = className;
        this.methodName = method2.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JITCompiler jITCompiler = this.jitCompiler;
        synchronized (jITCompiler) {
            try {
                Iterator<IntHashMap.Entry<MethodType>> iterator;
                if (this.jitCompiler.config.getExcludedMethods().size() > 0) {
                    RubyBasicObject possibleRealClass;
                    String excludeModuleName = this.className;
                    if (this.method.getImplementationClass().getMethodLocation().isSingleton() && (possibleRealClass = ((MetaClass)this.method.getImplementationClass()).getAttached()) instanceof RubyModule) {
                        excludeModuleName = "Meta:" + ((RubyModule)possibleRealClass).getName();
                    }
                    if (this.jitCompiler.config.getExcludedMethods().contains(excludeModuleName) || this.jitCompiler.config.getExcludedMethods().contains(excludeModuleName + '#' + this.methodName) || this.jitCompiler.config.getExcludedMethods().contains(this.methodName)) {
                        this.method.setCallCount(-1);
                        if (this.jitCompiler.config.isJitLogging()) {
                            JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.methodName, "skipping method: " + excludeModuleName + '#' + this.methodName, new String[0]);
                        }
                        return;
                    }
                }
                String key2 = SexpMaker.sha1(this.method.getIRScope());
                Ruby runtime2 = this.jitCompiler.runtime;
                JVMVisitor visitor = new JVMVisitor(runtime2);
                MethodJITClassGenerator generator = new MethodJITClassGenerator(this.className, this.methodName, key2, runtime2, this.method, visitor);
                JVMVisitorMethodContext context = new JVMVisitorMethodContext();
                generator.compile(context);
                Class sourceClass = visitor.defineFromBytecode(this.method.getIRScope(), generator.bytecode(), new OneShotClassLoader(runtime2.getJRubyClassLoader()));
                if (sourceClass == null) {
                    this.jitCompiler.counts.failCount.incrementAndGet();
                    return;
                }
                generator.updateCounters(this.jitCompiler.counts, this.method.ensureInstrsReady());
                long methodCount = this.jitCompiler.counts.successCount.incrementAndGet();
                if (this.jitCompiler.config.getJitLogEvery() > 0 && methodCount % (long)this.jitCompiler.config.getJitLogEvery() == 0L) {
                    JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.methodName, "live compiled methods: " + methodCount, new String[0]);
                }
                if (this.jitCompiler.config.isJitLogging()) {
                    JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.className + '.' + this.methodName, "done jitting", new String[0]);
                }
                String variableName = context.getVariableName();
                MethodHandle variable = JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, variableName, context.getNativeSignature(-1));
                IntHashMap<MethodType> signatures = context.getNativeSignaturesExceptVariable();
                this.method.setVariable(variable);
                if (signatures.size() != 0 && (iterator = signatures.entrySet().iterator()).hasNext()) {
                    IntHashMap.Entry<MethodType> entry = iterator.next();
                    this.method.setSpecific(JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, context.getSpecificName(), entry.getValue()));
                }
            }
            catch (Throwable t) {
                if (this.jitCompiler.config.isJitLogging()) {
                    JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.className + '.' + this.methodName, "Could not compile; passes run: " + this.method.getIRScope().getExecutedPasses(), t.getMessage());
                    if (this.jitCompiler.config.isJitLoggingVerbose()) {
                        t.printStackTrace();
                    }
                }
                this.jitCompiler.counts.failCount.incrementAndGet();
            }
        }
    }
}

