/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.CommunicatorDescriptor;
import com.zeroc.IceGrid.DbEnvDescriptor;
import com.zeroc.IceGrid.IceBoxDescriptor;
import com.zeroc.IceGrid.ServerDescriptor;
import com.zeroc.IceGrid.ServiceInstanceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.Adapter;
import com.zeroc.IceGridGUI.Application.Communicator;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.PlainServer;
import com.zeroc.IceGridGUI.Application.ServerTemplateEditor;
import com.zeroc.IceGridGUI.Application.ServerTemplates;
import com.zeroc.IceGridGUI.Application.TemplateInstance;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ServerTemplate
extends Communicator {
    private TemplateDescriptor _templateDescriptor;
    private final boolean _ephemeral;
    private Editable _editable;
    private ServerTemplateEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon _plainIcon;
    private static Icon _iceboxIcon;
    private static JPopupMenu _popup;

    public static TemplateDescriptor copyDescriptor(TemplateDescriptor templateDescriptor) {
        TemplateDescriptor copy = templateDescriptor.clone();
        copy.descriptor = PlainServer.copyDescriptor((ServerDescriptor)copy.descriptor);
        return copy;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _plainIcon = Utils.getIcon("/icons/16x16/server_template.png");
            _iceboxIcon = Utils.getIcon("/icons/16x16/icebox_server_template.png");
        }
        if (this._templateDescriptor.descriptor instanceof IceBoxDescriptor) {
            if (expanded) {
                _cellRenderer.setOpenIcon(_iceboxIcon);
            } else {
                _cellRenderer.setClosedIcon(_iceboxIcon);
            }
        } else if (expanded) {
            _cellRenderer.setOpenIcon(_plainIcon);
        } else {
            _cellRenderer.setClosedIcon(_plainIcon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public boolean[] getAvailableActions() {
        Object clipboard;
        boolean[] actions = new boolean[20];
        boolean bl = actions[13] = !this._ephemeral;
        actions[14] = ((TreeNode)this._parent).getAvailableActions()[14] ? true : (clipboard = this.getCoordinator().getClipboard()) != null && (this.isIceBox() && clipboard instanceof ServiceInstanceDescriptor || !this.isIceBox() && (clipboard instanceof Adapter.AdapterCopy || clipboard instanceof DbEnvDescriptor));
        actions[15] = true;
        if (!this._ephemeral) {
            actions[0] = !this._services.initialized();
            actions[8] = this._services.initialized();
            actions[9] = this._services.initialized();
            actions[1] = this._dbEnvs.initialized();
        }
        return actions;
    }

    @Override
    public void copy() {
        this.getCoordinator().setClipboard(ServerTemplate.copyDescriptor(this._templateDescriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(0));
            _popup.add(actions.get(1));
            _popup.add(actions.get(8));
            _popup.add(actions.get(9));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ServerTemplateEditor)this.getRoot().getEditor(ServerTemplateEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    @Override
    protected Editor createEditor() {
        return new ServerTemplateEditor();
    }

    @Override
    public void destroy() {
        ServerTemplates serverTemplates = (ServerTemplates)this._parent;
        if (this._ephemeral) {
            serverTemplates.removeChild(this);
        } else {
            serverTemplates.removeDescriptor(this._id);
            this.getRoot().removeServerInstances(this._id);
            serverTemplates.removeChild(this);
            serverTemplates.getEditable().removeElement(this._id, this._editable, ServerTemplate.class);
            this.getRoot().updated();
        }
    }

    @Override
    public boolean isEphemeral() {
        return this._ephemeral;
    }

    @Override
    public Object getDescriptor() {
        return this._templateDescriptor;
    }

    @Override
    CommunicatorDescriptor getCommunicatorDescriptor() {
        return this._templateDescriptor.descriptor;
    }

    @Override
    public Object saveDescriptor() {
        TemplateDescriptor clone = this._templateDescriptor.clone();
        clone.descriptor = this._templateDescriptor.descriptor.clone();
        return clone;
    }

    @Override
    public void restoreDescriptor(Object savedDescriptor) {
        TemplateDescriptor clone = (TemplateDescriptor)savedDescriptor;
        this._templateDescriptor.parameters = clone.parameters;
        PlainServer.shallowRestore((ServerDescriptor)clone.descriptor, (ServerDescriptor)this._templateDescriptor.descriptor);
    }

    ServerTemplate(boolean brandNew, ServerTemplates parent, String name, TemplateDescriptor descriptor) throws UpdateFailedException {
        super(parent, name);
        this._editable = new Editable(brandNew);
        this._ephemeral = false;
        this.rebuild(descriptor);
    }

    ServerTemplate(ServerTemplates parent, String name, TemplateDescriptor descriptor) {
        block2: {
            super(parent, name);
            this._ephemeral = true;
            try {
                this.rebuild(descriptor);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(ServerTemplate.createAttribute("id", this._id));
            writer.writeStartTag("server-template", attributes);
            ServerTemplate.writeParameters(writer, this._templateDescriptor.parameters, this._templateDescriptor.parameterDefaults);
            if (this._templateDescriptor.descriptor instanceof IceBoxDescriptor) {
                IceBoxDescriptor descriptor = (IceBoxDescriptor)this._templateDescriptor.descriptor;
                writer.writeStartTag("icebox", PlainServer.createAttributes((ServerDescriptor)descriptor));
                if (descriptor.description.length() > 0) {
                    writer.writeElement("description", descriptor.description);
                }
                PlainServer.writeOptions(writer, descriptor.options);
                PlainServer.writeEnvs(writer, descriptor.envs);
                ServerTemplate.writePropertySet(writer, "", "", descriptor.propertySet, descriptor.adapters, descriptor.logs);
                ServerTemplate.writeLogs(writer, descriptor.logs, descriptor.propertySet.properties);
                ServerTemplate.writeDistribution(writer, descriptor.distrib);
                this._adapters.write(writer, descriptor.propertySet.properties);
                this._services.write(writer);
                writer.writeEndTag("icebox");
            } else {
                ServerDescriptor descriptor = (ServerDescriptor)this._templateDescriptor.descriptor;
                writer.writeStartTag("server", PlainServer.createAttributes(descriptor));
                if (descriptor.description.length() > 0) {
                    writer.writeElement("description", descriptor.description);
                }
                PlainServer.writeOptions(writer, descriptor.options);
                PlainServer.writeEnvs(writer, descriptor.envs);
                ServerTemplate.writePropertySet(writer, descriptor.propertySet, descriptor.adapters, descriptor.logs);
                ServerTemplate.writeLogs(writer, descriptor.logs, descriptor.propertySet.properties);
                ServerTemplate.writeDistribution(writer, descriptor.distrib);
                this._adapters.write(writer, descriptor.propertySet.properties);
                this._dbEnvs.write(writer);
                writer.writeEndTag("server");
            }
            writer.writeEndTag("server-template");
        }
    }

    @Override
    boolean isIceBox() {
        return this._templateDescriptor.descriptor instanceof IceBoxDescriptor;
    }

    void rebuild(TemplateDescriptor descriptor) throws UpdateFailedException {
        this._templateDescriptor = descriptor;
        this._adapters.clear();
        this._dbEnvs.clear();
        this._services.clear();
        if (!this._ephemeral) {
            this._adapters.init(this._templateDescriptor.descriptor.adapters);
            if (this.isIceBox()) {
                IceBoxDescriptor iceBoxDescriptor = (IceBoxDescriptor)this._templateDescriptor.descriptor;
                this._services.init(iceBoxDescriptor.services);
                assert (this._templateDescriptor.descriptor.dbEnvs.size() == 0);
            } else {
                this._dbEnvs.init(this._templateDescriptor.descriptor.dbEnvs);
            }
        }
    }

    void rebuild() throws UpdateFailedException {
        this.rebuild(this._templateDescriptor);
    }

    void commit() {
        this._editable.commit();
    }

    Editable getEditable() {
        return this._editable;
    }

    @Override
    Editable getEnclosingEditable() {
        return this._editable;
    }

    @Override
    List<? extends TemplateInstance> findInstances() {
        return this.getRoot().findServerInstances(this._id);
    }
}

