/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.GestureType;
import com.sparshui.common.ClientProtocol;
import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;
import com.sparshui.server.TouchPoint;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import javajs.util.Lst;

public class ServerToClientProtocol
extends ClientProtocol {
    private DataOutputStream _bufferOut;
    private ByteArrayOutputStream _buffer = new ByteArrayOutputStream();

    public ServerToClientProtocol(Socket socket) throws IOException {
        super(socket);
        this._bufferOut = new DataOutputStream(this._buffer);
    }

    public Lst<GestureType> getGestures(int n) throws IOException {
        Lst<GestureType> lst = new Lst<GestureType>();
        this._bufferOut.writeInt(n);
        this.sendBuffer(2);
        int n2 = this._in.readInt();
        while (n2 > 0) {
            int n3 = this._in.readInt();
            if (n3 < 0) {
                byte[] byArray = new byte[-n3];
                this._in.read(byArray);
                lst.addLast(new GestureType(Converter.byteArrayToString(byArray)));
                n2 -= byArray.length;
            } else {
                lst.addLast(new GestureType(n3));
            }
            n2 -= 4;
        }
        return lst;
    }

    public int getGroupID(TouchPoint touchPoint) throws IOException {
        byte[] byArray = new byte[4];
        Converter.floatToByteArray(byArray, 0, touchPoint.getLocation().getX());
        this._bufferOut.write(byArray);
        Converter.floatToByteArray(byArray, 0, touchPoint.getLocation().getY());
        this._bufferOut.write(byArray);
        this.sendBuffer(1);
        int n = this._in.readInt();
        return n;
    }

    public void processEvents(int n, Lst<Event> lst) throws IOException {
        int n2 = 0;
        while (n2 < lst.size()) {
            this._bufferOut.writeInt(n);
            this._bufferOut.write(((Event)lst.get(n2)).serialize());
            this.sendBuffer(0);
            ++n2;
        }
    }

    public void processError(int n) throws IOException {
        this._bufferOut.writeInt(-1);
        this._bufferOut.writeInt(n);
        this.sendBuffer(0);
    }

    private void sendBuffer(int n) throws IOException {
        this._out.writeByte((byte)n);
        this._out.writeInt(this._buffer.size());
        this._out.write(this._buffer.toByteArray());
        this._buffer.reset();
    }
}

