/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.quantum.SlaterData;
import org.jmol.util.JSONWriter;
import org.jmol.util.Vibration;
import org.jmol.viewer.Viewer;
import org.qcschema.QCSchemaUnits;

public class QCJSONWriter
extends JSONWriter {
    private Map<String, Object> moBases = new Hashtable<String, Object>();
    private Map<String, String> htBasisMap = new Hashtable<String, String>();
    private boolean filterMOs;
    private Viewer vwr;
    private int basisID = 0;
    private Lst<int[]> shells;
    private int[][] dfCoefMaps;
    private static Map<String, String> integrationKeyMap;

    public void set(Viewer viewer, OutputStream outputStream) {
        this.vwr = viewer;
        this.setWriteNullAsString(false);
        this.setStream(outputStream);
    }

    public String toString() {
        return this.oc == null ? "{}" : this.oc.toString();
    }

    public void writeJSON() {
        this.openSchema();
        this.writeMagic();
        this.oc.append(",\n");
        this.writeSchemaMetadata();
        this.writeJobs();
        this.closeSchema();
    }

    public void writeSchemaMetadata() {
        this.mapOpen();
        this.mapAddKeyValue("__jmol_created", new Date(), ",\n");
        this.mapAddKeyValue("__jmol_source", this.vwr.getP("_modelFile"), "");
        this.mapClose();
    }

    public void openSchema() {
        this.arrayOpen(false);
    }

    public void writeMagic() {
        this.writeString(QCSchemaUnits.version);
    }

    public void closeSchema() {
        this.oc.append("\n");
        this.arrayClose(false);
        this.closeStream();
    }

    public void writeJobs() {
        this.writeJob(1);
    }

    public void writeJob(int n) {
        this.append(",\n");
        this.mapOpen();
        this.mapAddKeyValue("__jmol_block", "Job " + n, ",\n");
        this.writeJobMetadata();
        this.writeModels();
        this.writeMOBases();
        this.mapClose();
    }

    public void writeJobMetadata() {
        this.mapAddKey("metadata");
        this.mapOpen();
        this.mapAddMapAllExcept("__jmol_info", this.vwr.getModelSetAuxiliaryInfo(), ";group3Counts;properties;group3Lists;models;unitCellParams;");
        this.mapClose();
    }

    public void writeModels() {
        int n = this.vwr.ms.mc;
        this.oc.append(",\n");
        this.mapAddKey("steps");
        this.arrayOpen(true);
        this.oc.append("\n");
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                this.append(",\n");
            }
            n2 = this.writeModel(n2);
        }
        this.arrayClose(true);
    }

    public int writeModel(int n) {
        int n2 = n + 1;
        this.append("");
        this.mapOpen();
        this.mapAddKeyValue("__jmol_block", "Model " + (n + 1), ",\n");
        this.writeTopology(n);
        if (this.isVibration(n)) {
            this.oc.append(",\n");
            n2 = this.writeVibrations(n);
        }
        if (this.haveMOData(n)) {
            this.oc.append(",\n");
            this.writeMOData(n);
        }
        this.oc.append(",\n");
        this.writeModelMetadata(n);
        this.mapClose();
        this.oc.append("\n");
        return n2;
    }

    public void writeTopology(int n) {
        this.mapAddKey("topology");
        this.mapOpen();
        this.writeAtoms(n);
        this.writeBonds(n);
        this.mapClose();
    }

    public Object getProperty(int n, String string) {
        Map map = (Map)(n >= this.vwr.ms.am.length ? null : this.vwr.ms.am[n].auxiliaryInfo.get("modelProperties"));
        return map == null ? null : map.get(string);
    }

    private boolean isVibration(int n) {
        return this.vwr.ms.getLastVibrationVector(n, 0) >= 0;
    }

    public void writeModelMetadata(int n) {
        this.mapAddKey("metadata");
        this.mapOpen();
        this.mapAddMapAllExcept("__jmol_info", this.vwr.ms.am[n].auxiliaryInfo, ";.PATH;PATH;fileName;moData;unitCellParams;");
        this.mapClose();
    }

    public void writeAtoms(int n) {
        Object object;
        boolean bl;
        SparseArray sparseArray = new SparseArray("_RLE_");
        SparseArray sparseArray2 = new SparseArray("_RLE_");
        SparseArray sparseArray3 = new SparseArray("_RLE_");
        SparseArray sparseArray4 = new SparseArray("_RLE_");
        SparseArray sparseArray5 = new SparseArray("_RLE_");
        this.mapAddKey("atoms");
        this.mapOpen();
        SymmetryInterface symmetryInterface = this.vwr.ms.getUnitCell(n);
        boolean bl2 = bl = symmetryInterface != null && !symmetryInterface.isBio();
        if (bl) {
            object = symmetryInterface.getUnitCellAsArray(false);
            this.writePrefix_Units("unit_cell", "angstroms");
            this.mapAddKeyValue("unit_cell", object, ",\n");
        }
        this.writePrefix_Units("coords", bl ? "fractional" : "angstroms");
        this.mapAddKey("coords");
        this.arrayOpen(true);
        this.oc.append("\n");
        object = this.vwr.getModelUndeletedAtomsBitSet(n);
        int n2 = ((BS)object).length() - 1;
        P3 p3 = new P3();
        int n3 = ((BS)object).nextSetBit(0);
        while (n3 >= 0) {
            Atom atom = this.vwr.ms.at[n3];
            this.append("");
            p3.setT(atom);
            if (bl) {
                symmetryInterface.toFractional(p3, false);
            }
            this.oc.append(this.formatNumber(p3.x)).append(",\t").append(this.formatNumber(p3.y)).append(",\t").append(this.formatNumber(p3.z)).append(n3 < n2 ? ",\n" : "\n");
            sparseArray.add(PT.esc(atom.getElementSymbol()));
            sparseArray2.add("" + atom.getElementNumber());
            sparseArray3.add("" + atom.getPartialCharge());
            String string = atom.getAtomName();
            sparseArray4.add(string);
            String string2 = atom.getAtomType();
            sparseArray5.add(string2.equals(string) ? null : string2);
            n3 = ((BS)object).nextSetBit(n3 + 1);
        }
        this.arrayClose(true);
        this.oc.append(",\n");
        if (sparseArray3.isNumericAndNonZero()) {
            this.mapAddKeyValueRaw("charge", sparseArray3, ",\n");
        }
        if (sparseArray5.hasValues()) {
            this.mapAddKeyValueRaw("types", sparseArray5, ",\n");
        }
        this.mapAddKeyValueRaw("symbol", sparseArray, ",\n");
        this.mapAddKeyValueRaw("atom_number", sparseArray2, "\n");
        this.mapClose();
    }

    private String formatNumber(float f) {
        return String.valueOf(f < 0.0f ? "" : " ") + DF.formatDecimal(f, -6);
    }

    private void writePrefix_Units(String string, String string2) {
        this.mapAddKeyValueRaw(String.valueOf(string) + "_units", QCSchemaUnits.getUnitsJSON(string2, false), ",\n");
    }

    public void writeBonds(int n) {
    }

    public int writeVibrations(int n) {
        this.mapAddKey("vibrations");
        this.arrayOpen(true);
        this.oc.append("\n");
        String string = null;
        int n2 = 0;
        --n;
        while (this.isVibration(++n)) {
            String string2;
            String[] stringArray;
            if (string != null) {
                this.oc.append(string);
            }
            string = ",\n";
            this.append("");
            this.mapOpen();
            this.mapAddKeyValue("__jmol_block", "Vibration " + ++n2, ",\n");
            Object object = this.getProperty(n, "FreqValue");
            String string3 = (String)this.getProperty(n, "Frequency");
            String string4 = (String)this.getProperty(n, "IRIntensity");
            if (object == null) {
                System.out.println("model " + n + " has no _M.properties.FreqValue");
            }
            if (string3 == null) {
                System.out.println("model " + n + " has no _M.properties.Frequency");
            } else {
                stringArray = PT.split(string3, " ");
                if (stringArray.length == 1) {
                    System.out.println("model " + n + " has no frequency units");
                }
                this.writeMapKeyValueUnits("frequency", object, stringArray[1]);
            }
            if (string4 != null) {
                stringArray = PT.split(string4, " ");
                this.writeMapKeyValueUnits("ir_intensity", stringArray[0], stringArray[1]);
            }
            if ((string2 = (String)this.getProperty(n, "FrequencyLabel")) != null) {
                this.mapAddKeyValue("label", string2, ",\n");
            }
            this.mapAddKey("vectors");
            this.arrayOpen(true);
            this.oc.append("\n");
            BS bS = this.vwr.getModelUndeletedAtomsBitSet(n);
            int n3 = bS.length() - 1;
            int n4 = bS.nextSetBit(0);
            while (n4 >= 0) {
                Atom atom = this.vwr.ms.at[n4];
                Vibration vibration = atom.getVibrationVector();
                this.append("");
                this.oc.append(this.formatNumber(vibration.x)).append(",\t").append(this.formatNumber(vibration.y)).append(",\t").append(this.formatNumber(vibration.z)).append(n4 < n3 ? ",\n" : "\n");
                n4 = bS.nextSetBit(n4 + 1);
            }
            this.arrayClose(true);
            this.append("");
            this.mapClose();
        }
        this.oc.append("\n");
        this.arrayClose(true);
        return n;
    }

    private void writeMapKeyValueUnits(String string, Object object, String string2) {
        this.mapAddKeyValueRaw(string, "{\"value\":" + object + ",\"units\":" + QCSchemaUnits.getUnitsJSON(string2, false) + "}", ",\n");
    }

    private boolean haveMOData(int n) {
        return this.getAuxiliaryData(n, "moData") != null;
    }

    private Object getAuxiliaryData(int n, String string) {
        return this.vwr.ms.am[n].auxiliaryInfo.get(string);
    }

    private void writeMOData(int n) {
        Map map = (Map)this.getAuxiliaryData(n, "moData");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("orbitals", map.get("mos"));
        String string = (String)map.get("EnergyUnits");
        if (string == null) {
            string = "?";
        }
        hashtable.put("orbitals_energy_units", QCSchemaUnits.getUnitsJSON(string, true));
        hashtable.put("__jmol_normalized", map.get("isNormalized") == Boolean.TRUE);
        String string2 = (String)map.get("calculationType");
        hashtable.put("__jmol_calculation_type", string2 == null ? "?" : string2);
        this.setDFCoord(map);
        hashtable.put("basis_id", this.addBasis(map));
        this.filterMOs = true;
        this.setModifyKeys(QCJSONWriter.fixIntegration());
        this.mapAddKeyValue("molecular_orbitals", hashtable, "\n");
        this.setModifyKeys(null);
        this.filterMOs = false;
        this.append("");
    }

    private static Map<String, String> fixIntegration() {
        if (integrationKeyMap == null) {
            integrationKeyMap = new Hashtable<String, String>();
            integrationKeyMap.put("integration", "__jmol_integration");
        }
        return integrationKeyMap;
    }

    @Override
    protected Object getAndCheckValue(Map<String, Object> map, String string) {
        if (this.filterMOs) {
            if (string.equals("dfCoefMaps")) {
                return null;
            }
            if (string.equals("symmetry")) {
                return ((String)map.get(string)).replace('_', ' ').trim();
            }
            if (string.equals("coefficients") && this.dfCoefMaps != null) {
                return this.fixCoefficients((double[])map.get(string));
            }
        }
        return map.get(string);
    }

    private Object fixCoefficients(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        int n2 = this.shells.size();
        while (n < n2) {
            int[] nArray = (int[])this.shells.get(n);
            int n3 = nArray[1];
            int[] nArray2 = this.dfCoefMaps[n3];
            int n4 = 0;
            int n5 = 0;
            while (n4 < nArray2.length) {
                dArray2[n5 + n4] = dArray[n5 + nArray2[n4]];
                ++n4;
                ++n5;
            }
            ++n;
        }
        return dArray2;
    }

    private void setDFCoord(Map<String, Object> map) {
        this.dfCoefMaps = (int[][])map.get("dfCoefMaps");
        if (this.dfCoefMaps != null) {
            boolean bl = false;
            int n = 0;
            while (!bl && n < this.dfCoefMaps.length) {
                int[] nArray = this.dfCoefMaps[n];
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] != 0) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            if (!bl) {
                this.dfCoefMaps = null;
            }
        }
    }

    private String addBasis(Map<String, Object> map) {
        String string;
        String string2;
        Object object;
        int n = 1;
        Object object2 = map.get("gaussians");
        if (object2 != null) {
            n ^= object2.hashCode();
        }
        this.shells = (Lst)map.get("shells");
        if (this.shells != null) {
            n ^= this.shells.hashCode();
        }
        if ((object = map.get("slaters")) != null) {
            n ^= object.hashCode();
        }
        if ((string2 = this.htBasisMap.get(string = "" + n)) == null) {
            string2 = "MOBASIS_" + ++this.basisID;
            this.htBasisMap.put(string, string2);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            if (object2 != null) {
                hashtable.put("gaussians", object2);
            }
            if (this.shells != null) {
                hashtable.put("shells", this.shells);
            }
            if (object != null) {
                hashtable.put("slaters", object);
            }
            this.moBases.put(string2, hashtable);
        }
        return string2;
    }

    public void writeMOBases() {
        if (this.moBases.isEmpty()) {
            return;
        }
        this.oc.append(",\n");
        this.mapAddKey("mo_bases");
        this.mapOpen();
        String string = null;
        for (String string2 : this.moBases.keySet()) {
            if (string2.startsWith("!")) continue;
            this.append(string);
            this.mapAddKeyValue(string2, this.moBases.get(string2), "\n");
            string = ",\n";
        }
        this.mapClose();
        this.moBases.clear();
    }

    @Override
    public void writeObject(Object object) {
        if (object instanceof SlaterData) {
            this.oc.append(object.toString());
        } else {
            super.writeObject(object);
        }
    }

    public class SparseArray
    extends SB {
        private int repeatCount = 0;
        private int elementCount = 0;
        private String lastElement = null;
        private String sep = "";
        private String type;
        private boolean isRLE;

        public SparseArray(String string) {
            this.type = string;
            this.isRLE = string.equals("_RLE_");
        }

        protected void add(String string) {
            if (string == null) {
                string = "null";
            }
            if (!this.isRLE) {
                this.append(this.sep);
                this.append(string);
                this.sep = ",";
                return;
            }
            if (this.repeatCount > 0 && !string.equals(this.lastElement)) {
                this.append(this.sep);
                this.appendI(this.repeatCount);
                this.sep = ",";
                this.append(this.sep);
                this.append(this.lastElement);
                this.repeatCount = 0;
            }
            this.lastElement = string;
            ++this.repeatCount;
            ++this.elementCount;
        }

        public String lastElement() {
            return this.lastElement;
        }

        public boolean isEmpty() {
            return this.elementCount == 0;
        }

        public boolean allNaN() {
            return this.allSame() && PT.parseFloat(this.lastElement) == Float.NaN;
        }

        public boolean allNull() {
            return this.allSame() && this.lastElement.equals("null");
        }

        public boolean allEmptyString() {
            return this.allSame() && this.lastElement.equals("");
        }

        public boolean allSame() {
            return !this.isEmpty() && this.elementCount == this.repeatCount;
        }

        public boolean allZero() {
            return this.allSame() && PT.parseFloat(this.lastElement) != Float.NaN;
        }

        public boolean hasValues() {
            return !this.allSame() || !this.allNull() && !this.allEmptyString();
        }

        public boolean isNumericAndNonZero() {
            return this.allSame() && !this.allNaN() && !this.allZero();
        }

        @Override
        public String toString() {
            String string = super.toString();
            return string.length() == 0 ? "[]" : "[\"" + this.type + "\"," + string + (this.repeatCount > 0 ? String.valueOf(this.sep) + this.repeatCount + "," + this.lastElement : "") + "]";
        }
    }
}

