/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.protege.editor.core.log.LogLevel;
import org.protege.editor.core.log.LogRecord;
import org.protege.editor.core.log.ThrowableInfo;
import org.slf4j.Marker;

public class LoggingEventTranslator {
    public LogRecord toLogRecord(ILoggingEvent event) {
        return new LogRecord(LoggingEventTranslator.toLogLevel(event.getLevel()), event.getTimeStamp(), this.getMessage(event), LoggingEventTranslator.toThrowableInfo(event), event.getThreadName());
    }

    private String getMessage(ILoggingEvent event) {
        Marker marker = event.getMarker();
        StringBuilder sb = new StringBuilder();
        if (marker != null) {
            sb.append("[");
            sb.append(marker.getName());
            sb.append("]  ");
        }
        sb.append(event.getFormattedMessage());
        return sb.toString();
    }

    private static LogLevel toLogLevel(Level level) {
        if (level.equals(Level.ERROR)) {
            return LogLevel.ERROR;
        }
        if (level.equals(Level.WARN)) {
            return LogLevel.WARN;
        }
        if (level.equals(Level.INFO)) {
            return LogLevel.INFO;
        }
        if (level.equals(Level.DEBUG)) {
            return LogLevel.DEBUG;
        }
        return LogLevel.TRACE;
    }

    private static Optional<ThrowableInfo> toThrowableInfo(ILoggingEvent event) {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy == null) {
            return Optional.empty();
        }
        ThrowableInfo toThrowableInfo = LoggingEventTranslator.toThrowableInfo(throwableProxy);
        return Optional.of(toThrowableInfo);
    }

    private static ThrowableInfo toThrowableInfo(IThrowableProxy throwableProxy) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (StackTraceElementProxy proxy : throwableProxy.getStackTraceElementProxyArray()) {
            result.add((Object)proxy.getStackTraceElement());
        }
        Optional<ThrowableInfo> cause = throwableProxy.getCause() != null ? Optional.of(LoggingEventTranslator.toThrowableInfo(throwableProxy.getCause())) : Optional.empty();
        return new ThrowableInfo(throwableProxy.getClassName(), throwableProxy.getMessage(), (ImmutableList<StackTraceElement>)result.build(), cause);
    }
}

