/* appstream.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "As", gir_namespace = "AppStream", gir_version = "1.0", lower_case_cprefix = "as_")]
namespace AppStream {
	[CCode (cheader_filename = "appstream.h", type_id = "as_agreement_get_type ()")]
	public class Agreement : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.12.1")]
		public Agreement ();
		public void add_section (AppStream.AgreementSection agreement_section);
		[Version (since = "0.12.1")]
		public AppStream.AgreementKind get_kind ();
		[Version (since = "0.12.1")]
		public unowned AppStream.AgreementSection? get_section_default ();
		[Version (since = "0.12.1")]
		public GLib.GenericArray<weak AppStream.AgreementSection> get_sections ();
		[Version (since = "0.12.1")]
		public unowned string get_version_id ();
		[Version (since = "0.12.1")]
		public static AppStream.AgreementKind kind_from_string (string value);
		[Version (since = "0.12.1")]
		public static unowned string kind_to_string (AppStream.AgreementKind value);
		[Version (since = "0.12.1")]
		public void set_kind (AppStream.AgreementKind kind);
		[Version (since = "0.12.1")]
		public void set_version_id (string version_id);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_agreement_section_get_type ()")]
	public class AgreementSection : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.12.1")]
		public AgreementSection ();
		public unowned string get_active_locale ();
		[Version (since = "0.12.1")]
		public unowned string get_description ();
		[Version (since = "0.12.1")]
		public unowned string get_kind ();
		[Version (since = "0.12.1")]
		public unowned string get_name ();
		public void set_active_locale (string locale);
		[Version (since = "0.12.1")]
		public void set_description (string desc, string? locale);
		[Version (since = "0.12.1")]
		public void set_kind (string kind);
		[Version (since = "0.12.1")]
		public void set_name (string name, string? locale);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_artifact_get_type ()")]
	public class Artifact : GLib.Object {
		[CCode (has_construct_function = false)]
		public Artifact ();
		public void add_checksum (AppStream.Checksum cs);
		public void add_location (string location);
		public AppStream.BundleKind get_bundle_kind ();
		public unowned AppStream.Checksum? get_checksum (AppStream.ChecksumKind kind);
		public unowned GLib.GenericArray<AppStream.Checksum> get_checksums ();
		public AppStream.ArtifactKind get_kind ();
		public unowned GLib.GenericArray<string> get_locations ();
		public unowned string get_platform ();
		public uint64 get_size (AppStream.SizeKind kind);
		public static AppStream.ArtifactKind kind_from_string (string kind);
		public static unowned string kind_to_string (AppStream.ArtifactKind kind);
		public void set_bundle_kind (AppStream.BundleKind kind);
		public void set_kind (AppStream.ArtifactKind kind);
		public void set_platform (string platform);
		public void set_size (uint64 size, AppStream.SizeKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_bundle_get_type ()")]
	public class Bundle : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.10")]
		public Bundle ();
		[Version (since = "0.10")]
		public unowned string get_id ();
		[Version (since = "0.10")]
		public AppStream.BundleKind get_kind ();
		public static AppStream.BundleKind kind_from_string (string bundle_str);
		[Version (since = "0.8.0")]
		public static unowned string kind_to_string (AppStream.BundleKind kind);
		[Version (since = "0.10")]
		public void set_id (string id);
		[Version (since = "0.10")]
		public void set_kind (AppStream.BundleKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_category_get_type ()")]
	public class Category : GLib.Object {
		[CCode (has_construct_function = false)]
		public Category ();
		public void add_child (AppStream.Category subcat);
		public void add_component (AppStream.Component cpt);
		public void add_desktop_group (string group_name);
		public unowned GLib.GenericArray<AppStream.Category> get_children ();
		public unowned GLib.GenericArray<AppStream.Component> get_components ();
		public unowned GLib.GenericArray<string> get_desktop_groups ();
		public unowned string get_icon ();
		public unowned string get_id ();
		public unowned string get_name ();
		public unowned string get_summary ();
		public bool has_children ();
		public bool has_component (AppStream.Component cpt);
		public void remove_child (AppStream.Category subcat);
		public void set_icon (string value);
		public void set_id (string id);
		public void set_name (string value);
		public void set_summary (string value);
		public void* children { get; }
		public string icon { get; set; }
		public string id { get; set; }
		public string name { get; set; }
		public string summary { get; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_checksum_get_type ()")]
	public class Checksum : GLib.Object {
		[CCode (has_construct_function = false)]
		public Checksum ();
		public AppStream.ChecksumKind get_kind ();
		public unowned string get_value ();
		public static AppStream.ChecksumKind kind_from_string (string kind_str);
		public static unowned string kind_to_string (AppStream.ChecksumKind kind);
		public void set_kind (AppStream.ChecksumKind kind);
		public void set_value (string value);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_component_get_type ()")]
	public class Component : GLib.Object {
		[CCode (has_construct_function = false)]
		public Component ();
		[Version (since = "0.9.2")]
		public void add_addon (AppStream.Component addon);
		[Version (since = "0.12.1")]
		public void add_agreement (AppStream.Agreement agreement);
		[Version (since = "0.8.0")]
		public void add_bundle (AppStream.Bundle bundle);
		public void add_category (string category);
		[Version (since = "0.11.0")]
		public void add_content_rating (AppStream.ContentRating content_rating);
		[Version (since = "0.7.0")]
		public void add_extends (string cpt_id);
		public void add_icon (AppStream.Icon icon);
		[Version (since = "0.7.0")]
		public void add_language (string? locale, int percentage);
		[Version (since = "0.11.0")]
		public void add_launchable (AppStream.Launchable launchable);
		[Version (since = "0.6.2")]
		public void add_provided (AppStream.Provided prov);
		[Version (since = "0.12.0")]
		public void add_relation (AppStream.Relation relation);
		public void add_release (AppStream.Release release);
		public void add_screenshot (AppStream.Screenshot sshot);
		public void add_suggested (AppStream.Suggested suggested);
		[Version (since = "0.9.2")]
		public void add_translation (AppStream.Translation tr);
		[Version (since = "0.6.2")]
		public void add_url (AppStream.UrlKind url_kind, string url);
		public unowned string get_active_locale ();
		[Version (since = "0.9.2")]
		public unowned GLib.GenericArray<AppStream.Component> get_addons ();
		[Version (since = "0.12.1")]
		public unowned AppStream.Agreement? get_agreement_by_kind (AppStream.AgreementKind kind);
		[Version (since = "0.8.0")]
		public unowned AppStream.Bundle? get_bundle (AppStream.BundleKind bundle_kind);
		[Version (since = "0.10")]
		public unowned GLib.GenericArray<AppStream.Bundle> get_bundles ();
		public unowned GLib.GenericArray<string> get_categories ();
		public unowned GLib.GenericArray<string> get_compulsory_for_desktops ();
		[Version (since = "0.11.0")]
		public unowned AppStream.ContentRating? get_content_rating (string kind);
		[Version (since = "0.11.0")]
		public unowned GLib.GenericArray<AppStream.ContentRating> get_content_ratings ();
		[Version (since = "0.10.5")]
		public unowned GLib.HashTable<void*,void*> get_custom ();
		[Version (since = "0.10.5")]
		public unowned string get_custom_value (string key);
		public unowned string get_data_id ();
		public unowned string get_description ();
		[Version (deprecated = true, deprecated_since = "0.11.0", since = "0.9.8")]
		public unowned string get_desktop_id ();
		public unowned string get_developer_name ();
		[Version (since = "0.7.0")]
		public unowned GLib.GenericArray<string>? get_extends ();
		public unowned AppStream.Icon? get_icon_by_size (uint width, uint height);
		public unowned GLib.GenericArray<AppStream.Icon> get_icons ();
		public unowned string get_id ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_keywords ();
		public AppStream.ComponentKind get_kind ();
		[Version (since = "0.7.0")]
		public int get_language (string? locale);
		[Version (since = "0.7.0")]
		public GLib.List<weak string> get_languages ();
		[Version (since = "0.11.0")]
		public unowned AppStream.Launchable? get_launchable (AppStream.LaunchableKind kind);
		[Version (since = "0.11.0")]
		public unowned GLib.GenericArray<AppStream.Launchable> get_launchables ();
		[Version (since = "0.9.8")]
		public AppStream.MergeKind get_merge_kind ();
		public unowned string get_metadata_license ();
		public unowned string get_name ();
		public unowned string get_origin ();
		public unowned string get_pkgname ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_pkgnames ();
		public unowned string get_project_group ();
		public unowned string get_project_license ();
		public unowned GLib.GenericArray<AppStream.Provided> get_provided ();
		public unowned AppStream.Provided? get_provided_for_kind (AppStream.ProvidedKind kind);
		[Version (since = "0.12.0")]
		public unowned GLib.GenericArray<AppStream.Relation> get_recommends ();
		public unowned GLib.GenericArray<AppStream.Release> get_releases ();
		[Version (since = "0.12.0")]
		public unowned GLib.GenericArray<AppStream.Relation> get_requires ();
		public unowned GLib.GenericArray<AppStream.Screenshot> get_screenshots ();
		[Version (since = "0.9.7")]
		public GLib.GenericArray<weak string> get_search_tokens ();
		public unowned string get_source_pkgname ();
		public unowned GLib.GenericArray<AppStream.Suggested> get_suggested ();
		public unowned string get_summary ();
		[Version (since = "0.9.2")]
		public unowned GLib.GenericArray<AppStream.Translation> get_translations ();
		[Version (since = "0.6.2")]
		public unowned string? get_url (AppStream.UrlKind url_kind);
		public AppStream.ValueFlags get_value_flags ();
		public bool has_bundle ();
		public bool has_category (string category);
		[Version (since = "0.10.5")]
		public bool insert_custom_value (string key, string value);
		public bool is_compulsory_for_desktop (string desktop);
		[Version (since = "0.10.2")]
		public bool is_ignored ();
		public bool is_member_of_category (AppStream.Category category);
		public bool is_valid ();
		[Version (since = "0.9.7")]
		public uint search_matches (string term);
		[Version (since = "0.9.8")]
		public uint search_matches_all (string terms);
		public void set_active_locale (string? locale);
		public void set_compulsory_for_desktop (string desktop);
		public void set_data_id (string value);
		public void set_description (string value, string? locale);
		public void set_developer_name (string value, string? locale);
		public void set_id (string value);
		public void set_keywords ([CCode (array_length = false, array_null_terminated = true)] string[] value, string? locale);
		public void set_kind (AppStream.ComponentKind value);
		[Version (since = "0.9.8")]
		public void set_merge_kind (AppStream.MergeKind kind);
		public void set_metadata_license (string value);
		public void set_name (string value, string? locale);
		public void set_origin (string origin);
		public void set_pkgnames ([CCode (array_length = false, array_null_terminated = true)] string[] packages);
		public void set_project_group (string value);
		public void set_project_license (string value);
		public void set_source_pkgname (string spkgname);
		public void set_summary (string value, string? locale);
		public void set_value_flags (AppStream.ValueFlags flags);
		public string to_string ();
		public GLib.GenericArray<void*> categories { get; }
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public string developer_name { owned get; set; }
		public GLib.List<AppStream.Icon> icons { get; }
		public string id { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] keywords { owned get; set; }
		public AppStream.ComponentKind kind { get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] pkgnames { get; set; }
		public string project_group { get; set; }
		public string project_license { get; set; }
		public GLib.GenericArray<AppStream.Screenshot> screenshots { get; }
		[NoAccessorMethod]
		public string summary { owned get; set; }
		[NoAccessorMethod]
		public GLib.HashTable<AppStream.UrlKind,string> urls { owned get; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_content_rating_get_type ()")]
	public class ContentRating : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.11.0")]
		public ContentRating ();
		[Version (since = "0.11.0")]
		public unowned string get_kind ();
		[Version (since = "0.11.0")]
		public uint get_minimum_age ();
		[Version (since = "0.11.0")]
		public AppStream.ContentRatingValue get_value (string id);
		[Version (since = "0.11.0")]
		public void set_kind (string kind);
		[Version (since = "0.11.0")]
		public void set_value (string id, AppStream.ContentRatingValue value);
		[Version (since = "0.11.0")]
		public static AppStream.ContentRatingValue value_from_string (string value);
		[Version (since = "0.11.0")]
		public static unowned string value_to_string (AppStream.ContentRatingValue value);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_distro_details_get_type ()")]
	public class DistroDetails : GLib.Object {
		[CCode (has_construct_function = false)]
		public DistroDetails ();
		public bool get_bool (string key, bool default_val);
		public unowned string get_cid ();
		public unowned string get_homepage ();
		public unowned string get_id ();
		public unowned string get_name ();
		public string get_str (string key);
		public unowned string get_version ();
		public string homepage { get; }
		public string id { get; }
		public string name { get; }
		public string version { get; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_icon_get_type ()")]
	public class Icon : GLib.Object {
		[CCode (has_construct_function = false)]
		public Icon ();
		public unowned string get_filename ();
		public uint get_height ();
		public AppStream.IconKind get_kind ();
		public unowned string get_name ();
		[Version (since = "0.11.0")]
		public uint get_scale ();
		public unowned string get_url ();
		public uint get_width ();
		public static AppStream.IconKind kind_from_string (string kind_str);
		public static unowned string kind_to_string (AppStream.IconKind kind);
		public void set_filename (string filename);
		public void set_height (uint height);
		public void set_kind (AppStream.IconKind kind);
		public void set_name (string name);
		[Version (since = "0.11.0")]
		public void set_scale (uint scale);
		public void set_url (string url);
		public void set_width (uint width);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_image_get_type ()")]
	public class Image : GLib.Object {
		[CCode (has_construct_function = false)]
		public Image ();
		public uint get_height ();
		public AppStream.ImageKind get_kind ();
		[Version (since = "0.9.5")]
		public unowned string get_locale ();
		public unowned string get_url ();
		public uint get_width ();
		public static AppStream.ImageKind kind_from_string (string kind);
		public static unowned string kind_to_string (AppStream.ImageKind kind);
		public void set_height (uint height);
		public void set_kind (AppStream.ImageKind kind);
		[Version (since = "0.9.5")]
		public void set_locale (string locale);
		public void set_url (string url);
		public void set_width (uint width);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_launchable_get_type ()")]
	public class Launchable : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.11.0")]
		public Launchable ();
		[Version (since = "0.11.0")]
		public void add_entry (string entry);
		[Version (since = "0.11.0")]
		public unowned GLib.GenericArray<string> get_entries ();
		[Version (since = "0.11.0")]
		public AppStream.LaunchableKind get_kind ();
		[Version (since = "0.11.0")]
		public static AppStream.LaunchableKind kind_from_string (string kind_str);
		[Version (since = "0.11.0")]
		public static unowned string kind_to_string (AppStream.LaunchableKind kind);
		[Version (since = "0.11.0")]
		public void set_kind (AppStream.LaunchableKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_metadata_get_type ()")]
	public class Metadata : GLib.Object {
		[CCode (has_construct_function = false)]
		public Metadata ();
		public void add_component (AppStream.Component cpt);
		public void clear_components ();
		public string component_to_metainfo (AppStream.FormatKind format) throws GLib.Error;
		public string components_to_collection (AppStream.FormatKind format) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public unowned string get_architecture ();
		public unowned AppStream.Component? get_component ();
		public unowned GLib.GenericArray<AppStream.Component> get_components ();
		public AppStream.FormatStyle get_format_style ();
		public AppStream.FormatVersion get_format_version ();
		public unowned string get_locale ();
		public unowned string get_origin ();
		public AppStream.ParseFlags get_parse_flags ();
		public bool get_update_existing ();
		public bool get_write_header ();
		public void parse (string data, AppStream.FormatKind format) throws GLib.Error;
		public void parse_desktop_data (string data, string cid) throws GLib.Error;
		public void parse_file (GLib.File file, AppStream.FormatKind format) throws GLib.Error;
		public void save_collection (string fname, AppStream.FormatKind format) throws GLib.Error;
		public void save_metainfo (string fname, AppStream.FormatKind format) throws GLib.Error;
		public void set_architecture (string arch);
		public void set_format_style (AppStream.FormatStyle mode);
		public void set_format_version (AppStream.FormatVersion version);
		public void set_locale (string locale);
		public void set_origin (string origin);
		public void set_parse_flags (AppStream.ParseFlags flags);
		public void set_update_existing (bool update);
		public void set_write_header (bool wheader);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_pool_get_type ()")]
	public class Pool : GLib.Object {
		[CCode (has_construct_function = false)]
		public Pool ();
		public bool add_component (AppStream.Component cpt) throws GLib.Error;
		public void add_metadata_location (string directory);
		public void clear ();
		public void clear_metadata_locations ();
		public static GLib.Quark error_quark ();
		public AppStream.CacheFlags get_cache_flags ();
		public GLib.GenericArray<AppStream.Component> get_components ();
		public GLib.GenericArray<AppStream.Component> get_components_by_categories (string categories);
		public GLib.GenericArray<AppStream.Component> get_components_by_id (string cid);
		public GLib.GenericArray<AppStream.Component> get_components_by_kind (AppStream.ComponentKind kind);
		[Version (since = "0.11.4")]
		public GLib.GenericArray<AppStream.Component> get_components_by_launchable (AppStream.LaunchableKind kind, string id);
		public GLib.GenericArray<AppStream.Component> get_components_by_provided_item (AppStream.ProvidedKind kind, string item);
		public AppStream.PoolFlags get_flags ();
		public unowned string get_locale ();
		public bool load (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool load_cache_file (string fname) throws GLib.Error;
		public bool refresh_cache (bool force) throws GLib.Error;
		public bool save_cache_file (string fname) throws GLib.Error;
		[Version (since = "0.9.7")]
		public GLib.GenericArray<weak AppStream.Component> search (string search);
		public void set_cache_flags (AppStream.CacheFlags flags);
		public void set_flags (AppStream.PoolFlags flags);
		public void set_locale (string locale);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_provided_get_type ()")]
	public class Provided : GLib.Object {
		[CCode (has_construct_function = false)]
		public Provided ();
		public void add_item (string item);
		public unowned GLib.GenericArray<string> get_items ();
		public AppStream.ProvidedKind get_kind ();
		public bool has_item (string item);
		public static AppStream.ProvidedKind kind_from_string (string kind_str);
		public static unowned string kind_to_l10n_string (AppStream.ProvidedKind kind);
		public static unowned string kind_to_string (AppStream.ProvidedKind kind);
		public void set_kind (AppStream.ProvidedKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_relation_get_type ()")]
	public class Relation : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.11.0")]
		public Relation ();
		[Version (since = "0.12.0")]
		public static AppStream.RelationCompare compare_from_string (string compare_str);
		[Version (since = "0.12.0")]
		public static unowned string compare_to_string (AppStream.RelationCompare compare);
		[Version (since = "0.12.0")]
		public static unowned string compare_to_symbols_string (AppStream.RelationCompare compare);
		[Version (since = "0.12.0")]
		public AppStream.RelationCompare get_compare ();
		[Version (since = "0.12.0")]
		public AppStream.RelationItemKind get_item_kind ();
		[Version (since = "0.12.0")]
		public AppStream.RelationKind get_kind ();
		[Version (since = "0.12.0")]
		public unowned string get_value ();
		[Version (since = "0.12.0")]
		public int get_value_int ();
		[Version (since = "0.12.0")]
		public unowned string get_version ();
		[Version (since = "0.12.0")]
		public static AppStream.RelationItemKind item_kind_from_string (string kind_str);
		[Version (since = "0.12.0")]
		public static unowned string item_kind_to_string (AppStream.RelationItemKind kind);
		[Version (since = "0.12.0")]
		public static AppStream.RelationKind kind_from_string (string kind_str);
		[Version (since = "0.12.0")]
		public static unowned string kind_to_string (AppStream.RelationKind kind);
		[Version (since = "0.12.0")]
		public void set_compare (AppStream.RelationCompare compare);
		[Version (since = "0.12.0")]
		public void set_item_kind (AppStream.RelationItemKind kind);
		[Version (since = "0.12.0")]
		public void set_kind (AppStream.RelationKind kind);
		[Version (since = "0.12.0")]
		public void set_value (string value);
		[Version (since = "0.12.0")]
		public void set_version (string version);
		[Version (since = "0.12.0")]
		public bool version_compare (string version) throws GLib.Error;
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_release_get_type ()")]
	public class Release : GLib.Object {
		[CCode (has_construct_function = false)]
		public Release ();
		[Version (since = "0.12.6")]
		public void add_artifact (AppStream.Artifact artifact);
		[Version (deprecated = true, since = "0.8.2")]
		public void add_checksum (AppStream.Checksum cs);
		[Version (deprecated = true, since = "0.8.1")]
		public void add_location (string location);
		public unowned string get_active_locale ();
		[Version (since = "0.12.6")]
		public unowned GLib.GenericArray<AppStream.Artifact> get_artifacts ();
		[Version (deprecated = true, since = "0.8.2")]
		public unowned AppStream.Checksum? get_checksum (AppStream.ChecksumKind kind);
		[Version (deprecated = true, since = "0.10")]
		public unowned GLib.GenericArray<AppStream.Checksum> get_checksums ();
		[Version (since = "0.12.5")]
		public unowned string get_date ();
		[Version (since = "0.12.5")]
		public unowned string get_date_eol ();
		public unowned string? get_description ();
		[Version (since = "0.12.0")]
		public AppStream.ReleaseKind get_kind ();
		[Version (deprecated = true, since = "0.8.1")]
		public unowned GLib.GenericArray<string> get_locations ();
		[Version (deprecated = true, since = "0.8.6")]
		public uint64 get_size (AppStream.SizeKind kind);
		public uint64 get_timestamp ();
		[Version (since = "0.12.5")]
		public uint64 get_timestamp_eol ();
		[Version (since = "0.6.5")]
		public AppStream.UrgencyKind get_urgency ();
		[Version (since = "0.12.5")]
		public unowned string? get_url (AppStream.ReleaseUrlKind url_kind);
		public unowned string? get_version ();
		[Version (since = "0.12.0")]
		public static AppStream.ReleaseKind kind_from_string (string kind_str);
		[Version (since = "0.12.0")]
		public static unowned string kind_to_string (AppStream.ReleaseKind kind);
		public void set_active_locale (string locale);
		[Version (since = "0.12.5")]
		public void set_date (string date);
		[Version (since = "0.12.5")]
		public void set_date_eol (string date);
		public void set_description (string description, string locale);
		[Version (since = "0.12.0")]
		public void set_kind (AppStream.ReleaseKind kind);
		[Version (deprecated = true, since = "0.8.6")]
		public void set_size (uint64 size, AppStream.SizeKind kind);
		public void set_timestamp (uint64 timestamp);
		[Version (since = "0.12.5")]
		public void set_timestamp_eol (uint64 timestamp);
		[Version (since = "0.6.5")]
		public void set_urgency (AppStream.UrgencyKind urgency);
		[Version (since = "0.12.5")]
		public void set_url (AppStream.ReleaseUrlKind url_kind, string url);
		public void set_version (string version);
		[Version (since = "0.12.5")]
		public static AppStream.ReleaseUrlKind url_kind_from_string (string kind_str);
		[Version (since = "0.12.5")]
		public static unowned string url_kind_to_string (AppStream.ReleaseUrlKind kind);
		public int vercmp (AppStream.Release rel2);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_screenshot_get_type ()")]
	public class Screenshot : GLib.Object {
		[CCode (has_construct_function = false)]
		public Screenshot ();
		public void add_image (AppStream.Image image);
		public unowned string get_active_locale ();
		public unowned string get_caption ();
		public unowned GLib.GenericArray<AppStream.Image> get_images ();
		[Version (since = "0.10")]
		public unowned GLib.GenericArray<AppStream.Image> get_images_all ();
		public AppStream.ScreenshotKind get_kind ();
		public bool is_valid ();
		public static AppStream.ScreenshotKind kind_from_string (string kind);
		public static unowned string kind_to_string (AppStream.ScreenshotKind kind);
		public void set_active_locale (string locale);
		public void set_caption (string caption, string locale);
		public void set_kind (AppStream.ScreenshotKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_suggested_get_type ()")]
	public class Suggested : GLib.Object {
		[CCode (has_construct_function = false)]
		public Suggested ();
		public void add_id (string cid);
		public unowned GLib.GenericArray<string> get_ids ();
		public AppStream.SuggestedKind get_kind ();
		public bool is_valid ();
		public static AppStream.SuggestedKind kind_from_string (string kind_str);
		public static unowned string kind_to_string (AppStream.SuggestedKind kind);
		public void set_kind (AppStream.SuggestedKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_translation_get_type ()")]
	public class Translation : GLib.Object {
		[CCode (has_construct_function = false)]
		public Translation ();
		public unowned string get_id ();
		public AppStream.TranslationKind get_kind ();
		public static AppStream.TranslationKind kind_from_string (string kind_str);
		public static unowned string kind_to_string (AppStream.TranslationKind kind);
		public void set_id (string id);
		public void set_kind (AppStream.TranslationKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_validator_get_type ()")]
	public class Validator : GLib.Object {
		[CCode (has_construct_function = false)]
		public Validator ();
		public void clear_issues ();
		public bool get_check_urls ();
		public GLib.List<weak AppStream.ValidatorIssue> get_issues ();
		public void set_check_urls (bool value);
		public bool validate_data (string metadata);
		public bool validate_file (GLib.File metadata_file);
		public bool validate_tree (string root_dir);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_validator_issue_get_type ()")]
	public class ValidatorIssue : GLib.Object {
		[CCode (has_construct_function = false)]
		public ValidatorIssue ();
		public unowned string get_cid ();
		public unowned string get_filename ();
		public AppStream.IssueImportance get_importance ();
		public AppStream.IssueKind get_kind ();
		public int get_line ();
		public string get_location ();
		public unowned string get_message ();
		public void set_cid (string cid);
		public void set_filename (string fname);
		public void set_importance (AppStream.IssueImportance importance);
		public void set_kind (AppStream.IssueKind kind);
		public void set_line (int line);
		public void set_message (string message);
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_AGREEMENT_KIND_", has_type_id = false)]
	public enum AgreementKind {
		UNKNOWN,
		GENERIC,
		EULA,
		PRIVACY
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_ARTIFACT_KIND_", has_type_id = false)]
	public enum ArtifactKind {
		UNKNOWN,
		SOURCE,
		BINARY
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_BUNDLE_KIND_", has_type_id = false)]
	public enum BundleKind {
		UNKNOWN,
		PACKAGE,
		LIMBA,
		FLATPAK,
		APPIMAGE,
		SNAP,
		TARBALL
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_CACHE_FLAG_", has_type_id = false)]
	[Flags]
	public enum CacheFlags {
		NONE,
		USE_USER,
		USE_SYSTEM
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_CHECKSUM_KIND_", has_type_id = false)]
	public enum ChecksumKind {
		NONE,
		SHA1,
		SHA256
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_COMPONENT_KIND_", type_id = "as_component_kind_get_type ()")]
	public enum ComponentKind {
		UNKNOWN,
		GENERIC,
		DESKTOP_APP,
		CONSOLE_APP,
		WEB_APP,
		ADDON,
		FONT,
		CODEC,
		INPUTMETHOD,
		FIRMWARE,
		DRIVER,
		LOCALIZATION,
		SERVICE,
		REPOSITORY,
		OPERATING_SYSTEM;
		public static AppStream.ComponentKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_COMPONENT_SCOPE_", has_type_id = false)]
	public enum ComponentScope {
		UNKNOWN,
		SYSTEM,
		USER
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_CONTENT_RATING_VALUE_", has_type_id = false)]
	public enum ContentRatingValue {
		UNKNOWN,
		NONE,
		MILD,
		MODERATE,
		INTENSE
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_FORMAT_KIND_", has_type_id = false)]
	public enum FormatKind {
		UNKNOWN,
		XML,
		YAML,
		DESKTOP_ENTRY;
		[Version (since = "0.10")]
		public static AppStream.FormatKind from_string (string kind_str);
		[Version (since = "0.10")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_FORMAT_STYLE_", has_type_id = false)]
	public enum FormatStyle {
		UNKNOWN,
		METAINFO,
		COLLECTION
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_FORMAT_VERSION_", has_type_id = false)]
	public enum FormatVersion {
		V0_6,
		V0_7,
		V0_8,
		V0_9,
		V0_10,
		V0_11,
		V0_12;
		[Version (since = "0.10")]
		public static AppStream.FormatVersion from_string (string version_str);
		[Version (since = "0.10")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_ICON_KIND_", has_type_id = false)]
	public enum IconKind {
		UNKNOWN,
		CACHED,
		STOCK,
		LOCAL,
		REMOTE
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_IMAGE_KIND_", has_type_id = false)]
	public enum ImageKind {
		UNKNOWN,
		SOURCE,
		THUMBNAIL
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_ISSUE_IMPORTANCE_", has_type_id = false)]
	public enum IssueImportance {
		UNKNOWN,
		ERROR,
		WARNING,
		INFO,
		PEDANTIC
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_ISSUE_KIND_", has_type_id = false)]
	public enum IssueKind {
		UNKNOWN,
		MARKUP_INVALID,
		LEGACY,
		TAG_DUPLICATED,
		TAG_MISSING,
		TAG_UNKNOWN,
		TAG_NOT_ALLOWED,
		PROPERTY_MISSING,
		PROPERTY_INVALID,
		VALUE_MISSING,
		VALUE_WRONG,
		VALUE_ISSUE,
		FILE_MISSING,
		WRONG_NAME,
		READ_ERROR,
		REMOTE_ERROR,
		UNUSUAL
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_LAUNCHABLE_KIND_", has_type_id = false)]
	public enum LaunchableKind {
		UNKNOWN,
		DESKTOP_ID,
		SERVICE,
		COCKPIT_MANIFEST,
		URL
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_MERGE_KIND_", has_type_id = false)]
	public enum MergeKind {
		NONE,
		REPLACE,
		APPEND,
		REMOVE_COMPONENT;
		public static AppStream.MergeKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_METADATA_ERROR_", has_type_id = false)]
	public enum MetadataError {
		FAILED,
		PARSE,
		FORMAT_UNEXPECTED,
		NO_COMPONENT,
		VALUE_MISSING
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_PARSE_FLAG_", has_type_id = false)]
	[Flags]
	public enum ParseFlags {
		NONE,
		IGNORE_MEDIABASEURL
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_POOL_ERROR_", has_type_id = false)]
	public enum PoolError {
		FAILED,
		TARGET_NOT_WRITABLE,
		INCOMPLETE,
		COLLISION
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_POOL_FLAG_", has_type_id = false)]
	[Flags]
	public enum PoolFlags {
		NONE,
		READ_COLLECTION,
		READ_METAINFO,
		READ_DESKTOP_FILES
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_PROVIDED_KIND_", has_type_id = false)]
	public enum ProvidedKind {
		UNKNOWN,
		LIBRARY,
		BINARY,
		MIMETYPE,
		FONT,
		MODALIAS,
		PYTHON_2,
		PYTHON,
		DBUS_SYSTEM,
		DBUS_USER,
		FIRMWARE_RUNTIME,
		FIRMWARE_FLASHED,
		ID
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_RELATION_COMPARE_", has_type_id = false)]
	public enum RelationCompare {
		UNKNOWN,
		EQ,
		NE,
		LT,
		GT,
		LE,
		GE
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_RELATION_ITEM_KIND_", has_type_id = false)]
	public enum RelationItemKind {
		UNKNOWN,
		ID,
		MODALIAS,
		KERNEL,
		MEMORY
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_RELATION_KIND_", has_type_id = false)]
	public enum RelationKind {
		UNKNOWN,
		REQUIRES,
		RECOMMENDS
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_RELEASE_KIND_", has_type_id = false)]
	[Version (since = "0.12.0")]
	public enum ReleaseKind {
		UNKNOWN,
		STABLE,
		DEVELOPMENT
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_RELEASE_URL_KIND_", has_type_id = false)]
	[Version (since = "0.12.5")]
	public enum ReleaseUrlKind {
		UNKNOWN,
		DETAILS
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_SCREENSHOT_KIND_", has_type_id = false)]
	public enum ScreenshotKind {
		UNKNOWN,
		DEFAULT,
		EXTRA
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_SIZE_KIND_", has_type_id = false)]
	[Version (since = "0.8.6")]
	public enum SizeKind {
		UNKNOWN,
		DOWNLOAD,
		INSTALLED;
		public static AppStream.SizeKind from_string (string size_kind);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_SUGGESTED_KIND_", has_type_id = false)]
	public enum SuggestedKind {
		UNKNOWN,
		UPSTREAM,
		HEURISTIC
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_TRANSLATION_KIND_", has_type_id = false)]
	public enum TranslationKind {
		UNKNOWN,
		GETTEXT,
		QT
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_URGENCY_KIND_", has_type_id = false)]
	public enum UrgencyKind {
		UNKNOWN,
		LOW,
		MEDIUM,
		HIGH,
		CRITICAL;
		[Version (since = "0.6.5")]
		public static AppStream.UrgencyKind from_string (string urgency_kind);
		[Version (since = "0.6.5")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_URL_KIND_", has_type_id = false)]
	public enum UrlKind {
		UNKNOWN,
		HOMEPAGE,
		BUGTRACKER,
		FAQ,
		HELP,
		DONATION,
		TRANSLATE,
		CONTACT;
		public static AppStream.UrlKind from_string (string url_kind);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_VALUE_FLAG_", has_type_id = false)]
	[Flags]
	public enum ValueFlags {
		NONE,
		DUPLICATE_CHECK,
		NO_TRANSLATION_FALLBACK
	}
	[CCode (cheader_filename = "appstream.h")]
	public static unowned string get_appstream_version ();
	[CCode (cheader_filename = "appstream.h")]
	public static string get_current_distro_component_id ();
	[CCode (cheader_filename = "appstream.h")]
	public static GLib.GenericArray<weak AppStream.Category> get_default_categories (bool with_special);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static bool is_spdx_license_expression (string license);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static bool is_spdx_license_id (string license_id);
	[CCode (cheader_filename = "appstream.h")]
	public static bool license_is_metadata_license (string license);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static string license_to_spdx_id (string license);
	[CCode (cheader_filename = "appstream.h")]
	public static string markup_convert_simple (string markup) throws GLib.Error;
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static string? spdx_license_detokenize (string license_tokens);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static string[]? spdx_license_tokenize (string license);
	[CCode (cheader_filename = "appstream.h")]
	public static int utils_compare_versions (string a, string b);
	[CCode (cheader_filename = "appstream.h")]
	public static bool utils_is_category_name (string category_name);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.10.0")]
	public static bool utils_is_desktop_environment (string desktop);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static bool utils_is_tld (string tld);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.5")]
	public static bool utils_locale_is_compatible (string locale1, string locale2);
	[CCode (cheader_filename = "appstream.h")]
	public static void utils_sort_components_into_categories (GLib.GenericArray<AppStream.Component> cpts, GLib.GenericArray<AppStream.Category> categories, bool check_duplicates);
}
