/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import sun.java2d.xr.DirtyRegion;
import sun.java2d.xr.GrowableRectArray;

public class MaskTile {
    GrowableRectArray rects = new GrowableRectArray(128);
    DirtyRegion dirtyArea = new DirtyRegion();

    public void addRect(int x, int y, int width, int height) {
        int index = this.rects.getNextIndex();
        this.rects.setX(index, x);
        this.rects.setY(index, y);
        this.rects.setWidth(index, width);
        this.rects.setHeight(index, height);
    }

    public void addLine(int x1, int y1, int x2, int y2) {
        DirtyRegion region = new DirtyRegion();
        region.setDirtyLineRegion(x1, y1, x2, y2);
        int xDiff = region.x2 - region.x;
        int yDiff = region.y2 - region.y;
        if (xDiff == 0 || yDiff == 0) {
            this.addRect(region.x, region.y, region.x2 - region.x + 1, region.y2 - region.y + 1);
        } else if (xDiff == 1 && yDiff == 1) {
            this.addRect(x1, y1, 1, 1);
            this.addRect(x2, y2, 1, 1);
        } else {
            this.lineToRects(x1, y1, x2, y2);
        }
    }

    private void lineToRects(int xstart, int ystart, int xend, int yend) {
        int el;
        int es;
        int ddy;
        int ddx;
        int pdy;
        int pdx;
        int incy;
        int incx;
        int dx = xend - xstart;
        int dy = yend - ystart;
        int n = dx > 0 ? 1 : (incx = dx < 0 ? -1 : 0);
        int n2 = dy > 0 ? 1 : (incy = dy < 0 ? -1 : 0);
        if (dx < 0) {
            dx = -dx;
        }
        if (dy < 0) {
            dy = -dy;
        }
        if (dx > dy) {
            pdx = incx;
            pdy = 0;
            ddx = incx;
            ddy = incy;
            es = dy;
            el = dx;
        } else {
            pdx = 0;
            pdy = incy;
            ddx = incx;
            ddy = incy;
            es = dx;
            el = dy;
        }
        int x = xstart;
        int y = ystart;
        int err = el / 2;
        this.addRect(x, y, 1, 1);
        for (int t = 0; t < el; ++t) {
            if ((err -= es) < 0) {
                err += el;
                x += ddx;
                y += ddy;
            } else {
                x += pdx;
                y += pdy;
            }
            this.addRect(x, y, 1, 1);
        }
    }

    public void calculateDirtyAreas() {
        for (int i = 0; i < this.rects.getSize(); ++i) {
            int x = this.rects.getX(i);
            int y = this.rects.getY(i);
            this.dirtyArea.growDirtyRegion(x, y, x + this.rects.getWidth(i), y + this.rects.getHeight(i));
        }
    }

    public void reset() {
        this.rects.clear();
        this.dirtyArea.clear();
    }

    public void translate(int x, int y) {
        if (this.rects.getSize() > 0) {
            this.dirtyArea.translate(x, y);
        }
        this.rects.translateRects(x, y);
    }

    public GrowableRectArray getRects() {
        return this.rects;
    }

    public DirtyRegion getDirtyArea() {
        return this.dirtyArea;
    }
}

