/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif


#ifndef _PRESENTATION_h_ 
#define _PRESENTATION_h_

#ifdef __STDC__

/**********************************************************************
|  FILE: presentation.c
***********************************************************************/
extern matrix_TYP *pres(bahn **s,
                        bravais_TYP *G,
                        int *OPT);

extern void normalize_word(int *w);

/**********************************************************************
|  FILE: mapped_word.c
***********************************************************************/
matrix_TYP *mapped_word(int *w,
                        matrix_TYP **A,
                        matrix_TYP **AINV);

/**********************************************************************
|  FILE: check_base.c
***********************************************************************/
void check_base(bahn **s,
                bravais_TYP *G);

/**********************************************************************
|  FILE: put_word.c
***********************************************************************/
void put_word(int *w,
              char *O);

#else

/**********************************************************************
|  FILE: presentation.c
***********************************************************************/
extern matrix_TYP *pres();

extern void normalize_word();

/**********************************************************************
|  FILE: mapped_word.c
***********************************************************************/
matrix_TYP *mapped_word();

/**********************************************************************
|  FILE: check_base.c
***********************************************************************/
void check_base();

/**********************************************************************
|  FILE: put_word.c
***********************************************************************/
void put_word();

#endif
#endif

#ifdef __cplusplus
}
#endif

