/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "matrix.h"
#include "symm.h"
#include "getput.h"
#include "bravais.h"
#include "sort.h"
#include "polyeder.h"
#include "presentation.h"
#include "tools.h"
#include "tietzetrans.h"
#include "datei.h"

extern int SFLAG;

int main (int argc, char *argv[])
{
  bravais_TYP 		*G;
  matrix_TYP		*vec;
  matrix_TYP		*Form;
  polyeder_TYP		*Pol;

  	extern polyeder_TYP *fub();

        read_header(argc, argv);
        if(FILEANZ != 3)
        {
   printf("\n");
   printf("Usage\n");
   printf("  %s file1 file2 file3 \n", argv[0]);
   printf(" \n");
   printf(" where file1 contains a bravais_TYP describing\n");
   printf(" a set of affine matrices generating a space group.\n");
   printf(" \n");
   printf(" where file2 contains a matrix_TYP describing\n");
   printf(" an affine vector which is a starting point for the algorithm\n");
   printf(" \n");
   printf(" where file3 contains a matrix_TYP describing a positive definite,\n");
   printf(" invariant form for R \n");
   printf(" \n");
   printf(" Calculates a fundamental polyhedron for the group in file1,\n");
   printf(" and writes it to the stdout.\n");
 
   printf(" \n");
   printf(" The options are:\n");
   printf("\n");
   printf(" -h   : Gives you this help.\n");
   printf("\n");

          if (is_option('h')){
             exit(0);
          }
          else{
             exit(31);
          }
        }

        /* setting SFALG according to optionnumber('h') */
        if (is_option('h') && optionnumber('h') == 8){
           SFLAG = 1;
        }

        G = get_bravais(FILENAMES[0]);
        vec = get_mat(FILENAMES[1]);
        Form = get_mat(FILENAMES[2]);

        Pol = fub(vec, G, Form);

        put_polyeder(Pol);
        free_polyeder(Pol);

        free_bravais(G);
        free_mat(vec); vec = NULL;
        free_mat(Form); Form = NULL;

        if (SFLAG == 1){
           pointer_statistics(0,0);
        }
   printf("\n");
}
