/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"


main (int argc, char *argv[])
{

	matrix_TYP **Mat;
        bravais_TYP *G, *Gtr;
        polyeder_TYP *pol;
        matrix_TYP *bifo;
        int Mat_anz;

        extern char **FILENAMES;
        extern int FILEANZ;

	extern matrix_TYP **mget_mat();
	extern bravais_TYP *get_bravais();
        extern polyeder_TYP *vor_polyhedra();
        extern matrix_TYP *trace_bifo();
	extern void put_polyeder ();

        read_header(argc, argv);
        if(FILEANZ != 3)
	{
          printf("usage:  vor_polyhedra 'file1' 'file2' 'file3',\n");
          printf("where 'file1' containes a group G, given as bravais_TYP\n");
          printf("      'file2' containes the transposed group G^{tr}, given as bravais_TYP\n");
          printf("      'file3' containes a G-perfect matrix \n");
          if (is_option('h')){
             exit(0);
          }
          else{
             exit(31);
          }
	}
        G = get_bravais(FILENAMES[0]);
        Gtr = get_bravais(FILENAMES[1]);
	Mat = mget_mat (FILENAMES[2], &Mat_anz);
        bifo = trace_bifo(G->form, Gtr->form, G->form_no);
        pol = vor_polyhedra(Mat[0], G, Gtr->form, bifo);
        put_polyeder(pol);


   exit(0);
}
