#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.17';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 103 => 0x69 },
	'about' => { 466 => 'about' },
	'aboutcvterm' => { 458 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 458 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 458 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 458 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 458 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 110 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 472 => 'absPeakAudioFilePath' },
	'academicfield' => { 462 => 'academicField' },
	'acceleration' => { 113 => 0x9404, 453 => 'Acceleration' },
	'accelerationtracking' => { 78 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 366 => 0x3 },
	'accelerometerx' => { 301 => 0x8d },
	'accelerometery' => { 301 => 0x8e },
	'accelerometerz' => { 301 => 0x8c },
	'accessoryserialnumber' => { 301 => 0x54 },
	'accessorytype' => { 301 => 0x53 },
	'actionadvised' => { 125 => 0x2a },
	'activearea' => { 113 => 0xc68d },
	'actived-lighting' => { 214 => 0x22, 252 => 0x24 },
	'actived-lightingmode' => { 252 => 0x25 },
	'adaptervoltage' => { 131 => 0x407 },
	'addaspectratioinfo' => { 78 => 0x80e },
	'addiptcinformation' => { 78 => 0x815 },
	'additionalmodelinformation' => { 458 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 78 => 0x80f, 79 => 0x11, 80 => 0x13, 83 => 0x14 },
	'address' => { 152 => 'Address' },
	'adjustmentmode' => { 373 => 0x15 },
	'adlbracketingstep' => { 233 => 0x883 },
	'adlbracketingtype' => { 233 => 0x884 },
	'adobe' => { 114 => 'Adobe' },
	'adultcontentwarning' => { 288 => 'AdultContentWarning', 465 => 'adultContentWarning' },
	'advancedfilter' => { 121 => 0x1201 },
	'advancedraw' => { 254 => 0x76a43203 },
	'advancedscenetype' => { 301 => 0x3d },
	'advisory' => { 470 => 'Advisory' },
	'ae_iso' => { 309 => 0x2, 310 => 0x4, 311 => 0x12 },
	'aeaperture' => { 309 => 0x1, 310 => 0x3, 311 => 0x11 },
	'aeaperturesteps' => { 309 => 0x8, 310 => 0xb },
	'aebautocancel' => { 78 => 0x104 },
	'aebbracketvalue' => { 72 => 0x11 },
	'aebracketingsteps' => { 232 => 0x174c, 233 => 0x87b, 241 => 0x1756 },
	'aebsequence' => { 78 => 0x105 },
	'aebsequenceautocancel' => { 76 => 0x9, 77 => 0x9, 79 => 0x8, 80 => 0x9, 83 => 0x9, 84 => 0x7 },
	'aebshotcount' => { 78 => 0x106 },
	'aebxv' => { 309 => 0x4, 310 => 0x6 },
	'aeerror' => { 310 => 0x8 },
	'aeexposuretime' => { 309 => 0x0, 310 => 0x2, 311 => 0x10 },
	'aelbutton' => { 174 => 0x45 },
	'aelexposureindicator' => { 174 => 0x51 },
	'aelock' => { 174 => 0x5b, 263 => '4.2', 272 => '4.2', 278 => 0x201, 336 => 0x48, 381 => 0x40, 382 => 0x40, 383 => [0x86,0x286] },
	'aelockbutton' => { 261 => '16.1', 263 => '4.1', 266 => '15.1', 267 => '16.1', 268 => '16.1', 270 => '30.1', 271 => '16.1', 272 => '4.1', 274 => '17.1', 276 => '17.1' },
	'aelockbuttonplusdials' => { 261 => '16.2', 270 => '32.1', 274 => '44.1' },
	'aelockformb-d80' => { 276 => '3.1' },
	'aelockmetermodeafterfocus' => { 78 => 0x114 },
	'aemaxaperture' => { 309 => 0x9, 310 => 0x10, 311 => 0x1c },
	'aemaxaperture2' => { 309 => 0xa, 310 => 0x11, 311 => 0x1d },
	'aemeteringmode' => { 309 => 0xc },
	'aemeteringmode2' => { 309 => '13.1' },
	'aemeteringsegments' => { 177 => 0x628, 336 => 0x209 },
	'aemicroadjustment' => { 78 => 0x110 },
	'aeminaperture' => { 309 => 0xb, 310 => 0x12, 311 => 0x1e },
	'aeminexposuretime' => { 309 => 0x5, 310 => 0x13, 311 => 0x1f },
	'aeprogrammode' => { 309 => 0x6 },
	'aeprojectlink' => { 447 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 447 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 447 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 447 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 447 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 447 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 33 => 0x21 },
	'aewhitebalance' => { 309 => 0xd },
	'aexv' => { 309 => 0x3, 310 => 0x5 },
	'af-cpriority' => { 122 => '0.2' },
	'af-cpriorityselection' => { 261 => '1.1', 262 => '1.1', 264 => '1.1', 265 => '1.1', 267 => '0.1', 268 => '0.1', 269 => '0.1', 270 => '1.1', 271 => '0.1', 274 => '1.1', 275 => '1.1' },
	'af-csetting' => { 118 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 118 => '0.2' },
	'af-ctrackingsensitivity' => { 118 => '0.1' },
	'af-czoneareaswitching' => { 118 => '0.3' },
	'af-onbutton' => { 264 => '70.1', 265 => '70.1', 275 => '70.1' },
	'af-onformb-d10' => { 261 => '3.3', 270 => '3.2' },
	'af-onformb-d11' => { 271 => '2.2' },
	'af-onformb-d12' => { 274 => '50.1' },
	'af-spriority' => { 122 => '0.1' },
	'af-spriorityselection' => { 261 => '1.2', 262 => '1.2', 264 => '1.4', 265 => '1.4', 269 => '0.2', 270 => '1.2', 271 => '0.2', 274 => '1.2', 275 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 261 => '2.1', 262 => '2.1', 264 => '78.3', 265 => '78.3', 270 => '2.1', 274 => '2.1', 275 => '78.3' },
	'afadjustment' => { 336 => 0x72, 345 => 0x267 },
	'afandmeteringbuttons' => { 78 => 0x701 },
	'afaperture' => { 207 => 0x5, 208 => 0x5, 212 => 0x5 },
	'afareaheight' => { 183 => [0x1a,0x34,0x50] },
	'afareaillumination' => { 174 => 0x4b, 272 => '15.3' },
	'afareamode' => { 120 => '0.2', 170 => 0x33, 174 => 0xe, 182 => 0x0, 183 => 0x5, 301 => 0xf, 363 => 0x1205, 374 => [0xa,0x3a], 381 => 0x11, 382 => 0x10, 383 => 0x24, 394 => 0xb043, 417 => 0x17 },
	'afareamodesetting' => { 263 => '11.1', 266 => '0.1', 272 => '16.1', 276 => '2.1', 394 => 0x201c },
	'afareapointsize' => { 120 => '0.3' },
	'afareas' => { 278 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 78 => 0x51b },
	'afareawidth' => { 183 => [0x18,0x32,0x4e] },
	'afareaxposition' => { 183 => [0x14,0x2e,0x4a], 363 => 0x1203 },
	'afareaxposition1' => { 363 => 0x1201 },
	'afareayposition' => { 183 => [0x16,0x30,0x4c], 363 => 0x1204 },
	'afareayposition1' => { 363 => 0x1202 },
	'afareazonesize' => { 120 => '0.4' },
	'afassist' => { 76 => 0x5, 84 => 0x5, 174 => 0x48, 261 => '2.5', 263 => '0.2', 266 => '0.2', 267 => '1.1', 268 => '1.1', 269 => '1.3', 270 => '2.4', 271 => '1.3', 272 => '0.2', 274 => '2.4', 276 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 78 => 0x50e, 79 => 0x4, 80 => 0x5, 81 => 0x4, 82 => 0x4, 83 => 0x5 },
	'afassistlamp' => { 301 => 0x31 },
	'afbuttonpressed' => { 383 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 312 => 0x6 },
	'afduringliveview' => { 78 => 0x511 },
	'affinea' => { 441 => 'AffineA' },
	'affineb' => { 441 => 'AffineB' },
	'affinec' => { 441 => 'AffineC' },
	'affined' => { 441 => 'AffineD' },
	'affinetune' => { 184 => 0x0, 278 => 0x306 },
	'affinetuneadj' => { 184 => 0x2, 225 => 0x2d1, 226 => 0x2dc, 278 => 0x307 },
	'affinetuneindex' => { 184 => 0x1 },
	'affinex' => { 441 => 'AffineX' },
	'affiney' => { 441 => 'AffineY' },
	'afhold' => { 312 => 0x1fd },
	'afilluminator' => { 381 => 0x29, 394 => 0xb044 },
	'afimageheight' => { 183 => [0x12,0x2c,0x48] },
	'afimagewidth' => { 183 => [0x10,0x2a,0x46] },
	'afintegrationtime' => { 312 => 0x7 },
	'afmicroadj' => { 374 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 378 => 0x131 },
	'afmicroadjregisteredlenses' => { 378 => '305.1' },
	'afmicroadjustment' => { 78 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 378 => 0x130 },
	'afmode' => { 107 => 0x3009, 121 => 0x1022, 170 => 0x16, 373 => 0x5 },
	'afmoderestrictions' => { 262 => '50.3', 264 => '48.3', 265 => '48.3', 274 => '48.3', 275 => '48.3' },
	'afonaelockbuttonswitch' => { 78 => 0x702 },
	'afonbutton' => { 261 => '3.1', 262 => '47.1' },
	'afpoint' => { 33 => 0x13, 106 => 0x18, 170 => 0x15, 182 => 0x1, 281 => 0x308, 373 => 0x1f, 374 => [0x37,0x7], 378 => 0x19, 379 => 0x18, 380 => [0x18,0x20] },
	'afpointactivationarea' => { 77 => 0x11, 83 => 0x11 },
	'afpointareaexpansion' => { 78 => 0x508 },
	'afpointatshutterrelease' => { 374 => [0x39,0x9] },
	'afpointautoselection' => { 78 => 0x50b },
	'afpointbrightness' => { 78 => 0x50d, 261 => '2.4', 262 => '46.5', 264 => '2.2', 265 => '2.2', 274 => '2.3', 275 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 78 => 0x50c },
	'afpointillumination' => { 77 => 0xa, 261 => '2.3', 262 => '46.2', 264 => '47.2', 265 => '47.2', 269 => '1.2', 270 => '2.3', 271 => '1.2', 274 => '47.2', 275 => '47.2', 276 => '2.4' },
	'afpointinfocus' => { 374 => [0x38,0x8] },
	'afpointmode' => { 317 => 0x3 },
	'afpointposition' => { 107 => 0x2021, 301 => 0x4d },
	'afpointregistration' => { 76 => 0x7 },
	'afpoints' => { 173 => 0x10 },
	'afpointselected' => { 174 => 0xd, 278 => 0x305, 336 => 0xe, 378 => 0x15, 379 => 0x14, 380 => [0x14,0x1c], 394 => 0x201e },
	'afpointselected2' => { 317 => 0x4 },
	'afpointselection' => { 77 => 0xb, 261 => '1.3', 262 => '1.3', 270 => '1.3', 274 => '1.3', 275 => '1.3' },
	'afpointselectionmethod' => { 78 => 0x50f, 79 => 0xc, 80 => 0xd, 83 => 0xd },
	'afpointsetting' => { 381 => 0x12, 382 => 0x11 },
	'afpointsinfocus' => { 72 => 0xe, 182 => 0x2, 312 => 0xb, 313 => 0x4, 336 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 77 => 0xd },
	'afpointsselected' => { 313 => '4.1', 425 => 0x4 },
	'afpointsspecial' => { 313 => '4.2' },
	'afpointsunknown1' => { 312 => 0x0 },
	'afpointsunknown2' => { 312 => 0x2 },
	'afpointsused' => { 183 => 0x8, 374 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 312 => 0x4 },
	'afresponse' => { 214 => 0xad },
	'afresult' => { 283 => 0x1038 },
	'afsearch' => { 278 => 0x303 },
	'afsensoractive' => { 170 => 0x1 },
	'afstatus' => { 363 => 0x1200 },
	'afstatus_00_b4' => { 377 => 0x0 },
	'afstatus_01_c4' => { 377 => 0x2 },
	'afstatus_02_d4' => { 377 => 0x4 },
	'afstatus_03_e4' => { 377 => 0x6 },
	'afstatus_04_f4' => { 377 => 0x8 },
	'afstatus_05_g4' => { 377 => 0xa },
	'afstatus_06_h4' => { 377 => 0xc },
	'afstatus_07_b3' => { 377 => 0xe },
	'afstatus_08_c3' => { 377 => 0x10 },
	'afstatus_09_d3' => { 377 => 0x12 },
	'afstatus_10_e3' => { 377 => 0x14 },
	'afstatus_11_f3' => { 377 => 0x16 },
	'afstatus_12_g3' => { 377 => 0x18 },
	'afstatus_13_h3' => { 377 => 0x1a },
	'afstatus_14_b2' => { 377 => 0x1c },
	'afstatus_15_c2' => { 377 => 0x1e },
	'afstatus_16_d2' => { 377 => 0x20 },
	'afstatus_17_e2' => { 377 => 0x22 },
	'afstatus_18_f2' => { 377 => 0x24 },
	'afstatus_19_g2' => { 377 => 0x26 },
	'afstatus_20_h2' => { 377 => 0x28 },
	'afstatus_21_c1' => { 377 => 0x2a },
	'afstatus_22_d1' => { 377 => 0x2c },
	'afstatus_23_e1' => { 377 => 0x2e },
	'afstatus_24_f1' => { 377 => 0x30 },
	'afstatus_25_g1' => { 377 => 0x32 },
	'afstatus_26_a7_vertical' => { 377 => 0x34 },
	'afstatus_27_a6_vertical' => { 377 => 0x36 },
	'afstatus_28_a5_vertical' => { 377 => 0x38 },
	'afstatus_29_c7_vertical' => { 377 => 0x3a },
	'afstatus_30_c6_vertical' => { 377 => 0x3c },
	'afstatus_31_c5_vertical' => { 377 => 0x3e },
	'afstatus_32_e7_vertical' => { 377 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 377 => 0x42 },
	'afstatus_34_e5_vertical' => { 377 => 0x44 },
	'afstatus_35_g7_vertical' => { 377 => 0x46 },
	'afstatus_36_g6_vertical' => { 377 => 0x48 },
	'afstatus_37_g5_vertical' => { 377 => 0x4a },
	'afstatus_38_i7_vertical' => { 377 => 0x4c },
	'afstatus_39_i6_vertical' => { 377 => 0x4e },
	'afstatus_40_i5_vertical' => { 377 => 0x50 },
	'afstatus_41_a7' => { 377 => 0x52 },
	'afstatus_42_b7' => { 377 => 0x54 },
	'afstatus_43_c7' => { 377 => 0x56 },
	'afstatus_44_d7' => { 377 => 0x58 },
	'afstatus_45_e7' => { 377 => 0x5a },
	'afstatus_46_f7' => { 377 => 0x5c },
	'afstatus_47_g7' => { 377 => 0x5e },
	'afstatus_48_h7' => { 377 => 0x60 },
	'afstatus_49_i7' => { 377 => 0x62 },
	'afstatus_50_a6' => { 377 => 0x64 },
	'afstatus_51_b6' => { 377 => 0x66 },
	'afstatus_52_c6' => { 377 => 0x68 },
	'afstatus_53_d6' => { 377 => 0x6a },
	'afstatus_54_e6_center' => { 377 => 0x6c },
	'afstatus_55_f6' => { 377 => 0x6e },
	'afstatus_56_g6' => { 377 => 0x70 },
	'afstatus_57_h6' => { 377 => 0x72 },
	'afstatus_58_i6' => { 377 => 0x74 },
	'afstatus_59_a5' => { 377 => 0x76 },
	'afstatus_60_b5' => { 377 => 0x78 },
	'afstatus_61_c5' => { 377 => 0x7a },
	'afstatus_62_d5' => { 377 => 0x7c },
	'afstatus_63_e5' => { 377 => 0x7e },
	'afstatus_64_f5' => { 377 => 0x80 },
	'afstatus_65_g5' => { 377 => 0x82 },
	'afstatus_66_h5' => { 377 => 0x84 },
	'afstatus_67_i5' => { 377 => 0x86 },
	'afstatus_68_c11' => { 377 => 0x88 },
	'afstatus_69_d11' => { 377 => 0x8a },
	'afstatus_70_e11' => { 377 => 0x8c },
	'afstatus_71_f11' => { 377 => 0x8e },
	'afstatus_72_g11' => { 377 => 0x90 },
	'afstatus_73_b10' => { 377 => 0x92 },
	'afstatus_74_c10' => { 377 => 0x94 },
	'afstatus_75_d10' => { 377 => 0x96 },
	'afstatus_76_e10' => { 377 => 0x98 },
	'afstatus_77_f10' => { 377 => 0x9a },
	'afstatus_78_g10' => { 377 => 0x9c },
	'afstatus_79_h10' => { 377 => 0x9e },
	'afstatus_80_b9' => { 377 => 0xa0 },
	'afstatus_81_c9' => { 377 => 0xa2 },
	'afstatus_82_d9' => { 377 => 0xa4 },
	'afstatus_83_e9' => { 377 => 0xa6 },
	'afstatus_84_f9' => { 377 => 0xa8 },
	'afstatus_85_g9' => { 377 => 0xaa },
	'afstatus_86_h9' => { 377 => 0xac },
	'afstatus_87_b8' => { 377 => 0xae },
	'afstatus_88_c8' => { 377 => 0xb0 },
	'afstatus_89_d8' => { 377 => 0xb2 },
	'afstatus_90_e8' => { 377 => 0xb4 },
	'afstatus_91_f8' => { 377 => 0xb6 },
	'afstatus_92_g8' => { 377 => 0xb8 },
	'afstatus_93_h8' => { 377 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 377 => 0xbc },
	'afstatusactivesensor' => { 170 => 0x2, 374 => [0x4,0x3b], 378 => 0x1e, 379 => 0x1b, 380 => [0x1b,0x21] },
	'afstatusbottom' => { 170 => 0x8, 378 => 0x2a, 379 => 0x21, 380 => 0x21 },
	'afstatusbottom-left' => { 170 => 0x12, 379 => 0x2b, 380 => 0x2b },
	'afstatusbottom-right' => { 170 => 0x6, 379 => 0x1f, 380 => 0x1f },
	'afstatusbottomassist-left' => { 378 => 0x28 },
	'afstatusbottomassist-right' => { 378 => 0x2c },
	'afstatusbottomhorizontal' => { 375 => 0x10, 376 => 0x1c },
	'afstatusbottomvertical' => { 375 => 0x16, 376 => 0x26 },
	'afstatuscenter-10' => { 378 => 0x34 },
	'afstatuscenter-11' => { 378 => 0x36 },
	'afstatuscenter-12' => { 378 => 0x38 },
	'afstatuscenter-14' => { 378 => 0x3c },
	'afstatuscenter-7' => { 378 => 0x2e },
	'afstatuscenter-9' => { 378 => 0x32 },
	'afstatuscenter-horizontal' => { 378 => 0x30 },
	'afstatuscenter-vertical' => { 378 => 0x3a },
	'afstatuscenterf2-8' => { 378 => 0x4c },
	'afstatuscenterhorizontal' => { 170 => 0x2f, 375 => 0xc, 376 => 0x18, 379 => 0x2f, 380 => 0x2f },
	'afstatuscentervertical' => { 170 => 0xc, 375 => 0x14, 376 => 0x22, 379 => 0x25, 380 => 0x25 },
	'afstatusfarleft' => { 375 => 0x6, 378 => 0x26 },
	'afstatusfarlefthorizontal' => { 376 => 0x4 },
	'afstatusfarleftvertical' => { 376 => 0x12 },
	'afstatusfarright' => { 375 => 0x18, 378 => 0x44 },
	'afstatusfarrighthorizontal' => { 376 => 0x2c },
	'afstatusfarrightvertical' => { 376 => 0x34 },
	'afstatusleft' => { 170 => 0x2d, 375 => 0x2, 378 => 0x22, 379 => 0x2d, 380 => 0x2d },
	'afstatuslefthorizontal' => { 376 => 0x6 },
	'afstatusleftvertical' => { 376 => 0xe },
	'afstatuslower-left' => { 375 => 0x4, 378 => 0x24 },
	'afstatuslower-lefthorizontal' => { 376 => 0xa },
	'afstatuslower-leftvertical' => { 376 => 0x10 },
	'afstatuslower-middle' => { 375 => 0x22, 376 => 0x24 },
	'afstatuslower-right' => { 375 => 0x1e, 378 => 0x4a },
	'afstatuslower-righthorizontal' => { 376 => 0x32 },
	'afstatuslower-rightvertical' => { 376 => 0x3a },
	'afstatuslowerfarleft' => { 376 => 0x8 },
	'afstatuslowerfarright' => { 376 => 0x30 },
	'afstatusmiddlehorizontal' => { 170 => 0xa, 379 => 0x23, 380 => 0x23 },
	'afstatusnearleft' => { 375 => 0xe, 376 => 0x1a },
	'afstatusnearright' => { 375 => 0xa, 376 => 0x16 },
	'afstatusright' => { 170 => 0x31, 375 => 0x1c, 378 => 0x48, 379 => 0x31, 380 => 0x31 },
	'afstatusrighthorizontal' => { 376 => 0x2e },
	'afstatusrightvertical' => { 376 => 0x38 },
	'afstatustop' => { 170 => 0xe, 378 => 0x40, 379 => 0x27, 380 => 0x27 },
	'afstatustop-left' => { 170 => 0x10, 379 => 0x29, 380 => 0x29 },
	'afstatustop-right' => { 170 => 0x4, 379 => 0x1d, 380 => 0x1d },
	'afstatustopassist-left' => { 378 => 0x3e },
	'afstatustopassist-right' => { 378 => 0x42 },
	'afstatustophorizontal' => { 375 => 0x8, 376 => 0x14 },
	'afstatustopvertical' => { 375 => 0x12, 376 => 0x1e },
	'afstatusupper-left' => { 375 => 0x0, 378 => 0x20 },
	'afstatusupper-lefthorizontal' => { 376 => 0x2 },
	'afstatusupper-leftvertical' => { 376 => 0xc },
	'afstatusupper-middle' => { 375 => 0x20, 376 => 0x20 },
	'afstatusupper-right' => { 375 => 0x1a, 378 => 0x46 },
	'afstatusupper-righthorizontal' => { 376 => 0x2a },
	'afstatusupper-rightvertical' => { 376 => 0x36 },
	'afstatusupperfarleft' => { 376 => 0x0 },
	'afstatusupperfarright' => { 376 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 394 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 374 => 0x2 },
	'afwithshutter' => { 381 => 0x2a },
	'aggregateissuenumber' => { 462 => 'aggregateIssueNumber' },
	'aggregationtype' => { 462 => 'aggregationType' },
	'agreement' => { 465 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 131 => 0xe4e },
	'aiservocontinuousshooting' => { 77 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 78 => 0x519 },
	'aiservoimagepriority' => { 78 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 78 => 0x51a },
	'aiservotrackingmethod' => { 78 => 0x504 },
	'aiservotrackingsensitivity' => { 77 => 0x14, 78 => 0x502 },
	'album' => { 472 => 'album' },
	'alreadyapplied' => { 448 => 'AlreadyApplied' },
	'alternatetitle' => { 462 => 'alternateTitle' },
	'alternatetitlea-lang' => { 462 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 462 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 462 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 185 => 0x6 },
	'alttapename' => { 472 => 'altTapeName' },
	'alttimecode' => { 472 => 'altTimecode' },
	'alttimecodetimeformat' => { 472 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 472 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 472 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 359 => 0x5c },
	'ambientlight' => { 359 => 0x5e },
	'ambienttemperature' => { 113 => 0x9400, 357 => 0x14, 358 => 0x46, 359 => 0x50, 417 => 0x4, 453 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 357 => 0x13, 358 => 0x44, 359 => 0x4e },
	'analogbalance' => { 113 => 0xc627 },
	'analogcaptureiso' => { 131 => 0x89e },
	'analogisotable' => { 131 => 0x89d },
	'angleadj' => { 97 => 0x10003, 103 => 0x8b },
	'angleinforoll' => { 443 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 443 => 'AngleInfoYaw' },
	'anti-blur' => { 394 => 0xb04b },
	'antialiasstrength' => { 113 => 0xc632 },
	'aperturelock' => { 262 => '38.2', 264 => '38.2', 265 => '38.2', 274 => '38.2', 275 => '38.2' },
	'aperturerange' => { 78 => 0x10d },
	'apertureringuse' => { 317 => '1.4' },
	'aperturesetting' => { 174 => 0x7, 381 => 0x30, 382 => 0x29, 383 => 0x1 },
	'aperturevalue' => { 87 => 0x2, 113 => 0x9202, 283 => 0x1002, 345 => 0x401, 452 => 'ApertureValue' },
	'applekeywords' => { 287 => 'AAPL:Keywords' },
	'applicationkeystring' => { 131 => 0x400 },
	'applicationnotes' => { 113 => 0x2bc, 306 => 0x2bc },
	'applicationrecordversion' => { 125 => 0x0 },
	'applyshootingmeteringmode' => { 78 => 0x10e },
	'approved' => { 454 => 'Approved' },
	'approvedby' => { 454 => 'ApprovedBy' },
	'approximatefnumber' => { 296 => 0x313, 303 => 0x3406 },
	'approximatefocusdistance' => { 444 => 'ApproximateFocusDistance' },
	'appversion' => { 456 => 'AppVersion' },
	'aquahsl' => { 97 => 0x20914 },
	'armidentifier' => { 126 => 0x78 },
	'armversion' => { 126 => 0x7a },
	'artfilter' => { 278 => 0x529 },
	'artfiltereffect' => { 278 => 0x52f },
	'artist' => { 113 => 0x13b, 291 => 'Artist', 336 => 0x22e, 468 => 'Artist', 472 => 'artist' },
	'artmode' => { 107 => 0x301b },
	'artmodeparameters' => { 107 => 0x310b },
	'artworkcircadatecreated' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 458 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 458 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 282 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 282 => 0x1112, 336 => 0x80, 381 => 0x55, 382 => 0x55, 383 => 0xa },
	'assetid' => { 437 => 'AssetID' },
	'asshoticcprofile' => { 113 => 0xc68f },
	'asshotneutral' => { 113 => 0xc628 },
	'asshotpreprofilematrix' => { 113 => 0xc690 },
	'asshotprofilename' => { 113 => 0xc6f6 },
	'asshotwhitexy' => { 113 => 0xc629 },
	'assignbktbutton' => { 261 => '4.2', 262 => '16.1', 264 => '16.1', 265 => '16.1', 274 => '16.1', 275 => '16.1' },
	'assignfuncbutton' => { 78 => 0x70b },
	'assignmb-d17af-onbutton' => { 265 => '79.1' },
	'assignmb-d17funcbutton' => { 265 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 265 => '68.1' },
	'assignmb-d18af-onbutton' => { 275 => '79.1' },
	'assignmb-d18funcbutton' => { 275 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 275 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 264 => '75.1', 265 => '75.1', 275 => '75.1' },
	'assignmoviefunc2button' => { 264 => '82.1', 265 => '82.1', 275 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 264 => '75.2', 265 => '75.2', 275 => '75.2' },
	'assignmovierecordbutton' => { 262 => '43.2', 274 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 264 => '45.1', 265 => '45.1', 275 => '45.1' },
	'assignmoviesubselector' => { 264 => '74.1', 265 => '74.1', 275 => '74.1' },
	'assignmoviesubselectorplusdials' => { 264 => '76.1', 265 => '76.1', 275 => '76.1' },
	'assignremotefnbutton' => { 262 => '54.1', 274 => '51.1' },
	'assistbuttonfunction' => { 76 => 0xd },
	'atcaptureusercrop' => { 131 => 0x943 },
	'attributionname' => { 445 => 'attributionName' },
	'attributionurl' => { 445 => 'attributionURL' },
	'audio' => { 301 => 0x20 },
	'audiobitrate' => { 63 => 0x6c, 458 => 'audioBitRate' },
	'audiobitratemode' => { 458 => 'audioBitRateMode' },
	'audiobitspersample' => { 458 => 'audioBitsPerSample' },
	'audiochannelcount' => { 458 => 'audioChannelCount' },
	'audiochannels' => { 63 => 0x70 },
	'audiochanneltype' => { 472 => 'audioChannelType' },
	'audiocompression' => { 146 => 'Compression' },
	'audiocompressor' => { 472 => 'audioCompressor' },
	'audiodata' => { 431 => 'Data' },
	'audioduration' => { 125 => 0x99 },
	'audiomimetype' => { 431 => 'Mime' },
	'audiomoddate' => { 472 => 'audioModDate' },
	'audiooutcue' => { 125 => 0x9a },
	'audiosamplerate' => { 63 => 0x6e, 472 => 'audioSampleRate' },
	'audiosampletype' => { 472 => 'audioSampleType' },
	'audiosamplingrate' => { 125 => 0x97 },
	'audiosamplingresolution' => { 125 => 0x98 },
	'audiotype' => { 125 => 0x96 },
	'author' => { 148 => 'Author', 287 => 'Author', 291 => 'Author', 352 => 'Author', 442 => 'author', 459 => 'Author', 470 => 'Author' },
	'authorsposition' => { 460 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 78 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 327 => '0.1' },
	'autobracket' => { 373 => 0x19 },
	'autobracketing' => { 121 => 0x1100, 336 => 0x18, 363 => 0x1007 },
	'autobracketingmode' => { 273 => '12.3' },
	'autobracketingset' => { 273 => '12.1' },
	'autobracketmodem' => { 261 => '21.2', 262 => '13.3', 264 => '13.2', 265 => '13.2', 270 => '26.2', 274 => '13.3', 275 => '13.2' },
	'autobracketorder' => { 174 => 0x43, 261 => '21.3', 262 => '13.2', 264 => '13.1', 265 => '13.1', 270 => '26.3', 271 => '12.2', 272 => '2.2', 273 => '12.2', 274 => '13.2', 275 => '13.1', 276 => '13.2' },
	'autobracketset' => { 261 => '21.1', 262 => '13.1', 266 => '11.1', 267 => '12.1', 268 => '12.1', 270 => '26.1', 271 => '12.1', 272 => '2.1', 274 => '13.1', 276 => '13.1' },
	'autobrightness' => { 448 => 'AutoBrightness' },
	'autocontrast' => { 448 => 'AutoContrast' },
	'autodistortioncontrol' => { 195 => 0x4 },
	'autodynamicrange' => { 121 => 0x140b },
	'autoexposure' => { 448 => 'AutoExposure' },
	'autoexposurebracketing' => { 72 => 0x10 },
	'autoflashisosensitivity' => { 264 => '38.5', 265 => '38.5', 275 => '38.5' },
	'autofocus' => { 281 => 0x209 },
	'autofp' => { 272 => '7.3', 276 => '31.4' },
	'autoiso' => { 72 => 0x1, 107 => 0x3008, 263 => '1.1', 272 => '1.1' },
	'autoisomax' => { 263 => '1.2', 272 => '1.2' },
	'autoisominshutterspeed' => { 263 => '1.3', 272 => '1.3' },
	'autolateralca' => { 448 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 59 => 0x2, 78 => 0x204, 97 => 0x20500, 103 => 0x6f },
	'autolightingoptimizeron' => { 97 => '0x20500.0', 103 => 0x6e },
	'autoportraitframed' => { 394 => 0x2016 },
	'autoredeye' => { 254 => 0xfe28a44f },
	'autorotate' => { 72 => 0x1b },
	'autoshadows' => { 448 => 'AutoShadows' },
	'autotone' => { 448 => 'AutoTone' },
	'autowhiteversion' => { 448 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 214 => 0x82 },
	'avaperturesetting' => { 317 => 0x13 },
	'averageblacklevel' => { 42 => 0xe7, 44 => 0xfb, 45 => 0x114, 46 => 0x146 },
	'averagelv' => { 177 => 0x38 },
	'avsettingwithoutlens' => { 78 => 0x707 },
	'azimuth' => { 156 => 'Azimuth' },
	'babyage' => { 301 => [0x8010,0x33] },
	'babyname' => { 301 => 0x66 },
	'backgroundalpha' => { 467 => 'bgalpha' },
	'baseexposurecompensation' => { 317 => 0x15 },
	'baseiso' => { 72 => 0x2, 91 => 0x101c, 131 => 0x903, 303 => 0x312a, 423 => 0x6 },
	'baseisodaylight' => { 131 => 0x910 },
	'baseisoflash' => { 131 => 0x913 },
	'baseisofluorescent' => { 131 => 0x912 },
	'baseisotungsten' => { 131 => 0x911 },
	'baselineexposure' => { 113 => 0xc62a },
	'baselineexposureoffset' => { 113 => 0xc7a5 },
	'baselinenoise' => { 113 => 0xc62b },
	'baselinesharpness' => { 113 => 0xc62c },
	'baseurl' => { 470 => 'BaseURL' },
	'batterylevel' => { 381 => 0x51, 385 => 0xc, 386 => 0x4, 387 => 0x4, 424 => 0x7 },
	'batterylevelgrip1' => { 424 => 0x6 },
	'batterylevelgrip2' => { 424 => 0x8 },
	'batteryorder' => { 261 => '12.5', 270 => '13.2', 271 => '2.1', 274 => '3.1' },
	'batterystate' => { 174 => 0x60, 381 => 0x50, 387 => 0x14 },
	'batterytemperature' => { 385 => 0x1, 387 => 0x2, 424 => 0x5 },
	'batterytype' => { 60 => 0x38, 359 => 0x66 },
	'batteryunknown' => { 385 => 0x2, 387 => 0x0 },
	'batteryvoltage' => { 131 => 0x408, 357 => 0x2a, 358 => 0x49, 359 => 0x62, 385 => 0x8 },
	'batteryvoltage1' => { 387 => 0x6 },
	'batteryvoltage2' => { 387 => 0x8 },
	'batteryvoltageavg' => { 359 => 0x64 },
	'bayergreensplit' => { 113 => 0xc62d },
	'bayerpattern' => { 130 => 0xf902, 178 => 0x17 },
	'beatspliceparams' => { 472 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 472 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 472 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 472 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 472 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 472 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 261 => '13.1', 262 => '5.4', 263 => '0.1', 266 => '2.1', 267 => '3.1', 268 => '3.1', 270 => '10.1', 272 => '0.1', 274 => '5.5', 276 => '4.1' },
	'beeppitch' => { 271 => '3.1' },
	'beepvolume' => { 271 => '4.5' },
	'bestqualityscale' => { 113 => 0xc65c },
	'bestshotmode' => { 107 => 0x3007 },
	'bitdepth' => { 153 => 'BitDepth', 178 => 0x11, 222 => 0x41 },
	'bitspercomponent' => { 127 => 0x87 },
	'bitspersample' => { 113 => 0x102, 306 => 0xa, 468 => 'BitsPerSample' },
	'blackacquirerows' => { 131 => 0x18ba },
	'blacklevel' => { 113 => 0xc61a, 193 => 0x20, 214 => 0x3d, 283 => [0x401,0x1012], 345 => 0x21d },
	'blacklevel2' => { 282 => 0x600, 286 => 0x600 },
	'blacklevelblue' => { 306 => 0x1e },
	'blacklevelbottom' => { 131 => 0x3f0 },
	'blackleveldata' => { 345 => 0x223 },
	'blackleveldeltah' => { 113 => 0xc61b },
	'blackleveldeltav' => { 113 => 0xc61c },
	'blacklevelgreen' => { 306 => 0x1d },
	'blacklevelred' => { 306 => 0x1c },
	'blacklevelrepeatdim' => { 113 => 0xc619 },
	'blacklevelrough' => { 131 => 0x40e },
	'blacklevelroughafter' => { 131 => 0x416 },
	'blackleveltop' => { 131 => 0x3ef },
	'blackpoint' => { 336 => 0x200 },
	'blacks2012' => { 448 => 'Blacks2012' },
	'blacksadj' => { 427 => 0x9018 },
	'bleachbypasstoning' => { 336 => 0x7f },
	'blockshotafresponse' => { 264 => '1.5', 265 => '1.5', 275 => '1.5' },
	'blogtitle' => { 462 => 'blogTitle' },
	'blogurl' => { 462 => 'blogURL' },
	'bluebalance' => { 283 => 0x1018, 306 => 0x12, 336 => 0x1b },
	'bluecurvelimits' => { 102 => 0x1fe },
	'bluecurvepoints' => { 101 => 0x79, 102 => 0x1d4 },
	'bluehsl' => { 97 => 0x20915 },
	'bluehue' => { 448 => 'BlueHue' },
	'bluesaturation' => { 448 => 'BlueSaturation' },
	'bluratinfinity' => { 433 => 'BlurAtInfinity' },
	'blurcontrol' => { 336 => 0x82 },
	'blurwarning' => { 121 => 0x1300 },
	'bodybatteryadload' => { 315 => 0x3 },
	'bodybatteryadnoload' => { 315 => 0x2 },
	'bodybatterystate' => { 315 => '1.1' },
	'bodybatteryvoltage1' => { 315 => 0x2 },
	'bodybatteryvoltage2' => { 315 => 0x4 },
	'bodybatteryvoltage3' => { 315 => 0x6 },
	'bodybatteryvoltage4' => { 315 => 0x8 },
	'bodyfirmware' => { 364 => 0x0 },
	'bodyfirmwareversion' => { 279 => 0x104, 280 => 0x100, 283 => 0x104 },
	'bodyserialnumber' => { 364 => 0x10 },
	'bookedition' => { 462 => 'bookEdition' },
	'bootloaderversion' => { 358 => 0x26 },
	'bracketmode' => { 54 => 0x3 },
	'bracketsequence' => { 107 => 0x301d },
	'bracketsettings' => { 301 => 0x45 },
	'bracketshotnumber' => { 54 => 0x5, 317 => 0x9, 392 => 0x2b },
	'bracketshotnumber2' => { 392 => 0x2d },
	'bracketstep' => { 171 => 0xe },
	'bracketvalue' => { 54 => 0x4 },
	'brightness' => { 113 => 0xfe53, 147 => 'Brightness', 167 => 'Brightness', 171 => 0x2c, 216 => 0x34, 217 => 0x39, 218 => 0x41, 357 => 0x25, 359 => 0x54, 381 => 0x22, 394 => 0x2007, 448 => 'Brightness' },
	'brightnessadj' => { 102 => 0x114, 247 => 0x0, 257 => 0x2d, 427 => 0x8018 },
	'brightnessvalue' => { 113 => 0x9203, 177 => [0x691,0x49c3], 283 => 0x1003, 399 => 0x1e, 402 => 0x1140, 403 => 0x1140, 404 => 0x111c, 405 => 0x1198, 406 => 0x1174, 407 => 0x102c, 408 => 0x224, 409 => 0x224, 410 => 0x219, 452 => 'BrightnessValue' },
	'bulbduration' => { 72 => 0x18 },
	'burstcount' => { 131 => 0x40d },
	'burstmode' => { 133 => 0xa, 301 => 0x2a },
	'burstmode2' => { 133 => 0x18 },
	'burstshot' => { 373 => 0x34 },
	'burstspeed' => { 301 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 78 => 0x70a },
	'bwadjustment' => { 121 => 0x1049 },
	'bwfilter' => { 171 => 0x2a, 179 => 0x39 },
	'bwmode' => { 283 => 0x203 },
	'by-line' => { 125 => 0x50 },
	'by-linetitle' => { 125 => 0x55 },
	'bytecount' => { 462 => 'byteCount' },
	'c14configuration' => { 131 => 0x1964 },
	'cacheversion' => { 113 => 0xc7aa },
	'calibratedfocallength' => { 110 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 110 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 110 => 'CalibratedOpticalCenterY' },
	'calibration' => { 373 => [0x24,0x30] },
	'calibrationhistory' => { 131 => 0x9c9 },
	'calibrationilluminant1' => { 113 => 0xc65a },
	'calibrationilluminant2' => { 113 => 0xc65b },
	'calibrationversion' => { 131 => 0x9c6 },
	'callforimage' => { 437 => 'CallForImage' },
	'cameraangle' => { 472 => 'cameraAngle' },
	'cameracalibration1' => { 113 => 0xc623 },
	'cameracalibration2' => { 113 => 0xc624 },
	'cameracalibrationsig' => { 113 => 0xc6f3 },
	'cameracolorcalibration01' => { 35 => 0x0, 36 => 0x0 },
	'cameracolorcalibration02' => { 35 => 0x4, 36 => 0x5 },
	'cameracolorcalibration03' => { 35 => 0x8, 36 => 0xa },
	'cameracolorcalibration04' => { 35 => 0xc, 36 => 0xf },
	'cameracolorcalibration05' => { 35 => 0x10, 36 => 0x14 },
	'cameracolorcalibration06' => { 35 => 0x14, 36 => 0x19 },
	'cameracolorcalibration07' => { 35 => 0x18, 36 => 0x1e },
	'cameracolorcalibration08' => { 35 => 0x1c, 36 => 0x23 },
	'cameracolorcalibration09' => { 35 => 0x20, 36 => 0x28 },
	'cameracolorcalibration10' => { 35 => 0x24, 36 => 0x2d },
	'cameracolorcalibration11' => { 35 => 0x28, 36 => 0x32 },
	'cameracolorcalibration12' => { 35 => 0x2c, 36 => 0x37 },
	'cameracolorcalibration13' => { 35 => 0x30, 36 => 0x3c },
	'cameracolorcalibration14' => { 35 => 0x34, 36 => 0x41 },
	'cameracolorcalibration15' => { 35 => 0x38, 36 => 0x46 },
	'camerae-mountversion' => { 426 => 0xb },
	'cameraelevationangle' => { 113 => 0x9405, 453 => 'CameraElevationAngle' },
	'camerafilename' => { 437 => 'CameraFilename' },
	'cameraid' => { 283 => 0x209, 372 => 0x209 },
	'cameraiso' => { 33 => 0x10 },
	'cameralabel' => { 113 => 0xc7a1, 472 => 'cameraLabel' },
	'cameramakemodel' => { 437 => 'CameraMakeModel' },
	'cameramodel' => { 345 => 0x410, 472 => 'cameraModel' },
	'cameramodelid' => { 167 => 'CameraModelID' },
	'cameramove' => { 472 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 27 => 0x35, 28 => 0x96, 301 => 0x8f, 340 => 0x1, 345 => 0x100, 387 => [0x16,0x18], 414 => 0x28, 415 => 0x24, 416 => 0x29 },
	'cameraowner' => { 134 => 0xc353 },
	'cameraparameters' => { 283 => 0x2050 },
	'camerapicturestyle' => { 27 => 0xaf },
	'camerapitch' => { 109 => 0x9 },
	'cameraprofile' => { 448 => 'CameraProfile' },
	'cameraprofiledigest' => { 448 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 103 => 0xe1 },
	'camerarawcontrast' => { 103 => 0xe3 },
	'camerarawhighlightpoint' => { 103 => 0xe6 },
	'camerarawlinear' => { 103 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 103 => 0xe8 },
	'camerarawoutputshadowpoint' => { 103 => 0xe9 },
	'camerarawsaturation' => { 103 => 0xe2 },
	'camerarawshadowpoint' => { 103 => 0xe7 },
	'camerarawsharpness' => { 103 => 0xe5 },
	'cameraroll' => { 109 => 0xb },
	'cameraserialnumber' => { 113 => 0xc62f, 169 => 'CameraSerialNumber', 437 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 278 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x19, 28 => 0x1b, 29 => [0x87,0x91], 30 => [0x99,0x9f,0xa4,0xa8,0x105], 32 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 72 => 0xc, 131 => 0x406, 282 => 0x1306, 296 => 0x320, 303 => 0x3402, 336 => 0x47, 370 => 0x43, 418 => 0x5 },
	'cameratemperature4' => { 341 => 0x14 },
	'cameratemperature5' => { 341 => 0x16 },
	'cameratemperaturerangemax' => { 115 => 0x5 },
	'cameratemperaturerangemin' => { 115 => 0x6 },
	'cameratype' => { 72 => 0x1a, 283 => 0x207 },
	'cameratype2' => { 279 => 0x100 },
	'camerayaw' => { 109 => 0xa },
	'camreverse' => { 110 => 'CamReverse' },
	'canondr4' => { 114 => 'CanonDR4' },
	'canonexposuremode' => { 33 => 0x14 },
	'canonfiledescription' => { 91 => 0x805 },
	'canonfilelength' => { 60 => 0xe },
	'canonfirmwareversion' => { 60 => 0x7, 91 => 0x80b },
	'canonflashinfo' => { 91 => 0x1028 },
	'canonflashmode' => { 33 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 33 => 0xa },
	'canonimagetype' => { 60 => 0x6, 91 => 0x815 },
	'canonmodelid' => { 60 => 0x10, 91 => 0x1834 },
	'canonvrd' => { 114 => 'CanonVRD' },
	'caption' => { 442 => 'caption' },
	'caption-abstract' => { 125 => 0x78 },
	'captionsauthornames' => { 451 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 451 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 460 => 'CaptionWriter' },
	'captureframerate' => { 107 => 0x4001 },
	'captureheightnormal' => { 131 => 0x1839 },
	'capturelook' => { 131 => 0xc48 },
	'capturesoftware' => { 435 => 'CaptureSoftware' },
	'capturewidthnormal' => { 131 => 0x1838 },
	'capturewidthtest' => { 131 => 0x1842 },
	'cardshutterlock' => { 174 => 0x49 },
	'casioimagesize' => { 107 => 0x9 },
	'catalogsets' => { 125 => 0xff, 430 => 'CatalogSets', 440 => 'CatalogSets' },
	'categories' => { 60 => 0x23, 442 => 'categories' },
	'category' => { 125 => 0xf, 277 => 0x30, 460 => 'Category' },
	'cbcrgain' => { 370 => 0xa036 },
	'cbcrgaindefault' => { 370 => 0xa035 },
	'cbcrmatrix' => { 370 => 0xa034 },
	'cbcrmatrixdefault' => { 370 => 0xa033 },
	'ccdboardversion' => { 296 => 0x331 },
	'ccdscanmode' => { 283 => 0x1039 },
	'ccdsensitivity' => { 244 => 0x6 },
	'ccdversion' => { 296 => 0x330 },
	'cellglobalid' => { 446 => 'cgi' },
	'celllength' => { 113 => 0x109 },
	'cellr' => { 446 => 'r' },
	'celltowerid' => { 446 => 'cellid' },
	'cellwidth' => { 113 => 0x108 },
	'centerafarea' => { 272 => '15.1' },
	'centerfocuspoint' => { 276 => '2.2' },
	'centerpixel' => { 131 => 0x40c },
	'centerweightedareasize' => { 261 => '7.1', 262 => '8.1', 264 => '8.1', 265 => '8.1', 269 => '7.1', 270 => '5.1', 271 => '7.1', 272 => '6.3', 274 => '8.1', 275 => '8.1', 276 => '8.1' },
	'certificate' => { 476 => 'Certificate' },
	'cfainterpolationalgorithm' => { 131 => 0xe60 },
	'cfainterpolationmetric' => { 131 => 0xe61 },
	'cfaoffsetcols' => { 131 => 0xc71 },
	'cfaoffsetrows' => { 131 => 0xc6f },
	'cfapattern' => { 113 => 0xa302, 306 => 0x9, 452 => 'CFAPattern' },
	'cfapattern2' => { 113 => 0x828e },
	'cfapatterncolumns' => { 452 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 452 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 452 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 113 => 0x828d },
	'cfazipperfixthreshold' => { 131 => 0xe62 },
	'channel' => { 462 => 'channel' },
	'channela-lang' => { 462 => [\'channel','channelA-lang'] },
	'channelchannel' => { 462 => [\'channel','channelChannel'] },
	'channels' => { 146 => 'Channels' },
	'channelsubchannel1' => { 462 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 462 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 462 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 462 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 97 => 0x10101, 102 => 0x26a },
	'checkmark2' => { 103 => 0x8e },
	'childfontfiles' => { 477 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 261 => '10.3', 262 => '11.2' },
	'chromablurradius' => { 113 => 0xc631 },
	'chromanoisecolorspace' => { 131 => 0xe6d },
	'chromanoiseedgemapthresh' => { 131 => 0xe6c },
	'chromanoisehighfthresh' => { 131 => 0xe6a },
	'chromanoiselowfthresh' => { 131 => 0xe6b },
	'chromaticaberration' => { 97 => 0x20703, 103 => 0x66, 370 => 0xa051 },
	'chromaticaberrationb' => { 448 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 97 => 0x20708, 103 => 0x6b },
	'chromaticaberrationcorr' => { 74 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 113 => 0x7034, 326 => 0x1, 427 => 0x900d },
	'chromaticaberrationcorrparams' => { 113 => 0x7035, 422 => 0x66a, 423 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 97 => '0x20703.0', 103 => 0x62 },
	'chromaticaberrationr' => { 448 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 97 => 0x20707, 103 => 0x6a },
	'chromaticaberrationsetting' => { 75 => 0x6 },
	'chrominancenoisereduction' => { 97 => 0x20601, 103 => 0x5e, 373 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 103 => 0x60 },
	'circadatecreated' => { 458 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 448 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 448 => 'CircularGradientBasedCorrections' },
	'city' => { 125 => 0x5a, 152 => 'City', 301 => 0x6d, 460 => 'City' },
	'city2' => { 301 => 0x80 },
	'clarity' => { 217 => 0x35, 218 => 0x3d, 448 => 'Clarity' },
	'clarity2012' => { 448 => 'Clarity2012' },
	'claritycontrol' => { 336 => 0x96 },
	'classifystate' => { 125 => 0xe1 },
	'clearretouch' => { 301 => 0x7c },
	'clearretouchvalue' => { 301 => 0xa3 },
	'client' => { 472 => 'client' },
	'clientname' => { 454 => 'ClientName' },
	'clmodeshootingspeed' => { 261 => '10.2', 262 => '11.3', 264 => '11.2', 265 => '11.2', 270 => '11.2', 271 => '10.2', 274 => '11.2', 275 => '11.2', 276 => '11.1' },
	'cmcontrast' => { 286 => 0x2022 },
	'cmexposurecompensation' => { 286 => 0x2000 },
	'cmhue' => { 286 => 0x2021 },
	'cmsaturation' => { 286 => 0x2020 },
	'cmsharpness' => { 286 => 0x2023 },
	'cmwhitebalance' => { 286 => 0x2001 },
	'cmwhitebalancecomp' => { 286 => 0x2002 },
	'cmwhitebalancegraypoint' => { 286 => 0x2010 },
	'codec' => { 160 => 'Codec' },
	'codedcharacterset' => { 126 => 0x5a },
	'collection' => { 291 => 'Collection' },
	'collectionname' => { 161 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 161 => 'Collections', 442 => 'collections' },
	'collectionuri' => { 161 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 461 => 'color' },
	'coloraberrationcontrol' => { 254 => 0xc89224b },
	'coloradjustment' => { 373 => 0x14 },
	'coloradjustmentmode' => { 372 => 0x210 },
	'coloranta' => { 477 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 477 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 477 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 477 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 477 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 477 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 477 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 477 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 477 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 477 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 477 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 477 => 'Colorants' },
	'colorantswatchname' => { 477 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 477 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 477 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 477 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 147 => 'ColorBalance' },
	'colorbalanceadj' => { 254 => 0x76a43202 },
	'colorbalanceblue' => { 171 => 0x1e },
	'colorbalancegreen' => { 171 => 0x1d },
	'colorbalancered' => { 171 => 0x1c },
	'colorbalanceversion' => { 192 => 0x4, 193 => 0x4, 194 => 0x0 },
	'colorblur' => { 103 => 0x65 },
	'colorbluron' => { 97 => 0x20704 },
	'colorbooster' => { 254 => 0x5f0e7d23 },
	'colorboostlevel' => { 248 => 0x1 },
	'colorboosttype' => { 248 => 0x0 },
	'colorchromeeffect' => { 121 => 0x1048 },
	'colorclass' => { 347 => 0xde, 348 => 'ColorClass' },
	'colorcompensationfilter' => { 174 => [0x3a,0x5f], 176 => 0x111, 394 => 0xb022 },
	'colorcompensationfiltercustom' => { 381 => 0xd, 382 => 0xc },
	'colorcompensationfilterset' => { 381 => 0x8, 382 => 0x7, 383 => 0x18, 399 => 0xf },
	'colorcontrol' => { 283 => 0x102b },
	'colorcorrection' => { 427 => 0x8015 },
	'colorcreatoreffect' => { 278 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0 },
	'coloreffect' => { 301 => 0x28 },
	'colorfilter' => { 106 => 0x17, 107 => 0x3017, 171 => 0x29, 179 => [0x38,0x4d,0x4f], 343 => 0x17 },
	'colorgain' => { 222 => 0x51 },
	'colorhue' => { 97 => 0x20900, 214 => 0x8d },
	'colorimetricreference' => { 113 => 0xc6bf },
	'colorlabel' => { 451 => 'ColorLabel' },
	'colormatrix' => { 282 => 0x200, 283 => 0x1011, 370 => 0xa030 },
	'colormatrix1' => { 113 => 0xc621, 345 => 0x106 },
	'colormatrix2' => { 113 => 0xc622, 286 => 0x200, 345 => 0x226 },
	'colormatrixa' => { 336 => 0x203 },
	'colormatrixadobergb' => { 370 => 0xa032 },
	'colormatrixb' => { 336 => 0x204 },
	'colormatrixnumber' => { 283 => 0x1019 },
	'colormatrixsrgb' => { 370 => 0xa031 },
	'colormode' => { 107 => 0x3015, 121 => 0x1210, 133 => 0x66, 171 => 0x28, 174 => 0x16, 176 => 0x101, 177 => 0x36, 179 => 0x7, 214 => 0x3, 244 => 0x4, 301 => 0x32, 373 => 0x2c, 394 => 0xb029, 460 => 'ColorMode' },
	'colormoirereduction' => { 97 => 0x20670, 255 => 0x15 },
	'colormoirereductionmode' => { 255 => 0x5 },
	'colormoirereductionon' => { 97 => '0x20670.0' },
	'colornoisereduction' => { 427 => 0x8029, 448 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 448 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 255 => 0x18 },
	'colornoisereductionsharpness' => { 255 => 0x1c },
	'colornoisereductionsmoothness' => { 448 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 117 => 0x2 },
	'colorprofile' => { 171 => 0x33 },
	'colorprofilesettings' => { 278 => 0x539 },
	'colorrepresentation' => { 127 => 0x3c },
	'colorsaturationadj' => { 97 => 0x20305 },
	'colorsequence' => { 127 => 0x41 },
	'colorspace' => { 48 => 0x3, 60 => 0xb4, 91 => 0x10b4, 113 => 0xa001, 153 => 'ColorSpace', 172 => 0x2f, 173 => 0x25, 174 => 0x17, 214 => 0x1e, 278 => 0x507, 336 => 0x37, 370 => 0xa011, 373 => 0xb, 381 => 0x1b, 382 => 0x83, 383 => 0xe, 399 => 0x6, 452 => 'ColorSpace' },
	'colortempasshot' => { 37 => 0x4, 38 => 0x7, 39 => 0x1d, 40 => 0x26, 41 => 0x43, 44 => 0x43, 45 => 0x43, 46 => 0x43, 47 => 0x4b },
	'colortempauto' => { 37 => 0x9, 38 => 0xf, 39 => 0x22, 40 => 0x1c, 41 => 0x48, 44 => 0x48, 45 => 0x48, 46 => 0x48, 47 => 0x50 },
	'colortempcloudy' => { 37 => 0x22, 38 => 0x37, 39 => 0x31, 40 => 0x35, 41 => 0x5c, 44 => 0x75, 45 => 0x8e, 46 => 0x93, 47 => 0x96, 336 => 0x55 },
	'colortempcustom' => { 41 => 0x84 },
	'colortempcustom1' => { 39 => 0x45 },
	'colortempcustom2' => { 39 => 0x4a },
	'colortempdaylight' => { 37 => 0x18, 38 => 0x27, 39 => 0x27, 40 => 0x2b, 41 => 0x52, 44 => 0x6b, 45 => 0x84, 46 => 0x89, 47 => 0x8c, 336 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x135, 27 => 0x7b, 28 => 0x13a, 60 => 0xae, 70 => 0x9, 91 => 0x10ae, 121 => 0x1005, 131 => 0x846, 147 => 'ColorTemperature', 172 => [0x6e,0x49], 173 => 0x3f, 174 => [0x39,0x5e], 176 => 0x10b, 179 => [0x3c,0x4c,0x4e], 296 => 0x321, 336 => 0x50, 363 => 0x1308, 394 => 0xb021, 448 => 'Temperature' },
	'colortemperatureadj' => { 427 => 0x8013 },
	'colortemperatureauto' => { 214 => 0x4f },
	'colortemperaturebg' => { 283 => 0x1013 },
	'colortemperaturecustom' => { 381 => 0xc, 382 => 0xb },
	'colortemperaturerg' => { 283 => 0x1014 },
	'colortemperatureset' => { 381 => 0x7, 382 => 0x6 },
	'colortemperaturesetting' => { 174 => 0x25, 383 => 0x17, 399 => 0xe },
	'colortempflash' => { 37 => 0x36, 38 => 0x57, 39 => 0x40, 40 => 0x49, 41 => 0x70, 44 => 0x89, 45 => 0xa2, 46 => 0xa7, 47 => 0xaa, 336 => 0x5a },
	'colortempflashdata' => { 41 => 0x24a },
	'colortempfluorescent' => { 37 => 0x2c, 38 => 0x47, 39 => 0x3b, 40 => 0x3f, 41 => 0x66, 44 => 0x7f, 45 => 0x98, 46 => 0x9d, 47 => 0xa0 },
	'colortempfluorescentd' => { 336 => 0x57 },
	'colortempfluorescentn' => { 336 => 0x58 },
	'colortempfluorescentw' => { 336 => 0x59 },
	'colortempkelvin' => { 37 => 0x31, 38 => 0x4f, 40 => 0x44, 41 => 0x6b, 44 => 0x84, 45 => 0x9d, 46 => 0xa2, 47 => 0xa5, 301 => 0x44, 363 => 0x1307 },
	'colortempmeasured' => { 37 => 0xe, 38 => 0x17, 41 => 0x4d, 44 => 0x4d, 45 => 0x4d, 46 => 0x4d, 47 => 0x55 },
	'colortemppc1' => { 40 => 0x94, 41 => 0x75 },
	'colortemppc2' => { 40 => 0x99, 41 => 0x7a },
	'colortemppc3' => { 40 => 0x9e, 41 => 0x7f },
	'colortempshade' => { 37 => 0x1d, 38 => 0x2f, 39 => 0x2c, 40 => 0x30, 41 => 0x57, 44 => 0x70, 45 => 0x89, 46 => 0x8e, 47 => 0x91, 336 => 0x54 },
	'colortemptungsten' => { 37 => 0x27, 38 => 0x3f, 39 => 0x36, 40 => 0x3a, 41 => 0x61, 44 => 0x7a, 45 => 0x93, 46 => 0x98, 47 => 0x9b, 336 => 0x56 },
	'colortempunknown' => { 37 => 0x13, 38 => 0x1f, 40 => 0x21, 44 => 0x52, 45 => 0x52, 46 => 0x52, 47 => 0x5a },
	'colortempunknown10' => { 37 => 0x63, 38 => 0x9f, 40 => 0x76, 44 => 0xa2, 45 => 0x7f, 46 => 0x7f, 47 => 0x87 },
	'colortempunknown11' => { 37 => 0x68, 38 => 0xa7, 40 => 0x7b, 44 => 0xa7, 45 => 0xa7, 46 => 0x84, 47 => 0xaf },
	'colortempunknown12' => { 37 => 0x6d, 38 => 0xaf, 40 => 0x80, 44 => 0xac, 45 => 0xac, 46 => 0xac, 47 => 0xb4 },
	'colortempunknown13' => { 37 => 0x72, 38 => 0xb7, 40 => 0x85, 44 => 0xb1, 45 => 0xb1, 46 => 0xb1, 47 => 0xb9 },
	'colortempunknown14' => { 40 => 0x8a, 44 => 0xb6, 45 => 0xb6, 46 => 0xb6, 47 => 0xbe },
	'colortempunknown15' => { 40 => 0x8f, 44 => 0xbb, 45 => 0xbb, 46 => 0xbb, 47 => 0xc3 },
	'colortempunknown16' => { 40 => 0xa3, 45 => 0xc0, 46 => 0xc0, 47 => 0xc8 },
	'colortempunknown17' => { 45 => 0xc5, 46 => 0xc5, 47 => 0xcd },
	'colortempunknown18' => { 45 => 0xca, 46 => 0xca, 47 => 0xd2 },
	'colortempunknown19' => { 45 => 0xcf, 46 => 0xcf, 47 => 0xd7 },
	'colortempunknown2' => { 37 => 0x3b, 38 => 0x5f, 40 => 0x4e, 44 => 0x57, 45 => 0x57, 46 => 0x57, 47 => 0x5f },
	'colortempunknown20' => { 45 => 0xd4, 46 => 0xd4, 47 => 0xdc },
	'colortempunknown21' => { 46 => 0xd9, 47 => 0xe1 },
	'colortempunknown22' => { 46 => 0xde, 47 => 0xe6 },
	'colortempunknown23' => { 46 => 0xe3, 47 => 0xeb },
	'colortempunknown24' => { 46 => 0xe8, 47 => 0xf0 },
	'colortempunknown25' => { 46 => 0xed, 47 => 0xf5 },
	'colortempunknown26' => { 46 => 0xf2, 47 => 0xfa },
	'colortempunknown27' => { 46 => 0xf7, 47 => 0xff },
	'colortempunknown28' => { 46 => 0xfc, 47 => 0x104 },
	'colortempunknown29' => { 46 => 0x101, 47 => 0x109 },
	'colortempunknown3' => { 37 => 0x40, 38 => 0x67, 40 => 0x53, 44 => 0x5c, 45 => 0x5c, 46 => 0x5c, 47 => 0x64 },
	'colortempunknown30' => { 46 => 0x106 },
	'colortempunknown4' => { 37 => 0x45, 38 => 0x6f, 40 => 0x58, 44 => 0x61, 45 => 0x61, 46 => 0x61, 47 => 0x69 },
	'colortempunknown5' => { 37 => 0x4a, 38 => 0x77, 40 => 0x5d, 44 => 0x66, 45 => 0x66, 46 => 0x66, 47 => 0x6e },
	'colortempunknown6' => { 37 => 0x4f, 38 => 0x7f, 40 => 0x62, 44 => 0x8e, 45 => 0x6b, 46 => 0x6b, 47 => 0x73 },
	'colortempunknown7' => { 37 => 0x54, 38 => 0x87, 40 => 0x67, 44 => 0x93, 45 => 0x70, 46 => 0x70, 47 => 0x78 },
	'colortempunknown8' => { 37 => 0x59, 38 => 0x8f, 40 => 0x6c, 44 => 0x98, 45 => 0x75, 46 => 0x75, 47 => 0x7d },
	'colortempunknown9' => { 37 => 0x5e, 38 => 0x97, 40 => 0x71, 44 => 0x9d, 45 => 0x7a, 46 => 0x7a, 47 => 0x82 },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 33 => 0x2a, 48 => 0x2 },
	'colortoneadj' => { 97 => 0x20304, 102 => 0x11e },
	'colortoneauto' => { 67 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 66 => 0x6c, 67 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 66 => 0x3c, 67 => 0x3c },
	'colortonemonochrome' => { 66 => 0x84, 67 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 66 => 0x54, 67 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 66 => 0x24, 67 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 66 => 0xc, 67 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 66 => 0x9c, 67 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 66 => 0xb4, 67 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 66 => 0xcc, 67 => 0xe4 },
	'comlenblksize' => { 131 => 0xfde8 },
	'commanddials' => { 272 => '5.1' },
	'commanddialsaperturesetting' => { 261 => '17.3', 262 => '18.3', 264 => '18.3', 265 => '18.3', 270 => '33.3', 271 => '17.3', 274 => '18.3', 275 => '18.3' },
	'commanddialschangemainsub' => { 261 => '17.2', 262 => '18.1', 264 => '18.1', 265 => '18.1', 270 => '33.2', 271 => '17.2', 274 => '18.1', 275 => '18.1' },
	'commanddialsmenuandplayback' => { 261 => '17.4', 262 => '18.2', 264 => '18.2', 265 => '18.2', 270 => '33.4', 271 => '17.4', 274 => '18.2', 275 => '18.2' },
	'commanddialsreverserotation' => { 261 => '17.1', 262 => '6.4', 264 => '6.2', 265 => '6.2', 266 => '16.2', 267 => '17.2', 270 => '33.1', 271 => '17.1', 274 => '6.2', 275 => '6.2', 276 => '18.1' },
	'commanderchannel' => { 272 => '10.2', 273 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 272 => '13.1', 273 => '31.1' },
	'commandergroupa_ttlcomp' => { 276 => '32.1' },
	'commandergroupamanualoutput' => { 272 => '13.2', 273 => '28.2' },
	'commandergroupamode' => { 272 => '11.2', 273 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 272 => '14.1', 273 => '32.1' },
	'commandergroupb_ttlcomp' => { 276 => '33.1' },
	'commandergroupbmanualoutput' => { 272 => '14.2', 273 => '29.2' },
	'commandergroupbmode' => { 272 => '11.3', 273 => '29.1' },
	'commanderinternalflash' => { 272 => '11.1', 273 => '27.1' },
	'commanderinternalmanualoutput' => { 272 => '12.2', 273 => '27.2' },
	'commanderinternalttlchannel' => { 270 => '18.2' },
	'commanderinternalttlcomp' => { 272 => '12.1', 273 => '30.2', 276 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 270 => '20.1', 271 => '26.1' },
	'commanderinternalttlcompgroupa' => { 270 => '21.1', 271 => '27.1' },
	'commanderinternalttlcompgroupb' => { 270 => '22.1', 271 => '28.1' },
	'comment' => { 0 => 0x2, 114 => 'Comment', 148 => 'Comment', 291 => 'Comment' },
	'compass' => { 366 => 0x4 },
	'complianceprofile' => { 462 => 'complianceProfile' },
	'componentsconfiguration' => { 113 => 0x9101, 153 => 'Components', 452 => 'ComponentsConfiguration' },
	'componentversion' => { 91 => 0x80c },
	'composer' => { 472 => 'composer' },
	'composition' => { 437 => 'Composition' },
	'compositionadjust' => { 335 => '0.1' },
	'compositionadjustrotation' => { 335 => 0x7 },
	'compositionadjustx' => { 335 => 0x5 },
	'compositionadjusty' => { 335 => 0x6 },
	'compressedbitsperpixel' => { 113 => 0x9102, 452 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 176 => 0x40, 283 => 0x40 },
	'compression' => { 113 => 0x103, 306 => 0xb, 468 => 'Compression' },
	'compressionfactor' => { 278 => 0x50d },
	'compressionratio' => { 153 => 'Compression', 283 => 0x1034 },
	'condadobvfactor' => { 131 => 0xf3e },
	'condadodaybvthresh' => { 131 => 0xf3c },
	'condadodayoffsets' => { 131 => 0xf42 },
	'condadofluoffsets' => { 131 => 0xf44 },
	'condadofluthresh' => { 131 => 0xf41 },
	'condadoillfactor' => { 131 => 0xf3f },
	'condadoneurange' => { 131 => 0xf3d },
	'condadotunoffsets' => { 131 => 0xf43 },
	'condadotunthresh' => { 131 => 0xf40 },
	'confidence' => { 432 => 'Confidence' },
	'confidencelevel' => { 443 => 'ConfidenceLevel' },
	'confidencemime' => { 432 => 'ConfidenceMime' },
	'constrainedcropheight' => { 102 => 0x266, 347 => 0xd6 },
	'constrainedcropwidth' => { 102 => 0x262, 347 => 0xd5 },
	'contact' => { 125 => 0x76 },
	'contactinfo' => { 461 => 'contactInfo' },
	'containerformat' => { 458 => 'ContainerFormat' },
	'containerformatidentifier' => { 458 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 458 => [\'ContainerFormat','ContainerFormatName'] },
	'contentidentifier' => { 1 => 0x11 },
	'contentlocationcode' => { 125 => 0x1a },
	'contentlocationname' => { 125 => 0x1b },
	'contenttype' => { 462 => 'contentType' },
	'continuousbracketing' => { 174 => 0x20 },
	'continuousdrive' => { 33 => 0x5 },
	'continuousmodeliveview' => { 275 => '77.2' },
	'continuousshootingspeed' => { 78 => 0x610 },
	'continuousshotlimit' => { 78 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 33 => 0xd, 106 => 0xc, 107 => [0x3012,0x20], 113 => [0xa408,0xfe54], 121 => [0x1004,0x1006], 147 => 'Contrast', 167 => 'Contrast', 171 => 0x20, 172 => 0x31, 173 => 0x27, 174 => 0x19, 179 => 0x2, 216 => 0x33, 217 => 0x37, 218 => 0x3f, 283 => 0x1029, 301 => 0x39, 303 => 0x300a, 336 => 0x20, 343 => 0xc, 357 => 0x24, 359 => 0x52, 363 => 0x1012, 373 => 0xd, 381 => 0x1d, 382 => 0x1a, 394 => 0x2004, 448 => 'Contrast', 452 => 'Contrast' },
	'contrast2012' => { 448 => 'Contrast2012' },
	'contrastadj' => { 97 => 0x20303, 102 => 0x115, 257 => 0x2c, 427 => 0x8017 },
	'contrastauto' => { 67 => 0x90 },
	'contrastcurve' => { 214 => 0x8c },
	'contrastdetectaf' => { 183 => 0x4 },
	'contrastdetectafarea' => { 336 => 0x231 },
	'contrastdetectafinfocus' => { 183 => [0x1c,0x52] },
	'contrastfaithful' => { 18 => 0xec, 66 => 0x60, 67 => 0x60 },
	'contrasthighlight' => { 336 => 0x6d },
	'contrasthighlightshadowadj' => { 336 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 66 => 0x30, 67 => 0x30 },
	'contrastmode' => { 301 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 66 => 0x78, 67 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 66 => 0x48, 67 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 66 => 0x18, 67 => 0x18 },
	'contrastsetting' => { 278 => 0x505, 286 => 0x1012, 383 => 0x10, 399 => 0x8 },
	'contrastshadow' => { 336 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 66 => 0x0, 67 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 66 => 0x90, 67 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 66 => 0xa8, 67 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 66 => 0xc0, 67 => 0xd8 },
	'contributedmedia' => { 472 => 'contributedMedia' },
	'contributedmediaduration' => { 472 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 472 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 472 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 472 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 472 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 472 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 472 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 472 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 472 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 472 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 449 => 'contributor', 458 => 'Contributor' },
	'contributoridentifier' => { 458 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 458 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 458 => [\'Contributor','ContributorRole'] },
	'contributors' => { 148 => 'Contributors' },
	'controldialset' => { 174 => 0x46 },
	'controlledvocabularyterm' => { 458 => 'CVterm' },
	'controllerboardversion' => { 296 => 0x332 },
	'controlmode' => { 72 => 0x12 },
	'controlringrotation' => { 78 => 0x712 },
	'conversionlens' => { 279 => 0x403, 301 => 0x35 },
	'converter' => { 113 => 0xfe4d, 244 => 0xb, 448 => 'Converter' },
	'converttograyscale' => { 448 => 'ConvertToGrayscale' },
	'cookingequipment' => { 464 => 'cookingEquipment' },
	'cookingmethod' => { 464 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 113 => 0x8298, 148 => 'Copyright', 291 => 'Copyright', 336 => 0x22f, 352 => 'Copyright', 459 => 'Copyright', 465 => 'copyright', 468 => 'Copyright', 472 => 'copyright' },
	'copyrightflag' => { 350 => 0x40a },
	'copyrightnotice' => { 125 => 0x74 },
	'copyrightowner' => { 288 => 'CopyrightOwner' },
	'copyrightownerid' => { 288 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 288 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 288 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 288 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 288 => 'CopyrightStatus' },
	'copyrightyear' => { 458 => 'CopyrightYear', 462 => 'copyrightYear' },
	'coringfilter' => { 282 => 0x310, 283 => 0x102d, 286 => 0x310 },
	'coringvalues' => { 282 => 0x311, 286 => 0x311 },
	'corporateentity' => { 462 => 'corporateEntity' },
	'country' => { 152 => 'Country', 301 => 0x69, 460 => 'Country' },
	'country-primarylocationcode' => { 125 => 0x64 },
	'country-primarylocationname' => { 125 => 0x65 },
	'countrycode' => { 213 => 0x5, 348 => 'CountryCode', 457 => 'CountryCode' },
	'course' => { 464 => 'course' },
	'coverage' => { 449 => 'coverage' },
	'coverdate' => { 462 => 'coverDate' },
	'coverdisplaydate' => { 462 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 336 => 0x28 },
	'crc32' => { 450 => 'crc32' },
	'createdate' => { 113 => 0x9004, 148 => 'CreateDate', 287 => 'CreationDate', 291 => 'create-date', 352 => 'CreationDate', 354 => 0x1, 470 => 'CreateDate' },
	'creationdate' => { 459 => 'CreationDate', 462 => 'creationDate' },
	'creationtime' => { 291 => 'Creation Time' },
	'creativestyle' => { 381 => 0x1a, 382 => 0x18, 392 => 0x41, 394 => 0xb020, 423 => 0x4a },
	'creativestylesetting' => { 383 => 0xf, 399 => 0x7 },
	'creativestylewaschanged' => { 427 => 0x8001 },
	'creator' => { 287 => 'Creator', 352 => 'Creator', 449 => 'creator', 458 => 'Creator', 459 => 'Creator' },
	'creatoraddress' => { 457 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 169 => 'CreatorAppId' },
	'creatorcity' => { 457 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 457 => 'CreatorContactInfo' },
	'creatorcountry' => { 457 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 458 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 458 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 169 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 457 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 457 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 458 => [\'Creator','CreatorRole'] },
	'creatortool' => { 470 => 'CreatorTool' },
	'creatorworkemail' => { 457 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 457 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 457 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 125 => 0x6e, 460 => 'Credit' },
	'creditline' => { 465 => 'creditLine' },
	'creditlinereq' => { 475 => 'CreditLineReq' },
	'creditlinerequired' => { 288 => 'CreditLineRequired' },
	'cropactive' => { 95 => 0x0, 102 => 0x244 },
	'cropangle' => { 448 => 'CropAngle' },
	'croparea' => { 427 => 0x9011 },
	'cropaspectratio' => { 97 => 0x30101, 102 => 0x260 },
	'cropaspectratiocustom' => { 97 => 0x30102 },
	'cropbottom' => { 117 => 0x9, 249 => 0x36, 306 => 0x31, 347 => 0xdc, 448 => 'CropBottom' },
	'cropbottommargin' => { 50 => 0x3 },
	'cropcircleactive' => { 103 => 0xd6 },
	'cropcircleradius' => { 103 => 0xd9 },
	'cropcirclex' => { 103 => 0xd7 },
	'cropcircley' => { 103 => 0xd8 },
	'cropconstraintowarp' => { 448 => 'CropConstrainToWarp' },
	'croph' => { 441 => 'CropH' },
	'cropheight' => { 95 => 0x6, 102 => 0x24c, 282 => 0x615, 286 => 0x615, 448 => 'CropHeight' },
	'crophispeed' => { 214 => 0x1b },
	'cropleft' => { 102 => 0x246, 117 => 0x6, 249 => 0x1e, 282 => 0x612, 286 => 0x612, 306 => 0x30, 347 => 0xd9, 448 => 'CropLeft' },
	'cropleftmargin' => { 50 => 0x0 },
	'cropmode' => { 121 => 0x104d },
	'cropmode35mm' => { 363 => 0x1018 },
	'croporiginalheight' => { 95 => 0xb },
	'croporiginalwidth' => { 95 => 0xa },
	'cropoutputheight' => { 249 => 0xce },
	'cropoutputheightinches' => { 249 => 0x96 },
	'cropoutputpixels' => { 249 => 0xd6 },
	'cropoutputresolution' => { 249 => 0xb6 },
	'cropoutputscale' => { 249 => 0xbe },
	'cropoutputwidth' => { 249 => 0xc6 },
	'cropoutputwidthinches' => { 249 => 0x8e },
	'croppedareaimageheightpixels' => { 435 => 'CroppedAreaImageHeightPixels', 436 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 435 => 'CroppedAreaImageWidthPixels', 436 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 435 => 'CroppedAreaLeftPixels', 436 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 435 => 'CroppedAreaTopPixels', 436 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 363 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 363 => 0x1603 },
	'cropping' => { 427 => 0x9010 },
	'cropright' => { 117 => 0x8, 249 => 0x2e, 306 => 0x32, 347 => 0xdb, 448 => 'CropRight' },
	'croprightmargin' => { 50 => 0x1 },
	'croprotatedoriginalheight' => { 95 => 0x2 },
	'croprotatedoriginalwidth' => { 95 => 0x1 },
	'croprotation' => { 95 => 0x8, 117 => 0xb },
	'cropscaledresolution' => { 249 => 0x9e },
	'cropsourceresolution' => { 249 => 0xae },
	'croptop' => { 102 => 0x248, 117 => 0x7, 249 => 0x26, 282 => 0x613, 286 => 0x613, 306 => 0x2f, 347 => 0xda, 448 => 'CropTop' },
	'croptopmargin' => { 50 => 0x2 },
	'cropunit' => { 448 => 'CropUnit' },
	'cropunits' => { 448 => 'CropUnits' },
	'cropw' => { 441 => 'CropW' },
	'cropwidth' => { 95 => 0x5, 102 => 0x24a, 282 => 0x614, 286 => 0x614, 448 => 'CropWidth' },
	'cropx' => { 95 => 0x3, 441 => 'CropX' },
	'cropy' => { 95 => 0x4, 441 => 'CropY' },
	'crossprocess' => { 336 => 0x7b },
	'crossprocessparams' => { 336 => 0x235 },
	'cuisine' => { 464 => 'cuisine' },
	'currenticcprofile' => { 113 => 0xc691 },
	'currentpreprofilematrix' => { 113 => 0xc692 },
	'currentversion' => { 427 => 0xd000 },
	'curve0x' => { 441 => 'Curve0x' },
	'curve0y' => { 441 => 'Curve0y' },
	'curve1x' => { 441 => 'Curve1x' },
	'curve1y' => { 441 => 'Curve1y' },
	'curve2x' => { 441 => 'Curve2x' },
	'curve2y' => { 441 => 'Curve2y' },
	'curve3x' => { 441 => 'Curve3x' },
	'curve3y' => { 441 => 'Curve3y' },
	'curve4x' => { 441 => 'Curve4x' },
	'curve4y' => { 441 => 'Curve4y' },
	'curves' => { 254 => 0x76a43201 },
	'custom1' => { 288 => 'Custom1' },
	'custom10' => { 288 => 'Custom10' },
	'custom2' => { 288 => 'Custom2' },
	'custom3' => { 288 => 'Custom3' },
	'custom4' => { 288 => 'Custom4' },
	'custom5' => { 288 => 'Custom5' },
	'custom6' => { 288 => 'Custom6' },
	'custom7' => { 288 => 'Custom7' },
	'custom8' => { 288 => 'Custom8' },
	'custom9' => { 288 => 'Custom9' },
	'customcolortone' => { 103 => 0x4c },
	'customcontrast' => { 103 => 0x4e },
	'customcontrols' => { 78 => 0x70c },
	'customdefaultunsharpfineness' => { 103 => 0xbe },
	'customdefaultunsharpstrength' => { 103 => 0xbc },
	'customdefaultunsharpthreshold' => { 103 => 0xc0 },
	'customilluminant' => { 131 => 0x405 },
	'customizedials' => { 78 => 0x715 },
	'customlinear' => { 103 => 0x4f },
	'customoutputhighlightpoint' => { 103 => 0x53 },
	'customoutputshadowpoint' => { 103 => 0x54 },
	'custompicturestyle' => { 97 => 0x10021 },
	'custompicturestyledata' => { 97 => 0xf0500 },
	'custompicturestylefilename' => { 60 => 0x4010 },
	'customrawhighlight' => { 103 => 0x7c },
	'customrawhighlightpoint' => { 103 => 0x51 },
	'customrawshadow' => { 103 => 0x85 },
	'customrawshadowpoint' => { 103 => 0x52 },
	'customrendered' => { 113 => 0xa401, 452 => 'CustomRendered' },
	'customsaturation' => { 103 => 0x4d, 278 => 0x503 },
	'customsettingsalldefault' => { 261 => '0.2', 270 => '0.2' },
	'customsettingsbank' => { 261 => '0.1', 262 => '0.1', 264 => '0.1', 265 => '0.1', 270 => '0.1', 274 => '0.2', 275 => '0.2' },
	'customsharpness' => { 103 => 0x50 },
	'customunsharpmaskfineness' => { 103 => 0xb8 },
	'customunsharpmaskstrength' => { 103 => 0xb6 },
	'customunsharpmaskthreshold' => { 103 => 0xba },
	'customwb_rblevels' => { 399 => 0x1a },
	'customwb_rgblevels' => { 382 => 0x8, 383 => 0x19 },
	'customwbbluelevel' => { 174 => 0x36 },
	'customwberror' => { 174 => 0x37 },
	'customwbgreenlevel' => { 174 => 0x35 },
	'customwbredlevel' => { 174 => 0x34 },
	'customwbsetting' => { 174 => 0x26 },
	'd-lightinghq' => { 254 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 250 => 0x2 },
	'd-lightinghqhighlight' => { 250 => 0x1 },
	'd-lightinghqselected' => { 254 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 250 => 0x0 },
	'd-lightinghs' => { 254 => 0xce5554aa },
	'd-lightinghsadjustment' => { 251 => 0x0 },
	'd-lightinghscolorboost' => { 251 => 0x1 },
	'd-rangeoptimizerhighlight' => { 427 => 0x8024 },
	'd-rangeoptimizermode' => { 427 => 0x8022 },
	'd-rangeoptimizershadow' => { 427 => 0x802d },
	'd-rangeoptimizervalue' => { 427 => 0x8023 },
	'd810meteringmode' => { 241 => 0x175e },
	'darkblacksegrows' => { 131 => 0x18d8 },
	'darkfocusenvironment' => { 301 => 0x8003 },
	'darkframecountfactor' => { 131 => 0xc85 },
	'darkframelongexposure' => { 131 => 0xc84 },
	'darkframeshortexposure' => { 131 => 0xc83 },
	'darkpedestal' => { 131 => 0xc7f },
	'data' => { 432 => 'Data' },
	'datacompressionmethod' => { 127 => 0x6e },
	'dataimprint' => { 171 => 0x34 },
	'dataonscreen' => { 458 => 'DataOnScreen' },
	'dataonscreenregion' => { 458 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 458 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 458 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 458 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 458 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 458 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 458 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 458 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 336 => 0x3d },
	'date' => { 336 => 0x6, 449 => 'date' },
	'dateacquired' => { 169 => 'DateAcquired' },
	'datecreated' => { 125 => 0x37, 460 => 'DateCreated' },
	'datedisplayformat' => { 246 => 0x3 },
	'dateidentified' => { 112 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 266 => '4.2' },
	'daterecieved' => { 462 => 'dateRecieved' },
	'datesent' => { 126 => 0x46 },
	'datestampmode' => { 60 => 0x1c },
	'datetime' => { 442 => 'datetime', 468 => 'DateTime' },
	'datetimedigitized' => { 452 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 94 => 0x0, 113 => 0x9003, 145 => 0x14, 148 => 'OriginalDate', 357 => 0xb, 358 => 0x3b, 359 => 0x3e, 452 => 'DateTimeOriginal' },
	'datetimestamp' => { 133 => 0x64 },
	'datetimeutc' => { 278 => 0x908 },
	'daylightsavings' => { 73 => 0x3, 246 => 0x2 },
	'dayofweek' => { 358 => 0x42, 359 => 0x4a },
	'dccontinent' => { 112 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 112 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 112 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 112 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 112 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 112 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 112 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 112 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 112 => 'Event' },
	'dcfootprintspatialfit' => { 112 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 112 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 112 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 112 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 112 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 112 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 112 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 112 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 112 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 112 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 112 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 112 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 112 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 112 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 112 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 112 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 112 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 156 => 'Declination' },
	'decposition' => { 171 => 0x32 },
	'defaultautogray' => { 448 => 'DefaultAutoGray' },
	'defaultautotone' => { 448 => 'DefaultAutoTone' },
	'defaultblackrender' => { 113 => 0xc7a6 },
	'defaultcroporigin' => { 113 => 0xc61f },
	'defaultcropsize' => { 113 => 0xc620 },
	'defaulteraseoption' => { 78 => 0x813 },
	'defaultscale' => { 113 => 0xc61e },
	'defaultsspecifictoiso' => { 448 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 448 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 113 => 0xc7b5 },
	'defectisocode' => { 131 => 0x90f },
	'defringe' => { 448 => 'Defringe' },
	'defringegreenamount' => { 448 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 448 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 448 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 448 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 448 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 448 => 'DefringePurpleHueLo' },
	'dehaze' => { 448 => 'Dehaze' },
	'deletedimagecount' => { 214 => 0xa6, 223 => 0x6e },
	'deprecatedon' => { 445 => 'deprecatedOn' },
	'derivedfrom' => { 473 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 473 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 473 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 473 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 473 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 473 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 473 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 473 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 473 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 473 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 473 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 473 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 473 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 473 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 473 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 473 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 473 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 473 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 473 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 473 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 473 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 473 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 473 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 473 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 291 => 'Description', 449 => 'description', 470 => 'Description' },
	'destination' => { 126 => 0x5 },
	'destinationcity' => { 336 => 0x24, 342 => 0x3 },
	'destinationcitycode' => { 343 => 0x1001 },
	'destinationdst' => { 336 => 0x26, 342 => '0.3' },
	'developmentdynamicrange' => { 121 => 0x1403 },
	'deviantmatrixcustom' => { 131 => 0x7de },
	'deviantmatrixdaylight' => { 131 => 0x7da },
	'deviantmatrixflash' => { 131 => 0x7dd },
	'deviantmatrixfluorescent' => { 131 => 0x7dc },
	'deviantmatrixtungsten' => { 131 => 0x7db },
	'deviantwhitecustom' => { 131 => 0x842 },
	'deviantwhitedaylight' => { 131 => 0x83e },
	'deviantwhiteflash' => { 131 => 0x841 },
	'deviantwhitefluorescent' => { 131 => 0x840 },
	'deviantwhitetungsten' => { 131 => 0x83f },
	'device' => { 462 => 'device' },
	'devicesettingdescription' => { 452 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 452 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 452 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 452 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 370 => 0x2 },
	'dewarpdata' => { 110 => 'DewarpData' },
	'dewarpflag' => { 110 => 'DewarpFlag' },
	'dialdirectiontvav' => { 78 => 0x706 },
	'dietaryneeds' => { 464 => 'dietaryNeeds' },
	'diffractioncorrection' => { 301 => 0xbc, 326 => 0x3 },
	'diffractioncorrectionon' => { 97 => 0x2070b },
	'digitalcreationdate' => { 125 => 0x3e },
	'digitalcreationtime' => { 125 => 0x3f },
	'digitaldeehighlightadj' => { 222 => 0x202 },
	'digitaldeeshadowadj' => { 222 => 0x200 },
	'digitaldeethreshold' => { 222 => 0x201 },
	'digitalfilter' => { 373 => 0x59 },
	'digitalfilter01' => { 323 => 0x5 },
	'digitalfilter02' => { 323 => 0x16 },
	'digitalfilter03' => { 323 => 0x27 },
	'digitalfilter04' => { 323 => 0x38 },
	'digitalfilter05' => { 323 => 0x49 },
	'digitalfilter06' => { 323 => 0x5a },
	'digitalfilter07' => { 323 => 0x6b },
	'digitalfilter08' => { 323 => 0x7c },
	'digitalfilter09' => { 323 => 0x8d },
	'digitalfilter10' => { 323 => 0x9e },
	'digitalfilter11' => { 323 => 0xaf },
	'digitalfilter12' => { 323 => 0xc0 },
	'digitalfilter13' => { 323 => 0xd1 },
	'digitalfilter14' => { 323 => 0xe2 },
	'digitalfilter15' => { 323 => 0xf3 },
	'digitalfilter16' => { 323 => 0x104 },
	'digitalfilter17' => { 323 => 0x115 },
	'digitalfilter18' => { 323 => 0x126 },
	'digitalfilter19' => { 323 => 0x137 },
	'digitalfilter20' => { 323 => 0x148 },
	'digitalgain' => { 70 => 0xb },
	'digitalgem' => { 203 => 0x0 },
	'digitalice' => { 222 => 0x100 },
	'digitalimageguid' => { 458 => 'DigImageGUID' },
	'digitalroc' => { 220 => 0x0 },
	'digitalsourcefiletype' => { 458 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 458 => 'DigitalSourceType' },
	'digitalzoom' => { 33 => 0xc, 106 => 0xa, 121 => 0x1044, 133 => 0x68, 147 => 'DigitalZoom', 171 => 0xc, 214 => 0x86, 244 => 0xa, 283 => 0x204, 336 => 0x1e, 343 => 0xa, 372 => 0x204, 414 => 0x12, 415 => 0x12 },
	'digitalzoomon' => { 372 => 0x21b },
	'digitalzoomratio' => { 113 => 0xa404, 404 => 0x200, 406 => 0x21c, 452 => 'DigitalZoomRatio' },
	'director' => { 472 => 'director' },
	'directorphotography' => { 472 => 'directorPhotography' },
	'directory' => { 114 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 27 => 0x1f7, 28 => 0x4ba },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 197 => 0x3, 359 => 0x12 },
	'disclaimer' => { 291 => 'Disclaimer' },
	'discnumber' => { 472 => 'discNumber' },
	'dishtype' => { 464 => 'dishType' },
	'displayallafpoints' => { 78 => 0x514 },
	'displayaperture' => { 33 => 0x23 },
	'displayedunitsx' => { 351 => 0x2 },
	'displayedunitsy' => { 351 => 0x6 },
	'displayname' => { 461 => 'displayName' },
	'distance1' => { 133 => 0x28 },
	'distance2' => { 133 => 0x2c },
	'distance3' => { 133 => 0x30 },
	'distance4' => { 133 => 0x34 },
	'distortion' => { 370 => 0xa050 },
	'distortioncompensation' => { 427 => 0x8040 },
	'distortioncontrol' => { 223 => 0x10 },
	'distortioncorrection' => { 97 => 0x20705, 103 => 0x67, 113 => 0x7036, 278 => 0x50b, 305 => '7.1', 326 => 0x0, 422 => 0x601, 423 => 0x5b },
	'distortioncorrection2' => { 282 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 444 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 97 => '0x20705.0', 103 => 0x63 },
	'distortioncorrectionsetting' => { 394 => 0x2013 },
	'distortioncorrparams' => { 113 => 0x7037, 403 => 0x1a23, 406 => 0x1870, 408 => 0x189c, 409 => 0x18cc, 410 => 0x17d0, 422 => 0x6ca, 423 => 0x64 },
	'distortioncorrparamsnumber' => { 406 => 0x1899, 408 => 0x18c5, 409 => 0x18f5, 410 => 0x17f9 },
	'distortioncorrparamspresent' => { 406 => 0x1898, 408 => 0x18c4, 409 => 0x18f4, 410 => 0x17f8, 412 => 0x10b, 413 => 0x10b, 422 => 0x600, 423 => 0x5a },
	'distortioneffect' => { 97 => 0x20709 },
	'distortionn' => { 305 => 0xc },
	'distortionparam02' => { 305 => 0x2 },
	'distortionparam04' => { 305 => 0x4 },
	'distortionparam08' => { 305 => 0x8 },
	'distortionparam09' => { 305 => 0x9 },
	'distortionparam11' => { 305 => 0xb },
	'distortionscale' => { 305 => 0x5 },
	'distributor' => { 462 => 'distributor' },
	'distributorproductid' => { 461 => 'distributorProductID' },
	'dloon' => { 97 => '0x20706.0', 103 => 0xdc },
	'dlosetting' => { 97 => 0x20706, 103 => 0xdd },
	'dlosettingapplied' => { 96 => 0x4 },
	'dloshootingdistance' => { 103 => 0xde },
	'dloversion' => { 96 => 0x5 },
	'dmcomment' => { 472 => 'comment' },
	'dmdithermatrix' => { 131 => 0xc7a },
	'dmdithermatrixheight' => { 131 => 0xc7c },
	'dmdithermatrixwidth' => { 131 => 0xc7b },
	'dngadobedata' => { 113 => 0xc634 },
	'dngbackwardversion' => { 113 => 0xc613 },
	'dngignoresidecars' => { 448 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 113 => 0xc630 },
	'dngprivatedata' => { 113 => 0xc634 },
	'dngversion' => { 113 => 0xc612 },
	'document' => { 291 => 'Document' },
	'documentancestors' => { 460 => 'DocumentAncestors' },
	'documenthistory' => { 125 => 0xe7 },
	'documentid' => { 473 => 'DocumentID' },
	'documentname' => { 113 => 0x10d },
	'documentnotes' => { 125 => 0xe6 },
	'doi' => { 462 => 'doi' },
	'dopesheet' => { 458 => 'Dopesheet' },
	'dopesheetlink' => { 458 => 'DopesheetLink' },
	'dopesheetlinklink' => { 458 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 458 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 131 => 0xc82 },
	'dpp' => { 442 => 'dpp' },
	'dr4cameramodel' => { 98 => 0x3 },
	'drangepriority' => { 121 => 0x1443 },
	'drangepriorityauto' => { 121 => 0x1444 },
	'drangepriorityfixed' => { 121 => 0x1445 },
	'drivemode' => { 107 => 0x3103, 119 => '0.1', 171 => 0x6, 174 => 0x1e, 177 => 0xe, 278 => 0x600, 336 => 0x34, 363 => 0x1002, 373 => 0x3, 381 => 0x4, 382 => 0x7e, 383 => 0x34 },
	'drivemode2' => { 174 => 0xa, 317 => 0x7, 392 => 0xe, 399 => 0x1 },
	'drivemodesetting' => { 383 => 0x4 },
	'drivespeed' => { 119 => '0.2' },
	'dspfirmwareversion' => { 336 => 0x27 },
	'duration' => { 63 => 0x6a, 146 => 'Duration', 160 => 'Duration', 464 => 'duration', 472 => 'duration' },
	'durationscale' => { 472 => [\'duration','durationScale'] },
	'durationvalue' => { 472 => [\'duration','durationValue'] },
	'dustremovaldata' => { 60 => 0x97 },
	'dynamicafarea' => { 261 => '1.4', 270 => '1.4' },
	'dynamicareaafdisplay' => { 262 => '46.1', 264 => '47.1', 265 => '47.1', 274 => '47.1', 275 => '47.1' },
	'dynamicrange' => { 121 => 0x1400 },
	'dynamicrangeexpansion' => { 336 => 0x69, 363 => 0x100e },
	'dynamicrangemax' => { 102 => 0x7c },
	'dynamicrangemin' => { 102 => 0x7a },
	'dynamicrangeoptimizer' => { 174 => 0x15, 394 => [0xb025,0xb04f], 402 => 0x1144, 403 => [0x1144,0x324], 404 => [0x1120,0x300], 405 => [0x119c,0x37c], 406 => [0x1178,0x328], 407 => [0x1030,0x50], 408 => [0x228,0x50], 409 => [0x228,0x50], 410 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 392 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 381 => 0x19, 382 => 0x17, 383 => 0xd, 392 => 0x79, 399 => 0x5 },
	'dynamicrangeoptimizermode' => { 177 => 0x15, 381 => 0x18, 382 => 0x16, 392 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 174 => 0x27, 383 => 0xc, 399 => 0x4 },
	'dynamicrangesetting' => { 121 => 0x1402 },
	'e-dialinprogram' => { 317 => '1.3' },
	'earliestageorloweststage' => { 112 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 276 => '6.1' },
	'easyexposurecompensation' => { 261 => '6.4', 262 => '6.5', 264 => '6.3', 265 => '6.3', 269 => '5.1', 270 => '4.4', 271 => '5.2', 274 => '6.3', 275 => '6.3' },
	'easymode' => { 33 => 0xb },
	'edgemapslope' => { 131 => 0x930 },
	'edgemapx1' => { 131 => 0x931 },
	'edgemapx2' => { 131 => 0x932 },
	'edgemapx3' => { 131 => 0x934 },
	'edgemapx4' => { 131 => 0x935 },
	'edgenoisereduction' => { 255 => 0x4, 427 => 0x8028 },
	'edition' => { 462 => 'edition' },
	'editorialupdate' => { 125 => 0x8 },
	'editstatus' => { 125 => 0x7, 348 => 'EditStatus', 442 => 'EditStatus' },
	'editversionname' => { 254 => 0x3d136244 },
	'effectivelv' => { 336 => 0x2d },
	'effectivemaxaperture' => { 207 => 0x12, 208 => 0x13, 212 => 0x14 },
	'eissn' => { 462 => 'eIssn' },
	'electricalblackcolumns' => { 131 => 0x1810 },
	'electronicfront-curtainshutter' => { 264 => '5.2', 265 => '5.2', 274 => '5.3', 275 => '5.2' },
	'electronicfrontcurtainshutter' => { 394 => 0x201a },
	'elevation' => { 156 => 'Elevation' },
	'email' => { 148 => 'EMail' },
	'embargodate' => { 465 => 'embargoDate' },
	'embdencrightsexpr' => { 458 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 458 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 458 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 458 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 460 => 'EmbeddedXMPDigest' },
	'emissivity' => { 115 => 0x3 },
	'enablechromanoisereduction' => { 131 => 0xe6e },
	'enablesharpening' => { 131 => 0x92e },
	'encryptionkey' => { 370 => 0xa020 },
	'endingpage' => { 462 => 'endingPage' },
	'enduser' => { 288 => 'EndUser' },
	'enduserid' => { 288 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 288 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 472 => 'engineer' },
	'enhancedarktones' => { 247 => 0x8 },
	'enhancement' => { 106 => 0x16, 107 => 0x3016 },
	'enhancer' => { 282 => 0x300 },
	'enhancervalues' => { 282 => 0x301 },
	'envelopenumber' => { 126 => 0x28 },
	'envelopepriority' => { 126 => 0x3c },
	'enveloperecordversion' => { 126 => 0x0 },
	'episode' => { 458 => 'Episode' },
	'episodeidentifier' => { 458 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 458 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 458 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 283 => 0x20c },
	'epsonimagewidth' => { 283 => 0x20b },
	'epsonsoftware' => { 283 => 0x20d },
	'equipmentinstitution' => { 429 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 429 => 'EquipmentManufacturer' },
	'equipmentversion' => { 279 => 0x0 },
	'ettlii' => { 78 => 0x304, 79 => 0xd, 80 => 0xe, 81 => 0x7, 82 => 0x7, 83 => 0xe },
	'event' => { 430 => 'Event', 440 => 'Event', 458 => 'Event', 462 => 'event' },
	'eventalias' => { 461 => 'eventAlias' },
	'eventdate' => { 112 => [\'Event','EventEventDate'] },
	'eventday' => { 112 => [\'Event','EventDay'] },
	'eventearliestdate' => { 112 => [\'Event','EventEarliestDate'] },
	'eventend' => { 461 => 'eventEnd' },
	'eventenddayofyear' => { 112 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 112 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 112 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 112 => [\'Event','EventHabitat'] },
	'eventid' => { 112 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 112 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 112 => [\'Event','EventMonth'] },
	'eventnumber' => { 357 => 0x9, 358 => 0x37, 359 => 0x3a },
	'eventparenteventid' => { 112 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 112 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 112 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 112 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 112 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 112 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 461 => 'eventStart' },
	'eventstartdayofyear' => { 112 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 461 => 'eventSubtype' },
	'eventtime' => { 112 => [\'Event','EventEventTime'] },
	'eventtype' => { 461 => 'eventType' },
	'eventverbatimeventdate' => { 112 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 112 => [\'Event','EventYear'] },
	'evsteps' => { 317 => '1.2', 319 => 0x0 },
	'evstepsize' => { 266 => '5.1', 267 => '6.1', 268 => '6.1', 272 => '0.7' },
	'exclusivecoverage' => { 437 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 465 => 'exclusivityEndDate' },
	'excursiontolerance' => { 127 => 0x82 },
	'exif' => { 114 => 'EXIF' },
	'exifbyteorder' => { 114 => 'ExifByteOrder' },
	'exifcamerainfo' => { 125 => 0xe8 },
	'exifimageheight' => { 113 => 0xa003, 452 => 'PixelYDimension' },
	'exifimagewidth' => { 113 => 0xa002, 452 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 114 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 113 => 0x9000, 452 => 'ExifVersion' },
	'exitpupilposition' => { 207 => 0x4, 208 => 0x4, 212 => 0x4 },
	'expirationdate' => { 125 => 0x25, 465 => 'expirationDate' },
	'expirationtime' => { 125 => 0x26 },
	'exposure' => { 113 => 0xfe51, 448 => 'Exposure' },
	'exposure2012' => { 448 => 'Exposure2012' },
	'exposureadj' => { 252 => 0x0 },
	'exposureadj2' => { 252 => 0x12 },
	'exposureadjust' => { 373 => 0xc },
	'exposurebracketingindicatorlast' => { 174 => 0x52 },
	'exposurebracketshotnumber' => { 177 => 0x2d, 392 => 0x2f },
	'exposurebracketstepsize' => { 317 => 0x8 },
	'exposurebracketvalue' => { 214 => 0x19 },
	'exposurecompautocancel' => { 78 => 0x113 },
	'exposurecompensation' => { 72 => 0x6, 87 => 0x0, 113 => 0x9204, 133 => 0x24, 147 => 'ExposureComp', 167 => 'ExposureCompensation', 171 => 0xd, 172 => 0x53, 173 => 0x1e, 177 => 0x49c0, 283 => 0x1006, 336 => 0x16, 345 => 0x402, 370 => 0xa013, 373 => [0xc,0x35,0x4d], 402 => 0x114c, 403 => 0x114c, 404 => 0x1128, 406 => 0x1180, 407 => 0x1038, 408 => 0x230, 409 => 0x230, 410 => 0x223, 452 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 399 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 174 => 0x47, 177 => 0x2a },
	'exposurecompensationset' => { 381 => 0x3, 382 => 0x3, 383 => 0x3, 399 => 0x1e },
	'exposurecompensationsetting' => { 174 => 0x1 },
	'exposurecompstepsize' => { 261 => '6.3', 262 => '7.3', 264 => '7.3', 265 => '7.3', 270 => '4.3', 274 => '7.3', 275 => '7.3' },
	'exposurecontrolstep' => { 269 => '6.1', 271 => '6.1' },
	'exposurecontrolstepsize' => { 261 => '6.2', 262 => '7.1', 264 => '7.1', 265 => '7.1', 270 => '4.2', 274 => '7.1', 275 => '7.1', 276 => '7.1' },
	'exposurecount' => { 121 => 0x1032 },
	'exposuredelaymode' => { 261 => '10.1', 262 => '11.1', 264 => '11.1', 265 => '11.1', 266 => '9.1', 267 => '10.1', 268 => '10.1', 270 => '10.4', 271 => '10.1', 272 => '6.4', 274 => '11.1', 275 => '11.1', 276 => '11.2' },
	'exposuredifference' => { 214 => 0xe },
	'exposuregaincustom' => { 131 => 0x89c },
	'exposuregaindaylight' => { 131 => 0x898 },
	'exposuregainflash' => { 131 => 0x89b },
	'exposuregainfluorescent' => { 131 => 0x89a },
	'exposuregaintungsten' => { 131 => 0x899 },
	'exposureindex' => { 113 => 0xa215, 452 => 'ExposureIndex' },
	'exposureindicator' => { 174 => 0x50 },
	'exposurelevelincrements' => { 76 => 0x6, 77 => 0x6, 78 => 0x101, 79 => 0x5, 80 => 0x6, 81 => 0x5, 82 => 0x5, 83 => 0x6, 84 => 0x4, 381 => 0x58, 382 => 0x58 },
	'exposurelockused' => { 435 => 'ExposureLockUsed' },
	'exposuremode' => { 113 => 0xa402, 147 => 'ExposureMode', 171 => 0x1, 172 => 0xa, 173 => 0x0, 174 => 0x0, 177 => 0x34, 278 => 0x200, 298 => 0x40d, 373 => 0x8, 394 => 0xb041, 452 => 'ExposureMode' },
	'exposuremodeinmanual' => { 78 => 0x10b },
	'exposureprogram' => { 113 => 0x8822, 363 => 0x1001, 374 => [0x17e,0x43], 381 => 0x3c, 382 => 0x3c, 383 => 0x5, 387 => 0x14, 392 => 0x3f, 399 => 0x2, 402 => 0x1175, 403 => 0x1179, 404 => 0x1155, 405 => 0x11d1, 406 => 0x11ad, 407 => 0x1065, 408 => 0x25d, 409 => 0x25d, 410 => 0x24c, 419 => 0xb, 420 => 0xc, 421 => 0xb, 423 => 0x48, 452 => 'ExposureProgram' },
	'exposureshift' => { 278 => 0x203 },
	'exposurestandardadjustment' => { 394 => 0x202d },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x6, 30 => 0x7, 72 => 0x16, 113 => 0x829a, 130 => 0xfd05, 133 => 0x20, 135 => 0xfa24, 137 => 0xf104, 140 => 0x12, 142 => 0x38, 145 => 0x10, 147 => 'ExposureTime', 171 => 0x9, 172 => 0x35, 173 => 0x48, 174 => 0x8, 177 => 0x49b8, 336 => 0x12, 370 => 0xa018, 373 => [0x32,0x4a], 381 => 0x0, 382 => 0x0, 399 => [0x21,0x23,0x27], 423 => 0x10, 452 => 'ExposureTime' },
	'exposuretime2' => { 373 => [0x33,0x4b] },
	'exposuretuning' => { 214 => 0x1c },
	'exposurevalue' => { 131 => 0x3 },
	'exposurewarning' => { 121 => 0x1302 },
	'exrauto' => { 121 => 0x1033 },
	'exrmode' => { 121 => 0x1034 },
	'extendedwbdetect' => { 278 => 0x902 },
	'extender' => { 279 => 0x301 },
	'extenderfirmwareversion' => { 279 => 0x304 },
	'extendermagnification' => { 149 => 'Magnification' },
	'extendermake' => { 149 => 'Make' },
	'extendermodel' => { 149 => 'Model', 279 => 0x303 },
	'extenderserialnumber' => { 149 => 'SerialNumber', 279 => 0x302 },
	'extenderstatus' => { 334 => 0x3 },
	'externalflash' => { 281 => 0x1201 },
	'externalflashae1' => { 283 => 0x101f },
	'externalflashae1_0' => { 283 => 0x101b },
	'externalflashae2' => { 283 => 0x1020 },
	'externalflashae2_0' => { 283 => 0x101c },
	'externalflashbounce' => { 281 => 0x1204, 283 => 0x1026, 324 => 0x1a },
	'externalflashcompensation' => { 200 => 0x1b },
	'externalflashexposurecomp' => { 214 => 0x17, 324 => 0x19 },
	'externalflashfirmware' => { 198 => 0x6, 199 => 0x6, 200 => 0x6, 201 => 0x6, 202 => 0x6 },
	'externalflashflags' => { 198 => 0x8, 199 => 0x8, 200 => 0x8, 201 => 0x8 },
	'externalflashguidenumber' => { 281 => 0x1203, 324 => '24.1' },
	'externalflashgvalue' => { 283 => 0x1025 },
	'externalflashmode' => { 283 => 0x1028, 324 => 0x2 },
	'externalflashreadystate' => { 202 => '9.1' },
	'externalflashstatus' => { 202 => '8.2' },
	'externalflashzoom' => { 281 => 0x1205, 283 => 0x1027 },
	'externalflashzoomoverride' => { 202 => '8.1' },
	'externalmetadatalink' => { 458 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 296 => 0x311, 299 => 0x311, 300 => 0x311, 303 => 0x3408 },
	'extrainfoversion' => { 385 => 0x1a },
	'eyestartaf' => { 174 => 0x40 },
	'fac100per' => { 131 => 0xe94 },
	'fac170per' => { 131 => 0xe93 },
	'fac18per' => { 131 => 0xe92 },
	'face10position' => { 104 => 0x3f4, 105 => 0x1ec, 196 => 0x28, 321 => 0x12 },
	'face10size' => { 322 => 0x12 },
	'face11position' => { 196 => 0x2c, 321 => 0x14 },
	'face11size' => { 322 => 0x14 },
	'face12position' => { 196 => 0x30, 321 => 0x16 },
	'face12size' => { 322 => 0x16 },
	'face13position' => { 321 => 0x18 },
	'face13size' => { 322 => 0x18 },
	'face14position' => { 321 => 0x1a },
	'face14size' => { 322 => 0x1a },
	'face15position' => { 321 => 0x1c },
	'face15size' => { 322 => 0x1c },
	'face16position' => { 321 => 0x1e },
	'face16size' => { 322 => 0x1e },
	'face17position' => { 321 => 0x20 },
	'face17size' => { 322 => 0x20 },
	'face18position' => { 321 => 0x22 },
	'face18size' => { 322 => 0x22 },
	'face19position' => { 321 => 0x24 },
	'face19size' => { 322 => 0x24 },
	'face1position' => { 51 => 0x8, 104 => 0xd, 105 => 0x18, 196 => 0x4, 293 => 0x1, 321 => 0x0, 360 => 0xbc, 388 => 0x1, 389 => 0x0, 390 => 0x0, 391 => 0x5b },
	'face1size' => { 322 => 0x0 },
	'face20position' => { 321 => 0x26 },
	'face20size' => { 322 => 0x26 },
	'face21position' => { 321 => 0x28 },
	'face21size' => { 322 => 0x28 },
	'face22position' => { 321 => 0x2a },
	'face22size' => { 322 => 0x2a },
	'face23position' => { 321 => 0x2c },
	'face23size' => { 322 => 0x2c },
	'face24position' => { 321 => 0x2e },
	'face24size' => { 322 => 0x2e },
	'face25position' => { 321 => 0x30 },
	'face25size' => { 322 => 0x30 },
	'face26position' => { 321 => 0x32 },
	'face26size' => { 322 => 0x32 },
	'face27position' => { 321 => 0x34 },
	'face27size' => { 322 => 0x34 },
	'face28position' => { 321 => 0x36 },
	'face28size' => { 322 => 0x36 },
	'face29position' => { 321 => 0x38 },
	'face29size' => { 322 => 0x38 },
	'face2position' => { 51 => 0xa, 104 => 0x7c, 105 => 0x4c, 196 => 0x8, 293 => 0x5, 321 => 0x2, 360 => 0xc8, 388 => 0x6, 389 => 0x20, 390 => 0x25, 391 => 0x65 },
	'face2size' => { 322 => 0x2 },
	'face30position' => { 321 => 0x3a },
	'face30size' => { 322 => 0x3a },
	'face31position' => { 321 => 0x3c },
	'face31size' => { 322 => 0x3c },
	'face32position' => { 321 => 0x3e },
	'face32size' => { 322 => 0x3e },
	'face3position' => { 51 => 0xc, 104 => 0xeb, 105 => 0x80, 196 => 0xc, 293 => 0x9, 321 => 0x4, 360 => 0xd4, 388 => 0xb, 389 => 0x40, 390 => 0x4a, 391 => 0x6f },
	'face3size' => { 322 => 0x4 },
	'face4position' => { 51 => 0xe, 104 => 0x15a, 105 => 0xb4, 196 => 0x10, 293 => 0xd, 321 => 0x6, 360 => 0xe0, 388 => 0x10, 389 => 0x60, 390 => 0x6f, 391 => 0x79 },
	'face4size' => { 322 => 0x6 },
	'face5position' => { 51 => 0x10, 104 => 0x1c9, 105 => 0xe8, 196 => 0x14, 293 => 0x11, 321 => 0x8, 360 => 0xec, 388 => 0x15, 389 => 0x80, 390 => 0x94 },
	'face5size' => { 322 => 0x8 },
	'face6position' => { 51 => 0x12, 104 => 0x238, 105 => 0x11c, 196 => 0x18, 321 => 0xa, 360 => 0xf8, 388 => 0x1a, 389 => 0xa0, 390 => 0xb9 },
	'face6size' => { 322 => 0xa },
	'face7position' => { 51 => 0x14, 104 => 0x2a7, 105 => 0x150, 196 => 0x1c, 321 => 0xc, 360 => 0x104, 388 => 0x1f, 389 => 0xc0, 390 => 0xde },
	'face7size' => { 322 => 0xc },
	'face8position' => { 51 => 0x16, 104 => 0x316, 105 => 0x184, 196 => 0x20, 321 => 0xe, 360 => 0x110, 388 => 0x24, 389 => 0xe0, 390 => 0x103 },
	'face8size' => { 322 => 0xe },
	'face9position' => { 51 => 0x18, 104 => 0x385, 105 => 0x1b8, 196 => 0x24, 321 => 0x10 },
	'face9size' => { 322 => 0x10 },
	'facebalanceorigi' => { 441 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 441 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 441 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 441 => 'FaceBalanceWarmth' },
	'facedetect' => { 336 => 0x76, 370 => 0x100 },
	'facedetectarea' => { 282 => 0x1201 },
	'facedetectframecrop' => { 282 => 0x1207 },
	'facedetectframesize' => { 51 => 0x3, 104 => 0x1, 105 => 0x4, 196 => 0x1, 282 => 0x1203, 336 => 0x77, 360 => 0xb6 },
	'facedetection' => { 383 => 0x30, 399 => 0x19 },
	'faceelementpositions' => { 121 => 0x4203 },
	'faceelementselected' => { 121 => 0x4005 },
	'faceelementtypes' => { 121 => 0x4201 },
	'faceid' => { 443 => 'FaceID' },
	'faceinfounknown' => { 107 => 0x2089 },
	'facename' => { 370 => 0x123 },
	'faceorientation' => { 105 => 0x8 },
	'faceposition' => { 320 => 0x2, 371 => 0x4 },
	'facepositions' => { 121 => 0x4103 },
	'facerecognition' => { 370 => 0x120 },
	'facesdetected' => { 51 => 0x2, 52 => 0x2, 53 => 0x3, 104 => 0x0, 105 => 0x2, 107 => 0x211c, 121 => 0x4100, 196 => 0x3, 282 => 0x1200, 301 => 0x3f, 320 => 0x0, 360 => 0xb5, 371 => 0x0, 388 => 0x0, 391 => 0x3, 401 => 0x30 },
	'facesrecognized' => { 294 => 0x0 },
	'facewidth' => { 52 => 0x1 },
	'faithfuloutputhighlightpoint' => { 103 => 0x38 },
	'faithfuloutputshadowpoint' => { 103 => 0x39 },
	'faithfulrawcolortone' => { 103 => 0x31 },
	'faithfulrawcontrast' => { 103 => 0x33 },
	'faithfulrawhighlight' => { 103 => 0x79 },
	'faithfulrawhighlightpoint' => { 103 => 0x36 },
	'faithfulrawlinear' => { 103 => 0x34 },
	'faithfulrawsaturation' => { 103 => 0x32 },
	'faithfulrawshadow' => { 103 => 0x82 },
	'faithfulrawshadowpoint' => { 103 => 0x37 },
	'faithfulrawsharpness' => { 103 => 0x35 },
	'faithfulunsharpmaskfineness' => { 103 => 0xac },
	'faithfulunsharpmaskstrength' => { 103 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 103 => 0xae },
	'far' => { 432 => 'Far' },
	'fastresetlinetime' => { 131 => 0x1860 },
	'feedidentifier' => { 458 => 'FeedIdentifier' },
	'femicroadjustment' => { 78 => 0x111 },
	'ffid' => { 450 => 'ffid' },
	'field' => { 461 => 'field' },
	'fieldcount' => { 283 => 0x103f },
	'fifoenonepixeldelay' => { 131 => 0x1901 },
	'filecreatedate' => { 114 => 'FileCreateDate' },
	'filedatarate' => { 472 => 'fileDataRate' },
	'fileformat' => { 89 => 0x0, 126 => 0x14, 373 => [0x22,0x26], 394 => 0xb000 },
	'filegroupid' => { 114 => 'FileGroupID' },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 27 => 0x1eb, 28 => 0x4ae, 302 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 114 => 'FileModifyDate' },
	'filename' => { 114 => 'FileName' },
	'filenameasdelivered' => { 288 => 'FileNameAsDelivered' },
	'filenumber' => { 54 => 0x1, 60 => 0x8, 91 => 0x1817, 108 => 'FileNumber', 197 => 0x4, 359 => 0x10 },
	'filenumbermemory' => { 171 => 0x1a },
	'filenumbersequence' => { 261 => '12.2', 266 => '3.1', 267 => '4.1', 268 => '4.1', 270 => '11.1', 271 => '4.3', 276 => '5.2' },
	'filepermissions' => { 114 => 'FilePermissions' },
	'filesource' => { 113 => 0xa300, 121 => 0x8000, 452 => 'FileSource' },
	'fileuserid' => { 114 => 'FileUserID' },
	'fileversion' => { 126 => 0x16 },
	'fillflashautoreduction' => { 76 => 0xe, 77 => 0xe, 84 => 0xa },
	'filllight' => { 448 => 'FillLight' },
	'fillorder' => { 113 => 0x10a },
	'filmgraineffect' => { 278 => 0x538 },
	'filmmode' => { 121 => 0x1401, 298 => 0x412, 301 => 0x42 },
	'filmtype' => { 222 => 0x2 },
	'filtereffect' => { 54 => 0xe, 216 => 0x37, 217 => 0x3f, 218 => 0x47 },
	'filtereffectauto' => { 67 => 0xa0 },
	'filtereffectfaithful' => { 66 => 0x70, 67 => 0x70 },
	'filtereffectlandscape' => { 66 => 0x40, 67 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 66 => 0x88, 67 => 0x88 },
	'filtereffectneutral' => { 66 => 0x58, 67 => 0x58 },
	'filtereffectportrait' => { 66 => 0x28, 67 => 0x28 },
	'filtereffectstandard' => { 66 => 0x10, 67 => 0x10 },
	'filtereffectuserdef1' => { 66 => 0xa0, 67 => 0xb8 },
	'filtereffectuserdef2' => { 66 => 0xb8, 67 => 0xd0 },
	'filtereffectuserdef3' => { 66 => 0xd0, 67 => 0xe8 },
	'finderdisplayduringexposure' => { 77 => 0x1 },
	'finesharpness' => { 336 => 0x70 },
	'finetuneoptcenterweighted' => { 261 => '7.2', 262 => '9.1', 264 => '9.1', 265 => '9.1', 269 => '8.1', 274 => '9.1', 275 => '9.1', 276 => '9.1' },
	'finetuneopthighlightweighted' => { 264 => '46.1', 265 => '46.1', 274 => '46.1', 275 => '46.1' },
	'finetuneoptmatrixmetering' => { 261 => '8.1', 262 => '8.2', 264 => '8.2', 265 => '8.2', 269 => '7.2', 270 => '6.1', 274 => '8.2', 275 => '8.2', 276 => '8.2' },
	'finetuneoptspotmetering' => { 261 => '8.2', 262 => '9.2', 264 => '9.2', 265 => '9.2', 269 => '8.2', 270 => '6.2', 274 => '9.2', 275 => '9.2', 276 => '9.2' },
	'finishexposure' => { 131 => 0xdbd },
	'finishfiletype' => { 131 => 0xdb8 },
	'finishlook' => { 131 => 0xdbc },
	'finishnoise' => { 131 => 0xdba },
	'finishresolution' => { 131 => 0xdb9 },
	'finishsharpening' => { 131 => 0xdbb },
	'firmware' => { 283 => 0x405, 373 => [0x17,0x3b,0x57], 444 => 'Firmware' },
	'firmwaredate' => { 106 => 0x15, 107 => 0x2001, 357 => 0x4, 359 => 0x30 },
	'firmwareid' => { 178 => 0x0 },
	'firmwarename' => { 370 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 60 => 0x1e, 361 => 0x0 },
	'firmwarerevision2' => { 361 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 131 => [0x415,0xce5], 145 => 0x57, 147 => 'FirmwareVersion', 299 => 0x320, 301 => 0x2, 303 => 0x3109, 336 => 0x230, 358 => 0x18, 359 => 0x2a, 363 => 0x2 },
	'firmwareversions' => { 345 => 0x301 },
	'firstphotodate' => { 435 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 288 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 125 => 0x16, 442 => 'FixtureIdentifier' },
	'flash' => { 108 => 'Flash', 113 => 0x9209, 172 => 0x1f, 173 => 0x15, 359 => 0x5a, 452 => 'Flash' },
	'flashaction' => { 381 => 0x3e, 382 => 0x3e, 394 => 0x2017, 399 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 381 => 0x4c, 382 => 0x4c, 399 => 0x77 },
	'flashactionexternal' => { 399 => [0x78,0x7c] },
	'flashactivity' => { 33 => 0x1c },
	'flashbatterylevel' => { 41 => 0x249 },
	'flashbias' => { 301 => 0x24 },
	'flashbits' => { 33 => 0x1d },
	'flashbuttonfunction' => { 78 => 0x70e },
	'flashchargelevel' => { 283 => 0x1010 },
	'flashcolorfilter' => { 200 => 0x10, 201 => 0x10 },
	'flashcommandermode' => { 198 => '9.1', 199 => '9.1', 200 => '9.1', 201 => '9.1' },
	'flashcompensation' => { 131 => 0x3f3, 198 => 0xa, 199 => 0xa, 200 => 0xa, 201 => 0x27, 202 => 0xa, 444 => 'FlashCompensation' },
	'flashcontrol' => { 381 => 0x23, 382 => 0x1f, 383 => 0x21 },
	'flashcontrolbuilt-in' => { 270 => '16.1', 271 => '23.1', 273 => '23.1', 274 => '24.1' },
	'flashcontrolmode' => { 198 => '9.2', 199 => '9.2', 200 => '9.2', 201 => '9.2', 278 => 0x404 },
	'flashcurtain' => { 301 => 0x48 },
	'flashdefault' => { 174 => 0x42 },
	'flashdevice' => { 283 => 0x1005 },
	'flashdistance' => { 107 => 0x2034 },
	'flashenergy' => { 113 => 0xa20b, 452 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 214 => 0x18 },
	'flashexposurecomp' => { 72 => 0xf, 121 => 0x1011, 150 => 'ExposureComp', 171 => 0x23, 176 => 0x104, 177 => 0x49c1, 214 => 0x12, 278 => 0x401, 283 => 0x1023, 336 => 0x4d, 363 => 0x100b, 373 => [0x3a,0x56], 394 => 0x104 },
	'flashexposurecomp2' => { 240 => 0x4d2 },
	'flashexposurecomp3' => { 200 => 0x1d },
	'flashexposurecomp4' => { 200 => 0x27 },
	'flashexposurecomparea' => { 262 => '38.4', 264 => '38.4', 265 => '38.4', 274 => '38.4', 275 => '38.4' },
	'flashexposurecompset' => { 174 => 0x10, 309 => 0xe, 381 => 0x14, 382 => 0x12, 383 => 0x23, 399 => 0x1f },
	'flashexposurecompset2' => { 399 => [0x26,0x2c] },
	'flashexposureindicator' => { 174 => 0x54 },
	'flashexposureindicatorlast' => { 174 => 0x56 },
	'flashexposureindicatornext' => { 174 => 0x55 },
	'flashexposurelock' => { 54 => 0x19 },
	'flashfired' => { 133 => 0x5d, 150 => 'Fired', 171 => 0x14, 239 => '590.3', 452 => [\'Flash','FlashFired'] },
	'flashfiring' => { 78 => 0x306, 79 => 0x6, 80 => 0x7, 83 => 0x7 },
	'flashfirmwareversion' => { 279 => 0x1002 },
	'flashfocallength' => { 198 => 0xb, 199 => 0xc, 200 => 0xc, 201 => 0xc, 202 => 0xc },
	'flashfunction' => { 177 => 0x31, 452 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 198 => 0xe, 199 => 0xf, 200 => 0xf, 201 => 0xf, 202 => 0xf },
	'flashgroupacompensation' => { 198 => 0x11, 199 => 0x12, 200 => 0x13, 201 => 0x28, 202 => 0x28 },
	'flashgroupacontrolmode' => { 198 => 0xf, 199 => '16.1', 200 => '17.1', 201 => '17.1', 202 => '17.1' },
	'flashgroupaoutput' => { 198 => 0x11, 199 => 0x12, 200 => 0x13, 201 => 0x28, 202 => 0x28 },
	'flashgroupbcompensation' => { 198 => 0x12, 199 => 0x13, 200 => 0x14, 201 => 0x29, 202 => 0x29 },
	'flashgroupbcontrolmode' => { 198 => 0x10, 199 => '17.1', 200 => '18.1', 201 => '18.1', 202 => '18.1' },
	'flashgroupboutput' => { 198 => 0x12, 199 => 0x13, 200 => 0x14, 201 => 0x29, 202 => 0x29 },
	'flashgroupccompensation' => { 199 => 0x14, 200 => 0x15, 201 => 0x2a, 202 => 0x2a },
	'flashgroupccontrolmode' => { 199 => '17.2', 200 => '18.2', 201 => '18.2', 202 => '18.2' },
	'flashgroupcoutput' => { 199 => 0x14, 200 => 0x15, 201 => 0x2a, 202 => 0x2a },
	'flashguidenumber' => { 72 => 0xd, 88 => 0x0, 150 => 'GuideNumber' },
	'flashintensity' => { 106 => [0x19,0x5], 278 => 0x405 },
	'flashlevel' => { 263 => 0x9, 394 => 0xb048 },
	'flashmake' => { 150 => 'Make' },
	'flashmanufacturer' => { 169 => 'FlashManufacturer' },
	'flashmetering' => { 171 => 0x3f, 174 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 27 => 0x15 },
	'flashmeteringsegments' => { 336 => 0x20a },
	'flashmode' => { 106 => 0x4, 131 => 0x3f2, 133 => 0x5c, 150 => 'Mode', 171 => 0x2, 172 => 0x20, 173 => 0x16, 174 => 0xf, 214 => 0x87, 278 => 0x400, 283 => 0x1004, 336 => 0xc, 343 => 0x4, 362 => 0x20, 363 => 0x100a, 372 => 0x225, 381 => 0x13, 382 => 0x7f, 383 => 0x20, 399 => 0x10, 402 => 0x1138, 403 => 0x1138, 404 => 0x1114, 405 => 0x1190, 406 => 0x116c, 407 => 0x1024, 408 => 0x21c, 409 => 0x21c, 410 => 0x211, 452 => [\'Flash','FlashMode'] },
	'flashmodel' => { 150 => 'Model', 169 => 'FlashModel', 279 => 0x1001 },
	'flashoptions' => { 317 => 0x2 },
	'flashoptions2' => { 317 => 0x10 },
	'flashoutput' => { 41 => 0x248, 72 => 0x21, 198 => 0xa, 199 => 0xa, 200 => 0xa, 201 => 0x27 },
	'flashpixversion' => { 113 => 0xa000, 452 => 'FlashpixVersion' },
	'flashredeyemode' => { 452 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 278 => 0x403 },
	'flashreturn' => { 452 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 150 => 'SerialNumber', 279 => 0x1003 },
	'flashsetting' => { 214 => 0x8 },
	'flashshutterspeed' => { 261 => '20.2', 262 => '23.2', 264 => '23.2', 265 => '23.2', 270 => '15.2', 271 => '22.2', 272 => '7.2', 273 => '22.2', 274 => '23.2', 275 => '23.2', 276 => '23.1' },
	'flashsource' => { 198 => 0x4, 199 => 0x4, 200 => 0x4, 201 => 0x4, 202 => 0x4 },
	'flashstatus' => { 324 => 0x0, 399 => [0x82,0x86], 412 => 0x31, 413 => 0x39 },
	'flashstatusbuilt-in' => { 383 => [0x87,0x287] },
	'flashstatusexternal' => { 383 => [0x88,0x288] },
	'flashsyncspeed' => { 261 => '20.1', 262 => '23.1', 264 => '23.1', 265 => '23.1', 270 => '15.1', 271 => '22.1', 273 => '22.1', 274 => '23.1', 275 => '23.1' },
	'flashsyncspeedav' => { 76 => 0x3, 78 => 0x10f, 79 => 0x2, 80 => 0x3, 81 => 0x2, 82 => 0x2, 83 => 0x3, 84 => 0x6 },
	'flashthreshold' => { 88 => 0x1 },
	'flashtype' => { 150 => 'Type', 174 => 0x59, 214 => 0x9, 279 => 0x1000 },
	'flashwarning' => { 271 => '30.1', 272 => '7.1', 276 => '31.1', 301 => 0x62 },
	'flexiblespotposition' => { 394 => 0x201d },
	'flickerreduce' => { 372 => 0x218 },
	'flickerreduction' => { 121 => 0x1446, 233 => 0xe84 },
	'flickerreductionindicator' => { 233 => 0x5e2 },
	'flightpitchdegree' => { 110 => 'FlightPitchDegree' },
	'flightrolldegree' => { 110 => 'FlightRollDegree' },
	'flightxspeed' => { 110 => 'FlightXSpeed' },
	'flightyawdegree' => { 110 => 'FlightYawDegree' },
	'flightyspeed' => { 110 => 'FlightYSpeed' },
	'flightzspeed' => { 110 => 'FlightZSpeed' },
	'fliphorizontal' => { 254 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x5, 30 => 0x6, 72 => 0x15, 113 => 0x829d, 130 => 0xfd04, 133 => 0x1e, 135 => 0xfa23, 137 => 0xf103, 140 => 0x13, 142 => 0x3c, 145 => 0xc, 154 => 'FNumber', 171 => 0xa, 172 => 0x36, 173 => 0x47, 174 => 0x9, 177 => 0x49c7, 212 => 0x38, 336 => 0x13, 370 => 0xa019, 373 => [0x31,0x49], 381 => 0x1, 382 => 0x1, 399 => [0x20,0x22,0x26], 452 => 'FNumber' },
	'focaldistance' => { 433 => 'FocalDistance' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x1e, 28 => 0x23, 56 => 0x1, 107 => 0x1d, 113 => 0x920a, 140 => 0x1d, 154 => 'FocalLength', 171 => 0x12, 207 => 0xa, 208 => 0xb, 212 => [0xc,0x3c], 295 => 0x1, 336 => 0x1d, 345 => 0x403, 363 => 0x1500, 380 => 0xe, 406 => 0x1278, 407 => 0x1134, 408 => 0x32c, 409 => 0x32c, 410 => 0x30a, 452 => 'FocalLength' },
	'focallength2' => { 399 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 113 => 0xa405, 370 => 0xa01a, 452 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 380 => 0x10 },
	'focalplaneafpointarea' => { 411 => 0x2 },
	'focalplaneafpointlocation1' => { 411 => 0x6 },
	'focalplaneafpointlocation10' => { 411 => 0x2a },
	'focalplaneafpointlocation11' => { 411 => 0x2e },
	'focalplaneafpointlocation12' => { 411 => 0x32 },
	'focalplaneafpointlocation13' => { 411 => 0x36 },
	'focalplaneafpointlocation14' => { 411 => 0x3a },
	'focalplaneafpointlocation15' => { 411 => 0x3e },
	'focalplaneafpointlocation2' => { 411 => 0xa },
	'focalplaneafpointlocation3' => { 411 => 0xe },
	'focalplaneafpointlocation4' => { 411 => 0x12 },
	'focalplaneafpointlocation5' => { 411 => 0x16 },
	'focalplaneafpointlocation6' => { 411 => 0x1a },
	'focalplaneafpointlocation7' => { 411 => 0x1e },
	'focalplaneafpointlocation8' => { 411 => 0x22 },
	'focalplaneafpointlocation9' => { 411 => 0x26 },
	'focalplaneafpointsused' => { 411 => 0x1 },
	'focalplanediagonal' => { 279 => 0x103, 283 => 0x205 },
	'focalplaneresolutionunit' => { 113 => 0xa210, 452 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 113 => 0xa20e, 452 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 56 => 0x2 },
	'focalplanexunknown' => { 56 => 0x2 },
	'focalplaneyresolution' => { 113 => 0xa20f, 452 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 56 => 0x3 },
	'focalplaneyunknown' => { 56 => 0x3 },
	'focalpointx' => { 433 => 'FocalPointX' },
	'focalpointy' => { 433 => 'FocalPointY' },
	'focaltype' => { 9 => 0x2d, 56 => 0x0 },
	'focalunits' => { 33 => 0x19 },
	'focus' => { 244 => 0x8 },
	'focusarea' => { 171 => 0x31 },
	'focusareaselection' => { 272 => '15.2' },
	'focuscontinuous' => { 33 => 0x20 },
	'focusdisplayaiservoandmf' => { 78 => 0x515 },
	'focusdistance' => { 154 => 'FocusDistance', 171 => 0x13, 177 => 0x49bb, 207 => 0x9, 208 => 0xa, 212 => 0xb, 281 => 0x305, 295 => 0x0, 299 => 0x304, 300 => 0x304 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0xa7, 27 => 0x56, 28 => 0xa7, 54 => 0x15, 72 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0xa5, 27 => 0x54, 28 => 0xa5, 54 => 0x14, 72 => 0x13 },
	'focusholdbutton' => { 174 => 0x44 },
	'focusinfoversion' => { 281 => 0x0 },
	'focusingscreen' => { 77 => 0x0, 78 => 0x80b, 83 => 0x0 },
	'focuslocation' => { 394 => 0x2027 },
	'focuslocked' => { 170 => 0x14 },
	'focusmode' => { 33 => 0x7, 106 => 0x3, 107 => [0x3003,0xd], 121 => 0x1021, 131 => 0x3f5, 133 => 0x38, 147 => 'FocusMode', 171 => 0x30, 173 => 0xe, 174 => 0xc, 214 => 0x7, 278 => 0x301, 283 => 0x100b, 301 => 0x7, 336 => 0xd, 343 => 0x3, 363 => 0x1006, 374 => [0xb,0x5], 380 => [0x15,0x1d], 381 => 0x4d, 382 => 0x4d, 394 => [0xb042,0xb04e,0x201b], 399 => 0x13, 417 => 0x16 },
	'focusmode2' => { 120 => '0.1', 317 => '3.1', 399 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 263 => '10.1', 378 => 0x14, 379 => 0x15, 381 => 0x10, 382 => 0xf, 383 => 0x6 },
	'focusmodeswitch' => { 174 => 0x58, 381 => 0x2e },
	'focuspixel' => { 121 => 0x1023 },
	'focuspointwrap' => { 261 => '2.2', 262 => '2.2', 264 => '2.1', 265 => '2.1', 269 => '1.1', 270 => '2.2', 271 => '1.1', 274 => '2.2', 275 => '2.1', 276 => '2.5' },
	'focusposition' => { 207 => 0x8, 208 => 0x8, 212 => 0x9, 336 => 0x10, 392 => 0x9bb },
	'focusposition2' => { 399 => [0x29,0x2b,0x2f], 417 => 0x2d, 420 => 0x20 },
	'focusprocess' => { 278 => 0x302 },
	'focusrange' => { 33 => 0x12, 283 => 0x100a },
	'focusrangeindex' => { 327 => '3.1' },
	'focusringrotation' => { 78 => 0x713 },
	'focussetting' => { 373 => 0x6 },
	'focusstatus' => { 380 => 0x19, 381 => 0x53, 382 => 0x53 },
	'focusstepcount' => { 281 => 0x301, 283 => 0x100e },
	'focusstepinfinity' => { 281 => 0x303, 283 => 0x103b },
	'focusstepnear' => { 281 => 0x304, 283 => 0x103c },
	'focustrackinglockon' => { 261 => ['1.5','4.1'], 262 => '1.4', 269 => '0.4', 270 => '3.1', 271 => '0.4', 274 => '1.4' },
	'focuswarning' => { 121 => 0x1301 },
	'foldername' => { 171 => 0x27 },
	'foldernumber' => { 381 => 0x9a, 383 => [0x402,0x114,0x316] },
	'fontcomposite' => { 477 => [\'Fonts','FontsComposite'] },
	'fontface' => { 477 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 477 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 477 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 477 => [\'Fonts','FontsFontName'] },
	'fonts' => { 477 => 'Fonts' },
	'fonttype' => { 477 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 477 => [\'Fonts','FontsVersionString'] },
	'for' => { 352 => 'For' },
	'forcewrite' => { 114 => 'ForceWrite' },
	'format' => { 432 => 'Format', 449 => 'format', 470 => 'Format' },
	'forwardlock' => { 467 => 'forwardlock' },
	'forwardmatrix1' => { 113 => 0xc714 },
	'forwardmatrix2' => { 113 => 0xc715 },
	'fossilspecimen' => { 112 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 112 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 63 => [0x2,0x4] },
	'frameheight' => { 121 => 0x3822 },
	'framenum' => { 347 => 0xd7 },
	'framenumber' => { 121 => 0x8003, 177 => 0x3c, 336 => 0x29 },
	'framerate' => { 63 => [0x1,0x6], 113 => 0xc764, 121 => 0x3820 },
	'framewidth' => { 121 => 0x3821 },
	'framing' => { 461 => 'framing' },
	'freebytes' => { 91 => 0x1 },
	'freememorycardimages' => { 172 => [0x37,0x54], 173 => [0x2d,0x4a], 174 => 0x32 },
	'fujiflashmode' => { 121 => 0x1010 },
	'fullimagesize' => { 394 => 0xb02b },
	'fullpanoheightpixels' => { 435 => 'FullPanoHeightPixels', 436 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 435 => 'FullPanoWidthPixels', 436 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 363 => 0x100d },
	'fullsizeimage' => { 153 => 'data' },
	'fullsizeimagename' => { 153 => '1Name' },
	'fullsizeimagetype' => { 153 => '0Type' },
	'func1button' => { 264 => '14.1', 265 => '14.1', 275 => '14.1' },
	'func1buttonplusdials' => { 264 => '42.1', 265 => '42.1', 275 => '42.1' },
	'func2button' => { 264 => '80.1', 265 => '80.1', 275 => '80.1' },
	'func2buttonplusdials' => { 264 => '81.1' },
	'func3button' => { 264 => '83.1' },
	'funcbutton' => { 261 => ['14.1','15.1'], 262 => '14.1', 270 => '28.1', 271 => '13.1', 274 => '14.1', 276 => '14.1' },
	'funcbuttonplusdials' => { 261 => ['14.2','15.2'], 262 => '14.2', 270 => '31.1', 274 => '42.1' },
	'functionbutton' => { 268 => '13.1', 272 => '5.2' },
	'gainbase' => { 282 => 0x610 },
	'gaincontrol' => { 113 => 0xa407, 452 => 'GainControl' },
	'gamma' => { 113 => 0xa500, 131 => 0x8fe, 306 => 0x11c, 453 => 'Gamma' },
	'gammablackpoint' => { 99 => 0xc },
	'gammacolortone' => { 99 => 0x3 },
	'gammacompensatedvalue' => { 127 => 0x91 },
	'gammacontrast' => { 99 => 0x2 },
	'gammacurveoutputrange' => { 99 => 0xf },
	'gammahighlight' => { 99 => 0xa },
	'gammalinear' => { 97 => 0x20200 },
	'gammamidpoint' => { 99 => 0xe },
	'gammasaturation' => { 99 => 0x4 },
	'gammashadow' => { 99 => 0x9 },
	'gammasharpnessstrength' => { 99 => 0x8 },
	'gammaunsharpmaskfineness' => { 99 => 0x6 },
	'gammaunsharpmaskstrength' => { 99 => 0x5 },
	'gammaunsharpmaskthreshold' => { 99 => 0x7 },
	'gammawhitepoint' => { 99 => 0xd },
	'geimagesize' => { 121 => 0x1304 },
	'gemake' => { 123 => 0x300 },
	'gemodel' => { 123 => 0x207 },
	'genre' => { 458 => 'Genre', 462 => 'genre', 472 => 'genre' },
	'genrecvid' => { 458 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 458 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 458 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 458 => [\'Genre','GenreCvTermRefinedAbout'] },
	'geography' => { 463 => 'geography' },
	'geologicalcontext' => { 112 => 'GeologicalContext' },
	'geologicalcontextbed' => { 112 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 112 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 112 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 112 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 112 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 114 => 'Geosync' },
	'geotag' => { 114 => 'Geotag' },
	'geotiffasciiparams' => { 113 => 0x87b1 },
	'geotiffdirectory' => { 113 => 0x87af },
	'geotiffdoubleparams' => { 113 => 0x87b0 },
	'geotime' => { 114 => 'Geotime' },
	'giftftppriority' => { 437 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 110 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 110 => 'GimbalReverse' },
	'gimbalrolldegree' => { 110 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 110 => 'GimbalYawDegree' },
	'globalaltitude' => { 350 => 0x419 },
	'globalangle' => { 350 => 0x40d },
	'good' => { 472 => 'good' },
	'googleplusuploadcode' => { 113 => 0x9009 },
	'gpsaltitude' => { 124 => 0x6, 151 => 'Altitude', 452 => 'GPSAltitude' },
	'gpsaltituderef' => { 124 => 0x5, 452 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 124 => 0x1c, 452 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 124 => 0x1d },
	'gpsdatetime' => { 151 => 'DateTime', 452 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 124 => 0x18, 151 => 'Bearing', 452 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 124 => 0x17, 452 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 124 => 0x1a, 151 => 'Distance', 452 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 124 => 0x19, 452 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 124 => 0x14, 452 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 124 => 0x13 },
	'gpsdestlongitude' => { 124 => 0x16, 452 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 124 => 0x15 },
	'gpsdifferential' => { 124 => 0x1e, 151 => 'Differential', 452 => 'GPSDifferential' },
	'gpsdop' => { 124 => 0xb, 452 => 'GPSDOP' },
	'gpshpositioningerror' => { 124 => 0x1f, 452 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 124 => 0x11, 452 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 124 => 0x10, 452 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 110 => 'GpsLatitude', 124 => 0x2, 151 => 'Latitude', 452 => 'GPSLatitude' },
	'gpslatituderef' => { 124 => 0x1 },
	'gpslongitude' => { 110 => 'GpsLongitude', 124 => 0x4, 151 => 'Longitude', 452 => 'GPSLongitude' },
	'gpslongituderef' => { 124 => 0x3 },
	'gpslongtitude' => { 110 => 'GpsLongtitude' },
	'gpsmapdatum' => { 124 => 0x12, 151 => 'Datum', 452 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 124 => 0xa, 151 => 'MeasureMode', 452 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 124 => 0x1b, 452 => 'GPSProcessingMethod' },
	'gpssatellites' => { 124 => 0x8, 151 => 'Satellites', 452 => 'GPSSatellites' },
	'gpsspeed' => { 124 => 0xd, 151 => 'Speed', 452 => 'GPSSpeed' },
	'gpsspeedref' => { 124 => 0xc, 452 => 'GPSSpeedRef' },
	'gpsstatus' => { 124 => 0x9, 452 => 'GPSStatus' },
	'gpsstring' => { 131 => 0x402 },
	'gpstimestamp' => { 124 => 0x7 },
	'gpstrack' => { 124 => 0xf, 151 => 'Heading', 452 => 'GPSTrack' },
	'gpstrackref' => { 124 => 0xe, 452 => 'GPSTrackRef' },
	'gpsversionid' => { 124 => 0x0, 452 => 'GPSVersionID' },
	'gradation' => { 278 => 0x50f },
	'gradientbasedcorractive' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 448 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 448 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 448 => 'GrainAmount' },
	'graineffect' => { 121 => 0x1047 },
	'grainfrequency' => { 448 => 'GrainFrequency' },
	'grainsize' => { 448 => 'GrainSize' },
	'graymixeraqua' => { 448 => 'GrayMixerAqua' },
	'graymixerblue' => { 448 => 'GrayMixerBlue' },
	'graymixergreen' => { 448 => 'GrayMixerGreen' },
	'graymixermagenta' => { 448 => 'GrayMixerMagenta' },
	'graymixerorange' => { 448 => 'GrayMixerOrange' },
	'graymixerpurple' => { 448 => 'GrayMixerPurple' },
	'graymixerred' => { 448 => 'GrayMixerRed' },
	'graymixeryellow' => { 448 => 'GrayMixerYellow' },
	'graypoint' => { 427 => 0x8021 },
	'grayresponseunit' => { 113 => 0x122 },
	'greencurvelimits' => { 102 => 0x1c4 },
	'greencurvepoints' => { 101 => 0x53, 102 => 0x19a },
	'greenhsl' => { 97 => 0x20913 },
	'greenhue' => { 448 => 'GreenHue' },
	'greensaturation' => { 448 => 'GreenSaturation' },
	'griddisplay' => { 261 => '13.3', 262 => '4.3', 264 => '4.2', 265 => '4.2', 266 => '2.2', 270 => '10.5', 271 => '3.4', 272 => '6.1', 274 => '4.4', 275 => '4.2', 276 => '4.2' },
	'gripbatteryadload' => { 315 => 0x5 },
	'gripbatteryadnoload' => { 315 => 0x4 },
	'gripbatterystate' => { 315 => '1.2' },
	'groupareaafillumination' => { 262 => '46.4', 265 => '47.4', 274 => '47.4' },
	'h2resetblackpixels' => { 131 => 0x18a6 },
	'h3resetblackcolumns' => { 131 => 0x18ce },
	'h3resetblackpixels' => { 131 => 0x18b0 },
	'halftonehints' => { 113 => 0x141 },
	'hardlink' => { 114 => 'HardLink' },
	'hasalternative' => { 462 => 'hasAlternative' },
	'hascorrection' => { 462 => 'hasCorrection' },
	'hascorrectiona-lang' => { 462 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 462 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 462 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 448 => 'HasCrop' },
	'hasextendedxmp' => { 474 => 'HasExtendedXMP' },
	'hassettings' => { 448 => 'HasSettings' },
	'hastranslation' => { 462 => 'hasTranslation' },
	'hasvisibleoverprint' => { 477 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 477 => 'HasVisibleTransparency' },
	'hdr' => { 57 => 0x1, 204 => 0x4, 301 => 0x9e, 336 => 0x85, 394 => 0x200a },
	'hdreffect' => { 57 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 204 => 0x0 },
	'hdrlevel' => { 204 => 0x5, 383 => 0x2e, 399 => 0x17 },
	'hdrlevel2' => { 204 => 0x7 },
	'hdrsetting' => { 383 => 0x2d, 399 => 0x16, 402 => 0x1148, 403 => 0x1148, 404 => 0x1124, 405 => 0x11a0, 406 => 0x117c, 407 => 0x1034, 408 => 0x22c, 409 => 0x22c, 410 => 0x21f },
	'hdrshot' => { 301 => 0x76 },
	'hdrsmoothing' => { 204 => 0x6 },
	'headline' => { 125 => 0x69, 458 => 'Headline', 460 => 'Headline' },
	'hierarchicalkeywords' => { 162 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 162 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 162 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 162 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 162 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 439 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 112 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 306 => 0x1a },
	'highisomultipliergreen' => { 306 => 0x19 },
	'highisomultiplierred' => { 306 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 27 => 0xc9, 59 => 0x5, 78 => 0x202, 214 => 0xb1, 336 => 0x71, 381 => 0x2c, 382 => 0x26, 383 => 0x26, 394 => 0x2009, 399 => 0x12, 423 => 0x42 },
	'highisonoisereduction2' => { 394 => 0xb050 },
	'highlight' => { 373 => 0xf },
	'highlightadj' => { 97 => 0x2030c },
	'highlightcolordistortreduct' => { 427 => 0x8026 },
	'highlightlinearitylimit' => { 370 => 0xa025 },
	'highlightprotection' => { 253 => 0x6 },
	'highlightrecovery' => { 448 => 'HighlightRecovery' },
	'highlights' => { 441 => 'Highlights' },
	'highlights2012' => { 448 => 'Highlights2012' },
	'highlightsadj' => { 427 => 0x9019 },
	'highlightshadow' => { 301 => 0xad },
	'highlighttone' => { 121 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 27 => 0x7, 59 => 0x3, 78 => 0x203 },
	'highlightwarning' => { 301 => 0x8002 },
	'highlowkeyadj' => { 336 => 0x6c },
	'highspeedsync' => { 174 => 0x5, 381 => 0x2, 382 => 0x2 },
	'histogramxml' => { 254 => 0x83a1a25 },
	'history' => { 460 => 'History', 473 => 'History' },
	'historyaction' => { 473 => [\'History','HistoryAction'] },
	'historychanged' => { 473 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 473 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 473 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 473 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 473 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 131 => 0xc88 },
	'holefilldeltathreshold' => { 131 => 0xc7e },
	'hometowncity' => { 107 => 0x3006, 336 => 0x23, 342 => 0x2 },
	'hometowncitycode' => { 343 => 0x1000 },
	'hometowndst' => { 336 => 0x25, 342 => '0.2' },
	'hostcomputer' => { 113 => 0x13c },
	'hostsoftwarerendering' => { 131 => 0xce7 },
	'hue' => { 179 => 0x3b, 217 => 0x3d, 218 => 0x45, 336 => 0x67 },
	'hueadj' => { 257 => 0x2f, 427 => 0x8019 },
	'hueadjust' => { 363 => 0x1016 },
	'hueadjustment' => { 172 => 0x4a, 173 => 0x40, 214 => 0x92, 216 => 0x36 },
	'hueadjustmentaqua' => { 448 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 448 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 448 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 448 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 448 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 448 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 448 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 448 => 'HueAdjustmentYellow' },
	'huesetting' => { 286 => 0x1011 },
	'humanobservation' => { 112 => 'HumanObservation' },
	'humanobservationday' => { 112 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 112 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 112 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 112 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 112 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 112 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 112 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 112 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 112 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 112 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 112 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 112 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 112 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 112 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 112 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 112 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 112 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 112 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 112 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 112 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 113 => 0x9401, 453 => 'Humidity' },
	'icc_profile' => { 114 => 'ICC_Profile' },
	'iccprofilename' => { 460 => 'ICCProfile' },
	'idccreativestyle' => { 427 => 0x8000 },
	'idcpreviewlength' => { 427 => 0x202 },
	'idcpreviewstart' => { 427 => 0x201 },
	'identification' => { 112 => 'Identification' },
	'identificationid' => { 112 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 112 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 112 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 112 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 112 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 112 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 449 => 'identifier', 470 => 'Identifier' },
	'ifcameramodel' => { 131 => 0x9c8 },
	'illumination' => { 272 => '0.5', 358 => 0x48 },
	'imageabsolutex' => { 131 => 0x3fe },
	'imageabsolutey' => { 131 => 0x3ff },
	'imageadjustment' => { 214 => 0x80, 244 => 0x5 },
	'imagealterationconstraints' => { 288 => 'ImageAlterationConstraints' },
	'imagearea' => { 227 => 0x10, 230 => 0x10 },
	'imageareaoffset' => { 336 => 0x38 },
	'imageauthentication' => { 214 => 0x20 },
	'imageboundary' => { 214 => 0x16 },
	'imagecount' => { 121 => 0x1438, 214 => 0xa5, 397 => 0x11b },
	'imagecreator' => { 288 => 'ImageCreator' },
	'imagecreatorid' => { 288 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 288 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 288 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 131 => 0x41f },
	'imagecropy' => { 131 => 0x420 },
	'imagedata' => { 434 => 'Data' },
	'imagedatasize' => { 214 => 0xa2 },
	'imagedescription' => { 113 => 0x10e, 468 => 'ImageDescription' },
	'imageduplicationconstraints' => { 288 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 254 => 0xfe443a45 },
	'imageeditcount' => { 336 => 0x41 },
	'imageediting' => { 336 => 0x32 },
	'imageeffects' => { 363 => 0x1010 },
	'imagefileconstraints' => { 288 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 288 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 288 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 121 => 0x1436 },
	'imageheight' => { 113 => 0x101, 178 => 0xc, 345 => 0x10d, 432 => 'ImageHeight', 468 => 'ImageLength' },
	'imagehistory' => { 113 => 0x9213, 451 => 'ImageHistory' },
	'imageidnumber' => { 296 => 0x340 },
	'imagemimetype' => { 434 => 'Mime' },
	'imagenumber' => { 113 => 0x9211, 147 => 'ImageNumber', 172 => 0xae, 173 => 0x5e, 345 => 0x113, 381 => 0x9b, 383 => [0x400,'276.1',0x314], 444 => 'ImageNumber' },
	'imagenumber2' => { 173 => 0x62 },
	'imageoptimization' => { 214 => 0xa9 },
	'imageorientation' => { 125 => 0x83 },
	'imageprocessing' => { 214 => 0x1a },
	'imageprocessingfiledatecreated' => { 131 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 131 => 0xc80 },
	'imageprocessingversion' => { 282 => 0x0 },
	'imagequality' => { 147 => 'ImageQuality', 229 => '723.2', 230 => '732.2', 239 => '708.1', 301 => 0x1 },
	'imagequality2' => { 278 => 0x603 },
	'imagerank' => { 437 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 131 => 0x600 },
	'imagerboardversion' => { 131 => 0x439 },
	'imagercols' => { 131 => 0x17d4 },
	'imageref' => { 456 => 'ImageRef' },
	'imageresolution' => { 131 => 0x944 },
	'imageresolutionjpg' => { 131 => 0x945 },
	'imagereview' => { 263 => '0.4', 272 => '0.4' },
	'imagereviewmonitorofftime' => { 262 => '21.1', 264 => '21.1', 265 => '21.1', 269 => '20.1', 274 => '21.1', 275 => '21.1' },
	'imagereviewtime' => { 261 => '25.1', 263 => '2.1', 266 => '19.1', 267 => '20.1', 268 => '20.1', 270 => '9.2', 271 => '20.1', 276 => '21.2' },
	'imagerfiledatecreated' => { 131 => 0x9c5 },
	'imagerfileproductionlevel' => { 131 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 131 => 0x9c7 },
	'imagerpowerondelaymsec' => { 131 => 0x5fd },
	'imagerrows' => { 131 => 0x17de },
	'imagesegmentlines' => { 131 => 0x184d },
	'imagesegmentstartline' => { 131 => 0x184c },
	'imagesize' => { 153 => 'ImageSize' },
	'imagesizerestriction' => { 465 => 'imageSizeRestriction' },
	'imagesourcedata' => { 113 => 0x935c },
	'imagespace' => { 131 => 0x909 },
	'imagestabilization' => { 33 => 0x22, 107 => 0x3020, 121 => 0x1422, 147 => 'ImageStabilization', 172 => 0xbd, 173 => 0x71, 174 => 0x57, 175 => 0x0, 176 => [0x18,0x107,0x113], 177 => 0x49c2, 214 => 0xac, 278 => 0x604, 281 => 0x1600, 301 => 0x1a, 386 => 0x12, 387 => 0x11, 394 => 0xb026 },
	'imagestabilization2' => { 385 => 0xa },
	'imagestabilizationsetting' => { 177 => 0x14, 381 => 0x3d, 382 => 0x3d, 392 => 0x14 },
	'imagestyle' => { 381 => 0x2d, 382 => 0x27 },
	'imagesupplier' => { 288 => 'ImageSupplier' },
	'imagesupplierid' => { 288 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 288 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 288 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 115 => 0x1 },
	'imagetemperaturemin' => { 115 => 0x2 },
	'imagetone' => { 336 => 0x4f },
	'imagetype' => { 125 => 0x82, 288 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 60 => 0x28, 113 => 0xa420, 451 => 'ImageUniqueID', 452 => 'ImageUniqueID' },
	'imagewidth' => { 113 => 0x100, 178 => 0xe, 345 => 0x10c, 432 => 'ImageWidth', 468 => 'ImageWidth' },
	'inclinationangle' => { 427 => 0x900f },
	'inclinationcorrection' => { 427 => 0x900e },
	'incrementaltemperature' => { 448 => 'IncrementalTemperature' },
	'incrementaltint' => { 448 => 'IncrementalTint' },
	'industry' => { 462 => 'industry', 463 => 'industry' },
	'infobuttonwhenshooting' => { 78 => 0x409 },
	'infraredilluminator' => { 357 => 0x28 },
	'ingredientexclusion' => { 464 => 'ingredientExclusion' },
	'ingredients' => { 473 => 'Ingredients' },
	'ingredientsalternatepaths' => { 473 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 473 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 473 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 473 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 473 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 473 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 473 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 473 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 473 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 473 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 473 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 473 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 473 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 473 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 473 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 473 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 473 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 473 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 473 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 473 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 473 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 473 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 473 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 78 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 435 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 435 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 435 => 'InitialViewHeadingDegrees', 436 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 435 => 'InitialViewPitchDegrees', 436 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 435 => 'InitialViewRollDegrees', 436 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 261 => '4.4' },
	'initialzoomsetting' => { 261 => '9.3', 270 => '27.3' },
	'inkset' => { 113 => 0x14c },
	'inputprofile' => { 131 => 0x1389 },
	'instanceid' => { 473 => 'InstanceID' },
	'instantplaybacksetup' => { 174 => 0x3e },
	'instantplaybacktime' => { 174 => 0x3d },
	'instructions' => { 460 => 'Instructions' },
	'instrument' => { 472 => 'instrument' },
	'integrationtime' => { 131 => 0x423 },
	'intellectualgenre' => { 457 => 'IntellectualGenre' },
	'intelligentauto' => { 394 => 0xb052, 419 => 0xd, 420 => 0xe, 421 => 0xd },
	'intelligentcontrast' => { 49 => 0x4 },
	'intelligentd-range' => { 301 => 0x79 },
	'intelligentexposure' => { 301 => 0x5d },
	'intelligentresolution' => { 301 => 0x70 },
	'interchangecolorspace' => { 127 => 0x40 },
	'intergraphmatrix' => { 113 => 0x8480 },
	'internalflash' => { 171 => 0x2b, 261 => '23.1', 263 => '8.1', 266 => '22.1', 268 => '23.1', 272 => '8.1', 276 => '24.1', 281 => 0x1208 },
	'internalflashae1' => { 283 => 0x1021 },
	'internalflashae1_0' => { 283 => 0x101d },
	'internalflashae2' => { 283 => 0x1022 },
	'internalflashae2_0' => { 283 => 0x101e },
	'internalflashmode' => { 324 => 0x1 },
	'internalflashstrength' => { 324 => 0x3 },
	'internalflashtable' => { 283 => 0x1024 },
	'internallensserialnumber' => { 370 => 0xa005 },
	'internalndfilter' => { 301 => 0x9d },
	'internalserialnumber' => { 60 => 0x96, 71 => 0x9, 121 => 0x10, 177 => 0x49dc, 277 => 0x18, 279 => 0x102, 298 => 0x500, 301 => 0x25, 316 => 0x4, 363 => 0x5, 412 => [0x7c,0xf0], 413 => 0x88 },
	'interopindex' => { 113 => 0x1, 453 => 'InteroperabilityIndex' },
	'interopversion' => { 113 => 0x2 },
	'intervallength' => { 171 => 0x10 },
	'intervalmode' => { 171 => 0x26 },
	'intervalnumber' => { 171 => 0x11 },
	'intervalshooting' => { 336 => 0x92 },
	'introtime' => { 472 => 'introTime' },
	'introtimescale' => { 472 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 472 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 131 => 0xdae },
	'ipfcameramodel' => { 131 => 0xe4d },
	'iptc' => { 114 => 'IPTC' },
	'iptc-naa' => { 113 => 0x83bb, 306 => 0x83bb },
	'iptcbitspersample' => { 127 => 0x56 },
	'iptcdigest' => { 350 => 0x425 },
	'iptcimageheight' => { 127 => 0x1e },
	'iptcimagerotation' => { 127 => 0x66 },
	'iptcimagewidth' => { 127 => 0x14 },
	'iptclastedited' => { 458 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 127 => 0xa },
	'iptcpixelheight' => { 127 => 0x32 },
	'iptcpixelwidth' => { 127 => 0x28 },
	'isalternativeof' => { 462 => 'isAlternativeOf' },
	'isbn' => { 462 => 'isbn' },
	'iscorrectionof' => { 462 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 103 => 0x3 },
	'ismergedhdr' => { 444 => 'IsMergedHDR' },
	'ismergedpanorama' => { 444 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x0, 30 => 0x1, 106 => 0x14, 107 => [0x3014,0x14], 113 => 0x8827, 130 => 0xfd06, 131 => 0x1784, 133 => 0x60, 135 => [0xfa2e,0xfa46], 136 => [0x27,0x28], 137 => 0xf105, 140 => 0x14, 142 => 0x4e, 145 => 0x34, 147 => 'ISO', 171 => 0x8, 177 => 0x49ba, 205 => 0x0, 214 => 0x2, 306 => 0x17, 336 => [0x8b,0x14], 343 => 0x14, 345 => 0x105, 370 => 0xa014, 392 => 0x6f, 399 => [0x1f,0x21,0x25], 452 => 'ISOSpeedRatings' },
	'iso2' => { 205 => 0x6, 224 => 0x265, 225 => 0x25c, 226 => 0x265, 227 => 0x221, 228 => 0x25d, 229 => 0x256, 230 => 0x25d, 234 => 0x2b5, 237 => 0x265, 243 => 0x2b5 },
	'isoauto' => { 317 => '14.4' },
	'isoautohilimit' => { 232 => 0x18eb, 233 => 0xe82, 241 => 0x185d },
	'isoautomax' => { 393 => 0x4 },
	'isoautomin' => { 393 => 0x2 },
	'isoautoparameters' => { 336 => 0x7a },
	'isoautoshuttertime' => { 232 => 0x18ea, 233 => 0xe81, 241 => 0x185c },
	'isocalibrationgain' => { 131 => 0x89f },
	'isodisplay' => { 264 => '4.1', 265 => '4.1', 266 => '2.3', 267 => '3.3', 268 => '3.3', 271 => '3.3', 274 => '4.3', 275 => '4.1', 276 => '4.3' },
	'isoexpansion' => { 78 => 0x103, 79 => 0x7, 80 => 0x8, 83 => 0x8, 205 => 0x4 },
	'isoexpansion2' => { 205 => 0xa },
	'isofloor' => { 317 => 0x6 },
	'isoselection' => { 214 => 0xf },
	'isosensitivitystep' => { 269 => '6.2', 271 => '6.2' },
	'isosetting' => { 133 => 0x5e, 147 => 'ISOSetting', 171 => 0x24, 172 => 0x26, 173 => 0x1c, 174 => 0x13, 179 => 0x6, 214 => 0x13, 317 => '17.3', 362 => 0x27, 381 => 0x16, 382 => 0x14, 383 => 0x2, 392 => 0x6d, 393 => 0x0 },
	'isospeed' => { 113 => 0x8833, 453 => 'ISOSpeed' },
	'isospeedexpansion' => { 77 => 0x3 },
	'isospeedincrements' => { 78 => 0x102 },
	'isospeedlatitudeyyy' => { 113 => 0x8834, 453 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 113 => 0x8835, 453 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 78 => 0x103 },
	'isostepsize' => { 261 => '6.1', 262 => '7.2', 264 => '7.2', 265 => '7.2', 270 => '4.1', 274 => '7.2', 275 => '7.2' },
	'isovalue' => { 283 => 0x1001 },
	'issn' => { 462 => 'issn' },
	'issueidentifier' => { 462 => 'issueIdentifier' },
	'issuename' => { 462 => 'issueName' },
	'issueteaser' => { 462 => 'issueTeaser' },
	'issuetype' => { 462 => 'issueType' },
	'istranslationof' => { 462 => 'isTranslationOf' },
	'itemsubtype' => { 169 => 'ItemSubType' },
	'jobid' => { 125 => 0xb8 },
	'jobname' => { 454 => 'JobName' },
	'jobref' => { 471 => 'JobRef' },
	'jobrefid' => { 471 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 471 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 471 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 454 => 'JobStatus' },
	'jpeghandling' => { 448 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 301 => 0x43, 303 => 0x3034, 394 => 0xb047 },
	'jpegsize' => { 303 => 0x303a },
	'jpgcompression' => { 233 => 0x7d4 },
	'jpgfromraw' => { 91 => 0x2007, 108 => 'JpgFromRaw', 306 => 0x2e },
	'jpgfromrawlength' => { 113 => [0x117,0x202] },
	'jpgfromrawstart' => { 113 => [0x111,0x201] },
	'jpgrecordedpixels' => { 317 => '14.1' },
	'jurisdiction' => { 445 => 'jurisdiction' },
	'kelvinwb_01' => { 325 => 0x5 },
	'kelvinwb_02' => { 325 => 0x9 },
	'kelvinwb_03' => { 325 => 0xd },
	'kelvinwb_04' => { 325 => 0x11 },
	'kelvinwb_05' => { 325 => 0x15 },
	'kelvinwb_06' => { 325 => 0x19 },
	'kelvinwb_07' => { 325 => 0x1d },
	'kelvinwb_08' => { 325 => 0x21 },
	'kelvinwb_09' => { 325 => 0x25 },
	'kelvinwb_10' => { 325 => 0x29 },
	'kelvinwb_11' => { 325 => 0x2d },
	'kelvinwb_12' => { 325 => 0x31 },
	'kelvinwb_13' => { 325 => 0x35 },
	'kelvinwb_14' => { 325 => 0x39 },
	'kelvinwb_15' => { 325 => 0x3d },
	'kelvinwb_16' => { 325 => 0x41 },
	'kelvinwb_daylight' => { 325 => 0x1 },
	'kerneldenominators' => { 131 => 0x933 },
	'key' => { 472 => 'key' },
	'keystonecompensation' => { 282 => 0x1900 },
	'keystonedirection' => { 282 => 0x1901 },
	'keystonevalue' => { 282 => 0x1906 },
	'keyword' => { 462 => 'keyword' },
	'keywordinfo' => { 162 => 'Keywords' },
	'keywords' => { 125 => 0x19, 148 => 'Keywords', 287 => 'Keywords', 352 => 'Keywords', 442 => 'keywords', 459 => 'Keywords', 470 => 'Keywords' },
	'killdate' => { 462 => 'killDate' },
	'killdatea-platform' => { 462 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 462 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 130 => 0xf908, 133 => 0xe, 135 => [0xfa1e,0xfa52], 141 => 0x70 },
	'kodakimagewidth' => { 130 => 0xf907, 133 => 0xc, 135 => [0xfa1d,0xfa51], 141 => 0x6c },
	'kodakinfotype' => { 130 => 0xfa00 },
	'kodaklook' => { 131 => 0xe4c },
	'kodaklookprofile' => { 131 => 0x138a },
	'kodakmaker' => { 141 => 0x8 },
	'kodakmodel' => { 133 => 0x0, 141 => 0x28 },
	'kodaktag' => { 131 => 0x3ea },
	'kodakversion' => { 131 => 0x0 },
	'label' => { 291 => 'Label', 470 => 'Label' },
	'labelname1' => { 456 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 456 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 301 => 0x6f },
	'landscapeoutputhighlightpoint' => { 103 => 0x26 },
	'landscapeoutputshadowpoint' => { 103 => 0x27 },
	'landscaperawcolortone' => { 103 => 0x1f },
	'landscaperawcontrast' => { 103 => 0x21 },
	'landscaperawhighlight' => { 103 => 0x77 },
	'landscaperawhighlightpoint' => { 103 => 0x24 },
	'landscaperawlinear' => { 103 => 0x22 },
	'landscaperawsaturation' => { 103 => 0x20 },
	'landscaperawshadow' => { 103 => 0x80 },
	'landscaperawshadowpoint' => { 103 => 0x25 },
	'landscaperawsharpness' => { 103 => 0x23 },
	'landscapeunsharpmaskfineness' => { 103 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 103 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 103 => 0xa2 },
	'language' => { 449 => 'language' },
	'languageidentifier' => { 125 => 0x87 },
	'largestvalidinteriorrectheight' => { 435 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 435 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 435 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 435 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 171 => 0x1b },
	'lastkeywordiptc' => { 169 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 169 => 'LastKeywordXMP' },
	'lastphotodate' => { 435 => 'LastPhotoDate' },
	'lasturl' => { 473 => 'LastURL' },
	'lateralchromaticaberration' => { 394 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 444 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 112 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 112 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 112 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 112 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 112 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 110 => 'Latitude' },
	'lc1' => { 327 => 0x2 },
	'lc10' => { 327 => 0xb },
	'lc11' => { 327 => 0xc },
	'lc12' => { 327 => 0xd },
	'lc14' => { 327 => 0xf },
	'lc15' => { 327 => 0x10 },
	'lc3' => { 327 => 0x4 },
	'lc4' => { 327 => 0x5 },
	'lc5' => { 327 => 0x6 },
	'lc6' => { 327 => 0x7 },
	'lc7' => { 327 => 0x8 },
	'lc8' => { 327 => 0x9 },
	'lcddisplayatpoweron' => { 78 => 0x811, 82 => 0xa },
	'lcddisplayreturntoshoot' => { 83 => 0x12 },
	'lcdillumination' => { 261 => '17.5', 262 => '5.2', 264 => '5.1', 265 => '5.1', 270 => '10.3', 271 => '4.2', 274 => '5.2', 275 => '5.1', 276 => '5.4' },
	'lcdilluminationduringbulb' => { 78 => 0x408 },
	'lcdmatrix' => { 131 => 0xe74 },
	'lcdmatrixchickfix' => { 131 => 0xe75 },
	'lcdmatrixmarvin' => { 131 => 0xe76 },
	'lcdpanels' => { 77 => 0x8 },
	'lcheditor' => { 254 => 0x8ae85e },
	'legacyiptcdigest' => { 460 => 'LegacyIPTCDigest' },
	'legalcode' => { 445 => 'legalcode' },
	'lens' => { 113 => 0xfdea, 214 => 0x84, 444 => 'Lens' },
	'lensafstopbutton' => { 76 => 0x11, 77 => 0x13, 78 => 0x506, 79 => 0x10, 80 => 0x12, 83 => 0x13, 84 => 0x9 },
	'lensaperturerange' => { 373 => [0x30,0x48] },
	'lenscorrectionsettings' => { 451 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 444 => 'LensDistortInfo' },
	'lensdistortionparams' => { 283 => 0x206 },
	'lensdrivenoaf' => { 78 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 383 => 0x3f0, 426 => 0xd },
	'lensfirmware' => { 364 => 0x20, 370 => 0xa004 },
	'lensfirmwareversion' => { 279 => 0x204, 301 => 0x60, 383 => 0x3f3, 426 => 0x14 },
	'lensfocallength' => { 97 => 0xf0512, 327 => 0x9 },
	'lensfocalrange' => { 373 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 262 => '55.1', 264 => '52.1', 265 => '52.1', 274 => '52.1', 275 => '52.1' },
	'lensformat' => { 406 => 0x1891, 408 => 0x18bd, 409 => 0x18ed, 410 => 0x17f1, 412 => 0x106, 413 => 0x106, 422 => 0x603, 423 => 0x5d },
	'lensfstops' => { 206 => 0x7, 207 => 0xc, 208 => 0xd, 212 => 0xe, 214 => 0x8b, 327 => '0.3' },
	'lensid' => { 444 => 'LensID' },
	'lensidnumber' => { 206 => 0x6, 207 => 0xb, 208 => 0xc, 212 => 0xd },
	'lensinfo' => { 113 => 0xa432, 333 => 0x2a, 444 => 'LensInfo', 453 => 'LensSpecification' },
	'lenskind' => { 327 => 0x1 },
	'lensmake' => { 113 => 0xa433, 154 => 'Make', 453 => 'LensMake' },
	'lensmanualdistortionamount' => { 448 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 169 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 373 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 60 => 0x95, 113 => 0xa434, 154 => 'Model', 169 => 'LensModel', 209 => 0x18a, 210 => 0x18b, 211 => 0x2ac, 279 => 0x203, 333 => 0xc, 345 => 0x412, 453 => 'LensModel' },
	'lensmodulationoptimizer' => { 121 => 0x1045 },
	'lensmount' => { 383 => 0x99, 406 => 0x1892, 408 => 0x18be, 409 => 0x18ee, 410 => 0x17f2, 412 => 0x105, 413 => 0x105, 422 => 0x604, 423 => 0x5e },
	'lensmount2' => { 426 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 448 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 448 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 448 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 448 => 'LensProfileEnable' },
	'lensprofilefilename' => { 448 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 448 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 448 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 448 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 448 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 448 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 448 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 448 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 448 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 448 => 'LensProfileName' },
	'lensprofilesetup' => { 448 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 448 => 'LensProfileVignettingScale' },
	'lensproperties' => { 279 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 31 => 0x16b, 58 => 0x0, 113 => 0xa435, 154 => 'SerialNumber', 279 => 0x202, 299 => 0x321, 301 => 0x52, 364 => 0x30, 444 => 'LensSerialNumber', 453 => 'LensSerialNumber' },
	'lensshutterlock' => { 174 => 0x4a },
	'lensspec' => { 378 => 0x0, 379 => 0x0, 380 => 0x0, 394 => 0xb02a },
	'lensspecfeatures' => { 412 => [0x115,0x116], 413 => [0x116,0x21c,0x21e] },
	'lenstemperature' => { 283 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x184, 27 => 0x112, 28 => 0x189, 33 => 0x16, 176 => 0x10c, 177 => 0x49bd, 214 => 0x83, 279 => 0x201, 292 => 0x16, 296 => 0x310, 298 => 0x303, 299 => 0x303, 301 => 0x51, 303 => 0x3405, 328 => 0x0, 329 => 0x0, 330 => 0x1, 331 => 0x1, 332 => 0x1, 334 => 0x0, 370 => 0xa003, 373 => 0x27, 394 => 0xb027, 406 => 0x1896, 408 => 0x18c2, 409 => 0x18f2, 410 => 0x17f6, 412 => 0x109, 413 => 0x109, 422 => 0x608, 423 => 0x62 },
	'lenstype2' => { 383 => 0x3f7, 406 => 0x1893, 408 => 0x18bf, 409 => 0x18ef, 410 => 0x17f3, 412 => 0x107, 413 => 0x107, 422 => 0x605, 423 => 0x60 },
	'lenstype3' => { 426 => 0x9 },
	'lenszoomposition' => { 419 => 0x19, 420 => 0x1e, 423 => [0x342,0x35a] },
	'levelindicator' => { 309 => 0x15 },
	'levelorientation' => { 335 => 0x0 },
	'license' => { 445 => 'license' },
	'licensee' => { 288 => 'Licensee' },
	'licenseeid' => { 288 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 288 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 288 => 'LicenseeImageNotes' },
	'licenseename' => { 288 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 288 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 288 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 288 => 'LicenseeTransactionID' },
	'licenseid' => { 288 => 'LicenseID' },
	'licensestartdate' => { 288 => 'LicenseStartDate' },
	'licensetransactiondate' => { 288 => 'LicenseTransactionDate' },
	'licensetype' => { 450 => 'licensetype' },
	'licensor' => { 288 => 'Licensor' },
	'licensorcity' => { 288 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 288 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 288 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 288 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 288 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 288 => 'LicensorImageID' },
	'licensorname' => { 288 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 288 => 'LicensorNotes' },
	'licensorpostalcode' => { 288 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 288 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 288 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 288 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 288 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 288 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 288 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 288 => 'LicensorTransactionID' },
	'licensorurl' => { 288 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 283 => 0x1009 },
	'lightingmode' => { 107 => 0x302a },
	'lightreading' => { 336 => 0x15 },
	'lightsource' => { 113 => 0x9208, 214 => 0x90, 286 => 0x1000, 452 => 'LightSource' },
	'lightsourcespecial' => { 372 => 0x21d },
	'lightswitch' => { 274 => '0.1', 276 => '0.1' },
	'lightvaluecenter' => { 283 => 0x103d },
	'lightvalueperiphery' => { 283 => 0x103e },
	'limitafareamodeselection' => { 262 => '51.1', 264 => '49.1', 265 => '49.1', 274 => '49.1', 275 => '49.1' },
	'linearitylimitblue' => { 306 => 0x10 },
	'linearitylimitgreen' => { 306 => 0xf },
	'linearitylimitred' => { 306 => 0xe },
	'linearityuppermargin' => { 42 => [0x2ba,0x2d1,0x2d5], 44 => 0x1e5, 45 => [0x1fe,0x2de], 46 => [0x232,0x310], 47 => 0x31e },
	'linearizationtable' => { 113 => 0xc618 },
	'linearresponselimit' => { 113 => 0xc62e },
	'link' => { 462 => 'link' },
	'linkaetoafpoint' => { 317 => '14.2' },
	'linkedencodedrightsexpr' => { 458 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 458 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 458 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 458 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 131 => 0x904 },
	'lithostratigraphicterms' => { 112 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 266 => '32.1', 276 => '34.1' },
	'liveviewafareamode' => { 271 => '34.1' },
	'liveviewafmethod' => { 399 => 0x20 },
	'liveviewafmode' => { 271 => '34.2' },
	'liveviewafsetting' => { 383 => 0x36 },
	'liveviewbuttonoptions' => { 262 => '50.2', 264 => '48.2', 265 => '48.2', 274 => '48.2', 275 => '48.2' },
	'liveviewexposuresimulation' => { 78 => 0x810 },
	'liveviewfocusmode' => { 383 => [0x8b,0x28b] },
	'liveviewmetering' => { 383 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 262 => '21.2', 264 => '21.2', 265 => '21.2', 267 => '20.2', 268 => '20.2', 269 => '20.2', 271 => '20.2', 274 => '21.2', 275 => '21.2' },
	'liveviewshooting' => { 54 => 0x13 },
	'livingspecimen' => { 112 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 112 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 125 => 0x79 },
	'localizedcameramodel' => { 113 => 0xc615 },
	'locallocationname' => { 370 => 0x30 },
	'location' => { 213 => 0x9, 301 => 0x67, 440 => 'Location', 457 => 'Location', 461 => 'location', 462 => 'location' },
	'locationareacode' => { 446 => 'lac' },
	'locationcreated' => { 458 => 'LocationCreated' },
	'locationcreatedcity' => { 458 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 458 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 458 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 458 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 458 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 458 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 458 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 458 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 458 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 458 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 458 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 458 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 213 => 0x0 },
	'locationname' => { 370 => 0x31 },
	'locationshown' => { 458 => 'LocationShown' },
	'locationshowncity' => { 458 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 458 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 458 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 458 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 458 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 458 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 458 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 458 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 458 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 458 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 458 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 458 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 78 => 0x709 },
	'logcomment' => { 472 => 'logComment' },
	'logscale' => { 131 => 0x902 },
	'longexposurenoisereduction' => { 59 => 0x4, 78 => 0x201, 79 => 0x1, 80 => 0x2, 81 => 0x1, 82 => 0x1, 83 => 0x2, 84 => 0x1, 301 => 0x49, 381 => 0x2b, 382 => 0x25, 383 => 0x25, 394 => 0x2008, 399 => 0x11, 423 => 0x44 },
	'longexposurenoisereduction2' => { 54 => 0x8 },
	'longitude' => { 110 => 'Longitude' },
	'loop' => { 472 => 'loop' },
	'lowestbiostratigraphiczone' => { 112 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 448 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 448 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 448 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 448 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 448 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 448 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 448 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 448 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 102 => 0x150 },
	'luminancecurvepoints' => { 102 => 0x126 },
	'luminancenoisereduction' => { 97 => 0x20600, 103 => 0x5f, 373 => 0x1b },
	'luminancenoisereductioncontrast' => { 448 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 448 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 103 => 0x6d },
	'luminancesmoothing' => { 448 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 78 => [0x40b,0x40c] },
	'lyrics' => { 472 => 'lyrics' },
	'm16cversion' => { 296 => 0x333 },
	'macatom' => { 447 => 'macAtom' },
	'macatomapplicationcode' => { 447 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 447 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 447 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 112 => 'MachineObservation' },
	'machineobservationday' => { 112 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 112 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 112 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 112 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 112 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 112 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 112 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 112 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 112 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 112 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 112 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 112 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 112 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 112 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 112 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 112 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 112 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 112 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 112 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 112 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 121 => 0x1020, 123 => 0x202, 283 => 0x202, 362 => 0x21, 372 => 0x202, 394 => 0xb040 },
	'macroled' => { 281 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 54 => 0x10 },
	'macromode' => { 33 => 0x1, 171 => 0xb, 278 => 0x300, 301 => 0x1c, 363 => 0x1009 },
	'magentahsl' => { 97 => 0x20917 },
	'magicfilter' => { 278 => 0x52c },
	'magnifiedview' => { 80 => 0x11, 82 => 0x9 },
	'mainboardversion' => { 131 => 0x438 },
	'maindialexposurecomp' => { 272 => '0.6' },
	'mainingredient' => { 464 => 'mainIngredient' },
	'majorversion' => { 438 => 'MajorVersion' },
	'make' => { 92 => 0x0, 109 => 0x1, 113 => 0x10f, 147 => 'Make', 291 => 'Make', 306 => 0x10f, 461 => 'make', 468 => 'Make' },
	'makernote' => { 452 => 'MakerNote' },
	'makernoteapple' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecanon' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecasio' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecasio2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotedji' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteflir' => { 111 => 'MakN', 113 => 0x927c },
	'makernotefujifilm' => { 111 => 'MakN', 113 => 0x927c },
	'makernotege' => { 111 => 'MakN', 113 => 0x927c },
	'makernotege2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehasselblad' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp6' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteisl' => { 111 => 'MakN', 113 => 0x927c },
	'makernotejvc' => { 111 => 'MakN', 113 => 0x927c },
	'makernotejvctext' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak10' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak11' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak12' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak1a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak1b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak6a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak6b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak7' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8c' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak9' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodakunknown' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekyocera' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica10' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica2' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica3' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica4' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica5' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica6' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica7' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica8' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica9' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta2' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotemotorola' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenintendo' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteoffset' => { 372 => 0xff },
	'makernoteolympus' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteolympus2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax6' => { 111 => 'MakN', 113 => 0x927c },
	'makernotephaseone' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericoh' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericoh2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericohpentax' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericohtext' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesafety' => { 113 => 0xc635 },
	'makernotesamsung1a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesamsung1b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesamsung2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyo' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyoc4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyopatch' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesigma' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesonyericsson' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesonysrf' => { 111 => 'MakN', 113 => 0x927c },
	'makernotetype' => { 363 => 0x1 },
	'makernoteunknown' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteunknownbinary' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteunknowntext' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteversion' => { 176 => 0x0, 214 => 0x1, 283 => 0x0, 301 => 0x8000, 367 => 0x0, 370 => 0x1, 373 => [0x1d,0x1f], 384 => 0x2000 },
	'managedfrom' => { 473 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 473 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 473 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 473 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 473 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 473 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 473 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 473 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 473 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 473 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 473 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 473 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 473 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 473 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 473 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 473 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 473 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 473 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 473 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 473 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 473 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 473 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 473 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 473 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 473 => 'Manager' },
	'managervariant' => { 473 => 'ManagerVariant' },
	'manageto' => { 473 => 'ManageTo' },
	'manageui' => { 473 => 'ManageUI' },
	'manifest' => { 473 => 'Manifest' },
	'manifestlinkform' => { 473 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 473 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 473 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 473 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 473 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 473 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 473 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 473 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 473 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 473 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 473 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 473 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 473 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 473 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 473 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 473 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 473 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 473 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 473 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 473 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 473 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 473 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 473 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 473 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 473 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 473 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 473 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 473 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 278 => 0x900, 301 => 0x86 },
	'manometerreading' => { 278 => 0x901 },
	'manualafpointselectpattern' => { 78 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 281 => 0x1209 },
	'manualflashoutput' => { 33 => 0x29, 263 => '8.2', 266 => '22.2', 267 => '23.1', 268 => '23.2', 270 => '16.2', 271 => '23.2', 272 => '8.2', 273 => '23.2', 276 => '24.2', 363 => 0x100c },
	'manualflashstrength' => { 278 => 0x406 },
	'manualfocusdistance' => { 214 => 0x85, 283 => 0x100c, 372 => 0x223 },
	'manualtv' => { 77 => 0x5, 78 => 0x705 },
	'manufacturedate' => { 181 => 0x6705, 316 => 0x1 },
	'manufacturedate1' => { 365 => 0x4 },
	'manufacturedate2' => { 365 => 0x5 },
	'manufacturer' => { 432 => 'Manufacturer', 461 => 'manufacturer' },
	'mariahchromablursize' => { 131 => 0xf0d },
	'mariahmaphithreshold' => { 131 => 0xf0c },
	'mariahmaplothreshold' => { 131 => 0xf0b },
	'mariahsigmathreshold' => { 131 => 0xf0e },
	'mariahtexturethreshold' => { 131 => 0xf0a },
	'marked' => { 459 => 'Marked', 476 => 'Marked' },
	'markers' => { 472 => 'markers' },
	'markerscomment' => { 472 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 472 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 472 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 472 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 472 => [\'markers','markersCuePointType'] },
	'markersduration' => { 472 => [\'markers','markersDuration'] },
	'markerslocation' => { 472 => [\'markers','markersLocation'] },
	'markersname' => { 472 => [\'markers','markersName'] },
	'markersprobability' => { 472 => [\'markers','markersProbability'] },
	'markersspeaker' => { 472 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 472 => [\'markers','markersStartTime'] },
	'markerstarget' => { 472 => [\'markers','markersTarget'] },
	'markerstype' => { 472 => [\'markers','markersType'] },
	'maskedareas' => { 113 => 0xc68e },
	'masterdocumentid' => { 125 => 0xb9 },
	'mastergain' => { 222 => 0x50 },
	'materialsample' => { 112 => 'MaterialSample' },
	'materialsampleid' => { 112 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 262 => '50.1', 264 => '48.1', 265 => '48.1', 274 => '48.1', 275 => '48.1' },
	'matrixselectk' => { 131 => 0x91b },
	'matrixselectthreshold' => { 131 => 0x91a },
	'matrixselectthreshold1' => { 131 => 0x91e },
	'matrixselectthreshold2' => { 131 => 0x91f },
	'matrixstructure' => { 356 => 0xa },
	'maxaperture' => { 33 => 0x1a, 131 => 0x3f9, 137 => 0x6103, 154 => 'MaxAperture', 171 => 0x17, 177 => 0x49c5, 212 => 0x36, 279 => 0x20a, 327 => '14.1' },
	'maxapertureatmaxfocal' => { 121 => 0x1407, 154 => 'MaxApertureAtMaxFocal', 206 => 0xb, 207 => 0x10, 208 => 0x11, 212 => 0x12, 279 => 0x206 },
	'maxapertureatminfocal' => { 121 => 0x1406, 206 => 0xa, 207 => 0xf, 208 => 0x10, 212 => 0x11, 279 => 0x205 },
	'maxaperturevalue' => { 113 => 0x9205, 345 => 0x414, 452 => 'MaxApertureValue' },
	'maxavailheight' => { 458 => 'MaxAvailHeight' },
	'maxavailwidth' => { 458 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 261 => 0xb, 262 => 0xc, 264 => '12.1', 265 => '12.1', 270 => 0xc, 271 => 0xb, 274 => '12.1', 275 => '12.1' },
	'maxfaces' => { 282 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x188, 27 => 0x116, 28 => 0x18d, 33 => 0x17, 121 => 0x1405, 154 => 'MaxFocalLength', 206 => 0x9, 207 => 0xe, 208 => 0xf, 212 => 0x10, 279 => 0x208, 406 => 0x127c, 407 => 0x1138, 408 => 0x330, 409 => 0x330, 410 => 0x30e },
	'maximumdensityrange' => { 127 => 0x8c },
	'maxpagesize' => { 477 => 'MaxPageSize' },
	'maxpagesizeh' => { 477 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 477 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 477 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 131 => 0xc7d },
	'maxsamplevalue' => { 113 => 0x119 },
	'maxstorage' => { 467 => 'maxstorage' },
	'mb-d10batteries' => { 261 => '12.6' },
	'mb-d10batterytype' => { 270 => '13.3' },
	'mb-d11batterytype' => { 271 => '2.3' },
	'mb-d12batterytype' => { 274 => '3.2' },
	'mb-d80batteries' => { 272 => '6.5' },
	'mb-d80batterytype' => { 276 => '3.2' },
	'mcuversion' => { 206 => 0xc, 207 => 0x11, 208 => 0x12, 212 => 0x13 },
	'md5digest' => { 155 => 'zmd5' },
	'mditemfindercomment' => { 164 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 164 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 164 => 'MDItemFSLabel' },
	'mditemusertags' => { 164 => 'MDItemUserTags' },
	'meal' => { 464 => 'meal' },
	'measuredev' => { 27 => 0x9, 72 => 0x3, 91 => 0x1814, 147 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 27 => 0x8, 72 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 177 => 0x690, 296 => 0x312, 299 => 0x312, 300 => 0x312, 303 => 0x3407 },
	'measuredrggb' => { 61 => 0x1 },
	'measuredrggbdata' => { 41 => 0x287 },
	'measurementaccuracy' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 112 => 'MeasurementOrFact' },
	'measurementremarks' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 432 => 'MeasureType' },
	'mechanicalshuttercount' => { 214 => 0x37 },
	'mediaconstraints' => { 288 => 'MediaConstraints' },
	'mediacreatedate' => { 353 => 0x1 },
	'mediaeventiddate' => { 437 => 'MediaEventIdDate' },
	'mediamodifydate' => { 353 => 0x2 },
	'mediasummarycode' => { 288 => 'MediaSummaryCode' },
	'memoaudioquality' => { 78 => 0x812 },
	'memorycardconfiguration' => { 387 => 0x16 },
	'memorycardnumber' => { 197 => 0x2 },
	'menubuttondisplayposition' => { 76 => 0xb, 79 => 0xa, 80 => 0xb, 83 => 0xb },
	'menubuttonreturn' => { 84 => 0xb },
	'menumonitorofftime' => { 261 => '26.1', 262 => '22.1', 264 => '22.1', 265 => '22.1', 269 => '21.1', 270 => '8.2', 271 => '21.1', 274 => '22.1', 275 => '22.1', 276 => '22.1' },
	'metadatadate' => { 470 => 'MetadataDate' },
	'metadatamoddate' => { 472 => 'metadataModDate' },
	'metaversion' => { 401 => 0x34 },
	'meterinfo1row1' => { 395 => 0x0, 396 => 0x0 },
	'meterinfo1row2' => { 395 => 0x6c, 396 => 0x5a },
	'meterinfo1row3' => { 395 => 0xd8, 396 => 0xb4 },
	'meterinfo1row4' => { 395 => 0x144, 396 => 0x10e },
	'meterinfo1row5' => { 395 => 0x1b0, 396 => 0x168 },
	'meterinfo1row6' => { 395 => 0x21c, 396 => 0x1c2 },
	'meterinfo1row7' => { 395 => 0x288, 396 => 0x21c },
	'meterinfo2row1' => { 395 => 0x2f4, 396 => 0x276 },
	'meterinfo2row2' => { 395 => 0x378, 396 => 0x2e4 },
	'meterinfo2row3' => { 395 => 0x3fc, 396 => 0x352 },
	'meterinfo2row4' => { 395 => 0x480, 396 => 0x3c0 },
	'meterinfo2row5' => { 395 => 0x504, 396 => 0x42e },
	'meterinfo2row6' => { 395 => 0x588, 396 => 0x49c },
	'meterinfo2row7' => { 395 => 0x60c, 396 => 0x50a },
	'meterinfo2row8' => { 395 => 0x690, 396 => 0x578 },
	'meterinfo2row9' => { 395 => 0x714, 396 => 0x5e6 },
	'metering' => { 263 => '6.1' },
	'meteringmode' => { 33 => 0x11, 113 => 0x9207, 133 => 0x1c, 171 => 0x7, 172 => 0x25, 174 => 0x12, 278 => 0x202, 336 => 0x17, 373 => 0x9, 381 => 0x15, 382 => 0x13, 383 => 0x7, 399 => 0x3, 402 => 0x1174, 403 => 0x1178, 404 => 0x1154, 405 => 0x11d0, 406 => 0x11ac, 407 => 0x1064, 408 => 0x25c, 409 => 0x25c, 410 => 0x24b, 452 => 'MeteringMode' },
	'meteringmode2' => { 317 => '2.1', 394 => 0x202c },
	'meteringmode3' => { 317 => '16.1' },
	'meteringoffscaleindicator' => { 174 => 0x53 },
	'meteringtime' => { 261 => '22.2', 263 => '3.2', 266 => '17.1', 267 => '18.1', 270 => '7.3', 271 => '18.1', 272 => '3.2', 276 => '19.1' },
	'micro1version' => { 358 => 0x1f },
	'micro2version' => { 358 => 0x2d },
	'midrangesharpness' => { 218 => 0x3b },
	'mieversion' => { 155 => '0Vers' },
	'mime' => { 432 => 'Mime' },
	'minaperture' => { 33 => 0x1b, 131 => 0x3f8, 154 => 'MinAperture', 327 => '0.2' },
	'minaperturevalue' => { 345 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x186, 27 => 0x114, 28 => 0x18b, 33 => 0x18, 121 => 0x1404, 154 => 'MinFocalLength', 206 => 0x8, 207 => 0xd, 208 => 0xe, 212 => 0xf, 279 => 0x207, 406 => 0x127a, 407 => 0x1136, 408 => 0x32e, 409 => 0x32e, 410 => 0x30c },
	'minfocusdistance' => { 327 => 0x3 },
	'minintegrationrows' => { 131 => 0x1874 },
	'minoltadate' => { 171 => 0x15 },
	'minoltaimagesize' => { 171 => 0x4, 172 => 0xc, 173 => 0x2, 176 => 0x103 },
	'minoltamodelid' => { 171 => 0x25 },
	'minoltaquality' => { 171 => 0x5, 172 => 0xd, 173 => 0x3, 176 => [0x102,0x103] },
	'minoltatime' => { 171 => 0x16 },
	'minormodelagedisclosure' => { 288 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 438 => 'MinorVersion' },
	'minsamplevalue' => { 113 => 0x118 },
	'mirrorlockup' => { 76 => 0xc, 77 => 0xc, 78 => 0x60f, 79 => 0xb, 80 => 0xc, 81 => 0x6, 82 => 0x6, 83 => 0xc, 84 => 0x3 },
	'mobilecountrycode' => { 446 => 'mcc' },
	'mobilenetworkcode' => { 446 => 'mnc' },
	'moddate' => { 291 => 'modify-date', 459 => 'ModDate' },
	'modedialposition' => { 387 => 0x14 },
	'model' => { 92 => 0x6, 113 => 0x110, 147 => 'Model', 291 => 'Model', 306 => 0x110, 336 => 0x23f, 373 => 0x84, 432 => 'Model', 461 => 'model', 468 => 'Model' },
	'modelage' => { 458 => 'ModelAge' },
	'modelid' => { 277 => 0x0 },
	'modelingflash' => { 261 => '21.4', 262 => '31.1', 264 => '31.1', 265 => '31.1', 270 => '26.4', 271 => '30.2', 272 => '7.4', 273 => '30.1', 274 => '31.1', 275 => '31.1', 276 => '31.3' },
	'modelreleaseid' => { 288 => 'ModelReleaseID' },
	'modelreleasestatus' => { 288 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 414 => 0x52, 415 => 0x46, 416 => 0x53 },
	'modeltiepoint' => { 113 => 0x8482 },
	'modeltransform' => { 113 => 0x85d8 },
	'modelyear' => { 461 => 'modelYear' },
	'modificationdate' => { 462 => 'modificationDate' },
	'modifiedcolortemp' => { 62 => 0x9 },
	'modifieddigitalgain' => { 62 => 0xb },
	'modifiedparamflag' => { 55 => 0x1 },
	'modifiedpicturestyle' => { 62 => 0xa },
	'modifiedsaturation' => { 278 => 0x504 },
	'modifiedsensorbluelevel' => { 62 => 0x5 },
	'modifiedsensorredlevel' => { 62 => 0x4 },
	'modifiedsharpness' => { 62 => 0x2 },
	'modifiedsharpnessfreq' => { 62 => 0x3 },
	'modifiedtonecurve' => { 62 => 0x1 },
	'modifiedwhitebalance' => { 62 => 0x8 },
	'modifiedwhitebalanceblue' => { 62 => 0x7 },
	'modifiedwhitebalancered' => { 62 => 0x6 },
	'modifydate' => { 113 => 0x132, 148 => 'ModifyDate', 287 => 'ModDate', 289 => 'tIME', 352 => 'ModDate', 354 => 0x2, 470 => 'ModifyDate' },
	'moirefilter' => { 113 => 0xfe58, 448 => 'MoireFilter' },
	'monitordisplayoff' => { 174 => 0x4c },
	'monitormatrix' => { 131 => 0x8fc },
	'monitorofftime' => { 261 => '18.2', 263 => '3.1', 272 => '3.1' },
	'monochromecolor' => { 278 => 0x53b },
	'monochromecontrast' => { 103 => 0x3c },
	'monochromefiltereffect' => { 97 => 0x20307, 103 => 0x3a, 336 => 0x73 },
	'monochromelinear' => { 103 => 0x3d },
	'monochromeoutputhighlightpoint' => { 103 => 0x41 },
	'monochromeoutputshadowpoint' => { 103 => 0x42 },
	'monochromeprofilesettings' => { 278 => 0x537 },
	'monochromerawhighlight' => { 103 => 0x7a },
	'monochromerawhighlightpoint' => { 103 => 0x3f },
	'monochromerawshadow' => { 103 => 0x83 },
	'monochromerawshadowpoint' => { 103 => 0x40 },
	'monochromesharpness' => { 103 => 0x3e },
	'monochrometoning' => { 336 => 0x74 },
	'monochrometoningeffect' => { 97 => 0x20306, 103 => 0x3b },
	'monochromeunsharpmaskfineness' => { 103 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 103 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 103 => 0xb4 },
	'monochromevignetting' => { 278 => 0x53a },
	'monthdaycreated' => { 133 => 0x12, 142 => 0xe },
	'moonphase' => { 357 => 0x12, 358 => 0x43, 359 => 0x4c },
	'morepermissions' => { 445 => 'morePermissions' },
	'motionsensitivity' => { 357 => 0x29, 359 => 0x60 },
	'movieaelockbuttonassignment' => { 274 => '40.1' },
	'moviefunc1button' => { 264 => '41.1', 265 => '41.1', 275 => '41.1' },
	'moviefunctionbutton' => { 262 => '41.1', 274 => '41.1' },
	'moviefunctionbuttonplusdials' => { 262 => '52.1' },
	'moviepreviewbutton' => { 262 => '41.2', 264 => '41.2', 265 => '41.2', 274 => '41.2', 275 => '41.2' },
	'moviepreviewbuttonplusdials' => { 262 => '52.2' },
	'movieshutterbutton' => { 262 => '38.3', 264 => '38.3', 265 => '38.3', 274 => '38.3', 275 => '38.3' },
	'moviesubselectorassignment' => { 262 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 262 => '53.1' },
	'multiburstimageheight' => { 394 => 0x1002 },
	'multiburstimagewidth' => { 394 => 0x1001 },
	'multiburstmode' => { 394 => 0x1000 },
	'multicontrollerwhilemetering' => { 78 => 0x517 },
	'multiexposure' => { 64 => 0x1, 301 => 0xb4 },
	'multiexposureautogain' => { 215 => 0x3 },
	'multiexposurecontrol' => { 64 => 0x2 },
	'multiexposuremode' => { 215 => 0x1 },
	'multiexposureshots' => { 64 => 0x3, 215 => 0x2 },
	'multiframenoisereduction' => { 383 => 0x35, 394 => 0x200b, 399 => 0x15 },
	'multiframenreffect' => { 394 => 0x2023 },
	'multifunctionlock' => { 78 => 0x70f },
	'multipleexposuremode' => { 282 => 0x101c },
	'multipleexposureset' => { 317 => '10.1' },
	'multisample' => { 222 => 0x40 },
	'multiselector' => { 261 => '9.4', 262 => '10.3', 264 => '10.3', 265 => '10.3', 270 => '27.4', 274 => '10.3', 275 => '10.3' },
	'multiselectorliveview' => { 261 => '4.3', 264 => '37.1', 265 => '37.1', 274 => '37.1', 275 => '37.1' },
	'multiselectorliveviewmode' => { 232 => 0x18c2 },
	'multiselectorplaybackmode' => { 261 => ['13.5','9.2'], 262 => '10.2', 265 => '10.2', 270 => '27.2', 274 => '10.2', 275 => '10.2' },
	'multiselectorshootmode' => { 261 => '9.1', 262 => '10.1', 264 => '10.1', 265 => '10.1', 270 => '27.1', 274 => '10.1', 275 => '10.1' },
	'multishot' => { 306 => 0x121 },
	'mycolormode' => { 65 => 0x2 },
	'nationalcatalognumber' => { 462 => 'nationalCatalogNumber' },
	'nativedigest' => { 452 => 'NativeDigest', 468 => 'NativeDigest' },
	'ndfilter' => { 72 => 0x1c, 278 => 0x204, 363 => 0x1019 },
	'near' => { 432 => 'Near' },
	'nefbitdepth' => { 214 => 0xe22 },
	'nefcompression' => { 214 => 0x93 },
	'neflinearizationtable' => { 214 => 0x96 },
	'negativecachelargepreviewsize' => { 448 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 448 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 448 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 336 => 0x88 },
	'neutraloutputhighlightpoint' => { 103 => 0x2f },
	'neutraloutputshadowpoint' => { 103 => 0x30 },
	'neutralrawcolortone' => { 103 => 0x28 },
	'neutralrawcontrast' => { 103 => 0x2a },
	'neutralrawhighlight' => { 103 => 0x78 },
	'neutralrawhighlightpoint' => { 103 => 0x2d },
	'neutralrawlinear' => { 103 => 0x2b },
	'neutralrawsaturation' => { 103 => 0x29 },
	'neutralrawshadow' => { 103 => 0x81 },
	'neutralrawshadowpoint' => { 103 => 0x2e },
	'neutralrawsharpness' => { 103 => 0x2c },
	'neutralunsharpmaskfineness' => { 103 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 103 => 0xa8 },
	'neutraunsharpmaskstrength' => { 103 => 0xa4 },
	'newrawimagedigest' => { 113 => 0xc7a7 },
	'newsphotoversion' => { 127 => 0x0 },
	'nickname' => { 470 => 'Nickname' },
	'nikoncapturedata' => { 214 => 0xe01 },
	'nikoncaptureeditversions' => { 214 => 0xe13 },
	'nikoncaptureoutput' => { 214 => 0xe1e },
	'nikoncaptureversion' => { 214 => 0xe09 },
	'nikoniccprofile' => { 214 => 0xe1d },
	'nikonimagesize' => { 229 => '723.1', 230 => '732.1', 239 => 0x2c4 },
	'noisefilter' => { 278 => 0x527 },
	'noiseprofile' => { 113 => 0xc761 },
	'noisereduction' => { 121 => [0x100b,0x100e], 172 => 0xb0, 173 => 0x60, 174 => 0x3f, 214 => 0x95, 254 => 0x753dcbc0, 255 => 0x17, 278 => 0x50a, 283 => 0x103a, 301 => 0x2d, 336 => 0x49, 363 => 0x100f, 365 => 0x2a },
	'noisereduction2' => { 282 => 0x1010 },
	'noisereductionapplied' => { 113 => 0xc6f7 },
	'noisereductionintensity' => { 255 => 0x9 },
	'noisereductionmethod' => { 255 => 0x11 },
	'noisereductionmode' => { 427 => 0x801e },
	'noisereductionparametersatcapture' => { 131 => 0xe73 },
	'noisereductionparameterscamera' => { 131 => 0xe72 },
	'noisereductionparametershost3mp' => { 131 => 0xe71 },
	'noisereductionparametershost6mp' => { 131 => 0xe70 },
	'noisereductionparametershostrgb' => { 131 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 131 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 131 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 131 => 0xe63 },
	'noisereductionparams' => { 306 => 0x1b },
	'noisereductionsharpness' => { 255 => 0xd },
	'noisereductionvalue' => { 427 => 0x8027 },
	'nomemorycard' => { 261 => '22.1', 262 => '4.2', 263 => '0.3', 266 => '2.4', 267 => '3.2', 268 => '3.2', 270 => '33.7', 271 => '3.2', 272 => '0.3', 274 => '4.2', 276 => '4.5' },
	'nominalmaxaperture' => { 327 => 0xa },
	'nominalminaperture' => { 327 => '10.1' },
	'normallinetime' => { 131 => 0x186a },
	'normalwhitelevel' => { 42 => [0x2b8,0x2cf,0x2d3], 44 => 0x1e3, 45 => [0x1fc,0x2dc], 46 => [0x230,0x30e], 47 => 0x31c },
	'notes' => { 428 => 'Notes', 442 => 'notes' },
	'npages' => { 477 => 'NPages' },
	'nullrecord' => { 91 => 0x0 },
	'numafpoints' => { 313 => 0x2 },
	'number' => { 462 => 'number' },
	'numberofbeats' => { 472 => 'numberOfBeats' },
	'numberoffocuspoints' => { 264 => '1.2', 265 => '1.2', 268 => '0.2', 269 => '0.3', 271 => '0.3' },
	'numfaceelements' => { 121 => 0x4200 },
	'numfacepositions' => { 293 => 0x0 },
	'numindexentries' => { 127 => 0x54 },
	'numwbentries' => { 307 => 0x0, 308 => 0x0 },
	'object' => { 462 => 'object' },
	'objectattributereference' => { 125 => 0x4 },
	'objectcycle' => { 125 => 0x4b, 442 => 'ObjectCycle' },
	'objectdescription' => { 461 => 'objectDescription' },
	'objectdistance' => { 106 => 0x6, 107 => 0x2022 },
	'objectname' => { 125 => 0x5 },
	'objectpreviewdata' => { 125 => 0xca },
	'objectpreviewfileformat' => { 125 => 0xc8 },
	'objectpreviewfileversion' => { 125 => 0xc9 },
	'objectsubtype' => { 461 => 'objectSubtype' },
	'objecttype' => { 461 => 'objectType' },
	'objecttypereference' => { 125 => 0x3 },
	'occurrence' => { 112 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 112 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 112 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 112 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 112 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 112 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 112 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 112 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 112 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 112 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 112 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 112 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 112 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 112 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 112 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 112 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 112 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 112 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 112 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 112 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 112 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 112 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 112 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 112 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 112 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 112 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 452 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 452 => [\'OECF','OECFNames'] },
	'oecfrows' => { 452 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 452 => [\'OECF','OECFValues'] },
	'offsaledate' => { 462 => 'offSaleDate' },
	'offsaledatea-platform' => { 462 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 462 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 131 => 0x190a },
	'offsetschema' => { 113 => 0xea1d },
	'offsettime' => { 113 => 0x9010 },
	'offsettimedigitized' => { 113 => 0x9012 },
	'offsettimeoriginal' => { 113 => 0x9011 },
	'okbutton' => { 271 => '15.1', 276 => '16.1' },
	'oldsubfiletype' => { 113 => 0xff },
	'olympusimageheight' => { 283 => 0x102f },
	'olympusimagewidth' => { 283 => 0x102e },
	'omenatcapturestrength' => { 131 => 0xa60 },
	'omenautostrength' => { 131 => 0xa5f },
	'omenearlystrength' => { 131 => 0xa5e },
	'omenfocallengthlimit' => { 131 => 0xa62 },
	'omeninitialipfstrength' => { 131 => 0xa5d },
	'omensurfaceindex' => { 131 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 283 => 0x302 },
	'onsaledate' => { 462 => 'onSaleDate' },
	'onsaledatea-platform' => { 462 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 462 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 462 => 'onSaleDay' },
	'onsaledaya-platform' => { 462 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 462 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 113 => 0xc740 },
	'opcodelist2' => { 113 => 0xc741 },
	'opcodelist3' => { 113 => 0xc74e },
	'opticalzoom' => { 135 => 0xfa3d, 137 => [0x6006,0xf006], 138 => 0x1000, 139 => 0xf, 142 => 0x1e, 154 => 'OpticalZoom' },
	'opticalzoomcode' => { 72 => 0xa },
	'opticalzoommode' => { 301 => 0x34 },
	'opticalzoomon' => { 372 => 0x219 },
	'optionenddate' => { 465 => 'optionEndDate' },
	'opto-electricconvfactor' => { 452 => 'OECF' },
	'orangehsl' => { 97 => 0x20911 },
	'ordernumber' => { 121 => 0x8002 },
	'organisationinimagecode' => { 458 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 458 => 'OrganisationInImageName' },
	'organism' => { 112 => 'Organism' },
	'organismassociatedoccurrences' => { 112 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 112 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 112 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 112 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 112 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 112 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 112 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 462 => 'organization' },
	'orientation' => { 113 => 0x112, 306 => 0x112, 461 => 'orientation', 468 => 'Orientation' },
	'orientation2' => { 399 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 78 => 0x516 },
	'originalbestqualitysize' => { 113 => 0xc792 },
	'originalcreatedatetime' => { 437 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 108 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 60 => 0x83 },
	'originaldefaultcropsize' => { 113 => 0xc793 },
	'originaldefaultfinalsize' => { 113 => 0xc791 },
	'originaldirectory' => { 298 => 0x408 },
	'originaldocumentid' => { 473 => 'OriginalDocumentID' },
	'originalfilename' => { 91 => 0x816, 131 => 0x3e9, 143 => 0x20, 298 => 0x407, 437 => 'OriginalFilename' },
	'originalimageheight' => { 74 => 0xc, 117 => 0x1 },
	'originalimagewidth' => { 74 => 0xb, 117 => 0x0 },
	'originalrawfiledata' => { 113 => 0xc68c },
	'originalrawfiledigest' => { 113 => 0xc71d },
	'originalrawfilename' => { 113 => 0xc68b },
	'originaltransmissionreference' => { 125 => 0x67 },
	'originatingprogram' => { 125 => 0x41, 442 => 'OriginatingProgram' },
	'originplatform' => { 462 => 'originPlatform' },
	'os' => { 450 => 'os' },
	'otherconditions' => { 288 => 'OtherConditions' },
	'otherconstraints' => { 288 => 'OtherConstraints' },
	'otherimage' => { 108 => 'OtherImage' },
	'otherimageinfo' => { 288 => 'OtherImageInfo' },
	'otherimagelength' => { 113 => 0x202 },
	'otherimagestart' => { 113 => 0x201 },
	'otherlicensedocuments' => { 288 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 288 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 288 => 'OtherLicenseRequirements' },
	'outcue' => { 472 => 'outCue' },
	'outcuescale' => { 472 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 472 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 186 => 0x3 },
	'outputimagewidth' => { 186 => 0x2 },
	'outputlut' => { 301 => 0xa7 },
	'outputprofile' => { 131 => 0x138b },
	'outputresolution' => { 186 => 0x4 },
	'overclockcols' => { 131 => 0x189c },
	'overclockrows' => { 131 => 0x18c4 },
	'owner' => { 476 => 'Owner' },
	'ownerid' => { 125 => 0xbc },
	'ownername' => { 14 => 0x10f, 60 => 0x9, 91 => 0x810, 113 => [0xa430,0xfde8], 147 => 'OwnerName', 444 => 'OwnerName', 453 => 'CameraOwnerName' },
	'padding' => { 113 => 0xea1c },
	'pagecount' => { 462 => 'pageCount' },
	'pageimage' => { 470 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 470 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 470 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 470 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 470 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 470 => 'PageInfo' },
	'pagename' => { 113 => 0x11d },
	'pagenumber' => { 113 => 0x129 },
	'pageprogressiondirection' => { 462 => 'pageProgressionDirection' },
	'pagerange' => { 462 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 448 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 448 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicdatetime' => { 304 => 0x0 },
	'panasonicexifversion' => { 301 => 0x26 },
	'panasonicimageheight' => { 301 => 0x4c },
	'panasonicimagewidth' => { 301 => 0x4b },
	'panasonicrawversion' => { 306 => 0x1 },
	'panasonictitle' => { 113 => 0xc6d2 },
	'panasonictitle2' => { 113 => 0xc6d3 },
	'panoramaangle' => { 121 => 0x1153 },
	'panoramacropbottom' => { 400 => 0x7 },
	'panoramacropleft' => { 400 => 0x4 },
	'panoramacropright' => { 400 => 0x6 },
	'panoramacroptop' => { 400 => 0x5 },
	'panoramadirection' => { 68 => 0x5, 121 => 0x1154, 400 => 0x3 },
	'panoramaframeheight' => { 400 => 0x9 },
	'panoramaframenumber' => { 68 => 0x2 },
	'panoramaframewidth' => { 400 => 0x8 },
	'panoramafullheight' => { 400 => 0x2 },
	'panoramafullwidth' => { 400 => 0x1 },
	'panoramamode' => { 133 => 0x3c, 278 => 0x601 },
	'panoramasize3d' => { 383 => 0x38 },
	'panoramasourceheight' => { 400 => 0xb },
	'panoramasourcewidth' => { 400 => 0xa },
	'panoramicstitchcameramotion' => { 167 => 'PanoramicStitchCameraMotion', 168 => 0x1 },
	'panoramicstitchmaptype' => { 167 => 'PanoramicStitchMapType', 168 => 0x2 },
	'panoramicstitchphi0' => { 167 => 'PanoramicStitchPhi0', 168 => 0x5 },
	'panoramicstitchphi1' => { 167 => 'PanoramicStitchPhi1', 168 => 0x6 },
	'panoramicstitchtheta0' => { 167 => 'PanoramicStitchTheta0', 168 => 0x3 },
	'panoramicstitchtheta1' => { 167 => 'PanoramicStitchTheta1', 168 => 0x4 },
	'panoramicstitchversion' => { 168 => 0x0 },
	'pantry' => { 473 => 'Pantry' },
	'parallax' => { 121 => 0xb211, 277 => 0x28 },
	'parametricdarks' => { 448 => 'ParametricDarks' },
	'parametrichighlights' => { 448 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 448 => 'ParametricHighlightSplit' },
	'parametriclights' => { 448 => 'ParametricLights' },
	'parametricmidtonesplit' => { 448 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 448 => 'ParametricShadows' },
	'parametricshadowsplit' => { 448 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 437 => 'ParentMediaEventID' },
	'parentmeid' => { 437 => 'ParentMEID' },
	'parentreference1' => { 456 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 456 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partialactivecols1' => { 131 => 0x17e8 },
	'partialactivecols2' => { 131 => 0x17f2 },
	'partialactiverows1' => { 131 => 0x17fc },
	'partialactiverows2' => { 131 => 0x1806 },
	'partofcompilation' => { 472 => 'partOfCompilation' },
	'patientbirthdate' => { 429 => 'PatientDOB' },
	'patientid' => { 429 => 'PatientID' },
	'patientname' => { 429 => 'PatientName' },
	'patientsex' => { 429 => 'PatientSex' },
	'patternareaheight' => { 131 => 0x963 },
	'patternareawidth' => { 131 => 0x962 },
	'patterncorrectionfactorscale' => { 131 => 0x969 },
	'patterncropcols1' => { 131 => 0x96c },
	'patterncropcols2' => { 131 => 0x96d },
	'patterncroprows1' => { 131 => 0x96a },
	'patterncroprows2' => { 131 => 0x96b },
	'patternimagerheight' => { 131 => 0x961 },
	'patternimagerwidth' => { 131 => 0x960 },
	'patternx' => { 131 => 0x966 },
	'patterny' => { 131 => 0x967 },
	'pdfversion' => { 459 => 'PDFVersion' },
	'pentaximagesize' => { 336 => 0x9 },
	'pentaxmodelid' => { 316 => 0x0, 336 => 0x5 },
	'pentaxmodeltype' => { 336 => 0x1 },
	'pentaxversion' => { 336 => 0x0 },
	'people' => { 430 => 'People', 440 => 'People' },
	'perchannelblacklevel' => { 41 => 0xc4, 42 => [0x2b4,0x2cb,0x2cf], 43 => [0x108,0x14d], 44 => 0x1df, 45 => [0x1f8,0x2d8], 46 => [0x22c,0x30a], 47 => 0x149 },
	'peripheralillumcentralradius' => { 427 => 0x8030 },
	'peripheralillumcentralvalue' => { 427 => 0x8031 },
	'peripheralillumination' => { 97 => 0x20702, 103 => 0x68 },
	'peripheralilluminationcorr' => { 59 => 0x1, 326 => 0x2 },
	'peripheralilluminationon' => { 97 => '0x20702.0', 103 => 0x64 },
	'peripheralillumperiphvalue' => { 427 => 0x8032 },
	'peripherallighting' => { 74 => 0x2 },
	'peripherallightingsetting' => { 75 => 0x5 },
	'peripherallightingvalue' => { 74 => 0x6 },
	'permissions' => { 465 => 'permissions' },
	'permits' => { 445 => 'permits' },
	'person' => { 462 => 'person' },
	'personality' => { 437 => 'Personality' },
	'personheard' => { 458 => 'PersonHeard' },
	'personheardidentifier' => { 458 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 458 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 458 => 'PersonInImage' },
	'personinimagecharacteristic' => { 458 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 458 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 458 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 458 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 458 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 458 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 458 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 458 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 458 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 448 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 448 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 448 => 'PerspectiveRotate' },
	'perspectivescale' => { 448 => 'PerspectiveScale' },
	'perspectiveupright' => { 448 => 'PerspectiveUpright' },
	'perspectivevertical' => { 448 => 'PerspectiveVertical' },
	'perspectivex' => { 448 => 'PerspectiveX' },
	'perspectivey' => { 448 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 86 => 0x1 },
	'pf10retainprogramshift' => { 86 => 0xb },
	'pf13drivepriority' => { 86 => 0xe },
	'pf14disablefocussearch' => { 86 => 0xf },
	'pf15disableafassistbeam' => { 86 => 0x10 },
	'pf16autofocuspointshoot' => { 86 => 0x11 },
	'pf17disableafpointsel' => { 86 => 0x12 },
	'pf18enableautoafpointsel' => { 86 => 0x13 },
	'pf19continuousshootspeed' => { 86 => 0x14 },
	'pf19shootingspeedhigh' => { 85 => 0xa },
	'pf19shootingspeedlow' => { 85 => 0x9 },
	'pf1disableshootingmodes' => { 86 => 0x2 },
	'pf1value' => { 85 => 0x1 },
	'pf20limitcontinousshots' => { 86 => 0x15 },
	'pf20maxcontinousshots' => { 85 => 0xb },
	'pf21enablequietoperation' => { 86 => 0x16 },
	'pf23felocktime' => { 85 => 0xd },
	'pf23postreleasetime' => { 85 => 0xe },
	'pf23settimerlengths' => { 86 => 0x18 },
	'pf23shutterbuttontime' => { 85 => 0xc },
	'pf24lightlcdduringbulb' => { 86 => 0x19 },
	'pf25aemode' => { 85 => 0xf },
	'pf25afmode' => { 85 => 0x12 },
	'pf25afpointsel' => { 85 => 0x13 },
	'pf25colormatrix' => { 85 => 0x17 },
	'pf25defaultclearsettings' => { 86 => 0x1a },
	'pf25drivemode' => { 85 => 0x11 },
	'pf25imagesize' => { 85 => 0x14 },
	'pf25meteringmode' => { 85 => 0x10 },
	'pf25parameters' => { 85 => 0x16 },
	'pf25wbmode' => { 85 => 0x15 },
	'pf26shortenreleaselag' => { 86 => 0x1b },
	'pf27reversedialrotation' => { 86 => 0x1c },
	'pf27value' => { 85 => 0x18 },
	'pf28noquickdialexpcomp' => { 86 => 0x1d },
	'pf29quickdialswitchoff' => { 86 => 0x1e },
	'pf2disablemeteringmodes' => { 86 => 0x3 },
	'pf2value' => { 85 => 0x2 },
	'pf30enlargementmode' => { 86 => 0x1f },
	'pf31originaldecisiondata' => { 86 => 0x20 },
	'pf3manualexposuremetering' => { 86 => 0x4 },
	'pf3value' => { 85 => 0x3 },
	'pf4exposuretimelimits' => { 86 => 0x5 },
	'pf4exposuretimemax' => { 85 => 0x5 },
	'pf4exposuretimemin' => { 85 => 0x4 },
	'pf5aperturelimits' => { 86 => 0x6 },
	'pf5aperturemax' => { 85 => 0x7 },
	'pf5aperturemin' => { 85 => 0x6 },
	'pf6presetshootingmodes' => { 86 => 0x7 },
	'pf7bracketcontinuousshoot' => { 86 => 0x8 },
	'pf8bracketshots' => { 85 => 0x8 },
	'pf8setbracketshots' => { 86 => 0x9 },
	'pf9changebracketsequence' => { 86 => 0xa },
	'phasedetectaf' => { 183 => 0x6 },
	'phonenumber' => { 148 => 'Phone' },
	'photoeffect' => { 33 => 0x28 },
	'photoeffecthistoryxml' => { 254 => 0xe9651831 },
	'photoeffects' => { 254 => 0xab5eca5e },
	'photoeffectsblue' => { 256 => 0x8 },
	'photoeffectsgreen' => { 256 => 0x6 },
	'photoeffectsred' => { 256 => 0x4 },
	'photoeffectstype' => { 256 => 0x0 },
	'photographicsensitivity' => { 453 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 261 => '17.6', 270 => '33.6' },
	'photometricinterpretation' => { 113 => 0x106, 468 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 233 => 0xe7d, 242 => 0xfbd },
	'photoshootingmenubankimagearea' => { 233 => '3716.1', 242 => 0x791 },
	'photoshopbgrthumbnail' => { 350 => 0x409 },
	'photoshopquality' => { 349 => 0x0 },
	'photoshopthumbnail' => { 350 => 0x40c },
	'photostyle' => { 301 => 0x89 },
	'picklabel' => { 451 => 'PickLabel' },
	'pictinfo' => { 372 => 0x208 },
	'picturecontrol' => { 254 => 0xe2173c47 },
	'picturecontrolactive' => { 257 => 0x0 },
	'picturecontroladjust' => { 216 => 0x30, 217 => 0x30, 218 => 0x36 },
	'picturecontrolbase' => { 216 => 0x18, 217 => 0x18, 218 => 0x1c },
	'picturecontroldata' => { 214 => [0xbd,0x23] },
	'picturecontrolmode' => { 257 => 0x13 },
	'picturecontrolname' => { 216 => 0x4, 217 => 0x4, 218 => 0x8 },
	'picturecontrolquickadjust' => { 216 => 0x31, 217 => 0x31, 218 => 0x37 },
	'pictureeffect' => { 394 => 0x200e },
	'pictureeffect2' => { 402 => 0x1163, 403 => 0x1167, 404 => 0x1143, 405 => 0x11bf, 406 => 0x119b, 407 => 0x1053, 408 => 0x24b, 409 => 0x24b, 410 => 0x23c, 423 => 0x46 },
	'picturefinish' => { 172 => 0x71 },
	'picturemode' => { 121 => 0x1031, 278 => 0x520, 336 => [0xb,0x33], 373 => 0x3d },
	'picturemode2' => { 317 => 0x0 },
	'picturemodebwfilter' => { 278 => 0x525 },
	'picturemodecontrast' => { 278 => 0x523 },
	'picturemodeeffect' => { 278 => 0x52d },
	'picturemodehue' => { 278 => 0x522 },
	'picturemodesaturation' => { 278 => 0x521 },
	'picturemodesharpness' => { 278 => 0x524 },
	'picturemodetone' => { 278 => 0x526 },
	'pictureprofile' => { 402 => [0x115e,0x115f], 403 => [0x1162,0x1163], 404 => [0x113e,0x113f], 405 => [0x11ba,0x11bb], 406 => [0x1196,0x1197], 407 => [0x104e,0x104f], 408 => [0x246,0x247], 409 => [0x246,0x247], 410 => [0x237,0x238] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 26 => 0x169, 70 => 0xa, 97 => 0x20301, 103 => 0x2 },
	'picturewizard' => { 370 => 0x21 },
	'picturewizardcolor' => { 369 => 0x1 },
	'picturewizardcontrast' => { 369 => 0x4 },
	'picturewizardmode' => { 369 => 0x0 },
	'picturewizardsaturation' => { 369 => 0x2 },
	'picturewizardsharpness' => { 369 => 0x3 },
	'pipelineversion' => { 167 => 'PipelineVersion' },
	'pitch' => { 109 => 0x6, 262 => '4.1', 274 => '4.1' },
	'pitchangle' => { 232 => 0x350f, 233 => 0x2c28, 241 => 0x36f8, 278 => 0x904, 301 => 0x91, 335 => 0x2, 368 => 0x1 },
	'pixelclockfrequency' => { 131 => 0x40b },
	'pixelcorrectionoffset' => { 131 => 0x972 },
	'pixelcorrectionscale' => { 131 => 0x971 },
	'pixelscale' => { 113 => 0x830e },
	'pixelshiftinfo' => { 394 => 0x202f },
	'pixelshiftresolution' => { 337 => 0x0 },
	'pixelsperunitx' => { 290 => 0x0 },
	'pixelsperunity' => { 290 => 0x4 },
	'pixelunits' => { 290 => 0x8 },
	'planarconfiguration' => { 113 => 0x11c, 468 => 'PlanarConfiguration' },
	'planningref' => { 458 => 'PlanningRef' },
	'planningrefidentifier' => { 458 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 458 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 458 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 477 => 'PlateNames' },
	'platform' => { 462 => 'platform' },
	'playbackmenustime' => { 266 => '20.1', 267 => '21.1', 268 => '21.1' },
	'playbackmonitorofftime' => { 261 => '25.2', 262 => '36.1', 264 => '36.1', 265 => '36.1', 269 => '35.1', 270 => '8.1', 271 => '35.1', 274 => '36.1', 275 => '36.1', 276 => '21.1' },
	'playbackzoom' => { 262 => '37.1' },
	'playdisplay' => { 174 => 0x4e },
	'plusversion' => { 288 => 'Version' },
	'pmversion' => { 348 => 'PMVersion' },
	'pngwarning' => { 291 => 'Warning' },
	'poilevel' => { 213 => 0x8 },
	'portraitoutputhighlightpoint' => { 103 => 0x1d },
	'portraitoutputshadowpoint' => { 103 => 0x1e },
	'portraitrawcolortone' => { 103 => 0x16 },
	'portraitrawcontrast' => { 103 => 0x18 },
	'portraitrawhighlight' => { 103 => 0x76 },
	'portraitrawhighlightpoint' => { 103 => 0x1b },
	'portraitrawlinear' => { 103 => 0x19 },
	'portraitrawsaturation' => { 103 => 0x17 },
	'portraitrawshadow' => { 103 => 0x7f },
	'portraitrawshadowpoint' => { 103 => 0x1c },
	'portraitrawsharpness' => { 103 => 0x1a },
	'portraitrefiner' => { 107 => 0x302b },
	'portraitunsharpmaskfineness' => { 103 => 0x9a },
	'portraitunsharpmaskstrength' => { 103 => 0x98 },
	'portraitunsharpmaskthreshold' => { 103 => 0x9c },
	'poseheadingdegrees' => { 435 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 435 => 'PosePitchDegrees' },
	'poserolldegrees' => { 435 => 'PoseRollDegrees' },
	'positiondescriptor' => { 461 => 'positionDescriptor' },
	'postalcode' => { 152 => 'PostalCode' },
	'postcropvignetteamount' => { 448 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 448 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 448 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 448 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 448 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 448 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 391 => 0xb },
	'potentialface2position' => { 391 => 0x15 },
	'potentialface3position' => { 391 => 0x1f },
	'potentialface4position' => { 391 => 0x29 },
	'potentialface5position' => { 391 => 0x33 },
	'potentialface6position' => { 391 => 0x3d },
	'potentialface7position' => { 391 => 0x47 },
	'potentialface8position' => { 391 => 0x51 },
	'powersource' => { 315 => '0.1' },
	'poweruptime' => { 214 => 0xb6 },
	'precaptureframes' => { 283 => 0x300 },
	'predictor' => { 113 => 0x13d },
	'preflashreturnstrength' => { 230 => 0x28a },
	'prefs' => { 125 => 0xdd, 348 => 'Prefs' },
	'prereadfastresetcount' => { 131 => 0x187e },
	'preservedfilename' => { 473 => 'PreservedFileName' },
	'preservedspecimen' => { 112 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 112 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presetwhitebalance' => { 174 => 0x24, 427 => 0x8002 },
	'presetwhitebalanceadj' => { 427 => 0x8014 },
	'pressure' => { 113 => 0x9402, 453 => 'Pressure' },
	'previewapplicationname' => { 113 => 0xc716 },
	'previewapplicationversion' => { 113 => 0xc717 },
	'previewbutton' => { 261 => ['14.1','15.1'], 262 => '15.1', 264 => '15.1', 265 => '15.1', 270 => '29.1', 271 => '14.1', 274 => '15.1', 275 => '15.1' },
	'previewbuttonplusdials' => { 261 => ['14.2','15.2'], 262 => '15.2', 264 => '43.1', 265 => '43.1', 270 => '31.2', 274 => '43.1', 275 => '43.1' },
	'previewcolorspace' => { 113 => 0xc71a },
	'previewcropbottom' => { 347 => 0xef },
	'previewcropleft' => { 347 => 0xec },
	'previewcropright' => { 347 => 0xee },
	'previewcroptop' => { 347 => 0xed },
	'previewdate' => { 355 => 0x0 },
	'previewdatetime' => { 113 => 0xc71b },
	'previewimage' => { 107 => 0x2000, 108 => 'PreviewImage', 114 => 'PreviewImage', 116 => 0x4, 157 => 'data', 176 => 0x81, 283 => 0x280, 299 => 0x300, 394 => 0x2001 },
	'previewimageborders' => { 336 => 0x3e },
	'previewimageheight' => { 69 => 0x4, 135 => 0xfa58 },
	'previewimagelength' => { 69 => 0x2, 107 => 0x3, 113 => [0x117,0x202], 176 => 0x89, 219 => 0x202, 278 => 0x102, 283 => 0x1037, 336 => 0x3, 362 => 0x1e, 367 => 0x3, 373 => [0x1b,0x1d], 384 => 0x202 },
	'previewimagename' => { 157 => '1Name' },
	'previewimagesize' => { 107 => 0x2, 140 => 0x2, 157 => 'ImageSize', 336 => 0x2, 373 => [0x1c,0x1e], 394 => 0xb02c, 427 => 0x9012 },
	'previewimagestart' => { 69 => 0x5, 107 => 0x4, 113 => [0x111,0x201], 176 => 0x88, 219 => 0x201, 278 => 0x101, 283 => 0x1036, 336 => 0x4, 362 => 0x1c, 367 => 0x2, 373 => [0x1a,0x1c], 384 => 0x201 },
	'previewimagetype' => { 157 => '0Type' },
	'previewimagevalid' => { 278 => 0x100, 283 => 0x1035 },
	'previewimagewidth' => { 69 => 0x3, 135 => 0xfa57 },
	'previewquality' => { 69 => 0x1 },
	'previewsettingsdigest' => { 113 => 0xc719 },
	'previewsettingsname' => { 113 => 0xc718 },
	'primaryafpoint' => { 183 => [0x44,0x7] },
	'primarychromaticities' => { 113 => 0x13f, 468 => 'PrimaryChromaticities' },
	'primaryftp' => { 437 => 'PrimaryFTP' },
	'primaryslot' => { 233 => 0xe7f, 242 => 0xfbf },
	'printim' => { 113 => 0xc4a5 },
	'prioritysetinawb' => { 394 => 0x202b },
	'prioritysetupshutterrelease' => { 174 => 0x1d, 381 => 0x28 },
	'privatertkinfo' => { 439 => 'privateRTKInfo' },
	'processbordercolsleft' => { 131 => 0xc61 },
	'processbordercolsright' => { 131 => 0xc62 },
	'processborderrowsbottom' => { 131 => 0xc64 },
	'processborderrowstop' => { 131 => 0xc63 },
	'processingsoftware' => { 113 => 0xb },
	'processversion' => { 448 => 'ProcessVersion' },
	'producer' => { 287 => 'Producer', 459 => 'Producer' },
	'productcode' => { 462 => 'productCode' },
	'productid' => { 126 => 0x32, 461 => 'productID' },
	'productidtype' => { 461 => 'productIDType' },
	'productinimage' => { 458 => 'ProductInImage' },
	'productinimagedescription' => { 458 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 458 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 458 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 316 => 0x2 },
	'productorserviceconstraints' => { 288 => 'ProductOrServiceConstraints' },
	'profession' => { 462 => 'profession' },
	'profilecalibrationsig' => { 113 => 0xc6f4 },
	'profilecopyright' => { 113 => 0xc6fe },
	'profileembedpolicy' => { 113 => 0xc6fd },
	'profilehuesatmapdata1' => { 113 => 0xc6fa },
	'profilehuesatmapdata2' => { 113 => 0xc6fb },
	'profilehuesatmapdims' => { 113 => 0xc6f9 },
	'profilehuesatmapencoding' => { 113 => 0xc7a3 },
	'profilelooktabledata' => { 113 => 0xc726 },
	'profilelooktabledims' => { 113 => 0xc725 },
	'profilelooktableencoding' => { 113 => 0xc7a4 },
	'profilename' => { 113 => 0xc6f8 },
	'profiletonecurve' => { 113 => 0xc6fc },
	'programiso' => { 301 => 0x3c },
	'programline' => { 317 => '1.1' },
	'programmode' => { 179 => 0x5 },
	'programshift' => { 214 => 0xd },
	'programversion' => { 125 => 0x46 },
	'prohibits' => { 445 => 'prohibits' },
	'projectiontype' => { 435 => 'ProjectionType', 436 => 'ProjectionType' },
	'projectname' => { 472 => 'projectName' },
	'projectref' => { 472 => 'projectRef' },
	'projectrefpath' => { 472 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 472 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 288 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 288 => 'PropertyReleaseStatus' },
	'province-state' => { 125 => 0x5f },
	'publicationdate' => { 462 => 'publicationDate' },
	'publicationdatea-platform' => { 462 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 462 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 462 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 462 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 462 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 458 => 'PublicationEvent' },
	'publicationeventdate' => { 458 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 458 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 458 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 462 => 'publicationName' },
	'publisher' => { 449 => 'publisher' },
	'publishingfrequency' => { 462 => 'publishingFrequency' },
	'pulldown' => { 472 => 'pullDown' },
	'purplehsl' => { 97 => 0x20916 },
	'pxshiftperiphedgenr' => { 427 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 427 => 0x9014 },
	'quality' => { 0 => 0x1, 33 => 0x3, 106 => 0x2, 107 => 0x3002, 121 => 0x1000, 133 => 0x9, 214 => 0x4, 244 => 0x3, 283 => 0x201, 296 => 0x300, 336 => 0x8, 343 => 0x2, 373 => 0x16, 381 => 0x56, 382 => 0x56, 383 => 0xb, 394 => [0x102,0x202e] },
	'quality2' => { 402 => 0x1170, 403 => 0x1174, 404 => 0x1150, 406 => 0x11a8, 407 => 0x1060, 408 => 0x258, 409 => 0x258, 410 => 0x247, 414 => 0x29, 415 => 0x25, 416 => 0x2a },
	'qualitymode' => { 107 => 0x8 },
	'quantizationmethod' => { 127 => 0x78 },
	'quickadjust' => { 257 => 0x2a },
	'quickcontroldialinmeter' => { 78 => 0x703 },
	'quickfix' => { 254 => 0x416391c6 },
	'quickshot' => { 372 => 0x213 },
	'quiettime' => { 131 => 0x188a },
	'rangefinder' => { 266 => '4.1', 267 => '5.1', 268 => '5.1' },
	'rasterizedcaption' => { 125 => 0x7d },
	'rating' => { 113 => 0x4746, 121 => 0x1431, 347 => 0xdf, 394 => 0x2002, 442 => 'rating', 450 => 'rating', 458 => 'Rating', 462 => 'rating', 470 => 'Rating' },
	'ratingpercent' => { 113 => 0x4749, 169 => 'Rating' },
	'ratingratingregion' => { 458 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 458 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 458 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 458 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 458 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 458 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 458 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 458 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 458 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 458 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 458 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 458 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 458 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 458 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 458 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 458 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 458 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 458 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 76 => 0x8, 176 => 0x109, 317 => 0xd },
	'rawbrightnessadj' => { 97 => 0x20001, 102 => 0x38 },
	'rawcoloradj' => { 102 => 0x2e },
	'rawcropbottom' => { 347 => 0xd4 },
	'rawcropleft' => { 347 => 0xd1 },
	'rawcropright' => { 347 => 0xd3 },
	'rawcroptop' => { 347 => 0xd2 },
	'rawcustomsaturation' => { 102 => 0x30 },
	'rawcustomtone' => { 102 => 0x34 },
	'rawdata' => { 370 => 0xa048 },
	'rawdatabyteorder' => { 370 => 0x40 },
	'rawdatacfapattern' => { 370 => 0x50 },
	'rawdatauniqueid' => { 113 => 0xc65d },
	'rawdepth' => { 178 => 0x10 },
	'rawdevartfilter' => { 285 => 0x121 },
	'rawdevautogradation' => { 285 => 0x119 },
	'rawdevcolorspace' => { 284 => 0x108, 285 => 0x109 },
	'rawdevcontrastvalue' => { 284 => 0x106, 285 => 0x105 },
	'rawdeveditstatus' => { 284 => 0x10b },
	'rawdevelopmentprocess' => { 336 => 0x62 },
	'rawdevengine' => { 284 => 0x109, 285 => 0x10b },
	'rawdevexposurebiasvalue' => { 284 => 0x100, 285 => 0x100 },
	'rawdevgradation' => { 285 => 0x112 },
	'rawdevgraypoint' => { 284 => 0x103, 285 => 0x104 },
	'rawdevmemorycoloremphasis' => { 284 => 0x105, 285 => 0x108 },
	'rawdevnoisereduction' => { 284 => 0x10a, 285 => 0x10a },
	'rawdevpicturemode' => { 285 => 0x10c },
	'rawdevpm_bwfilter' => { 285 => 0x110 },
	'rawdevpmcontrast' => { 285 => 0x10e },
	'rawdevpmnoisefilter' => { 285 => 0x120 },
	'rawdevpmpicturetone' => { 285 => 0x111 },
	'rawdevpmsaturation' => { 285 => 0x10d },
	'rawdevpmsharpness' => { 285 => 0x10f },
	'rawdevsaturation3' => { 285 => 0x113 },
	'rawdevsaturationemphasis' => { 284 => 0x104, 285 => 0x107 },
	'rawdevsettings' => { 284 => 0x10c },
	'rawdevsharpnessvalue' => { 284 => 0x107, 285 => 0x106 },
	'rawdevversion' => { 284 => 0x0, 285 => 0x0 },
	'rawdevwbfineadjustment' => { 284 => 0x102, 285 => 0x103 },
	'rawdevwhitebalance' => { 285 => 0x101 },
	'rawdevwhitebalancevalue' => { 284 => 0x101, 285 => 0x102 },
	'rawfile' => { 113 => 0xfe4c },
	'rawfilename' => { 448 => 'RawFileName' },
	'rawfiletype' => { 394 => 0x2029 },
	'rawformat' => { 306 => 0x2d, 345 => 0x10e },
	'rawimagecenter' => { 214 => 0x99 },
	'rawimagedigest' => { 113 => 0xc71c },
	'rawimagesize' => { 336 => 0x39 },
	'rawinfoversion' => { 286 => 0x0 },
	'rawjpgheight' => { 93 => 0x4 },
	'rawjpgquality' => { 54 => 0x6, 93 => 0x1 },
	'rawjpgsize' => { 54 => 0x7, 93 => 0x2 },
	'rawjpgwidth' => { 93 => 0x3 },
	'rawmeasuredrggb' => { 40 => 0x26a, 42 => 0x280, 44 => 0x194, 45 => [0x1ad,0x26b] },
	'rawrppused' => { 442 => 'rawrppused' },
	'rawtopreviewgain' => { 113 => 0xc7a8 },
	'readouttypeactual' => { 131 => 0x1903 },
	'readouttyperequested' => { 131 => 0x1902 },
	'reardisplay' => { 261 => '12.3', 262 => '6.2' },
	'recdevice' => { 458 => 'RecDevice' },
	'recdeviceattlensdescription' => { 458 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 458 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 458 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 458 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 458 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 464 => 'recipeEndingPage' },
	'recipepagerange' => { 464 => 'recipePageRange' },
	'recipesource' => { 464 => 'recipeSource' },
	'recipestartingpage' => { 464 => 'recipeStartingPage' },
	'recipetitle' => { 464 => 'recipeTitle' },
	'recognizedface1age' => { 294 => 0x20 },
	'recognizedface1name' => { 294 => 0x4 },
	'recognizedface1position' => { 294 => 0x18 },
	'recognizedface2age' => { 294 => 0x50 },
	'recognizedface2name' => { 294 => 0x34 },
	'recognizedface2position' => { 294 => 0x48 },
	'recognizedface3age' => { 294 => 0x80 },
	'recognizedface3name' => { 294 => 0x64 },
	'recognizedface3position' => { 294 => 0x78 },
	'recognizedfaceflags' => { 301 => 0x63 },
	'recommendedexposureindex' => { 113 => 0x8832, 453 => 'RecommendedExposureIndex' },
	'record' => { 112 => 'Record' },
	'recordbasisofrecord' => { 112 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 112 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 112 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 112 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 112 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 112 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 174 => 0x4d },
	'recorddynamicproperties' => { 112 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 91 => 0x1804 },
	'recordinformationwithheld' => { 112 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 363 => 0x1000 },
	'recordingmode' => { 106 => 0x1, 343 => 0x1 },
	'recordinstitutioncode' => { 112 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 112 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 33 => 0x9, 107 => 0x3000 },
	'recordownerinstitutioncode' => { 112 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 372 => 0x217 },
	'redbalance' => { 283 => 0x1017, 306 => 0x11, 336 => 0x1c },
	'redcurvelimits' => { 102 => 0x18a },
	'redcurvepoints' => { 101 => 0x2d, 102 => 0x160 },
	'redeyecorrection' => { 258 => 0x0 },
	'redeyeinfo' => { 448 => 'RedEyeInfo' },
	'redeyereduction' => { 174 => 0x41, 381 => 0x6a, 383 => 0x28 },
	'redeyeremoval' => { 301 => 0xb9 },
	'redhsl' => { 97 => 0x20910 },
	'redhue' => { 448 => 'RedHue' },
	'redsaturation' => { 448 => 'RedSaturation' },
	'reductionmatrix1' => { 113 => 0xc625 },
	'reductionmatrix2' => { 113 => 0xc626 },
	'reelname' => { 113 => 0xc789 },
	'reference1' => { 456 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 456 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 113 => 0x214, 468 => 'ReferenceBlackWhite' },
	'referencedate' => { 125 => 0x2f },
	'referencenumber' => { 125 => 0x32 },
	'references' => { 148 => 'References' },
	'referenceservice' => { 125 => 0x2d },
	'regionappliedtodimensions' => { 163 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 163 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 163 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 163 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 163 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 163 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 163 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 163 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 163 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 163 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 163 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 163 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 288 => 'RegionConstraints' },
	'regiondescription' => { 163 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 163 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 163 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 163 => 'Regions' },
	'regioninfodateregionsvalid' => { 166 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 166 => 'RegionInfo' },
	'regioninforegions' => { 166 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 163 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 163 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 166 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 163 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 163 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 163 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 458 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 458 => 'RegistryId' },
	'registryitemid' => { 458 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 458 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 146 => 'data' },
	'relatedaudiofilename' => { 146 => '1Name' },
	'relatedaudiofiletype' => { 146 => '0Type' },
	'relatedimagefileformat' => { 113 => 0x1000 },
	'relatedimageheight' => { 113 => 0x1002 },
	'relatedimagewidth' => { 113 => 0x1001 },
	'relatedresourceid' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 113 => 0xa004, 452 => 'RelatedSoundFile' },
	'relatedvideofile' => { 160 => 'data' },
	'relatedvideofilename' => { 160 => '1Name' },
	'relatedvideofiletype' => { 160 => '0Type' },
	'relation' => { 449 => 'relation' },
	'relationshipaccordingto' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 110 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 472 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 472 => 'relativeTimestamp' },
	'relativetimestampscale' => { 472 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 472 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 261 => '17.8', 262 => '18.5', 264 => '18.4', 265 => '18.4', 270 => '33.8', 271 => '17.6', 274 => '18.5', 275 => '18.4' },
	'releasedate' => { 125 => 0x1e, 442 => 'ReleaseDate', 472 => 'releaseDate' },
	'releasemode' => { 107 => 0x3001, 232 => 0x184d, 394 => 0xb049 },
	'releasemode2' => { 402 => 0x112c, 403 => [0x112c,0x8], 404 => [0x1108,0x8], 405 => [0x1184,0x8], 406 => [0x1160,0x8], 407 => [0x4,0x1018], 408 => [0x4,0x210], 409 => [0x4,0x210], 410 => [0x4,0x208], 412 => [0x67,0x3f], 413 => [0x6b,0x6d,0x73,0x4b], 414 => 0x10, 415 => 0x10, 416 => 0x9, 423 => 0x34 },
	'releasemode3' => { 402 => 0x1128, 403 => 0x1128, 404 => 0x1104, 405 => 0x1180, 406 => 0x115c, 407 => 0x1014, 408 => 0x20c, 409 => 0x20c, 410 => 0x204 },
	'releaseready' => { 458 => 'ReleaseReady' },
	'releasesetting' => { 91 => 0x1016 },
	'releasetime' => { 125 => 0x23, 442 => 'ReleaseTime' },
	'remoteonduration' => { 263 => '3.4', 266 => '17.2', 267 => '18.2', 268 => '18.2', 269 => '18.2', 271 => '18.2', 272 => '4.3', 276 => '19.2' },
	'renditionclass' => { 473 => 'RenditionClass' },
	'renditionof' => { 473 => 'RenditionOf' },
	'renditionofalternatepaths' => { 473 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 473 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 473 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 473 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 473 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 473 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 473 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 473 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 473 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 473 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 473 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 473 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 473 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 473 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 473 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 473 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 473 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 473 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 473 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 473 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 473 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 473 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 473 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 473 => 'RenditionParams' },
	'repeatingflashcount' => { 198 => 0xd, 199 => 0xe, 200 => 0xe, 201 => 0xe, 202 => 0xe, 270 => '17.2', 271 => '24.2', 272 => '9.2', 273 => '24.2', 276 => '25.2' },
	'repeatingflashcountbuilt-in' => { 240 => 0x4db },
	'repeatingflashcountexternal' => { 240 => 0x4c3 },
	'repeatingflashoutput' => { 270 => '17.1', 271 => '24.1', 272 => '9.1', 273 => '24.1', 276 => '25.1' },
	'repeatingflashoutputexternal' => { 240 => 0x4c0 },
	'repeatingflashrate' => { 198 => 0xc, 199 => 0xd, 200 => 0xd, 201 => 0xd, 202 => 0xd, 270 => '18.1', 271 => '25.1', 272 => '10.1', 273 => '25.1', 276 => '26.1' },
	'repeatingflashratebuilt-in' => { 240 => 0x4da },
	'repeatingflashrateexternal' => { 240 => 0x4c2 },
	'requires' => { 445 => 'requires' },
	'resampleparams' => { 472 => 'resampleParams' },
	'resampleparamsquality' => { 472 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 131 => 0xe50 },
	'resamplingkerneldenominators067' => { 131 => 0xe4f },
	'resamplingkerneldenominators100' => { 131 => 0xe51 },
	'resaved' => { 372 => 0x21e },
	'resetblacksegrows' => { 131 => 0x181a },
	'resolution' => { 153 => 'Resolution' },
	'resolutionmode' => { 373 => 0x4 },
	'resolutionunit' => { 113 => 0x128, 128 => 0x2, 468 => 'ResolutionUnit' },
	'resourceid' => { 112 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 112 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 112 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 78 => 0x612 },
	'restrictions' => { 465 => 'restrictions' },
	'retouchareafeather' => { 448 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 448 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 448 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 448 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 448 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 448 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 448 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 448 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 448 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 448 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 448 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 448 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 448 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 448 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 448 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 448 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 448 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 448 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 448 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 448 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 448 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 448 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 448 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 448 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 448 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 448 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 448 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 448 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 448 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 448 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 448 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 448 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 448 => 'RetouchAreas' },
	'retouchareaseed' => { 448 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 448 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 448 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 448 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 214 => 0x9e },
	'retouchinfo' => { 448 => 'RetouchInfo' },
	'retouchnefprocessing' => { 221 => 0x5 },
	'retractlensonpoweroff' => { 78 => 0x814 },
	'reuse' => { 288 => 'Reuse' },
	'reuseallowed' => { 475 => 'ReuseAllowed' },
	'reuseprohibited' => { 465 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 268 => '5.2' },
	'reverseindicators' => { 261 => '12.1', 262 => '6.1', 264 => '6.1', 265 => '6.1', 266 => '4.3', 267 => '5.2', 268 => '5.4', 270 => '33.5', 271 => '5.1', 274 => '6.1', 275 => '6.1', 276 => '6.2' },
	'reverseshutterspeedaperture' => { 268 => '5.3' },
	'revision' => { 450 => 'revision' },
	'rflensmffocusringsensitivity' => { 78 => 0x714 },
	'rgbcurvelimits' => { 102 => 0x238 },
	'rgbcurvepoints' => { 101 => 0x7, 102 => 0x20e },
	'richtextcomment' => { 455 => 'RichTextComment' },
	'ricohdate' => { 362 => 0x6 },
	'ricohimageheight' => { 362 => 0x2 },
	'ricohimagewidth' => { 362 => 0x0 },
	'rightalbedo' => { 438 => 'RightAlbedo' },
	'rightascension' => { 156 => 'RightAscension' },
	'rights' => { 449 => 'rights' },
	'rightsagent' => { 465 => 'rightsAgent' },
	'rightsowner' => { 465 => 'rightsOwner' },
	'roll' => { 109 => 0x8 },
	'rollangle' => { 232 => 0x350b, 233 => 0x2c24, 241 => 0x36f4, 278 => 0x903, 301 => 0x90, 335 => 0x1, 368 => 0x2 },
	'romoperationmode' => { 91 => 0x80d },
	'rotation' => { 29 => 0x17, 30 => 0x18, 90 => 0x3, 97 => 0x10002, 102 => 0x26e, 108 => 'Rotation', 117 => 0x4, 156 => 'Rotation', 172 => [0x65,0x50], 173 => 0x46, 174 => 0x5a, 177 => 0x10, 232 => 0x3693, 233 => 0xca, 239 => '590.1', 254 => 0x76a43207, 301 => 0x30, 317 => '17.2', 347 => 0xd8, 381 => 0x3f, 382 => 0x3f, 392 => 0x10 },
	'routedto' => { 454 => 'RoutedTo' },
	'routing' => { 352 => 'Routing' },
	'routingdestinations' => { 437 => 'RoutingDestinations' },
	'routingexclusions' => { 437 => 'RoutingExclusions' },
	'routingnotes' => { 454 => 'RoutingNotes' },
	'rowsperstrip' => { 113 => 0x116 },
	'rpp' => { 442 => 'rpp' },
	'rtkflag' => { 110 => 'RtkFlag' },
	'rtkstdhgt' => { 110 => 'RtkStdHgt' },
	'rtkstdlat' => { 110 => 'RtkStdLat' },
	'rtkstdlon' => { 110 => 'RtkStdLon' },
	'safetyshift' => { 78 => 0x108 },
	'safetyshiftinavortv' => { 76 => 0x10, 77 => 0x10, 79 => 0xf, 80 => 0x10, 83 => 0x10 },
	'sameexposurefornewaperture' => { 78 => 0x112 },
	'samplebits' => { 146 => 'SampleBits' },
	'samplepagerange' => { 462 => 'samplePageRange' },
	'samplerate' => { 146 => 'SampleRate' },
	'samplesperpixel' => { 113 => 0x115, 306 => 0x8, 468 => 'SamplesPerPixel' },
	'samplestructure' => { 127 => 0x5a },
	'samsungmodelid' => { 370 => 0x3 },
	'sanyoquality' => { 372 => 0x201 },
	'sanyothumbnail' => { 372 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 33 => 0xe, 48 => 0x1, 106 => 0xd, 107 => [0x3013,0x1f], 113 => [0xa409,0xfe55], 121 => 0x1003, 147 => 'Saturation', 171 => 0x1f, 172 => 0x32, 173 => 0x28, 174 => 0x1a, 179 => 0x1, 214 => [0x94,0xaa], 216 => 0x35, 217 => 0x3b, 218 => 0x43, 301 => 0x40, 303 => 0x300d, 336 => 0x1f, 343 => 0xd, 357 => 0x27, 359 => 0x58, 362 => 0x28, 363 => 0x1013, 373 => 0x10, 381 => 0x1e, 382 => 0x1b, 394 => 0x2005, 448 => 'Saturation', 452 => 'Saturation' },
	'saturationadj' => { 97 => 0x20901, 102 => 0x116, 253 => 0x1, 257 => 0x2e, 427 => 0x8016 },
	'saturationadjustmentaqua' => { 448 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 448 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 448 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 448 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 448 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 448 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 448 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 448 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 67 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 66 => 0x68, 67 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 66 => 0x38, 67 => 0x38 },
	'saturationmonochrome' => { 66 => 0x80, 67 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 66 => 0x50, 67 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 66 => 0x20, 67 => 0x20 },
	'saturationsetting' => { 286 => 0x1010, 383 => 0x11, 399 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 66 => 0x8, 67 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 66 => 0x98, 67 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 66 => 0xb0, 67 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 66 => 0xc8, 67 => 0xe0 },
	'saveid' => { 473 => 'SaveID' },
	'sbaanalysiscomplete' => { 131 => 0xc35 },
	'sbablack' => { 131 => 0xc25 },
	'sbagmoffset' => { 131 => 0xc4a },
	'sbagray' => { 131 => 0xc26 },
	'sbagreenmagentabal' => { 131 => 0xc33 },
	'sbahighgray' => { 131 => 0xc46 },
	'sbailloffset' => { 131 => 0xc49 },
	'sbailluminantbal' => { 131 => 0xc34 },
	'sbalowgray' => { 131 => 0xc47 },
	'sbaneutralbal' => { 131 => 0xc32 },
	'sbawhite' => { 131 => 0xc27 },
	'scaletype' => { 472 => 'scaleType' },
	'scanimageenhancer' => { 222 => 0x60 },
	'scanningdirection' => { 127 => 0x64 },
	'scene' => { 457 => 'Scene', 472 => 'scene' },
	'scenearea' => { 281 => 0x211, 283 => 0x1031 },
	'sceneassist' => { 214 => 0x9c },
	'scenecapturetype' => { 113 => 0xa406, 452 => 'SceneCaptureType' },
	'scenedetect' => { 281 => 0x210, 283 => 0x1030 },
	'scenedetectdata' => { 281 => 0x212, 283 => 0x1033 },
	'scenemode' => { 135 => 0xfa02, 176 => 0x100, 214 => 0x8f, 278 => 0x509, 283 => 0x403, 301 => 0x8001, 310 => 0xf, 394 => 0xb023 },
	'scenemodeused' => { 137 => [0x6002,0xf002] },
	'scenerecognition' => { 121 => 0x1425 },
	'sceneselect' => { 372 => 0x21f },
	'scenetype' => { 113 => 0xa301, 452 => 'SceneType' },
	'screentips' => { 261 => '12.7', 262 => '5.3', 270 => '13.1', 271 => '4.4', 274 => '5.4', 276 => '5.1' },
	'scriptversion' => { 131 => 0x1770 },
	'season' => { 458 => 'Season', 461 => 'season' },
	'seasonidentifier' => { 458 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 458 => [\'Season','SeasonName'] },
	'seasonnumber' => { 458 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 437 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 232 => 0x1d0, 241 => 0x1d0 },
	'section' => { 462 => 'section' },
	'securityclassification' => { 113 => 0x9212 },
	'selectableafpoint' => { 78 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 78 => 0x512 },
	'selfdata' => { 110 => 'SelfData' },
	'selftimer' => { 33 => 0x2, 301 => 0x2e, 372 => 0x214, 402 => 0x1134, 403 => 0x1134, 404 => 0x1110, 405 => 0x118c, 406 => 0x1168, 407 => 0x1020, 408 => 0x218, 409 => 0x218, 410 => 0x210 },
	'selftimer2' => { 72 => 0x1d },
	'selftimerinterval' => { 271 => '19.2' },
	'selftimermode' => { 113 => 0x882b },
	'selftimershotcount' => { 262 => '20.2', 264 => '20.3', 265 => '20.3', 266 => '18.2', 267 => '19.2', 268 => '19.2', 269 => '19.3', 271 => '19.3', 274 => '20.3', 275 => '20.3', 276 => '20.2' },
	'selftimershotinterval' => { 262 => '20.3', 264 => '20.2', 265 => '20.2', 269 => '19.2', 274 => '20.2', 275 => '20.2' },
	'selftimertime' => { 91 => 0x1806, 174 => 0x1f, 261 => '18.1', 262 => '20.1', 263 => '3.3', 264 => '20.1', 265 => '20.1', 266 => '18.1', 267 => '19.1', 268 => '19.1', 269 => '19.1', 270 => '7.2', 271 => '19.1', 272 => '3.3', 274 => '20.1', 275 => '20.1', 276 => '20.1' },
	'sellingagency' => { 462 => 'sellingAgency' },
	'seminfo' => { 113 => 0x8546 },
	'sensingmethod' => { 113 => 0xa217, 452 => 'SensingMethod' },
	'sensitivityadjust' => { 336 => 0x40 },
	'sensitivitysteps' => { 317 => ['14.3','17.4'], 319 => 0x1 },
	'sensitivitytype' => { 113 => 0x8830, 453 => 'SensitivityType' },
	'sensor' => { 181 => 0x665e },
	'sensorareas' => { 370 => 0xa010 },
	'sensorbitdepth' => { 303 => 0x312d },
	'sensorbluelevel' => { 70 => 0x5 },
	'sensorcalibration' => { 282 => 0x805 },
	'sensorcleaning' => { 84 => 0xd },
	'sensorfullheight' => { 130 => 0xf904 },
	'sensorfullwidth' => { 130 => 0xf903 },
	'sensorheight' => { 130 => 0xf901, 135 => 0xfa21, 178 => 0x8, 303 => 0x312c, 345 => 0x109, 363 => 0x1602 },
	'sensorimageheight' => { 131 => 0x3ee },
	'sensorimagewidth' => { 131 => 0x3ed },
	'sensorleftborder' => { 131 => 0x3eb },
	'sensorleftmargin' => { 345 => 0x10a },
	'sensorpixelsize' => { 214 => 0x9a },
	'sensorredlevel' => { 70 => 0x4 },
	'sensorserialnumber' => { 131 => 0x9ce },
	'sensorsize' => { 147 => 'SensorSize', 336 => 0x35 },
	'sensortemperature' => { 281 => 0x1500, 283 => 0x1007, 341 => 0xc, 345 => 0x210, 373 => [0x39,0x55] },
	'sensortemperature2' => { 341 => 0xe, 345 => 0x211 },
	'sensortopborder' => { 131 => 0x3ec },
	'sensortopmargin' => { 345 => 0x10b },
	'sensorwidth' => { 130 => 0xf900, 135 => 0xfa20, 178 => 0xa, 303 => 0x312b, 345 => 0x108, 363 => 0x1601 },
	'sequence' => { 357 => 0x7, 358 => 0x35, 359 => 0x36 },
	'sequencefilenumber' => { 403 => 0x4, 404 => 0x4, 405 => 0x4, 406 => 0x4, 414 => 0xc, 415 => 0xc, 416 => 0x1a },
	'sequenceimagenumber' => { 403 => 0x0, 404 => 0x0, 405 => 0x0, 406 => 0x0, 414 => 0x8, 415 => 0x8, 416 => 0x12, 423 => 0x24 },
	'sequencelength' => { 414 => 0x22, 415 => 0x1e, 416 => [0x16,0x1e] },
	'sequencename' => { 461 => 'sequenceName' },
	'sequencenumber' => { 72 => 0x9, 107 => 0x301c, 121 => 0x1101, 133 => 0x1d, 240 => 0x51c, 301 => 0x2b, 383 => [0x10c,0x30c], 394 => 0xb04a, 461 => 'sequenceNumber' },
	'sequenceshotinterval' => { 372 => 0x224 },
	'sequencetotalnumber' => { 461 => 'sequenceTotalNumber' },
	'sequentialshot' => { 372 => 0x20e },
	'serialnumber' => { 60 => 0xc, 91 => 0x180b, 113 => [0xa431,0xfde9], 130 => 0xfa04, 132 => 0xfa00, 134 => 0xc354, 135 => 0xfa19, 144 => 0x0, 147 => 'SerialNumber', 214 => [0xa0,0x1d], 279 => 0x101, 283 => [0x404,0x101a], 296 => 0x303, 298 => 0x305, 303 => 0x3103, 336 => 0x229, 345 => 0x102, 346 => 0x407, 357 => 0x15, 358 => 0x4b, 359 => 0x7e, 363 => 0x5, 370 => 0xa002, 373 => 0x2, 394 => 0x2031, 444 => 'SerialNumber', 453 => 'BodySerialNumber' },
	'serialnumberformat' => { 60 => 0x15, 91 => 0x183b },
	'series' => { 458 => 'Series' },
	'seriesdatetime' => { 429 => 'SeriesDateTime' },
	'seriesdescription' => { 429 => 'SeriesDescription' },
	'seriesidentifier' => { 458 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 429 => 'SeriesModality' },
	'seriesname' => { 458 => [\'Series','SeriesName'] },
	'seriesnumber' => { 429 => 'SeriesNumber', 462 => 'seriesNumber' },
	'seriestitle' => { 462 => 'seriesTitle' },
	'serviceidentifier' => { 126 => 0x1e },
	'servingsize' => { 464 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 81 => 0x0, 82 => 0x0 },
	'setbuttonwhenshooting' => { 76 => 0x1, 78 => 0x704, 84 => 0xc },
	'setfunctionwhenshooting' => { 79 => 0x0, 80 => 0x1, 83 => 0x1 },
	'setting' => { 461 => 'setting' },
	'shadingcompensation' => { 278 => 0x50c, 301 => 0x8a },
	'shadingcompensation2' => { 282 => 0x1012 },
	'shadow' => { 373 => 0xe },
	'shadowadj' => { 97 => 0x2030b },
	'shadowcorrection' => { 336 => 0x79 },
	'shadowprotection' => { 253 => 0x0 },
	'shadows' => { 113 => 0xfe52, 441 => 'Shadows', 448 => 'Shadows' },
	'shadows2012' => { 448 => 'Shadows2012' },
	'shadowsadj' => { 427 => 0x901a },
	'shadowscale' => { 113 => 0xc633 },
	'shadowtint' => { 448 => 'ShadowTint' },
	'shadowtone' => { 121 => 0x1040 },
	'shakereduction' => { 338 => 0x1, 339 => 0x1 },
	'sharpendetail' => { 448 => 'SharpenDetail' },
	'sharpenedgemasking' => { 448 => 'SharpenEdgeMasking' },
	'sharpening' => { 303 => 0x300b },
	'sharpeningadj' => { 257 => 0x2b },
	'sharpeningkernel' => { 131 => 0x92f },
	'sharpenradius' => { 448 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 33 => 0xf, 70 => 0x2, 106 => 0xb, 107 => [0x3011,0x21], 113 => [0xa40a,0xfe56], 121 => 0x1001, 133 => 0x6b, 142 => 0x37, 147 => 'Sharpness', 171 => 0x21, 172 => 0x30, 173 => 0x26, 174 => 0x18, 179 => 0x3, 214 => 0x6, 216 => 0x32, 217 => 0x33, 218 => 0x39, 283 => 0x100f, 301 => 0x41, 336 => 0x21, 343 => 0xb, 357 => 0x26, 359 => 0x56, 362 => 0x22, 363 => [0x1003,0x1014], 373 => 0x11, 381 => 0x1c, 382 => 0x19, 394 => 0x2006, 423 => 0x52, 448 => 'Sharpness', 452 => 'Sharpness' },
	'sharpnessadj' => { 97 => 0x20310, 102 => 0x25a, 427 => 0x801a },
	'sharpnessadjon' => { 97 => '0x20310.0' },
	'sharpnessauto' => { 67 => 0x94 },
	'sharpnessfactor' => { 283 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 66 => 0x64, 67 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 70 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 66 => 0x34, 67 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 66 => 0x7c, 67 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 66 => 0x4c, 67 => 0x4c },
	'sharpnessovershoot' => { 427 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 66 => 0x1c, 67 => 0x1c },
	'sharpnesssetting' => { 278 => 0x506, 286 => 0x1013, 383 => 0x12, 399 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 66 => 0x4, 67 => 0x4 },
	'sharpnessstrength' => { 97 => 0x20311 },
	'sharpnessthreshold' => { 427 => 0x801d },
	'sharpnessundershoot' => { 427 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 66 => 0x94, 67 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 66 => 0xac, 67 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 66 => 0xc4, 67 => 0xdc },
	'shiftcols' => { 131 => 0xc70 },
	'shootid' => { 461 => 'shootID' },
	'shootingdistance' => { 97 => 0x20701 },
	'shootinginfodisplay' => { 261 => '13.2', 262 => '5.1', 270 => '10.2', 271 => '4.1', 274 => '5.1', 276 => '5.3' },
	'shootinginfomonitorofftime' => { 261 => '26.2', 262 => '22.2', 264 => '22.2', 265 => '22.2', 269 => '21.2', 270 => '9.1', 271 => '21.2', 274 => '22.2', 275 => '22.2', 276 => '22.2' },
	'shootingmode' => { 147 => 'ShootingMode', 214 => 0x89, 301 => 0x1f },
	'shootingmodesetting' => { 263 => '5.1' },
	'shortdescription' => { 450 => 'shortdescription' },
	'shortdocumentid' => { 125 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 78 => 0x80d },
	'shotdate' => { 472 => 'shotDate' },
	'shotday' => { 472 => 'shotDay' },
	'shotlocation' => { 472 => 'shotLocation' },
	'shotname' => { 472 => 'shotName' },
	'shotnumber' => { 472 => 'shotNumber' },
	'shotnumbersincepowerup' => { 398 => 0x44e, 414 => 0x1a, 415 => 0x16, 416 => 0xa },
	'shotnumbersincepowerup2' => { 383 => 0x200 },
	'shotsize' => { 472 => 'shotSize' },
	'shownevent' => { 458 => 'EventExt' },
	'showneventidentifier' => { 458 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 458 => [\'EventExt','EventExtName'] },
	'shutter' => { 413 => 0x2c },
	'shutter-aelock' => { 76 => 0x4, 78 => 0x701, 79 => 0x3, 80 => 0x4, 81 => 0x3, 82 => 0x3, 83 => 0x4, 84 => 0x2 },
	'shutteraelbutton' => { 77 => 0x4 },
	'shutterbuttonafonbutton' => { 78 => 0x701 },
	'shuttercount' => { 10 => 0x176, 54 => 0x1, 214 => 0xa7, 223 => [0x6a,0x157,0x24d], 224 => 0x286, 225 => 0x279, 226 => 0x284, 227 => 0x242, 228 => 0x280, 229 => 0x276, 230 => [0x27d,0x27f], 231 => 0x246, 234 => 0x2d6, 235 => 0x321, 236 => 0xbd8, 237 => 0x287, 238 => 0x320, 239 => 0x24a, 240 => 0x5fb, 243 => 0x2d5, 336 => 0x5d, 392 => 0x846, 397 => [0x125,0x14a], 412 => 0x32, 413 => 0x3a },
	'shuttercount2' => { 412 => 0x4c, 413 => [0x50,0x52,0x58] },
	'shuttercount3' => { 412 => [0x1a0,0x1aa,0x1bd], 413 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 76 => 0xf, 77 => 0xf, 78 => 0x305, 79 => 0xe, 80 => 0xf, 81 => 0x8, 82 => 0x8, 83 => 0xf, 84 => 0x8 },
	'shuttermode' => { 133 => 0x1b, 214 => 0x34 },
	'shutterreleasebuttonae-l' => { 261 => '17.7', 262 => '18.4', 264 => '78.4', 265 => '78.4', 266 => '16.1', 267 => '17.1', 268 => '17.1', 269 => '17.1', 270 => '7.1', 271 => '17.5', 274 => '18.4', 275 => '78.4', 276 => '18.2' },
	'shutterreleasemethod' => { 91 => 0x1010 },
	'shutterreleasenocfcard' => { 76 => 0x2, 77 => 0x2, 84 => 0xf },
	'shutterreleasetiming' => { 91 => 0x1011 },
	'shutterreleasewithoutlens' => { 78 => 0x711 },
	'shutterspeedlock' => { 262 => '38.1', 264 => '38.1', 265 => '38.1', 274 => '38.1', 275 => '38.1' },
	'shutterspeedrange' => { 78 => 0x10c },
	'shutterspeedsetting' => { 174 => 0x6, 381 => 0x2f, 382 => 0x28, 383 => 0x0 },
	'shutterspeedvalue' => { 87 => 0x1, 113 => 0x9201, 283 => 0x1000, 345 => 0x400, 452 => 'ShutterSpeedValue' },
	'shuttertype' => { 121 => 0x1050, 301 => 0x9f },
	'sidecarforextension' => { 460 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 131 => 0xe0d },
	'sigmascalingfactorcamera' => { 131 => 0xe0c },
	'sigmascalingfactorlowres' => { 131 => 0xe0b },
	'sigmasizetable' => { 131 => 0xe0f },
	'similarityindex' => { 125 => 0xe4 },
	'singleframebracketing' => { 174 => 0x21 },
	'skilllevel' => { 464 => 'skillLevel' },
	'skintonecorrection' => { 336 => 0x95 },
	'skiplinetime' => { 131 => 0x184e },
	'slaveflashmeteringsegments' => { 336 => 0x20b },
	'slideshowname' => { 461 => 'slideshowName' },
	'slideshownumber' => { 461 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 461 => 'slideshowTotalNumber' },
	'slowshutter' => { 72 => 0x8 },
	'slowsync' => { 121 => 0x1030 },
	'smartalbumcolor' => { 370 => 0x20 },
	'smartrange' => { 370 => 0xa012 },
	'smileshutter' => { 383 => 0x31 },
	'smileshuttermode' => { 383 => 0x27 },
	'smoothness' => { 113 => 0xfe57, 448 => 'Smoothness' },
	'snapshot' => { 458 => 'SnapshotLink' },
	'snapshotformat' => { 458 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 458 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 458 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 458 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 458 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 442 => 'Snapshots' },
	'snapshotusedvideoframe' => { 458 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 458 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 458 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 458 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 458 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 394 => 0x200f },
	'software' => { 113 => 0x131, 148 => 'Software', 291 => 'Software', 345 => 0x203, 373 => 0x18, 432 => 'Software', 468 => 'Software' },
	'softwareversion' => { 372 => 0x207 },
	'sonydatetime' => { 401 => 0x6, 403 => 0x1b6, 404 => 0x210, 405 => 0x1fe, 406 => 0x22c },
	'sonydatetime2' => { 412 => 0x51 },
	'sonyexposuretime' => { 412 => 0x3a, 413 => 0x46 },
	'sonyexposuretime2' => { 423 => 0xe },
	'sonyfnumber' => { 412 => 0x3c, 413 => 0x48, 423 => 0x14 },
	'sonyimageheight' => { 401 => 0x1a, 414 => 0x44, 415 => 0x3f, 416 => 0x47 },
	'sonyimageheightmax' => { 423 => 0x40 },
	'sonyimagesize' => { 174 => 0x3b, 381 => 0x54, 382 => 0x54, 383 => 0x9 },
	'sonyimagewidth' => { 401 => 0x1c },
	'sonyimagewidthmax' => { 423 => 0x3e },
	'sonyiso' => { 403 => 0x1218, 404 => 0x11f4, 405 => 0x1270, 406 => [0x1254,0x1258,0x1280], 407 => 0x113c, 408 => 0x344, 409 => 0x346, 410 => 0x320, 423 => 0x4 },
	'sonymaxaperture' => { 412 => 0x0, 413 => 0x0 },
	'sonymaxaperturevalue' => { 423 => 0x16 },
	'sonyminaperture' => { 412 => 0x1, 413 => 0x1 },
	'sonymodelid' => { 394 => 0xb001 },
	'sonyquality' => { 174 => 0x3c },
	'sonytimeminsec' => { 413 => 0x61 },
	'source' => { 125 => 0x73, 291 => 'Source', 449 => 'source', 450 => 'source', 460 => 'Source' },
	'sourcecount' => { 436 => 'SourceCount' },
	'sourcedirectoryindex' => { 323 => 0x0 },
	'sourcefileindex' => { 323 => 0x2 },
	'sourcephotoscount' => { 435 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 131 => 0x1390 },
	'spatialfrequencyresponse' => { 452 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 452 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 452 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 452 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 452 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 472 => 'speakerPlacement' },
	'specialeffectlevel' => { 107 => 0x3030 },
	'specialeffectmode' => { 107 => 0x2076 },
	'specialeffectsetting' => { 107 => 0x3031 },
	'specialinstructions' => { 125 => 0x28 },
	'specialmode' => { 283 => 0x200, 372 => 0x200 },
	'specialoccasion' => { 464 => 'specialOccasion' },
	'spectralsensitivity' => { 113 => 0x8824, 452 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 42 => [0x2b9,0x2d0,0x2d4], 44 => 0x1e4, 45 => [0x1fd,0x2dd], 46 => [0x231,0x30f], 47 => 0x31d },
	'speedx' => { 109 => 0x3 },
	'speedy' => { 109 => 0x4 },
	'speedz' => { 109 => 0x5 },
	'spherical' => { 436 => 'Spherical' },
	'splitcolumn' => { 345 => 0x222 },
	'splittoningbalance' => { 448 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 448 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 448 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 448 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 448 => 'SplitToningShadowSaturation' },
	'sport' => { 462 => 'sport' },
	'spotfocuspointx' => { 171 => 0x2d },
	'spotfocuspointy' => { 171 => 0x2e },
	'spotmeteringmode' => { 33 => 0x27 },
	'spotmeterlinktoafpoint' => { 78 => 0x107 },
	'sractive' => { 317 => '17.1' },
	'srawquality' => { 33 => 0x2e },
	'srfocallength' => { 338 => 0x3 },
	'srhalfpresstime' => { 338 => 0x2 },
	'srresult' => { 338 => 0x0, 339 => 0x0 },
	'stackedimage' => { 278 => 0x804 },
	'standardmatrixcustom' => { 131 => 0x7d4 },
	'standardmatrixdaylight' => { 131 => 0x7d0 },
	'standardmatrixflash' => { 131 => 0x7d3 },
	'standardmatrixfluorescent' => { 131 => 0x7d2 },
	'standardmatrixtungsten' => { 131 => 0x7d1 },
	'standardoutputhighlightpoint' => { 103 => 0x14 },
	'standardoutputsensitivity' => { 113 => 0x8831, 453 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 103 => 0x15 },
	'standardrawcolortone' => { 103 => 0xd },
	'standardrawcontrast' => { 103 => 0xf },
	'standardrawhighlight' => { 103 => 0x75 },
	'standardrawhighlightpoint' => { 103 => 0x12 },
	'standardrawlinear' => { 103 => 0x10 },
	'standardrawsaturation' => { 103 => 0xe },
	'standardrawshadow' => { 103 => 0x7e },
	'standardrawshadowpoint' => { 103 => 0x13 },
	'standardrawsharpness' => { 103 => 0x11 },
	'standardunsharpmaskfineness' => { 103 => 0x94 },
	'standardunsharpmaskstrength' => { 103 => 0x92 },
	'standardunsharpmaskthreshold' => { 103 => 0x96 },
	'standardwhitecustom' => { 131 => 0x838 },
	'standardwhitedaylight' => { 131 => 0x834 },
	'standardwhiteflash' => { 131 => 0x837 },
	'standardwhitefluorescent' => { 131 => 0x836 },
	'standardwhitetungsten' => { 131 => 0x835 },
	'standbytimer' => { 262 => '19.1', 264 => '19.1', 265 => '19.1', 268 => '18.1', 269 => '18.1', 274 => '19.1', 275 => '19.1' },
	'startingpage' => { 462 => 'startingPage' },
	'startmovieshooting' => { 78 => 0x70d },
	'starttimecode' => { 472 => 'startTimecode' },
	'starttimecodetimeformat' => { 472 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 472 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 472 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 472 => 'startTimeSampleSize' },
	'starttimescale' => { 472 => 'startTimeScale' },
	'state' => { 152 => 'State', 301 => 0x6b, 460 => 'State' },
	'status' => { 430 => 'Status', 440 => 'Status' },
	'stereomode' => { 436 => 'StereoMode' },
	'stitched' => { 436 => 'Stitched' },
	'stitchingsoftware' => { 435 => 'StitchingSoftware', 436 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 402 => 0x113e, 403 => 0x113e, 404 => 0x111a, 405 => 0x1196, 406 => 0x1172, 407 => 0x102a, 408 => 0x222, 409 => 0x222, 410 => 0x217, 423 => 0xa },
	'storagemethod' => { 178 => 0x12 },
	'storebyorientation' => { 262 => '46.3', 264 => '47.3', 265 => '47.3', 274 => '47.3', 275 => '47.3' },
	'storylineidentifier' => { 458 => 'StorylineIdentifier' },
	'straightenangle' => { 254 => 0x2fc08431 },
	'streamready' => { 458 => 'StreamReady' },
	'streamtype' => { 167 => 'StreamType' },
	'stretchmode' => { 472 => 'stretchMode' },
	'studydatetime' => { 429 => 'StudyDateTime' },
	'studydescription' => { 429 => 'StudyDescription' },
	'studyid' => { 429 => 'StudyID' },
	'studyphysician' => { 429 => 'StudyPhysician' },
	'styleperiod' => { 458 => 'StylePeriod' },
	'sub-location' => { 125 => 0x5c },
	'subfiledata' => { 155 => 'data' },
	'subfiledirectory' => { 155 => '1Directory' },
	'subfilemimetype' => { 155 => '2MIME' },
	'subfilename' => { 155 => '1Name' },
	'subfileresource' => { 155 => 'rsrc' },
	'subfiletype' => { 113 => 0xfe, 155 => '0Type' },
	'subject' => { 287 => 'Subject', 352 => 'Subject', 449 => 'subject', 459 => 'Subject', 473 => 'subject' },
	'subjectarea' => { 113 => 0x9214, 452 => 'SubjectArea' },
	'subjectcode' => { 457 => 'SubjectCode' },
	'subjectdistance' => { 113 => 0x9206, 133 => 0x3e, 452 => 'SubjectDistance' },
	'subjectdistancerange' => { 113 => 0xa40c, 452 => 'SubjectDistanceRange' },
	'subjectlocation' => { 113 => 0xa214, 452 => 'SubjectLocation' },
	'subjectmotion' => { 264 => '78.2', 265 => '78.2', 275 => '78.2' },
	'subjectprogram' => { 171 => 0x22 },
	'subjectreference' => { 125 => 0xc },
	'sublabels4' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 456 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 456 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 108 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 108 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 108 => 'SubSecModifyDate' },
	'subsectime' => { 113 => 0x9290 },
	'subsectimedigitized' => { 113 => 0x9292 },
	'subsectimeoriginal' => { 113 => 0x9291 },
	'subsection1' => { 462 => 'subsection1' },
	'subsection2' => { 462 => 'subsection2' },
	'subsection3' => { 462 => 'subsection3' },
	'subsection4' => { 462 => 'subsection4' },
	'subselector' => { 262 => '49.1', 264 => '71.1', 265 => '71.1', 275 => '71.1' },
	'subselectorassignment' => { 262 => '48.1' },
	'subselectorcenter' => { 264 => '72.1', 265 => '72.1', 275 => '72.1' },
	'subselectorplusdials' => { 262 => '49.2', 264 => '73.1', 265 => '73.1', 275 => '73.1' },
	'subtitle' => { 462 => 'subtitle' },
	'subversionfilename' => { 456 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 456 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 456 => 'SubVersions' },
	'superimposeddisplay' => { 76 => 0xa, 78 => 0x510, 79 => 0x9, 80 => 0xa, 83 => 0xa, 84 => 0xe },
	'supermacro' => { 60 => 0x1a },
	'supplementalcategories' => { 125 => 0x14, 460 => 'SupplementalCategories' },
	'supplementaltype' => { 127 => 0x37 },
	'supplementdisplayid' => { 462 => 'supplementDisplayID' },
	'supplementstartingpage' => { 462 => 'supplementStartingPage' },
	'supplementtitle' => { 462 => 'supplementTitle' },
	'supplychainsource' => { 458 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 458 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 458 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 317 => 0x14 },
	'swatchcoloranta' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 477 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 477 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 477 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 477 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 477 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 301 => 0x93, 383 => 0x33 },
	'sweeppanoramafieldofview' => { 301 => 0x94 },
	'sweeppanoramasize' => { 383 => 0x32 },
	'switchtoregisteredafpoint' => { 77 => 0x12, 78 => 0x50a },
	'syncreleasemode' => { 264 => '77.1', 265 => '77.1', 275 => '77.1' },
	'system' => { 345 => 0x204 },
	'tagged' => { 347 => 0xdd, 348 => 'Tagged', 442 => 'tagged' },
	'tagslist' => { 451 => 'TagsList' },
	'tagstructure' => { 456 => 'TagStructure' },
	'takenumber' => { 472 => 'takeNumber' },
	'tapename' => { 472 => 'tapeName' },
	'targetaperture' => { 72 => 0x4 },
	'targetcompressionratio' => { 89 => 0x1 },
	'targetdistancesetting' => { 91 => 0x1807 },
	'targetexposuretime' => { 72 => 0x5 },
	'targetimagetype' => { 91 => 0x100a },
	'targetprinter' => { 113 => 0x151 },
	'taxon' => { 112 => 'Taxon' },
	'taxonacceptednameusage' => { 112 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 112 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 112 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 112 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 112 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 112 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 112 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 112 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 112 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 112 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 112 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 112 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 112 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 112 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 112 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 112 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 112 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 112 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 112 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 112 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 112 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 112 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 112 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 112 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 112 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 112 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 112 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 112 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 112 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 112 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 112 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 112 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 112 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 131 => 0x196f },
	'tda1edgepolarity' => { 131 => 0x1971 },
	'tda1gain' => { 131 => 0x1970 },
	'tda1offset' => { 131 => 0x196e },
	'tda2bandwidth' => { 131 => 0x1979 },
	'tda2edgepolarity' => { 131 => 0x197b },
	'tda2gain' => { 131 => 0x197a },
	'tda2offset' => { 131 => 0x1978 },
	'tda3bandwidth' => { 131 => 0x1983 },
	'tda3edgepolarity' => { 131 => 0x1985 },
	'tda3gain' => { 131 => 0x1984 },
	'tda3offset' => { 131 => 0x1982 },
	'tda4bandwidth' => { 131 => 0x198d },
	'tda4edgepolarity' => { 131 => 0x198f },
	'tda4gain' => { 131 => 0x198e },
	'tda4offset' => { 131 => 0x198c },
	'teaser' => { 462 => 'teaser' },
	'teleconverter' => { 176 => 0x105, 394 => 0x105 },
	'tempampgainx100' => { 131 => 0x1914 },
	'tempo' => { 472 => 'tempo' },
	'temporalcoverage' => { 458 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 458 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 458 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 288 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 288 => 'TermsAndConditionsURL' },
	'testname' => { 114 => 'TestName' },
	'textencoding' => { 213 => 0x4 },
	'textlayername' => { 460 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 460 => 'TextLayers' },
	'textlayertext' => { 460 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 301 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 264 => '1.3', 265 => '1.3', 275 => '1.4' },
	'three-dtrackingwatcharea' => { 264 => '78.1', 265 => '78.1', 275 => '78.1' },
	'thresholding' => { 113 => 0x107 },
	'thumbnailfilename' => { 91 => 0x817 },
	'thumbnailformat' => { 470 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 135 => 0xfa55, 470 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 91 => 0x2008, 108 => 'ThumbnailImage', 116 => 0x3, 158 => 'data', 283 => 0x100, 470 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 158 => '1Name' },
	'thumbnailimagesize' => { 158 => 'ImageSize' },
	'thumbnailimagetype' => { 158 => '0Type' },
	'thumbnailimagevalidarea' => { 60 => 0x13 },
	'thumbnaillength' => { 113 => 0x202 },
	'thumbnailoffset' => { 113 => 0x201 },
	'thumbnails' => { 470 => 'Thumbnails' },
	'thumbnailwidth' => { 135 => 0xfa54, 470 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 462 => 'ticker' },
	'tiffhandling' => { 448 => 'TIFFHandling' },
	'tiffmeteringimage' => { 177 => 0x104c, 392 => 0x1110 },
	'tilelength' => { 113 => 0x143 },
	'tilewidth' => { 113 => 0x142 },
	'time' => { 131 => 0x401, 336 => 0x7 },
	'timecodes' => { 113 => 0xc763 },
	'timecreated' => { 125 => 0x3c, 133 => 0x14, 142 => 0x10, 348 => 'TimeCreated' },
	'timelapseshotnumber' => { 304 => 0x10 },
	'timeperiod' => { 462 => 'timePeriod' },
	'timerfunctionbutton' => { 263 => '5.2', 266 => '12.1', 267 => '13.1' },
	'timerlength' => { 78 => 0x80c },
	'timerrecording' => { 301 => 0x96 },
	'timescaleparams' => { 472 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 472 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 472 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 472 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 126 => 0x50 },
	'timeshot' => { 437 => 'TimeShot' },
	'timesignature' => { 472 => 'timeSignature' },
	'timesincepoweron' => { 301 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 277 => 0x8, 291 => 'TimeStamp', 301 => 0xaf, 436 => 'Timestamp', 443 => 'Timestamp', 456 => 'TimeStamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 73 => 0x1, 246 => 0x0, 366 => 0xa },
	'timezonecity' => { 73 => 0x2 },
	'timezonecode' => { 94 => 0x1 },
	'timezoneinfo' => { 94 => 0x2 },
	'timezoneoffset' => { 113 => 0x882a },
	'tint' => { 448 => 'Tint' },
	'title' => { 148 => 'Title', 287 => 'Title', 291 => 'Title', 301 => 0x65, 352 => 'Title', 449 => 'title', 459 => 'Title', 470 => 'Title' },
	'tonecomp' => { 214 => 0x81 },
	'tonecurve' => { 70 => 0x1, 336 => 0x402, 448 => 'ToneCurve' },
	'tonecurveactive' => { 102 => 0x110 },
	'tonecurveadobergb' => { 370 => 0xa043 },
	'tonecurveadobergbdefault' => { 370 => 0xa041 },
	'tonecurveblue' => { 448 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 427 => 0x9003 },
	'tonecurvebluey' => { 427 => 0x9007 },
	'tonecurvebrightness' => { 97 => 0x20410 },
	'tonecurvebrightnessx' => { 427 => 0x9000 },
	'tonecurvebrightnessy' => { 427 => 0x9004 },
	'tonecurvecolorspace' => { 101 => 0x0 },
	'tonecurvecontrast' => { 97 => 0x20411 },
	'tonecurvegreen' => { 448 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 427 => 0x9002 },
	'tonecurvegreeny' => { 427 => 0x9006 },
	'tonecurveinputrange' => { 101 => 0x3 },
	'tonecurveinterpolation' => { 102 => 0x159 },
	'tonecurvemode' => { 102 => 0x113 },
	'tonecurvename' => { 448 => 'ToneCurveName' },
	'tonecurvename2012' => { 448 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 97 => '0x20400.1' },
	'tonecurveoutputrange' => { 101 => 0x5 },
	'tonecurveprofilename' => { 131 => 0x1391 },
	'tonecurveproperty' => { 102 => 0x3c },
	'tonecurvepv2012' => { 448 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 448 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 448 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 448 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 448 => 'ToneCurveRed' },
	'tonecurveredx' => { 427 => 0x9001 },
	'tonecurveredy' => { 427 => 0x9005 },
	'tonecurves' => { 336 => 0x403 },
	'tonecurveshape' => { 101 => 0x1 },
	'tonecurvesrgb' => { 370 => 0xa042 },
	'tonecurvesrgbdefault' => { 370 => 0xa040 },
	'tonecurvex' => { 101 => 0xa },
	'tonecurvey' => { 101 => 0xb },
	'tonelevel' => { 278 => 0x52e },
	'tonemapstrength' => { 448 => 'ToneMapStrength' },
	'toningeffect' => { 54 => 0xf, 214 => 0xb3, 216 => 0x38, 217 => 0x40, 218 => 0x48, 363 => 0x1015 },
	'toningeffectauto' => { 67 => 0xa4 },
	'toningeffectfaithful' => { 66 => 0x74, 67 => 0x74 },
	'toningeffectlandscape' => { 66 => 0x44, 67 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 66 => 0x8c, 67 => 0x8c },
	'toningeffectneutral' => { 66 => 0x5c, 67 => 0x5c },
	'toningeffectportrait' => { 66 => 0x2c, 67 => 0x2c },
	'toningeffectstandard' => { 66 => 0x14, 67 => 0x14 },
	'toningeffectuserdef1' => { 66 => 0xa4, 67 => 0xbc },
	'toningeffectuserdef2' => { 66 => 0xbc, 67 => 0xd4 },
	'toningeffectuserdef3' => { 66 => 0xd4, 67 => 0xec },
	'toningsaturation' => { 216 => 0x39, 217 => 0x41, 218 => 0x49 },
	'totalzoom' => { 133 => 0x62 },
	'touchae' => { 301 => 0xab },
	'trackcreatedate' => { 356 => 0x1 },
	'trackmodifydate' => { 356 => 0x2 },
	'tracknumber' => { 472 => 'trackNumber' },
	'tracks' => { 472 => 'Tracks' },
	'tracksframerate' => { 472 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 472 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 472 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 472 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 472 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 472 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 472 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 472 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 472 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 472 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 472 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 472 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 472 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 472 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 472 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 472 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 472 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 155 => 'zmie' },
	'transcript' => { 458 => 'Transcript' },
	'transcriptlink' => { 458 => 'TranscriptLink' },
	'transcriptlinklink' => { 458 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 458 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 113 => 0x12d, 468 => 'TransferFunction' },
	'transfertimenormal' => { 131 => 0x1888 },
	'transfertimetest' => { 131 => 0x1889 },
	'transform' => { 301 => [0x8012,0x59] },
	'transmissionreference' => { 460 => 'TransmissionReference' },
	'trapped' => { 287 => 'Trapped', 459 => 'Trapped' },
	'trashbuttonfunction' => { 78 => 0x710 },
	'travelday' => { 301 => 0x36 },
	'triggermode' => { 357 => 0x6, 358 => 0x34, 359 => 0x34 },
	'tstop' => { 113 => 0xc772 },
	'ttl_da_adown' => { 324 => 0x5 },
	'ttl_da_aup' => { 324 => 0x4 },
	'ttl_da_bdown' => { 324 => 0x7 },
	'ttl_da_bup' => { 324 => 0x6 },
	'tungstenawb' => { 314 => 0x1 },
	'tvexposuretimesetting' => { 317 => 0x12 },
	'type' => { 449 => 'type', 467 => 'type' },
	'typestatus' => { 112 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 113 => 0xc614 },
	'uniquedocumentid' => { 125 => 0xbb },
	'uniquematrixauto' => { 131 => 0x7e9 },
	'uniquematrixcustom' => { 131 => 0x7e8 },
	'uniquematrixdaylight' => { 131 => 0x7e4 },
	'uniquematrixflash' => { 131 => 0x7e7 },
	'uniquematrixfluorescent' => { 131 => 0x7e6 },
	'uniquematrixtungsten' => { 131 => 0x7e5 },
	'uniqueobjectname' => { 126 => 0x64 },
	'units' => { 432 => 'Units' },
	'unknownblock' => { 336 => 0x405 },
	'unknownblock1' => { 282 => 0x635 },
	'unknownblock2' => { 282 => 0x636 },
	'unknownblock3' => { 282 => 0x1103 },
	'unknownblock4' => { 282 => 0x1104 },
	'unknowncontrast' => { 103 => 0x45 },
	'unknowndate' => { 345 => 0x212 },
	'unknownev' => { 131 => 0x1 },
	'unknownlinear' => { 103 => 0x46 },
	'unknownnumber' => { 91 => 0x180b },
	'unknownoutputhighlightpoint' => { 103 => 0x4a },
	'unknownoutputshadowpoint' => { 103 => 0x4b },
	'unknownrawhighlight' => { 103 => 0x7b },
	'unknownrawhighlightpoint' => { 103 => 0x48 },
	'unknownrawshadow' => { 103 => 0x84 },
	'unknownrawshadowpoint' => { 103 => 0x49 },
	'unknownsharpness' => { 103 => 0x47 },
	'unknowntemperature' => { 115 => 0x4 },
	'unsharp1color' => { 259 => 0x13 },
	'unsharp1halowidth' => { 259 => 0x19 },
	'unsharp1intensity' => { 259 => 0x17 },
	'unsharp1threshold' => { 259 => 0x1b },
	'unsharp2color' => { 259 => 0x2e },
	'unsharp2halowidth' => { 259 => 0x34 },
	'unsharp2intensity' => { 259 => 0x32 },
	'unsharp2threshold' => { 259 => 0x36 },
	'unsharp3color' => { 259 => 0x49 },
	'unsharp3halowidth' => { 259 => 0x4f },
	'unsharp3intensity' => { 259 => 0x4d },
	'unsharp3threshold' => { 259 => 0x51 },
	'unsharp4color' => { 259 => 0x64 },
	'unsharp4halowidth' => { 259 => 0x6a },
	'unsharp4intensity' => { 259 => 0x68 },
	'unsharp4threshold' => { 259 => 0x6c },
	'unsharpcount' => { 259 => 0x0 },
	'unsharpmask' => { 103 => 0x90, 254 => 0x76a43200 },
	'unsharpmaskfineness' => { 97 => 0x20309 },
	'unsharpmaskstrength' => { 97 => 0x20308 },
	'unsharpmaskthreshold' => { 97 => 0x2030a },
	'uprightcentermode' => { 448 => 'UprightCenterMode' },
	'uprightcenternormx' => { 448 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 448 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 448 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 448 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 448 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 448 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 448 => 'UprightPreview' },
	'uprighttransform_0' => { 448 => 'UprightTransform_0' },
	'uprighttransform_1' => { 448 => 'UprightTransform_1' },
	'uprighttransform_2' => { 448 => 'UprightTransform_2' },
	'uprighttransform_3' => { 448 => 'UprightTransform_3' },
	'uprighttransform_4' => { 448 => 'UprightTransform_4' },
	'uprighttransform_5' => { 448 => 'UprightTransform_5' },
	'uprighttransformcount' => { 448 => 'UprightTransformCount' },
	'uprightversion' => { 448 => 'UprightVersion' },
	'urgency' => { 125 => 0xa, 460 => 'Urgency' },
	'url' => { 148 => 'URL', 291 => 'URL', 350 => 0x40b, 462 => 'url' },
	'url_list' => { 350 => 0x41e },
	'urla-platform' => { 462 => [\'url','urlA-platform'] },
	'urlurl' => { 462 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 78 => 0x10a },
	'usableshootingmodes' => { 78 => 0x109 },
	'usage' => { 463 => 'usage' },
	'usageterms' => { 476 => 'UsageTerms' },
	'useguidelines' => { 445 => 'useGuidelines' },
	'usepanoramaviewer' => { 435 => 'UsePanoramaViewer' },
	'usercomment' => { 91 => 0x805, 113 => 0x9286, 452 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 66 => 0xd8, 67 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 66 => 0xda, 67 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 66 => 0xdc, 67 => 0xf4 },
	'userfields' => { 440 => 'UserFields' },
	'userlabel' => { 357 => 0x2b, 358 => 0x5a, 359 => 0x68 },
	'userprofile' => { 296 => 0x302, 303 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 77 => 0x7, 78 => 0x501 },
	'uspsnumber' => { 462 => 'uspsNumber' },
	'utmeasting' => { 159 => 'Easting' },
	'utmmapdatum' => { 159 => 'Datum' },
	'utmnorthing' => { 159 => 'Northing' },
	'utmzone' => { 159 => 'Zone' },
	'uv-irfiltercorrection' => { 296 => 0x325 },
	'validbits' => { 282 => 0x611, 283 => 0x102c },
	'validpixeldepth' => { 286 => 0x611 },
	'variablelowpassfilter' => { 394 => 0x2028 },
	'variousmodes' => { 133 => 0x26 },
	'variousmodes2' => { 133 => 0x3a },
	'variprogram' => { 214 => 0xab },
	'varraydacnominalvalues' => { 131 => 0x191e },
	'version' => { 121 => 0x0, 352 => 'Version', 448 => 'Version' },
	'versioncreatedate' => { 427 => 0xd100 },
	'versionid' => { 473 => 'VersionID' },
	'versionidentifier' => { 462 => 'versionIdentifier' },
	'versionmodifydate' => { 427 => 0xd101 },
	'versions' => { 473 => 'Versions' },
	'versionscomments' => { 473 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 473 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 473 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 473 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 473 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 473 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 473 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 473 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 473 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 473 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 473 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 261 => '3.2', 262 => '47.2', 264 => '79.1' },
	'verticalclockoverlaps' => { 131 => 0x412 },
	'verticalfuncbutton' => { 262 => '42.2', 264 => '67.1' },
	'verticalfuncbuttonplusdials' => { 262 => '43.1' },
	'verticalfuncplusdials' => { 264 => '68.1' },
	'verticalmultiselector' => { 262 => '42.1', 264 => '66.1', 265 => '66.1', 275 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 78 => [0x510,0x51d] },
	'vibrance' => { 441 => 'Vibrance', 448 => 'Vibrance' },
	'vibrationreduction' => { 223 => [0x75,0x82,0x1ae], 231 => '586.1', 239 => '590.2', 245 => 0x4 },
	'videoalphamode' => { 472 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 472 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 472 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 472 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 458 => 'videoBitRate' },
	'videobitratemode' => { 458 => 'videoBitRateMode' },
	'videoburstmode' => { 301 => 0xbb },
	'videocodec' => { 63 => 0x74 },
	'videocolorspace' => { 472 => 'videoColorSpace' },
	'videocompressor' => { 472 => 'videoCompressor' },
	'videodisplayaspectratio' => { 458 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 458 => 'videoEncodingProfile' },
	'videofieldorder' => { 472 => 'videoFieldOrder' },
	'videoframerate' => { 472 => 'videoFrameRate' },
	'videoframesize' => { 472 => 'videoFrameSize' },
	'videoframesizeh' => { 472 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 472 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 472 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 472 => 'videoModDate' },
	'videopixelaspectratio' => { 472 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 472 => 'videoPixelDepth' },
	'videoquality' => { 107 => 0x4003 },
	'videoshottype' => { 458 => 'VideoShotType' },
	'videoshottypeidentifier' => { 458 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 458 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 458 => 'videoStreamsCount' },
	'viewfinder' => { 345 => 0x455 },
	'viewfinderdisplay' => { 261 => '12.4', 262 => '6.3' },
	'viewfinderwarning' => { 261 => '13.4', 271 => '3.5', 272 => '6.2', 276 => '4.4' },
	'viewfinderwarnings' => { 78 => 0x40a },
	'viewinfoduringexposure' => { 78 => 0x407 },
	'viewingmode' => { 383 => 0x2f, 399 => 0x18 },
	'viewingmode2' => { 383 => [0x85,0x285] },
	'viewpoint' => { 461 => 'viewpoint' },
	'vignetteamount' => { 448 => 'VignetteAmount' },
	'vignettecontrol' => { 214 => 0x2a, 254 => 0x76a43205 },
	'vignettecontrolintensity' => { 254 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 444 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 448 => 'VignetteMidpoint' },
	'vignetting' => { 363 => 0x1011, 370 => 0xa052 },
	'vignettingcorrection' => { 113 => 0x7031, 370 => 0xa053, 394 => 0x2011 },
	'vignettingcorrparams' => { 113 => 0x7032, 422 => 0x64a, 423 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 370 => 0xa054 },
	'visualcolor' => { 458 => 'VisualColour' },
	'visualtechnique' => { 461 => 'visualTechnique' },
	'voicememo' => { 372 => 0x216 },
	'volume' => { 462 => 'volume' },
	'vr_0x66' => { 223 => 0x66 },
	'vrdoffset' => { 60 => 0xd0 },
	'vrmode' => { 245 => 0x6 },
	'waterdepth' => { 113 => 0x9403, 453 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 177 => 0x19a },
	'wb_bluelevel6500k' => { 177 => 0x18a },
	'wb_bluelevelcustom' => { 177 => 0x18e },
	'wb_bluelevelscloudy' => { 177 => 0x106 },
	'wb_bluelevelsdaylight' => { 177 => 0xea },
	'wb_bluelevelsflash' => { 177 => 0x122 },
	'wb_bluelevelsfluorescent' => { 177 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 177 => 0x254 },
	'wb_bluelevelsshade' => { 177 => 0x176 },
	'wb_bluelevelstungsten' => { 177 => 0xce },
	'wb_gbrglevels' => { 177 => 0xae, 180 => 0x4 },
	'wb_glevel' => { 282 => 0x11f },
	'wb_glevel3000k' => { 282 => 0x113 },
	'wb_glevel3300k' => { 282 => 0x114 },
	'wb_glevel3600k' => { 282 => 0x115 },
	'wb_glevel3900k' => { 282 => 0x116 },
	'wb_glevel4000k' => { 282 => 0x117 },
	'wb_glevel4300k' => { 282 => 0x118 },
	'wb_glevel4500k' => { 282 => 0x119 },
	'wb_glevel4800k' => { 282 => 0x11a },
	'wb_glevel5300k' => { 282 => 0x11b },
	'wb_glevel6000k' => { 282 => 0x11c },
	'wb_glevel6600k' => { 282 => 0x11d },
	'wb_glevel7500k' => { 282 => 0x11e },
	'wb_grbglevels' => { 190 => 0x0 },
	'wb_rbgglevels' => { 187 => 0x0 },
	'wb_rblevels' => { 191 => 0x270, 214 => 0xc, 282 => 0x100 },
	'wb_rblevels1' => { 307 => 0x2 },
	'wb_rblevels2' => { 307 => 0x5 },
	'wb_rblevels3' => { 307 => 0x8 },
	'wb_rblevels3000k' => { 282 => 0x102 },
	'wb_rblevels3300k' => { 282 => 0x103 },
	'wb_rblevels3500k' => { 177 => 0x430 },
	'wb_rblevels3600k' => { 282 => 0x104 },
	'wb_rblevels3900k' => { 282 => 0x105 },
	'wb_rblevels4' => { 307 => 0xb },
	'wb_rblevels4000k' => { 282 => 0x106 },
	'wb_rblevels4300k' => { 282 => 0x107 },
	'wb_rblevels4500k' => { 282 => 0x108 },
	'wb_rblevels4800k' => { 282 => 0x109 },
	'wb_rblevels5' => { 307 => 0xe },
	'wb_rblevels5300k' => { 282 => 0x10a },
	'wb_rblevels6' => { 307 => 0x11 },
	'wb_rblevels6000k' => { 282 => 0x10b },
	'wb_rblevels6500k' => { 177 => 0x420 },
	'wb_rblevels6600k' => { 282 => 0x10c },
	'wb_rblevels7' => { 307 => 0x14 },
	'wb_rblevels7500k' => { 282 => 0x10d },
	'wb_rblevelsauto' => { 191 => 0x272, 286 => 0x110 },
	'wb_rblevelscloudy' => { 177 => 0x3f0, 179 => 0x10, 191 => 0x296, 286 => 0x121 },
	'wb_rblevelscoolwhitef' => { 177 => 0x308, 179 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 286 => 0x132 },
	'wb_rblevelscustom' => { 177 => 0x424 },
	'wb_rblevelscwb1' => { 282 => 0x10e },
	'wb_rblevelscwb2' => { 282 => 0x10f },
	'wb_rblevelscwb3' => { 282 => 0x110 },
	'wb_rblevelscwb4' => { 282 => 0x111 },
	'wb_rblevelsdaylight' => { 177 => [0x3ec,0x528], 179 => 0xc, 191 => 0x274 },
	'wb_rblevelsdaylightf' => { 179 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 286 => 0x130 },
	'wb_rblevelsdaywhitef' => { 179 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 286 => 0x131 },
	'wb_rblevelseveningsunlight' => { 286 => 0x124 },
	'wb_rblevelsfineweather' => { 286 => 0x122 },
	'wb_rblevelsflash' => { 177 => [0x3f4,0x304], 179 => 0x18, 191 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 191 => 0x290 },
	'wb_rblevelsincandescent' => { 191 => 0x282 },
	'wb_rblevelsshade' => { 177 => 0x418, 179 => 0x20, 191 => 0x2b2, 286 => 0x120 },
	'wb_rblevelstungsten' => { 177 => 0x3e8, 179 => 0x8, 286 => 0x123 },
	'wb_rblevelsunknown' => { 179 => 0x1c },
	'wb_rblevelsused' => { 286 => 0x100 },
	'wb_rblevelswhitef' => { 179 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 286 => 0x133 },
	'wb_redlevel3500k' => { 177 => 0x198 },
	'wb_redlevel6500k' => { 177 => 0x188 },
	'wb_redlevelcustom' => { 177 => 0x18c },
	'wb_redlevelscloudy' => { 177 => 0xf8 },
	'wb_redlevelsdaylight' => { 177 => 0xdc },
	'wb_redlevelsflash' => { 177 => 0x114 },
	'wb_redlevelsfluorescent' => { 177 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 177 => 0x1be },
	'wb_redlevelsshade' => { 177 => 0x168 },
	'wb_redlevelstungsten' => { 177 => 0xc0 },
	'wb_rgbglevels' => { 189 => 0x0 },
	'wb_rgblevels' => { 177 => [0x546,0x96], 297 => 0xd, 298 => 0x413, 303 => 0x3036, 345 => 0x107, 402 => 0x117c, 403 => 0x1180, 404 => 0x115c, 405 => 0x11d8, 406 => 0x11b4, 407 => 0x106c, 408 => 0x264, 409 => 0x264, 410 => 0x252 },
	'wb_rgblevels1' => { 308 => 0x2 },
	'wb_rgblevels2' => { 308 => 0x6 },
	'wb_rgblevels3' => { 308 => 0xa },
	'wb_rgblevels4' => { 308 => 0xe },
	'wb_rgblevels5' => { 308 => 0x12 },
	'wb_rgblevels6' => { 308 => 0x16 },
	'wb_rgblevels7' => { 308 => 0x1a },
	'wb_rgbmuldaylight' => { 131 => 0x852 },
	'wb_rgbmulflash' => { 131 => 0x855 },
	'wb_rgbmulfluorescent' => { 131 => 0x854 },
	'wb_rgbmultungsten' => { 131 => 0x853 },
	'wb_rggbblacklevels' => { 34 => 0x25 },
	'wb_rggblevels' => { 180 => 0x4, 188 => 0x0, 192 => 0x13e8, 193 => 0x38 },
	'wb_rggblevelsasshot' => { 37 => 0x0, 38 => 0x0, 39 => 0x19, 40 => 0x22, 41 => 0x3f, 44 => 0x3f, 45 => 0x3f, 46 => 0x3f, 47 => 0x47 },
	'wb_rggblevelsauto' => { 34 => 0x1, 37 => 0x5, 38 => 0x8, 39 => 0x1e, 40 => 0x18, 41 => 0x44, 44 => 0x44, 45 => 0x44, 46 => 0x44, 47 => 0x4c, 192 => 0x1478, 193 => 0x114, 370 => 0xa022 },
	'wb_rggblevelsblack' => { 370 => 0xa028 },
	'wb_rggblevelscloudy' => { 34 => 0xd, 37 => 0x1e, 38 => 0x30, 39 => 0x2d, 40 => 0x31, 41 => 0x58, 44 => 0x71, 45 => 0x8a, 46 => 0x8f, 47 => 0x92, 192 => 0x1408, 193 => 0x60, 336 => 0x20f, 344 => 0x14 },
	'wb_rggblevelscustom' => { 34 => 0x1d, 41 => 0x80, 192 => 0x1468, 193 => 0x100 },
	'wb_rggblevelscustom1' => { 39 => 0x41 },
	'wb_rggblevelscustom2' => { 39 => 0x46 },
	'wb_rggblevelsdaylight' => { 34 => 0x5, 37 => 0x14, 38 => 0x20, 39 => 0x23, 40 => 0x27, 41 => 0x4e, 44 => 0x67, 45 => 0x80, 46 => 0x85, 47 => 0x88, 192 => 0x13f8, 193 => 0x4c, 336 => 0x20d, 344 => 0x2 },
	'wb_rggblevelsflash' => { 34 => 0x19, 37 => 0x32, 38 => 0x50, 39 => 0x3c, 40 => 0x45, 41 => 0x6c, 44 => 0x85, 45 => 0x9e, 46 => 0xa3, 47 => 0xa6, 192 => 0x1448, 336 => 0x214, 344 => 0x41 },
	'wb_rggblevelsfluorescent' => { 34 => 0x15, 37 => 0x28, 38 => 0x40, 39 => 0x37, 40 => 0x3b, 41 => 0x62, 44 => 0x7b, 45 => 0x94, 46 => 0x99, 47 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 193 => 0xc4, 336 => 0x211, 344 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 344 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 193 => 0xb0, 336 => 0x212, 344 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 192 => 0x1438, 193 => 0x9c, 336 => 0x213, 344 => 0x38 },
	'wb_rggblevelshtmercury' => { 193 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 370 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 370 => 0xa024 },
	'wb_rggblevelskelvin' => { 34 => 0x21, 37 => 0x2d, 38 => 0x48, 40 => 0x40, 41 => 0x67, 44 => 0x80, 45 => 0x99, 46 => 0x9e, 47 => 0xa1 },
	'wb_rggblevelsmeasured' => { 37 => 0xa, 38 => 0x10, 41 => 0x49, 44 => 0x49, 45 => 0x49, 46 => 0x49, 47 => 0x51 },
	'wb_rggblevelspc1' => { 40 => 0x90, 41 => 0x71 },
	'wb_rggblevelspc2' => { 40 => 0x95, 41 => 0x76 },
	'wb_rggblevelspc3' => { 40 => 0x9a, 41 => 0x7b },
	'wb_rggblevelsshade' => { 34 => 0x9, 37 => 0x19, 38 => 0x28, 39 => 0x28, 40 => 0x2c, 41 => 0x53, 44 => 0x6c, 45 => 0x85, 46 => 0x8a, 47 => 0x8d, 193 => 0x74, 336 => 0x20e, 344 => 0xb },
	'wb_rggblevelstungsten' => { 34 => 0x11, 37 => 0x23, 38 => 0x38, 39 => 0x32, 40 => 0x36, 41 => 0x5d, 44 => 0x76, 45 => 0x8f, 46 => 0x94, 47 => 0x97, 192 => 0x1428, 193 => 0x88, 336 => 0x210, 344 => 0x1d },
	'wb_rggblevelsuncorrected' => { 370 => 0xa021 },
	'wb_rggblevelsunknown' => { 37 => 0xf, 38 => 0x18, 40 => 0x1d, 44 => 0x4e, 45 => 0x4e, 46 => 0x4e, 47 => 0x56, 344 => 0x53 },
	'wb_rggblevelsunknown10' => { 37 => 0x5f, 38 => 0x98, 40 => 0x72, 44 => 0x9e, 45 => 0x7b, 46 => 0x7b, 47 => 0x83 },
	'wb_rggblevelsunknown11' => { 37 => 0x64, 38 => 0xa0, 40 => 0x77, 44 => 0xa3, 45 => 0xa3, 46 => 0x80, 47 => 0xab },
	'wb_rggblevelsunknown12' => { 37 => 0x69, 38 => 0xa8, 40 => 0x7c, 44 => 0xa8, 45 => 0xa8, 46 => 0xa8, 47 => 0xb0 },
	'wb_rggblevelsunknown13' => { 37 => 0x6e, 38 => 0xb0, 40 => 0x81, 44 => 0xad, 45 => 0xad, 46 => 0xad, 47 => 0xb5 },
	'wb_rggblevelsunknown14' => { 40 => 0x86, 44 => 0xb2, 45 => 0xb2, 46 => 0xb2, 47 => 0xba },
	'wb_rggblevelsunknown15' => { 40 => 0x8b, 44 => 0xb7, 45 => 0xb7, 46 => 0xb7, 47 => 0xbf },
	'wb_rggblevelsunknown16' => { 40 => 0x9f, 45 => 0xbc, 46 => 0xbc, 47 => 0xc4 },
	'wb_rggblevelsunknown17' => { 45 => 0xc1, 46 => 0xc1, 47 => 0xc9 },
	'wb_rggblevelsunknown18' => { 45 => 0xc6, 46 => 0xc6, 47 => 0xce },
	'wb_rggblevelsunknown19' => { 45 => 0xcb, 46 => 0xcb, 47 => 0xd3 },
	'wb_rggblevelsunknown2' => { 37 => 0x37, 38 => 0x58, 40 => 0x4a, 44 => 0x53, 45 => 0x53, 46 => 0x53, 47 => 0x5b },
	'wb_rggblevelsunknown20' => { 45 => 0xd0, 46 => 0xd0, 47 => 0xd8 },
	'wb_rggblevelsunknown21' => { 46 => 0xd5, 47 => 0xdd },
	'wb_rggblevelsunknown22' => { 46 => 0xda, 47 => 0xe2 },
	'wb_rggblevelsunknown23' => { 46 => 0xdf, 47 => 0xe7 },
	'wb_rggblevelsunknown24' => { 46 => 0xe4, 47 => 0xec },
	'wb_rggblevelsunknown25' => { 46 => 0xe9, 47 => 0xf1 },
	'wb_rggblevelsunknown26' => { 46 => 0xee, 47 => 0xf6 },
	'wb_rggblevelsunknown27' => { 46 => 0xf3, 47 => 0xfb },
	'wb_rggblevelsunknown28' => { 46 => 0xf8, 47 => 0x100 },
	'wb_rggblevelsunknown29' => { 46 => 0xfd, 47 => 0x105 },
	'wb_rggblevelsunknown3' => { 37 => 0x3c, 38 => 0x60, 40 => 0x4f, 44 => 0x58, 45 => 0x58, 46 => 0x58, 47 => 0x60 },
	'wb_rggblevelsunknown30' => { 46 => 0x102 },
	'wb_rggblevelsunknown4' => { 37 => 0x41, 38 => 0x68, 40 => 0x54, 44 => 0x5d, 45 => 0x5d, 46 => 0x5d, 47 => 0x65 },
	'wb_rggblevelsunknown5' => { 37 => 0x46, 38 => 0x70, 40 => 0x59, 44 => 0x62, 45 => 0x62, 46 => 0x62, 47 => 0x6a },
	'wb_rggblevelsunknown6' => { 37 => 0x4b, 38 => 0x78, 40 => 0x5e, 44 => 0x8a, 45 => 0x67, 46 => 0x67, 47 => 0x6f },
	'wb_rggblevelsunknown7' => { 37 => 0x50, 38 => 0x80, 40 => 0x63, 44 => 0x8f, 45 => 0x6c, 46 => 0x6c, 47 => 0x74 },
	'wb_rggblevelsunknown8' => { 37 => 0x55, 38 => 0x88, 40 => 0x68, 44 => 0x94, 45 => 0x71, 46 => 0x71, 47 => 0x79 },
	'wb_rggblevelsunknown9' => { 37 => 0x5a, 38 => 0x90, 40 => 0x6d, 44 => 0x99, 45 => 0x76, 46 => 0x76, 47 => 0x7e },
	'wb_rggblevelsuserselected' => { 344 => 0x5c },
	'wbadjblueamber' => { 97 => 0x20106 },
	'wbadjbluebalance' => { 260 => 0x8 },
	'wbadjcolortemp' => { 97 => 0x20102, 102 => 0x1a },
	'wbadjlighting' => { 260 => 0x14 },
	'wbadjmagentagreen' => { 97 => 0x20105 },
	'wbadjmode' => { 260 => 0x10 },
	'wbadjredbalance' => { 260 => 0x0 },
	'wbadjrggblevels' => { 97 => 0x20125, 102 => 0x6 },
	'wbadjtemperature' => { 260 => 0x18 },
	'wbadjtint' => { 260 => 0x25 },
	'wbbluelevel' => { 296 => 0x324, 301 => 0x8006, 306 => 0x26 },
	'wbbracketingsteps' => { 232 => 0x174d, 233 => 0x87c, 241 => 0x1757 },
	'wbbracketmode' => { 54 => 0x9 },
	'wbbracketshotnumber' => { 177 => 0x2b, 363 => 0x101a },
	'wbbracketvalueab' => { 54 => 0xc },
	'wbbracketvaluegm' => { 54 => 0xd },
	'wbfinetuneactive' => { 102 => 0x24 },
	'wbfinetunesaturation' => { 102 => 0x28 },
	'wbfinetunetone' => { 102 => 0x2c },
	'wbgreenlevel' => { 296 => 0x323, 301 => 0x8005, 306 => 0x25 },
	'wbmediaimagesizesetting' => { 78 => 0x708 },
	'wbmode' => { 179 => 0x4, 283 => 0x1015 },
	'wbredlevel' => { 296 => 0x322, 301 => 0x8004, 306 => 0x24 },
	'wbscale' => { 180 => 0x0 },
	'wbshiftab' => { 70 => 0xc, 301 => 0x46, 318 => 0x10 },
	'wbshiftab_gm' => { 394 => 0x2014 },
	'wbshiftab_gm_precise' => { 394 => 0x2026 },
	'wbshiftcreativecontrol' => { 301 => 0x92 },
	'wbshiftgm' => { 70 => 0xd, 301 => 0x47, 318 => 0x11 },
	'wbshiftintelligentauto' => { 301 => 0x8b },
	'wbtype1' => { 307 => 0x1, 308 => 0x1 },
	'wbtype2' => { 307 => 0x4, 308 => 0x5 },
	'wbtype3' => { 307 => 0x7, 308 => 0x9 },
	'wbtype4' => { 307 => 0xa, 308 => 0xd },
	'wbtype5' => { 307 => 0xd, 308 => 0x11 },
	'wbtype6' => { 307 => 0x10, 308 => 0x15 },
	'wbtype7' => { 307 => 0x13, 308 => 0x19 },
	'webstatement' => { 476 => 'WebStatement' },
	'what' => { 448 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x131, 27 => 0x77, 70 => 0x8, 72 => 0x7, 106 => 0x7, 107 => [0x19,0x2012], 113 => [0xa403,0xfe4e], 121 => 0x1002, 131 => 0x3fc, 132 => 0xfa0d, 133 => 0x40, 171 => 0x3, 172 => 0xe, 173 => 0x4, 174 => 0xb, 176 => 0x115, 214 => 0x5, 244 => 0x7, 296 => 0x304, 301 => 0x3, 303 => 0x3033, 336 => 0x19, 343 => 0x7, 362 => 0x26, 363 => 0x1003, 373 => [0x3c,0x7,0x58], 381 => 0xf, 382 => 0xe, 394 => [0x115,0xb054], 448 => 'WhiteBalance', 452 => 'WhiteBalance' },
	'whitebalance0' => { 167 => 'WhiteBalance0' },
	'whitebalance1' => { 167 => 'WhiteBalance1' },
	'whitebalance2' => { 167 => 'WhiteBalance2', 278 => 0x500 },
	'whitebalanceadj' => { 97 => 0x20101, 102 => 0x18, 254 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 314 => 0x0 },
	'whitebalancebias' => { 107 => 0x2011, 283 => 0x304, 301 => 0x23 },
	'whitebalanceblue' => { 70 => 0x7 },
	'whitebalancebracket' => { 278 => 0x502, 283 => 0x303 },
	'whitebalancebracketing' => { 174 => 0x22, 177 => 0x2c, 392 => 0x2c },
	'whitebalancecomp' => { 286 => 0x1001 },
	'whitebalancedetected' => { 131 => 0x3fb },
	'whitebalancefinetune' => { 121 => 0x100a, 174 => 0x38, 176 => 0x112, 214 => 0xb, 363 => 0x1004, 381 => 0x6, 382 => 0x5, 394 => 0x112 },
	'whitebalancemode' => { 131 => 0x3fa, 336 => 0x1a },
	'whitebalancered' => { 70 => 0x6 },
	'whitebalanceset' => { 317 => 0xa },
	'whitebalancesetting' => { 174 => 0x23, 381 => 0x5, 382 => 0x4, 383 => 0x16, 399 => 0xd },
	'whitebalancesetup' => { 370 => 0x41 },
	'whitebalancetemperature' => { 278 => 0x501 },
	'whiteboard' => { 283 => 0x301 },
	'whitelevel' => { 113 => 0xc61d, 336 => 0x7e },
	'whitepoint' => { 113 => 0x13e, 336 => 0x201, 468 => 'WhitePoint' },
	'whites2012' => { 448 => 'Whites2012' },
	'whitesadj' => { 427 => 0x9017 },
	'wideadapter' => { 363 => 0x1017 },
	'widefocuszone' => { 171 => 0x2f },
	'widerange' => { 372 => 0x20f },
	'windmode' => { 131 => 0x3f4 },
	'windowsatom' => { 447 => 'windowsAtom' },
	'windowsatomextension' => { 447 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 447 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 447 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 462 => 'wordCount' },
	'workcolorspace' => { 97 => 0x10200, 102 => 0x270 },
	'workflowtag' => { 458 => 'WorkflowTag' },
	'workflowtagcvid' => { 458 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 458 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 458 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 458 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 454 => 'WorkToDo' },
	'worldtimelocation' => { 301 => 0x3a, 336 => 0x22, 342 => '0.1' },
	'writer-editor' => { 125 => 0x7a },
	'x3filllight' => { 373 => 0x12 },
	'xattrquarantine' => { 165 => 'com.apple.quarantine' },
	'xilinxversion' => { 131 => 0x414 },
	'xml' => { 129 => 'xml ' },
	'xmp' => { 100 => 0xffff00f6, 114 => 'XMP' },
	'xmptoolkit' => { 469 => 'xmptk' },
	'xpauthor' => { 113 => 0x9c9d },
	'xpcomment' => { 113 => 0x9c9c },
	'xpkeywords' => { 113 => 0x9c9e },
	'xposition' => { 113 => 0x11e },
	'xpsubject' => { 113 => 0x9c9f },
	'xptitle' => { 113 => 0x9c9b },
	'xresolution' => { 113 => 0x11a, 128 => 0x3, 351 => 0x0, 468 => 'XResolution' },
	'xyresolution' => { 117 => 0x3 },
	'yaw' => { 109 => 0x7 },
	'yawangle' => { 232 => 0x3513, 233 => 0x2c2c, 241 => 0x36fc, 368 => 0x0 },
	'ycbcrcoefficients' => { 113 => 0x211, 468 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 113 => 0x213, 468 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 113 => 0x212, 468 => 'YCbCrSubSampling' },
	'yearcreated' => { 133 => 0x10, 142 => 0xc },
	'yellowhsl' => { 97 => 0x20912 },
	'yield' => { 464 => 'yield' },
	'yposition' => { 113 => 0x11f },
	'yresolution' => { 113 => 0x11b, 128 => 0x5, 351 => 0x4, 468 => 'YResolution' },
	'zonematching' => { 176 => 0x10a, 179 => [0x3a,0x4a], 394 => 0xb024 },
	'zonematchingmode' => { 174 => 0x14 },
	'zonematchingon' => { 173 => 0x75 },
	'zonematchingvalue' => { 381 => 0x1f },
	'zoomedpreviewlength' => { 283 => 0xf05 },
	'zoomedpreviewsize' => { 283 => 0xf06 },
	'zoomedpreviewstart' => { 283 => 0xf04 },
	'zoomsourcewidth' => { 33 => 0x24 },
	'zoomstepcount' => { 281 => 0x300, 283 => 0x100d },
	'zoomtargetwidth' => { 33 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'angleaxis' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applemaildatereceived' => 1,
	'applemailflagged' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimagetype' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketingcounter' => 1,
	'bracketinginfooffset' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'cx' => 1,
	'cy' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthmapdata' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotinfo' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderid' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gpmd' => 1,
	'gps' => 1,
	'gpsaltituderaw' => 1,
	'gpscoordinates' => 1,
	'gpsdatalist' => 1,
	'gpsdatetimeraw' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'gyroscope' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hiddenslides' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kinds' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelmeter' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magneticfield' => 1,
	'magnetometer' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlatitude' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemversion' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metaformat' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'moviefragment' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'pose' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rads' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorrightborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailpng' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrfinderinfo' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2019, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
