/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "gmp.h"
/* #include "gmp-impl.h" */
#include "longtools.h"
#include "matrix.h"
/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: long_qbase.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/


/**************************************************************************\
@---------------------------------------------------------------------------
@ matrix_TYP *long_qbase(Mat)
@ matrix_TYP *Mat;
@
@ long_qbase calculetes a matrix M1 with rows from Mat, such that
@ the rows of M1 form a qbase of the vectorspace generated by
@ the rows of Mat.
@---------------------------------------------------------------------------
@
\**************************************************************************/
matrix_TYP *long_qbase(Mat)
matrix_TYP *Mat;
{
  int i,j, rang, neurang, n;
  MP_INT **M;
  matrix_TYP *erg;
 
  n = Mat->cols;
  if(Mat->rows < Mat->cols)
   n = Mat->rows;
  M = init_MP_mat(n, Mat->cols);
  erg = init_mat(n, Mat->cols, "");
  rang = 0;
  for(i=0;i<Mat->rows && rang < n;i++)
  {
     for(j=0;j<Mat->cols;j++)
       mpz_set_si(&M[rang][j], Mat->array.SZ[i][j]);
     neurang = MP_row_gauss(M, rang+1, Mat->cols);
     if(neurang != rang)
     {
       for(j=0;j<Mat->cols;j++)
         erg->array.SZ[rang][j] = Mat->array.SZ[i][j];
       rang++;
     }
  }
  if(rang != n)
    real_mat(erg, rang, Mat->cols);
  free_MP_mat(M,n, Mat->cols);
  free(M);
  return(erg);
}
