/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.util.Arrays;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.intervals.ConjunctionIntervalsSource;
import org.apache.lucene.search.intervals.DifferenceIntervalFunction;
import org.apache.lucene.search.intervals.DifferenceIntervalsSource;
import org.apache.lucene.search.intervals.DisjunctionIntervalsSource;
import org.apache.lucene.search.intervals.ExtendedIntervalsSource;
import org.apache.lucene.search.intervals.FilteredIntervalsSource;
import org.apache.lucene.search.intervals.FilteringConjunctionIntervalsSource;
import org.apache.lucene.search.intervals.FixedFieldIntervalsSource;
import org.apache.lucene.search.intervals.IntervalFunction;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.lucene.search.intervals.MinimizingConjunctionIntervalsSource;
import org.apache.lucene.search.intervals.MinimumShouldMatchIntervalsSource;
import org.apache.lucene.search.intervals.MultiTermIntervalsSource;
import org.apache.lucene.search.intervals.OffsetIntervalsSource;
import org.apache.lucene.search.intervals.TermIntervalsSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public final class Intervals {
    private Intervals() {
    }

    public static IntervalsSource term(BytesRef term) {
        return new TermIntervalsSource(term);
    }

    public static IntervalsSource term(String term) {
        return new TermIntervalsSource(new BytesRef((CharSequence)term));
    }

    public static IntervalsSource phrase(String ... terms) {
        if (terms.length == 1) {
            return Intervals.term(terms[0]);
        }
        IntervalsSource[] sources = new IntervalsSource[terms.length];
        int i = 0;
        for (String term : terms) {
            sources[i] = Intervals.term(term);
            ++i;
        }
        return Intervals.phrase(sources);
    }

    public static IntervalsSource phrase(IntervalsSource ... subSources) {
        if (subSources.length == 1) {
            return subSources[0];
        }
        return new ConjunctionIntervalsSource(Arrays.asList(subSources), IntervalFunction.BLOCK);
    }

    public static IntervalsSource or(IntervalsSource ... subSources) {
        if (subSources.length == 1) {
            return subSources[0];
        }
        return new DisjunctionIntervalsSource(Arrays.asList(subSources));
    }

    public static IntervalsSource prefix(String prefix) {
        CompiledAutomaton ca = new CompiledAutomaton(PrefixQuery.toAutomaton((BytesRef)new BytesRef((CharSequence)prefix)));
        return new MultiTermIntervalsSource(ca, 128, prefix);
    }

    public static IntervalsSource wildcard(String wildcard) {
        CompiledAutomaton ca = new CompiledAutomaton(WildcardQuery.toAutomaton((Term)new Term("", wildcard)));
        return new MultiTermIntervalsSource(ca, 128, wildcard);
    }

    public static IntervalsSource maxwidth(final int width, IntervalsSource subSource) {
        return new FilteredIntervalsSource("MAXWIDTH/" + width, subSource){

            @Override
            protected boolean accept(IntervalIterator it) {
                return it.end() - it.start() + 1 <= width;
            }
        };
    }

    public static IntervalsSource maxgaps(final int gaps, IntervalsSource subSource) {
        return new FilteredIntervalsSource("MAXGAPS/" + gaps, subSource){

            @Override
            protected boolean accept(IntervalIterator it) {
                return it.gaps() <= gaps;
            }
        };
    }

    public static IntervalsSource extend(IntervalsSource source, int before, int after) {
        return new ExtendedIntervalsSource(source, before, after);
    }

    public static IntervalsSource ordered(IntervalsSource ... subSources) {
        if (subSources.length == 1) {
            return subSources[0];
        }
        return new MinimizingConjunctionIntervalsSource(Arrays.asList(subSources), IntervalFunction.ORDERED);
    }

    public static IntervalsSource unordered(IntervalsSource ... subSources) {
        return Intervals.unordered(true, subSources);
    }

    public static IntervalsSource unordered(boolean allowOverlaps, IntervalsSource ... subSources) {
        if (subSources.length == 1) {
            return subSources[0];
        }
        return new MinimizingConjunctionIntervalsSource(Arrays.asList(subSources), allowOverlaps ? IntervalFunction.UNORDERED : IntervalFunction.UNORDERED_NO_OVERLAP);
    }

    public static IntervalsSource fixField(String field, IntervalsSource source) {
        return new FixedFieldIntervalsSource(field, source);
    }

    public static IntervalsSource nonOverlapping(IntervalsSource minuend, IntervalsSource subtrahend) {
        return new DifferenceIntervalsSource(minuend, subtrahend, DifferenceIntervalFunction.NON_OVERLAPPING);
    }

    public static IntervalsSource overlapping(IntervalsSource source, IntervalsSource reference) {
        return new FilteringConjunctionIntervalsSource(source, reference, IntervalFunction.OVERLAPPING);
    }

    public static IntervalsSource notWithin(IntervalsSource minuend, int positions, IntervalsSource subtrahend) {
        return new DifferenceIntervalsSource(minuend, Intervals.extend(subtrahend, positions, positions), DifferenceIntervalFunction.NON_OVERLAPPING);
    }

    public static IntervalsSource within(IntervalsSource source, int positions, IntervalsSource reference) {
        return Intervals.containedBy(source, Intervals.extend(reference, positions, positions));
    }

    public static IntervalsSource notContaining(IntervalsSource minuend, IntervalsSource subtrahend) {
        return new DifferenceIntervalsSource(minuend, subtrahend, DifferenceIntervalFunction.NOT_CONTAINING);
    }

    public static IntervalsSource containing(IntervalsSource big, IntervalsSource small) {
        return new FilteringConjunctionIntervalsSource(big, small, IntervalFunction.CONTAINING);
    }

    public static IntervalsSource notContainedBy(IntervalsSource small, IntervalsSource big) {
        return new DifferenceIntervalsSource(small, big, DifferenceIntervalFunction.NOT_CONTAINED_BY);
    }

    public static IntervalsSource containedBy(IntervalsSource small, IntervalsSource big) {
        return new FilteringConjunctionIntervalsSource(small, big, IntervalFunction.CONTAINED_BY);
    }

    public static IntervalsSource atLeast(int minShouldMatch, IntervalsSource ... sources) {
        return new MinimumShouldMatchIntervalsSource(sources, minShouldMatch);
    }

    public static IntervalsSource before(IntervalsSource source, IntervalsSource reference) {
        return new FilteringConjunctionIntervalsSource(source, Intervals.extend(new OffsetIntervalsSource(reference, true), Integer.MAX_VALUE, 0), IntervalFunction.CONTAINED_BY);
    }

    public static IntervalsSource after(IntervalsSource source, IntervalsSource reference) {
        return new FilteringConjunctionIntervalsSource(source, Intervals.extend(new OffsetIntervalsSource(reference, false), 0, Integer.MAX_VALUE), IntervalFunction.CONTAINED_BY);
    }
}

