/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.management;

import java.lang.reflect.Constructor;
import org.jruby.Ruby;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.management.BeanManager;
import org.jruby.management.CachesMBean;
import org.jruby.management.ConfigMBean;
import org.jruby.management.ParserStatsMBean;
import org.jruby.management.Runtime;

public class BeanManagerFactory {
    private static final Class BeanManagerImpl;
    private static final Constructor BeanManagerImpl_constructor;

    public static BeanManager create(Ruby runtime2, boolean managementEnabled) {
        if (BeanManagerImpl_constructor != null) {
            try {
                return (BeanManager)BeanManagerImpl_constructor.newInstance(runtime2, managementEnabled);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return new DummyBeanManager();
    }

    static {
        Class<?> bm = null;
        Constructor<?> bmc = null;
        try {
            bm = Class.forName("org.jruby.management.BeanManagerImpl");
            bmc = bm.getConstructor(Ruby.class, Boolean.TYPE);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        BeanManagerImpl = bm;
        BeanManagerImpl_constructor = bmc;
    }

    private static class DummyBeanManager
    implements BeanManager {
        private DummyBeanManager() {
        }

        @Override
        public void register(JITCompilerMBean jitCompiler) {
        }

        @Override
        public void register(ConfigMBean config) {
        }

        @Override
        public void register(ParserStatsMBean parserStats) {
        }

        @Override
        public void register(CachesMBean methodCache) {
        }

        @Override
        public void register(Runtime runtime2) {
        }

        @Override
        public void unregisterCompiler() {
        }

        @Override
        public void unregisterConfig() {
        }

        @Override
        public void unregisterMethodCache() {
        }

        @Override
        public void unregisterParserStats() {
        }

        @Override
        public void unregisterRuntime() {
        }

        @Override
        public boolean tryShutdownAgent() {
            return false;
        }

        @Override
        public boolean tryRestartAgent() {
            return false;
        }
    }
}

