/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.starter;

import java.io.File;
import org.jivesoftware.openfire.starter.JiveClassLoader;
import org.jivesoftware.util.Log;

public class ServerStarter {
    private static final String DEFAULT_LIB_DIR = "../lib";
    private static final String DEFAULT_ADMIN_LIB_DIR = "../plugins/admin/webapp/WEB-INF/lib";

    public static void main(String[] args) {
        new ServerStarter().start();
    }

    private void start() {
        try {
            String adminLibDirString;
            File adminLibDir;
            File libDir;
            ClassLoader parent = this.findParentClassLoader();
            String libDirString = System.getProperty("openfire.lib.dir");
            if (libDirString != null) {
                libDir = new File(libDirString);
                if (!libDir.exists()) {
                    Log.warn((String)("Lib directory " + libDirString + " does not exist. Using default " + DEFAULT_LIB_DIR));
                    libDir = new File(DEFAULT_LIB_DIR);
                }
            } else {
                libDir = new File(DEFAULT_LIB_DIR);
            }
            if (!(adminLibDir = new File(adminLibDirString = (adminLibDirString = System.getProperty("openfireHome")) == null ? DEFAULT_ADMIN_LIB_DIR : adminLibDirString + "/plugins/admin/webapp/WEB-INF/lib")).exists()) {
                Log.warn((String)("Admin Lib Directory " + adminLibDirString + " does not exist. Web admin console may not work."));
            }
            JiveClassLoader loader = new JiveClassLoader(parent, libDir);
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> containerClass = loader.loadClass("org.jivesoftware.openfire.XMPPServer");
            containerClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ClassLoader findParentClassLoader() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null && (parent = this.getClass().getClassLoader()) == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }
}

