/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class ResolutionCandidate<D extends CallableDescriptor> {
    private final Call call;
    private final D candidateDescriptor;
    private final TypeSubstitutor knownTypeParametersResultingSubstitutor;
    private ReceiverValue dispatchReceiver;
    private ExplicitReceiverKind explicitReceiverKind;

    private ResolutionCandidate(@NotNull Call call2, @NotNull D descriptor2, @Nullable ReceiverValue dispatchReceiver, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable TypeSubstitutor knownTypeParametersResultingSubstitutor) {
        this.call = call2;
        this.candidateDescriptor = descriptor2;
        this.dispatchReceiver = dispatchReceiver;
        this.explicitReceiverKind = explicitReceiverKind;
        this.knownTypeParametersResultingSubstitutor = knownTypeParametersResultingSubstitutor;
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call2, @NotNull D descriptor2) {
        return new ResolutionCandidate<D>(call2, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call2, @NotNull D descriptor2, @Nullable TypeSubstitutor knownTypeParametersResultingSubstitutor) {
        return new ResolutionCandidate<D>(call2, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, knownTypeParametersResultingSubstitutor);
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call2, @NotNull D descriptor2, @Nullable ReceiverValue dispatchReceiver, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable TypeSubstitutor knownTypeParametersResultingSubstitutor) {
        return new ResolutionCandidate<D>(call2, descriptor2, dispatchReceiver, explicitReceiverKind, knownTypeParametersResultingSubstitutor);
    }

    public void setDispatchReceiver(@Nullable ReceiverValue dispatchReceiver) {
        this.dispatchReceiver = dispatchReceiver;
    }

    public void setExplicitReceiverKind(@NotNull ExplicitReceiverKind explicitReceiverKind) {
        this.explicitReceiverKind = explicitReceiverKind;
    }

    @NotNull
    public Call getCall() {
        return this.call;
    }

    @NotNull
    public D getDescriptor() {
        return this.candidateDescriptor;
    }

    @Nullable
    public ReceiverValue getDispatchReceiver() {
        return this.dispatchReceiver;
    }

    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        return this.explicitReceiverKind;
    }

    @Nullable
    public TypeSubstitutor getKnownTypeParametersResultingSubstitutor() {
        return this.knownTypeParametersResultingSubstitutor;
    }

    public String toString() {
        return this.candidateDescriptor.toString();
    }
}

