/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.RandomAccessFileInputStream;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class TestOutputStore {
    private final File resultsDir;
    private final Charset messageStorageCharset;

    public TestOutputStore(File resultsDir) {
        this.resultsDir = resultsDir;
        this.messageStorageCharset = Charset.forName("UTF-8");
    }

    File getOutputsFile() {
        return new File(this.resultsDir, "output.bin");
    }

    File getIndexFile() {
        return new File(this.resultsDir, this.getOutputsFile().getName() + ".idx");
    }

    public Writer writer() {
        return new Writer();
    }

    public Reader reader() {
        return new Reader();
    }

    public class Reader
    implements Closeable {
        private final Index index;
        private final RandomAccessFile dataFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reader() {
            File indexFile = TestOutputStore.this.getIndexFile();
            File outputsFile = TestOutputStore.this.getOutputsFile();
            if (outputsFile.exists()) {
                Input input;
                if (!indexFile.exists()) {
                    throw new IllegalStateException(String.format("Test outputs data file '%s' exists but the index file '%s' does not", outputsFile, indexFile));
                }
                try {
                    input = new Input((InputStream)new FileInputStream(indexFile));
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
                IndexBuilder rootBuilder = null;
                try {
                    int numClasses = input.readInt(true);
                    rootBuilder = new IndexBuilder();
                    for (int classCounter = 0; classCounter < numClasses; ++classCounter) {
                        long classId = input.readLong(true);
                        IndexBuilder classBuilder = new IndexBuilder();
                        int numEntries = input.readInt(true);
                        for (int entryCounter = 0; entryCounter < numEntries; ++entryCounter) {
                            long testId = input.readLong(true);
                            Region stdOut = new Region(input.readLong(), input.readLong());
                            Region stdErr = new Region(input.readLong(), input.readLong());
                            classBuilder.add(testId, new Index(stdOut, stdErr));
                        }
                        rootBuilder.add(classId, classBuilder.build());
                    }
                }
                finally {
                    input.close();
                }
                this.index = rootBuilder.build();
                try {
                    this.dataFile = new RandomAccessFile(TestOutputStore.this.getOutputsFile(), "r");
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
            if (indexFile.exists()) {
                throw new IllegalStateException(String.format("Test outputs data file '%s' does not exist but the index file '%s' does", outputsFile, indexFile));
            }
            this.index = null;
            this.dataFile = null;
        }

        @Override
        public void close() throws IOException {
            if (this.dataFile != null) {
                this.dataFile.close();
            }
        }

        public boolean hasOutput(long classId, TestOutputEvent.Destination destination) {
            if (this.dataFile == null) {
                return false;
            }
            Index classIndex = (Index)this.index.children.get((Object)classId);
            if (classIndex == null) {
                return false;
            }
            Region region = destination == TestOutputEvent.Destination.StdOut ? classIndex.stdOut : classIndex.stdErr;
            return region.start >= 0L;
        }

        public void writeAllOutput(long classId, TestOutputEvent.Destination destination, java.io.Writer writer) {
            this.doRead(classId, 0L, true, destination, writer);
        }

        public void writeNonTestOutput(long classId, TestOutputEvent.Destination destination, java.io.Writer writer) {
            this.doRead(classId, 0L, false, destination, writer);
        }

        public void writeTestOutput(long classId, long testId, TestOutputEvent.Destination destination, java.io.Writer writer) {
            this.doRead(classId, testId, false, destination, writer);
        }

        private void doRead(long classId, long testId, boolean allClassOutput, TestOutputEvent.Destination destination, java.io.Writer writer) {
            Region region;
            if (this.dataFile == null) {
                return;
            }
            Index targetIndex = (Index)this.index.children.get((Object)classId);
            if (targetIndex != null && testId != 0L) {
                targetIndex = (Index)targetIndex.children.get((Object)testId);
            }
            if (targetIndex == null) {
                return;
            }
            boolean stdout = destination == TestOutputEvent.Destination.StdOut;
            Region region2 = region = stdout ? targetIndex.stdOut : targetIndex.stdErr;
            if (region.start < 0L) {
                return;
            }
            boolean ignoreClassLevel = !allClassOutput && testId != 0L;
            boolean ignoreTestLevel = !allClassOutput && testId == 0L;
            try {
                this.dataFile.seek(region.start);
                long maxPos = region.stop - region.start;
                KryoBackedDecoder decoder = new KryoBackedDecoder((InputStream)new RandomAccessFileInputStream(this.dataFile));
                while (decoder.getReadPosition() <= maxPos) {
                    boolean isClassLevel;
                    boolean readStdout = decoder.readBoolean();
                    long readClassId = decoder.readSmallLong();
                    long readTestId = decoder.readSmallLong();
                    int readLength = decoder.readSmallInt();
                    boolean bl = isClassLevel = readTestId == 0L;
                    if (stdout != readStdout || classId != readClassId) {
                        decoder.skipBytes((long)readLength);
                        continue;
                    }
                    if (ignoreClassLevel && isClassLevel) {
                        decoder.skipBytes((long)readLength);
                        continue;
                    }
                    if (ignoreTestLevel && !isClassLevel) {
                        decoder.skipBytes((long)readLength);
                        continue;
                    }
                    if (testId == 0L || testId == readTestId) {
                        String message;
                        byte[] stringBytes = new byte[readLength];
                        decoder.readBytes(stringBytes);
                        try {
                            message = new String(stringBytes, TestOutputStore.this.messageStorageCharset.name());
                        }
                        catch (UnsupportedEncodingException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        }
                        writer.write(message);
                        continue;
                    }
                    decoder.skipBytes((long)readLength);
                }
            }
            catch (IOException e1) {
                throw new UncheckedIOException((Throwable)e1);
            }
        }
    }

    private static class IndexBuilder {
        final Region stdOut = new Region();
        final Region stdErr = new Region();
        private final ImmutableMap.Builder<Long, Index> children = ImmutableMap.builder();

        private IndexBuilder() {
        }

        void add(long key, Index index) {
            if (this.stdOut.start < 0L) {
                this.stdOut.start = index.stdOut.start;
            }
            if (this.stdErr.start < 0L) {
                this.stdErr.start = index.stdErr.start;
            }
            if (index.stdOut.stop > this.stdOut.stop) {
                this.stdOut.stop = index.stdOut.stop;
            }
            if (index.stdErr.stop > this.stdErr.stop) {
                this.stdErr.stop = index.stdErr.stop;
            }
            this.children.put((Object)key, (Object)index);
        }

        Index build() {
            return new Index(this.children.build(), this.stdOut, this.stdErr);
        }
    }

    private static class Index {
        final ImmutableMap<Long, Index> children;
        final Region stdOut;
        final Region stdErr;

        private Index(Region stdOut, Region stdErr) {
            this.children = ImmutableMap.of();
            this.stdOut = stdOut;
            this.stdErr = stdErr;
        }

        private Index(ImmutableMap<Long, Index> children, Region stdOut, Region stdErr) {
            this.children = children;
            this.stdOut = stdOut;
            this.stdErr = stdErr;
        }
    }

    public class Writer
    implements Closeable {
        private final KryoBackedEncoder output;
        private final Map<Long, Map<Long, TestCaseRegion>> index = new LinkedHashMap<Long, Map<Long, TestCaseRegion>>();

        public Writer() {
            try {
                this.output = new KryoBackedEncoder((OutputStream)new FileOutputStream(TestOutputStore.this.getOutputsFile()));
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        @Override
        public void close() {
            this.output.close();
            this.writeIndex();
        }

        public void onOutput(long classId, TestOutputEvent outputEvent) {
            this.onOutput(classId, 0L, outputEvent);
        }

        public void onOutput(long classId, long testId, TestOutputEvent outputEvent) {
            byte[] bytes;
            boolean stdout = outputEvent.getDestination() == TestOutputEvent.Destination.StdOut;
            this.mark(classId, testId, stdout);
            this.output.writeBoolean(stdout);
            this.output.writeSmallLong(classId);
            this.output.writeSmallLong(testId);
            try {
                bytes = outputEvent.getMessage().getBytes(TestOutputStore.this.messageStorageCharset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            this.output.writeSmallInt(bytes.length);
            this.output.writeBytes(bytes, 0, bytes.length);
        }

        private void mark(long classId, long testId, boolean isStdout) {
            TestCaseRegion region;
            Map<Long, TestCaseRegion> testCaseRegions;
            if (!this.index.containsKey(classId)) {
                this.index.put(classId, new LinkedHashMap());
            }
            if (!(testCaseRegions = this.index.get(classId)).containsKey(testId)) {
                region = new TestCaseRegion();
                testCaseRegions.put(testId, region);
            }
            region = testCaseRegions.get(testId);
            Region streamRegion = isStdout ? region.stdOutRegion : region.stdErrRegion;
            long total = this.output.getWritePosition();
            if (streamRegion.start < 0L) {
                streamRegion.start = total;
            }
            streamRegion.stop = total;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeIndex() {
            Output indexOutput;
            try {
                indexOutput = new Output((OutputStream)new FileOutputStream(TestOutputStore.this.getIndexFile()));
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException((Throwable)e);
            }
            try {
                indexOutput.writeInt(this.index.size(), true);
                for (Map.Entry<Long, Map<Long, TestCaseRegion>> classEntry : this.index.entrySet()) {
                    Long classId = classEntry.getKey();
                    Map<Long, TestCaseRegion> regions = classEntry.getValue();
                    indexOutput.writeLong(classId.longValue(), true);
                    indexOutput.writeInt(regions.size(), true);
                    for (Map.Entry<Long, TestCaseRegion> testCaseEntry : regions.entrySet()) {
                        long id = testCaseEntry.getKey();
                        TestCaseRegion region = testCaseEntry.getValue();
                        indexOutput.writeLong(id, true);
                        indexOutput.writeLong(region.stdOutRegion.start);
                        indexOutput.writeLong(region.stdOutRegion.stop);
                        indexOutput.writeLong(region.stdErrRegion.start);
                        indexOutput.writeLong(region.stdErrRegion.stop);
                    }
                }
            }
            finally {
                indexOutput.close();
            }
        }
    }

    private static class TestCaseRegion {
        Region stdOutRegion = new Region();
        Region stdErrRegion = new Region();

        private TestCaseRegion() {
        }
    }

    private static class Region {
        long start;
        long stop;

        private Region() {
            this.start = -1L;
            this.stop = -1L;
        }

        private Region(long start, long stop) {
            this.start = start;
            this.stop = stop;
        }
    }
}

