/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherBlockChaining;
import com.sun.crypto.provider.SymmetricCipher;
import javax.crypto.IllegalBlockSizeException;

final class CipherTextStealing
extends CipherBlockChaining {
    CipherTextStealing(SymmetricCipher embeddedCipher) {
        super(embeddedCipher);
    }

    @Override
    String getFeedback() {
        return "CTS";
    }

    @Override
    int encryptFinal(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException {
        if (plainLen < this.blockSize) {
            throw new IllegalBlockSizeException("input is too short!");
        }
        if (plainLen == this.blockSize) {
            this.encrypt(plain, plainOffset, plainLen, cipher, cipherOffset);
        } else {
            int nLeft = plainLen % this.blockSize;
            if (nLeft == 0) {
                this.encrypt(plain, plainOffset, plainLen, cipher, cipherOffset);
                int lastBlkIndex = cipherOffset + plainLen - this.blockSize;
                int nextToLastBlkIndex = lastBlkIndex - this.blockSize;
                byte[] tmp = new byte[this.blockSize];
                System.arraycopy(cipher, lastBlkIndex, tmp, 0, this.blockSize);
                System.arraycopy(cipher, nextToLastBlkIndex, cipher, lastBlkIndex, this.blockSize);
                System.arraycopy(tmp, 0, cipher, nextToLastBlkIndex, this.blockSize);
            } else {
                int newPlainLen = plainLen - (this.blockSize + nLeft);
                if (newPlainLen > 0) {
                    this.encrypt(plain, plainOffset, newPlainLen, cipher, cipherOffset);
                    plainOffset += newPlainLen;
                    cipherOffset += newPlainLen;
                }
                byte[] tmp = new byte[this.blockSize];
                for (int i = 0; i < this.blockSize; ++i) {
                    tmp[i] = (byte)(plain[plainOffset + i] ^ this.r[i]);
                }
                byte[] tmp2 = new byte[this.blockSize];
                this.embeddedCipher.encryptBlock(tmp, 0, tmp2, 0);
                System.arraycopy(tmp2, 0, cipher, cipherOffset + this.blockSize, nLeft);
                for (int i = 0; i < nLeft; ++i) {
                    tmp2[i] = (byte)(plain[plainOffset + this.blockSize + i] ^ tmp2[i]);
                }
                this.embeddedCipher.encryptBlock(tmp2, 0, cipher, cipherOffset);
            }
        }
        return plainLen;
    }

    @Override
    int decryptFinal(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException {
        if (cipherLen < this.blockSize) {
            throw new IllegalBlockSizeException("input is too short!");
        }
        if (cipherLen == this.blockSize) {
            this.decrypt(cipher, cipherOffset, cipherLen, plain, plainOffset);
        } else {
            int nLeft = cipherLen % this.blockSize;
            if (nLeft == 0) {
                int lastBlkIndex = cipherOffset + cipherLen - this.blockSize;
                int nextToLastBlkIndex = cipherOffset + cipherLen - 2 * this.blockSize;
                byte[] tmp = new byte[2 * this.blockSize];
                System.arraycopy(cipher, lastBlkIndex, tmp, 0, this.blockSize);
                System.arraycopy(cipher, nextToLastBlkIndex, tmp, this.blockSize, this.blockSize);
                int cipherLen2 = cipherLen - 2 * this.blockSize;
                this.decrypt(cipher, cipherOffset, cipherLen2, plain, plainOffset);
                this.decrypt(tmp, 0, 2 * this.blockSize, plain, plainOffset + cipherLen2);
            } else {
                int i;
                int newCipherLen = cipherLen - (this.blockSize + nLeft);
                if (newCipherLen > 0) {
                    this.decrypt(cipher, cipherOffset, newCipherLen, plain, plainOffset);
                    cipherOffset += newCipherLen;
                    plainOffset += newCipherLen;
                }
                byte[] tmp = new byte[this.blockSize];
                this.embeddedCipher.decryptBlock(cipher, cipherOffset, tmp, 0);
                for (i = 0; i < nLeft; ++i) {
                    plain[plainOffset + this.blockSize + i] = (byte)(cipher[cipherOffset + this.blockSize + i] ^ tmp[i]);
                }
                System.arraycopy(cipher, cipherOffset + this.blockSize, tmp, 0, nLeft);
                this.embeddedCipher.decryptBlock(tmp, 0, plain, plainOffset);
                for (i = 0; i < this.blockSize; ++i) {
                    plain[plainOffset + i] = (byte)(plain[plainOffset + i] ^ this.r[i]);
                }
            }
        }
        return cipherLen;
    }
}

