/*
 * Decompiled with CFR 0.152.
 */
import java.sql.ResultSet;
import java.util.Vector;

class GdaJResultSet {
    private ResultSet rs;
    private int ncols;
    protected Vector<GdaJValue> col_values;

    private static native void initIDs();

    public GdaJResultSet(ResultSet resultSet) throws Exception {
        this.rs = resultSet;
        if (resultSet != null) {
            this.ncols = resultSet.getMetaData().getColumnCount();
            this.col_values = new Vector(this.ncols);
        }
    }

    protected GdaJResultSet(int n) {
        this.ncols = n;
        this.col_values = new Vector(n);
    }

    public GdaJResultSetInfos getInfos() throws Exception {
        return new GdaJResultSetInfos(this.rs.getMetaData());
    }

    public void declareColumnTypes(long l, byte[] byArray) throws Exception {
        if (byArray.length != this.ncols) {
            throw new Exception("Number of types differs from number of columns: expected " + this.ncols + " got " + byArray.length);
        }
        for (int i = 0; i < this.ncols; ++i) {
            GdaJValue gdaJValue = GdaJValue.proto_type_to_jvalue(byArray[i]);
            gdaJValue.setGdaConnectionPointer(l);
            gdaJValue.setGdaRowColumn(i);
            this.col_values.add(gdaJValue);
        }
        this.columnTypesDeclared();
    }

    protected void columnTypesDeclared() {
    }

    public boolean fillNextRow(long l) throws Exception {
        if (!this.rs.next()) {
            return false;
        }
        for (int i = 0; i < this.ncols; ++i) {
            GdaJValue gdaJValue = this.col_values.elementAt(i);
            gdaJValue.setCValue(this.rs, i, l);
        }
        return true;
    }

    static {
        GdaJResultSet.initIDs();
    }
}

