/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class Undefined
extends Primitive {
    private byte action = 0;
    public static final byte ACTION_ERROR = 0;
    public static final byte ACTION_WARN = 1;
    public static final byte ACTION_MESSAGE = 2;
    public static final byte ACTION_IGNORE = 3;

    public Undefined() {
        this("undefined", 0);
    }

    public Undefined(String string, byte by) {
        super(string);
        this.setAction(by);
    }

    @Override
    public Object clone() {
        return new Undefined(this.getName(), this.action);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXApp teXApp = teXParser.getListener().getTeXApp();
        switch (this.action) {
            case 0: {
                throw new TeXSyntaxException(teXParser, "tex.error.undefined", this.getName());
            }
            case 1: {
                teXApp.warning(teXParser, teXApp.getMessage("tex.error.undefined", this.getName()));
                break;
            }
            case 2: {
                teXApp.message(teXApp.getMessage("tex.error.undefined", this.getName()));
            }
        }
    }

    public void setAction(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.action = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid undefined action " + by);
            }
        }
    }

    public byte getAction() {
        return this.action;
    }
}

