/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx.impl;

import com.sun.tools.visualvm.core.ui.components.Spacer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class CredentialsConfigurator
extends JPanel {
    private JLabel hintLabel1;
    private JLabel hintLabel2;
    private JLabel usernameLabel;
    private JTextField usernameField;
    private JLabel passwordLabel;
    private JPasswordField passwordField;
    private JButton okButton;

    public static CredentialsConfigurator supplyCredentials(String url) {
        CredentialsConfigurator asc = new CredentialsConfigurator();
        asc.setupDefineCredentials();
        String title = NbBundle.getMessage(CredentialsConfigurator.class, (String)"LBL_Supply_Security_Credentials") + url;
        DialogDescriptor dd = new DialogDescriptor((Object)asc, title, true, new Object[]{asc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)asc.okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == asc.okButton) {
            return asc;
        }
        return null;
    }

    public String getUsername() {
        return this.usernameField.getText().trim();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    private CredentialsConfigurator() {
        this.initComponents();
        this.update();
    }

    private void setupDefineCredentials() {
        this.usernameField.setEnabled(true);
        this.usernameField.setText("");
        this.passwordField.setEnabled(true);
        this.passwordField.setText("");
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String username = CredentialsConfigurator.this.getUsername();
                String password = CredentialsConfigurator.this.getPassword();
                CredentialsConfigurator.this.okButton.setEnabled(username.length() > 0 && password.length() > 0);
            }
        });
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.hintLabel1 = new JLabel();
        this.hintLabel1.setFont(this.hintLabel1.getFont().deriveFont(1));
        Mnemonics.setLocalizedText((JLabel)this.hintLabel1, (String)NbBundle.getMessage(CredentialsConfigurator.class, (String)"LBL_CredentialsMsg1"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 10, 0, 10);
        this.add((Component)this.hintLabel1, constraints);
        this.hintLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.hintLabel2, (String)NbBundle.getMessage(CredentialsConfigurator.class, (String)"LBL_CredentialsMsg2"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 10, 5, 10);
        this.add((Component)this.hintLabel2, constraints);
        this.usernameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(CredentialsConfigurator.class, (String)"LBL_Username"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(15, 20, 0, 0);
        this.add((Component)this.usernameLabel, constraints);
        this.usernameField = new JTextField();
        this.usernameLabel.setLabelFor(this.usernameField);
        this.usernameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CredentialsConfigurator.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CredentialsConfigurator.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CredentialsConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.usernameField, constraints);
        this.passwordLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(CredentialsConfigurator.class, (String)"LBL_Password"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(8, 20, 0, 0);
        this.add((Component)this.passwordLabel, constraints);
        this.passwordField = new JPasswordField();
        this.passwordLabel.setLabelFor(this.passwordField);
        this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CredentialsConfigurator.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CredentialsConfigurator.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CredentialsConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 5, 0, 10);
        this.add((Component)this.passwordField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)Spacer.create(), constraints);
        this.okButton = new JButton(NbBundle.getMessage(CredentialsConfigurator.class, (String)"LBL_OK"));
    }
}

