/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.uisupport;

import com.sun.tools.visualvm.uisupport.UISupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.netbeans.lib.profiler.ui.UIUtils;

public final class SeparatorLine
extends JSeparator {
    private final Color separatorColor;

    public SeparatorLine() {
        this(0);
    }

    public SeparatorLine(boolean thin) {
        this(0, thin);
    }

    public SeparatorLine(int orientation) {
        this(orientation, UISupport.isAquaLookAndFeel());
    }

    public SeparatorLine(int orientation, boolean thin) {
        super(orientation);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.separatorColor = thin ? SeparatorLine.getSeparatorColor() : null;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.separatorColor != null) {
            dim.height = 1;
        }
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        if (this.separatorColor != null) {
            g.setColor(this.separatorColor);
            g.drawLine(0, 0, this.getWidth(), 0);
        } else {
            super.paint(g);
        }
    }

    private static Color getSeparatorColor() {
        return UIUtils.getDarkerLine((Color)new JPanel().getBackground(), (float)0.8f);
    }
}

