/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.base.LayerFactory;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbCollections;

public class ModuleLayeredFileSystem
extends MultiFileSystem
implements LookupListener {
    private static final long serialVersionUID = 782910986724201983L;
    static final Logger err = Logger.getLogger("org.netbeans.core.projects");
    private static Lookup.Result<FileSystem> fsResult = Lookup.getDefault().lookupResult(FileSystem.class);
    private static Lookup.Result<Repository.LayerProvider> layerResult = Lookup.getDefault().lookupResult(Repository.LayerProvider.class);
    private static Mutex mutex;
    private List<URL> urls;
    private List<URL> prevs;
    private LayerFactory manager;
    private final FileSystem writableLayer;
    private FileSystem cacheLayer;
    private final FileSystem[] otherLayers;
    private final boolean addLookupBefore;
    private final boolean user;

    ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, LayerFactory layerFactory) throws IOException {
        this(fileSystem, bl, fileSystemArray, layerFactory, layerFactory.loadCache());
    }

    private ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, LayerFactory layerFactory, FileSystem fileSystem2) throws IOException {
        super(ModuleLayeredFileSystem.appendLayers(fileSystem, bl, fileSystemArray, fileSystem2 == null ? layerFactory.createEmptyFileSystem() : fileSystem2, bl));
        this.manager = layerFactory;
        this.writableLayer = fileSystem;
        this.otherLayers = fileSystemArray;
        this.cacheLayer = fileSystem2;
        this.addLookupBefore = bl;
        this.setPropagateMasks(true);
        this.urls = null;
        fsResult.addLookupListener((LookupListener)this);
        layerResult.addLookupListener((LookupListener)this);
        this.user = bl;
    }

    private static FileSystem[] appendLayers(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, FileSystem fileSystem2, boolean bl2) {
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(fileSystemArray.length + 2);
        arrayList.add(fileSystem);
        if (bl) {
            for (FileSystem fileSystem3 : fsResult.allInstances()) {
                if (Boolean.TRUE.equals(fileSystem3.getRoot().getAttribute("fallback"))) continue;
                arrayList.add(fileSystem3);
            }
        }
        arrayList.addAll(Arrays.asList(fileSystemArray));
        arrayList.add(fileSystem2);
        if (bl2) {
            Object object = null;
            try {
                object = ModuleLayeredFileSystem.collectLayers(ModuleInfo.class.getClassLoader());
                if (!object.isEmpty()) {
                    FileSystem fileSystem3;
                    fileSystem3 = new XMLFileSystem();
                    fileSystem3.setXmlUrls(object.toArray(new URL[object.size()]));
                    arrayList.add(fileSystem3);
                }
                err.log(Level.FINE, "Loading classpath layers: {0}", object);
            }
            catch (Exception exception) {
                err.log(Level.WARNING, "Setting layer URLs: " + object, exception);
            }
        }
        if (!bl) {
            for (FileSystem fileSystem3 : fsResult.allInstances()) {
                if (!Boolean.TRUE.equals(fileSystem3.getRoot().getAttribute("fallback"))) continue;
                arrayList.add(fileSystem3);
            }
        }
        return arrayList.toArray(new FileSystem[arrayList.size()]);
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.writableLayer;
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        SystemFileSystem systemFileSystem;
        try {
            systemFileSystem = (SystemFileSystem)FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new AssertionError((Object)fileStateInvalidException);
        }
        ModuleLayeredFileSystem moduleLayeredFileSystem = systemFileSystem.getInstallationLayer();
        if (moduleLayeredFileSystem != null) {
            return moduleLayeredFileSystem;
        }
        return systemFileSystem.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem systemFileSystem;
        try {
            systemFileSystem = (SystemFileSystem)FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new AssertionError((Object)fileStateInvalidException);
        }
        return systemFileSystem.getUserLayer();
    }

    public void setURLs(List<URL> list) throws Exception {
        assert (mutex == null || mutex.isWriteAccess());
        if (list == null) {
            list = this.prevs;
        }
        if (list == null) {
            return;
        }
        if (list.contains(null)) {
            throw new NullPointerException("urls=" + list);
        }
        if (err.isLoggable(Level.FINE)) {
            err.log(Level.FINE, "setURLs: {0}", list);
        }
        List<URL> list2 = list;
        if (this == ModuleLayeredFileSystem.getInstallationModuleLayer()) {
            list = this.manager.additionalLayers(list);
        }
        if (this.urls != null && list.equals(this.urls)) {
            err.fine("no-op");
            return;
        }
        if (this.urls != null || this.cacheLayer == null) {
            if (this.cacheLayer == null) {
                this.cacheLayer = this.manager.createEmptyFileSystem();
            }
            this.cacheLayer = this.manager.store(this.cacheLayer, list);
            err.log(Level.FINEST, "changing delegates");
            this.setDelegates(ModuleLayeredFileSystem.appendLayers(this.writableLayer, this.addLookupBefore, this.otherLayers, this.cacheLayer, this.addLookupBefore));
            err.log(Level.FINEST, "delegates changed");
        }
        this.urls = list;
        this.prevs = list2;
        this.firePropertyChange("layers", null, null);
    }

    public void addURLs(Collection<URL> collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(collection);
        if (this.prevs != null) {
            arrayList.addAll(this.prevs);
        }
        this.setURLs(arrayList);
    }

    public void removeURLs(Collection<URL> collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (this.prevs != null) {
            arrayList.addAll(this.prevs);
        }
        arrayList.removeAll(collection);
        this.setURLs(arrayList);
    }

    public void resultChanged(final LookupEvent lookupEvent) {
        class ProcessEv
        implements Mutex.Action<Void> {
            ProcessEv() {
            }

            public Void run() {
                if (lookupEvent.getSource() == fsResult) {
                    ModuleLayeredFileSystem.this.setDelegates(ModuleLayeredFileSystem.appendLayers(ModuleLayeredFileSystem.this.writableLayer, ModuleLayeredFileSystem.this.addLookupBefore, ModuleLayeredFileSystem.this.otherLayers, ModuleLayeredFileSystem.this.cacheLayer, ModuleLayeredFileSystem.this.addLookupBefore));
                    return null;
                }
                if (lookupEvent.getSource() == layerResult) {
                    if (ModuleLayeredFileSystem.this.prevs != null) {
                        try {
                            ModuleLayeredFileSystem.this.setURLs(ModuleLayeredFileSystem.this.prevs);
                        }
                        catch (Exception exception) {
                            err.log(Level.INFO, null, exception);
                        }
                    }
                    return null;
                }
                throw new IllegalStateException("Unknown source: " + lookupEvent.getSource());
            }
        }
        ProcessEv processEv = new ProcessEv();
        if (mutex != null) {
            mutex.writeAccess((Mutex.Action)processEv);
        } else {
            processEv.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URL> collectLayers(ClassLoader classLoader) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : NbCollections.iterable(classLoader.getResources("META-INF/MANIFEST.MF"))) {
            InputStream inputStream = uRL.openStream();
            try {
                Manifest manifest = new Manifest(inputStream);
                String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Layer");
                if (string == null) continue;
                URL uRL2 = classLoader.getResource(string);
                if (uRL2 != null) {
                    arrayList.add(uRL2);
                    continue;
                }
                err.log(Level.WARNING, "No such layer: {0}", string);
            }
            finally {
                inputStream.close();
            }
        }
        for (URL uRL : NbCollections.iterable(classLoader.getResources("META-INF/generated-layer.xml"))) {
            arrayList.add(uRL);
        }
        return arrayList;
    }

    static void registerMutex(Mutex mutex) {
        ModuleLayeredFileSystem.mutex = mutex;
    }
}

