/*
 * Decompiled with CFR 0.152.
 */
package org.jmol;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jmol.AppCloser;
import org.jmol.JmolPanel;
import org.jmol.api.JmolViewer;
import org.jmol.util.Logger;

public class JmolTable {
    static int STRUCTURE_COL = 0;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            stringArray = new String[]{"caffeine.xyz", "C6H6.smol"};
        }
        int n = stringArray.length;
        int n2 = 2;
        Object[][] objectArray = new Object[n][n2];
        int n3 = 0;
        while (n3 < n) {
            objectArray[n3][0] = new JmolPanel();
            JmolViewer jmolViewer = ((JmolPanel)objectArray[n3][0]).getViewer();
            String string = jmolViewer.openFile(stringArray[n3]);
            if (string != null) {
                Logger.error(string);
            }
            objectArray[n3][1] = stringArray[n3];
            ++n3;
        }
        String[] stringArray2 = new String[]{"Structure", "Filename"};
        JmolTable.showMolecules(stringArray2, objectArray, n);
    }

    public static void showMolecules(String[] stringArray, Object[][] objectArray, int n) {
        JFrame jFrame = new JFrame("Structure Viewer");
        jFrame.addWindowListener(new AppCloser());
        jFrame.setDefaultCloseOperation(3);
        JTable jTable = new JTable(new JmolPanelJTableModel(objectArray, stringArray));
        jTable.setShowGrid(true);
        jTable.getColumnModel().addColumnModelListener(new JmolColumnModelListener(jTable));
        jTable.setCellSelectionEnabled(true);
        jTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        jFrame.getContentPane().add(jScrollPane);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(STRUCTURE_COL);
        tableColumn.setCellRenderer(new JmolPanelCellRenderer());
        tableColumn.setCellEditor(new JmolPanelCellEditor());
        jFrame.pack();
        jFrame.setSize(300, 300);
        jFrame.setVisible(true);
    }

    static class JmolColumnModelListener
    implements TableColumnModelListener {
        JTable table;

        public JmolColumnModelListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            int n = this.table.getColumnModel().getColumn(STRUCTURE_COL).getWidth();
            int n2 = 0;
            while (n2 < this.table.getRowCount()) {
                this.table.setRowHeight(n2, n);
                ++n2;
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    static class JmolPanelCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JmolPanelCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return (JmolPanel)object;
        }

        @Override
        public Object getCellEditorValue() {
            return new Object();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == STRUCTURE_COL;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }
    }

    static class JmolPanelCellRenderer
    extends JmolPanel
    implements TableCellRenderer {
        JmolPanelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return (JmolPanel)object;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    static class JmolPanelJTableModel
    extends AbstractTableModel {
        private Object[][] rows;
        private String[] columns;

        public JmolPanelJTableModel(Object[][] objectArray, String[] stringArray) {
            this.rows = objectArray;
            this.columns = stringArray;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public int getRowCount() {
            return this.rows.length;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.rows[n][n2];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == STRUCTURE_COL;
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

