/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class BioExt {
    private Viewer vwr;
    private ModelSet ms;
    private static final String[] qColor = new String[]{"yellow", "orange", "purple"};
    private static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};
    private static final String naNoH = "A3;A1;C3;G3;I3";
    private static final String aaSp2 = "ARGN;ASNN;ASNO;ASPO;GLNN;GLNO;GLUO;HISN;HISC;PHECTRPC;TRPN;TYRC";
    private static final String aaSp21 = "ARGNE;ARGNH1;ASNNH2;GLNNE2;TRPNE1;HISNE2";
    private static final String aaPlus = "LYSN";

    BioExt set(Viewer viewer, ModelSet modelSet) {
        this.vwr = viewer;
        this.ms = modelSet;
        return this;
    }

    void getAllPolymerInfo(BS bS, Map<String, Lst<Map<String, Object>>> map) {
        Lst lst = new Lst();
        int n = this.ms.mc;
        Model[] modelArray = this.ms.am;
        int n2 = 0;
        while (n2 < n) {
            if (modelArray[n2].isBioModel) {
                BioModel bioModel = (BioModel)modelArray[n2];
                Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
                Lst lst2 = new Lst();
                int n3 = 0;
                while (n3 < bioModel.bioPolymerCount) {
                    BioPolymer bioPolymer = bioModel.bioPolymers[n3];
                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                    Lst<Map<String, Object>> lst3 = new Lst<Map<String, Object>>();
                    Lst<Hashtable<String, Object>> lst4 = null;
                    ProteinStructure proteinStructure = null;
                    int n4 = 0;
                    P3 p3 = new P3();
                    int n5 = 0;
                    while (n5 < bioPolymer.monomerCount) {
                        if (bS.get(bioPolymer.monomers[n5].leadAtomIndex)) {
                            Map<String, Object> map2 = bioPolymer.monomers[n5].getMyInfo(p3);
                            map2.put("monomerIndex", n5);
                            lst3.addLast(map2);
                            ProteinStructure proteinStructure2 = bioPolymer.getProteinStructure(n5);
                            if (proteinStructure2 != null && proteinStructure2 != proteinStructure) {
                                Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
                                proteinStructure = proteinStructure2;
                                hashtable3.put("type", proteinStructure2.type.getBioStructureTypeName(false));
                                int[] nArray = bioPolymer.getLeadAtomIndices();
                                int[] nArray2 = AU.arrayCopyRangeI(nArray, proteinStructure2.monomerIndexFirst, proteinStructure2.monomerIndexFirst + proteinStructure2.nRes);
                                hashtable3.put("leadAtomIndices", nArray2);
                                proteinStructure2.calcAxis();
                                if (proteinStructure2.axisA != null) {
                                    hashtable3.put("axisA", proteinStructure2.axisA);
                                    hashtable3.put("axisB", proteinStructure2.axisB);
                                    hashtable3.put("axisUnitVector", proteinStructure2.axisUnitVector);
                                }
                                hashtable3.put("index", n4++);
                                if (lst4 == null) {
                                    lst4 = new Lst<Hashtable<String, Object>>();
                                }
                                lst4.addLast(hashtable3);
                            }
                        }
                        ++n5;
                    }
                    if (lst3.size() > 0) {
                        hashtable2.put("sequence", bioPolymer.getSequence());
                        hashtable2.put("monomers", lst3);
                        if (lst4 != null) {
                            hashtable2.put("structures", lst4);
                        }
                    }
                    if (!hashtable2.isEmpty()) {
                        lst2.addLast(hashtable2);
                    }
                    ++n3;
                }
                if (lst2.size() > 0) {
                    hashtable.put("modelIndex", Integer.valueOf(bioModel.modelIndex));
                    hashtable.put("polymers", lst2);
                    lst.addLast(hashtable);
                }
            }
            ++n2;
        }
        map.put("models", lst);
    }

    void calculateStraightnessAll() {
        char c = this.vwr.getQuaternionFrame();
        int n = this.vwr.getInt(0x21000011);
        int n2 = this.ms.mc;
        while (--n2 >= 0) {
            if (!this.ms.am[n2].isBioModel) continue;
            BioModel bioModel = (BioModel)this.ms.am[n2];
            P3 p3 = new P3();
            int n3 = 0;
            while (n3 < bioModel.bioPolymerCount) {
                this.getPdbData(bioModel.bioPolymers[n3], 'S', c, n, 2, null, null, false, false, false, null, null, null, new BS(), p3);
                ++n3;
            }
        }
        this.ms.haveStraightness = true;
    }

    private void getPdbData(BioPolymer bioPolymer, char c, char c2, int n, int n2, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, LabelToken[] labelTokenArray, OC oC, SB sB, BS bS3, P3 p3) {
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7 = c2 == 'C' || c2 == 'P';
        boolean bl8 = bl6 = c == 'R' || c == 'S' && bl7;
        if (bl6 && !bioPolymer.calcPhiPsiAngles()) {
            return;
        }
        boolean bl9 = bioPolymer.type == 1;
        boolean bl10 = c == 'r';
        boolean bl11 = bl5 = !bl6 && c == 'S';
        if (n2 == 2 && bl10) {
            c = (char)119;
        }
        if (bl5) {
            n2 = 2;
        }
        boolean bl12 = c == 'S';
        boolean bl13 = bl4 = "rcpCP".indexOf(c2) >= 0;
        if (Logger.debugging && (bl5 || bl7)) {
            Logger.debug("For straightness calculation: useQuaternionStraightness = " + bl12 + " and quaternionFrame = " + c2);
        }
        if (bl3 && !bl2) {
            oC.append("REMARK   6    AT GRP CH RESNO  ");
            switch (c) {
                default: {
                    oC.append("x*10___ y*10___ z*10___      w*10__       ");
                    break;
                }
                case 'x': {
                    oC.append("y*10___ z*10___ w*10___      x*10__       ");
                    break;
                }
                case 'y': {
                    oC.append("z*10___ w*10___ x*10___      y*10__       ");
                    break;
                }
                case 'z': {
                    oC.append("w*10___ x*10___ y*10___      z*10__       ");
                    break;
                }
                case 'R': {
                    if (bl4) {
                        oC.append("phi____ psi____ theta         Straightness");
                        break;
                    }
                    oC.append("phi____ psi____ omega-180    PartialCharge");
                }
            }
            oC.append("    Sym   q0_______ q1_______ q2_______ q3_______");
            oC.append("  theta_  aaX_______ aaY_______ aaZ_______");
            if (c != 'R') {
                oC.append("  centerX___ centerY___ centerZ___");
            }
            if (c2 == 'n') {
                oC.append("  NHX_______ NHY_______ NHZ_______");
            }
            oC.append("\n\n");
        }
        float f = c == 'R' ? 1.0f : 10.0f;
        bl = false;
        int n3 = 0;
        while (n3 < (bl ? 2 : 1)) {
            int n4 = 0;
            while (n4 < (n < 1 ? 1 : n)) {
                if (bioPolymer.hasStructure) {
                    this.getData(n4, n, bioPolymer, c, c2, n2, bS, bS2, bl2, bl6, bl7, bl12, bl4, bl5, f, bl9, bl10, labelTokenArray, oC, sB, bS3, p3);
                }
                ++n4;
            }
            ++n3;
            f *= -1.0f;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void getData(int var1_1, int var2_2, BioPolymer var3_3, char var4_4, char var5_5, int var6_6, BS var7_7, BS var8_8, boolean var9_9, boolean var10_10, boolean var11_11, boolean var12_12, boolean var13_13, boolean var14_14, float var15_15, boolean var16_16, boolean var17_17, LabelToken[] var18_18, OC var19_19, SB var20_20, BS var21_21, P3 var22_22) {
        var23_23 = var6_6 > 0 ? "dq" + (var6_6 == 2 ? "2" : "") : "q";
        var25_24 = null;
        var26_25 = null;
        var27_26 = null;
        var28_27 = null;
        var29_28 = null;
        var30_29 = null;
        var31_30 = 0.0f;
        var32_31 = 0.0f;
        var33_32 = 0.0f;
        var34_33 = 0.0f;
        var35_34 = "";
        var36_35 = NaNf;
        var37_36 = NaNf;
        var38_37 = var9_9 != false ? new P3() : null;
        var39_38 = var2_2 <= 1 ? 1 : var2_2;
        var40_39 = var1_1;
        while (var40_39 < var3_3.monomerCount) {
            block38: {
                block39: {
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    var41_41 = var3_3.monomers[var40_39];
                                    if (var7_7 != null && !var7_7.get(var41_41.leadAtomIndex)) break block38;
                                    var42_42 = var41_41.getLeadAtom();
                                    var43_43 = var41_41.getUniqueID();
                                    if (!var10_10) break block39;
                                    if (var4_4 == 'S') {
                                        var41_41.setGroupParameter(1111490574, NaNf);
                                    }
                                    var31_30 = var41_41.getGroupParameter(1111490569);
                                    var32_31 = var41_41.getGroupParameter(1111490570);
                                    var33_32 = var41_41.getGroupParameter(1111490568);
                                    if (var33_32 < -90.0f) {
                                        var33_32 += 360.0f;
                                    }
                                    if (!Float.isNaN(var31_30) && !Float.isNaN(var32_31) && !Float.isNaN(var33_32 -= 180.0f)) break block40;
                                    if (var7_7 != null) {
                                        var7_7.clear(var42_42.i);
                                    }
                                    break block38;
                                }
                                var44_44 = var13_13 != false ? var3_3.calculateRamachandranHelixAngle(var40_39, var5_5) : 0.0f;
                                v0 = var45_47 = var11_11 != false || var13_13 != false ? BioExt.getStraightness((float)Math.cos((double)(var44_44 / 2.0f / 180.0f) * 3.141592653589793)) : 0.0f;
                                if (var4_4 != 'S') break block41;
                                var41_41.setGroupParameter(1111490574, var45_47);
                                break block38;
                            }
                            if (!var9_9) break block42;
                            if (var8_8 == null || var8_8.get(var42_42.getIndex())) {
                                var46_50 = (AminoMonomer)var41_41;
                                var38_37.set(-var31_30, var31_30, 0.5f);
                                var19_19.append("draw ID \"phi").append(var43_43).append("\" ARROW ARC ").append(Escape.eP(var46_50.getNitrogenAtom())).append(Escape.eP(var42_42)).append(Escape.eP(var46_50.getCarbonylCarbonAtom())).append(Escape.eP(var38_37)).append(" \"phi = ").append(String.valueOf(Math.round(var31_30))).append("\" color ").append(BioExt.qColor[2]).append("\n");
                                var38_37.set(0.0f, var32_31, 0.5f);
                                var19_19.append("draw ID \"psi").append(var43_43).append("\" ARROW ARC ").append(Escape.eP(var42_42)).append(Escape.eP(var46_50.getCarbonylCarbonAtom())).append(Escape.eP(var46_50.getNitrogenAtom())).append(Escape.eP(var38_37)).append(" \"psi = ").append(String.valueOf(Math.round(var32_31))).append("\" color ").append(BioExt.qColor[1]).append("\n");
                                var19_19.append("draw ID \"planeNCC").append(var43_43).append("\" ").append(Escape.eP(var46_50.getNitrogenAtom())).append(Escape.eP(var42_42)).append(Escape.eP(var46_50.getCarbonylCarbonAtom())).append(" color ").append(BioExt.qColor[0]).append("\n");
                                var19_19.append("draw ID \"planeCNC").append(var43_43).append("\" ").append(Escape.eP(((AminoMonomer)var3_3.monomers[var40_39 - 1]).getCarbonylCarbonAtom())).append(Escape.eP(var46_50.getNitrogenAtom())).append(Escape.eP(var42_42)).append(" color ").append(BioExt.qColor[1]).append("\n");
                                var19_19.append("draw ID \"planeCCN").append(var43_43).append("\" ").append(Escape.eP(var42_42)).append(Escape.eP(var46_50.getCarbonylCarbonAtom())).append(Escape.eP(((AminoMonomer)var3_3.monomers[var40_39 + 1]).getNitrogenAtom())).append(" color ").append(BioExt.qColor[2]).append("\n");
                            }
                            break block38;
                        }
                        if (!Float.isNaN(var44_44)) break block43;
                        var35_34 = "";
                        if (!var13_13) ** GOTO lbl157
                        break block38;
                    }
                    var24_40 = Quat.newVA(P3.new3(1.0f, 0.0f, 0.0f), var44_44);
                    var35_34 = BioExt.getQInfo(var24_40);
                    if (var13_13) {
                        var33_32 = var44_44;
                        var34_33 = var45_47;
                    } else {
                        var34_33 = var42_42.getPartialCharge();
                    }
                    ** GOTO lbl157
                }
                var24_40 = var41_41.getQuaternion(var5_5);
                if (var24_40 != null) {
                    var24_40.setRef(var29_28);
                    var29_28 = Quat.newQ(var24_40);
                }
                if (var6_6 == 2) {
                    var41_41.setGroupParameter(1111490574, NaNf);
                }
                if (var24_40 == null) {
                    var26_25 = null;
                    var29_28 = null;
                } else if (var6_6 > 0) {
                    var44_45 = var42_42;
                    var45_48 = var24_40;
                    if (var26_25 == null) {
                        var24_40 = null;
                        var28_27 = null;
                    } else {
                        var27_26 = var17_17 != false ? var26_25.leftDifference(var24_40) : var24_40.rightDifference(var26_25);
                        if (var6_6 == 1) {
                            var24_40 = var27_26;
                        } else if (var28_27 == null) {
                            var24_40 = null;
                        } else {
                            var24_40 = var27_26.rightDifference(var28_27);
                            var36_35 = BioExt.getQuaternionStraightness(var43_43, var28_27, var27_26);
                            var37_36 = BioExt.get3DStraightness(var43_43, var28_27, var27_26);
                            ((Monomer)var25_24.group).setGroupParameter(1111490574, var12_12 != false ? var36_35 : var37_36);
                        }
                        var28_27 = var27_26;
                    }
                    var25_24 = var44_45;
                    var26_25 = var45_48;
                }
                if (var24_40 == null) {
                    var30_29 = null;
                } else {
                    switch (var4_4) {
                        default: {
                            var31_30 = var24_40.q1;
                            var32_31 = var24_40.q2;
                            var33_32 = var24_40.q3;
                            var34_33 = var24_40.q0;
                            break;
                        }
                        case 'x': {
                            var31_30 = var24_40.q0;
                            var32_31 = var24_40.q1;
                            var33_32 = var24_40.q2;
                            var34_33 = var24_40.q3;
                            break;
                        }
                        case 'y': {
                            var31_30 = var24_40.q3;
                            var32_31 = var24_40.q0;
                            var33_32 = var24_40.q1;
                            var34_33 = var24_40.q2;
                            break;
                        }
                        case 'z': {
                            var31_30 = var24_40.q2;
                            var32_31 = var24_40.q3;
                            var33_32 = var24_40.q0;
                            var34_33 = var24_40.q1;
                        }
                    }
                    var44_46 = var41_41.getQuaternionFrameCenter(var5_5);
                    if (var44_46 == null) {
                        var44_46 = new P3();
                    }
                    if (var9_9) {
                        if (var8_8 == null || var8_8.get(var42_42.getIndex())) {
                            var45_49 = (int)Math.floor(Math.acos(var34_33) * 360.0 / 3.141592653589793);
                            if (var6_6 == 0) {
                                var19_19.append(Escape.drawQuat(var24_40, var23_23, var43_43, var44_46, 1.0f));
                                if (var5_5 == 'n' && var16_16 && (var46_50 = ((AminoMonomer)var41_41).getNitrogenHydrogenPoint()) != null) {
                                    var19_19.append("draw ID \"").append(var23_23).append("nh").append(var43_43).append("\" width 0.1 ").append(Escape.eP((T3)var46_50)).append("\n");
                                }
                            }
                            if (var6_6 == 1) {
                                var19_19.append((String)var41_41.getHelixData(135176, var5_5, var2_2)).append("\n");
                            } else {
                                var38_37.set(var31_30 * 2.0f, var32_31 * 2.0f, var33_32 * 2.0f);
                                var19_19.append("draw ID \"").append(var23_23).append("a").append(var43_43).append("\" VECTOR ").append(Escape.eP(var44_46)).append(Escape.eP(var38_37)).append(" \">").append(String.valueOf(var45_49)).append("\" color ").append(BioExt.qColor[var6_6]).append("\n");
                            }
                        }
                    } else {
                        var35_34 = String.valueOf(BioExt.getQInfo(var24_40)) + PT.sprintf("  %10.5p %10.5p %10.5p", "p", new Object[]{var44_46});
                        if (var5_5 == 'n' && var16_16) {
                            var35_34 = String.valueOf(var35_34) + PT.sprintf("  %10.5p %10.5p %10.5p", "p", new Object[]{((AminoMonomer)var41_41).getNitrogenHydrogenPoint()});
                        } else if (var6_6 == 2 && !Float.isNaN(var36_35)) {
                            var35_34 = String.valueOf(var35_34) + PT.sprintf(" %10.5f %10.5f", "F", new Object[]{new float[]{var36_35, var37_36}});
                        }
lbl157:
                        // 7 sources

                        if (var19_19 != null) {
                            var21_21.set(((Monomer)var42_42.group).leadAtomIndex);
                            this.ms.getLabeler();
                            var19_19.append(LabelToken.formatLabelAtomArray(this.vwr, var42_42, var18_18, '\u0000', null, var22_22));
                            var19_19.append(PT.sprintf("%8.2f%8.2f%8.2f      %6.3f          %2s    %s\n", "ssF", new Object[]{var42_42.getElementSymbolIso(false).toUpperCase(), var35_34, new float[]{var31_30 * var15_15, var32_31 * var15_15, var33_32 * var15_15, var34_33 * var15_15}}));
                            if (var30_29 != null && var30_29.group.getBioPolymerIndexInModel() == var42_42.group.getBioPolymerIndexInModel()) {
                                var20_20.append("CONECT").append(PT.formatStringI("%5i", "i", var30_29.getAtomNumber())).append(PT.formatStringI("%5i", "i", var42_42.getAtomNumber())).appendC('\n');
                            }
                            var30_29 = var42_42;
                        }
                    }
                }
            }
            var40_39 += var39_38;
        }
    }

    private static String getQInfo(Quat quat) {
        A4 a4 = quat.toAxisAngle4f();
        return PT.sprintf("%10.6f%10.6f%10.6f%10.6f  %6.2f  %10.5f %10.5f %10.5f", "F", new Object[]{new float[]{quat.q0, quat.q1, quat.q2, quat.q3, (float)((double)(a4.angle * 180.0f) / Math.PI), a4.x, a4.y, a4.z}});
    }

    static String drawQuat(Quat quat, String string, String string2, P3 p3, float f) {
        String string3 = " VECTOR " + Escape.eP(p3) + " ";
        if (f == 0.0f) {
            f = 1.0f;
        }
        return "draw " + string + "x" + string2 + string3 + Escape.eP(quat.getVectorScaled(0, f)) + " color red\n" + "draw " + string + "y" + string2 + string3 + Escape.eP(quat.getVectorScaled(1, f)) + " color green\n" + "draw " + string + "z" + string2 + string3 + Escape.eP(quat.getVectorScaled(2, f)) + " color blue\n";
    }

    private static float get3DStraightness(String string, Quat quat, Quat quat2) {
        return quat.getNormal().dot(quat2.getNormal());
    }

    private static float getQuaternionStraightness(String string, Quat quat, Quat quat2) {
        return BioExt.getStraightness(quat.dot(quat2));
    }

    private static float getStraightness(float f) {
        return (float)(1.0 - 2.0 * Math.acos(Math.abs(f)) / Math.PI);
    }

    void getPdbDataM(BioModel bioModel, Viewer viewer, String string, char c, boolean bl, BS bS, OC oC, LabelToken[] labelTokenArray, SB sB, BS bS2) {
        int n;
        char c2;
        boolean bl2 = false;
        char c3 = c != 'R' ? (char)'r' : (c2 = string.length() > 13 && string.indexOf("ramachandran ") >= 0 ? (char)string.charAt(13) : (char)'R');
        if (c2 == 'r') {
            c2 = viewer.getQuaternionFrame();
        }
        int n2 = viewer.getInt(0x21000011);
        int n3 = string.indexOf("diff") < 0 ? 0 : (n = string.indexOf("2") < 0 ? 1 : 2);
        if (!bl) {
            oC.append("REMARK   6 Jmol PDB-encoded data: " + string + ";");
            if (c != 'R') {
                oC.append("  quaternionFrame = \"" + c2 + "\"");
                bl2 = true;
            }
            oC.append("\nREMARK   6 Jmol Version ").append(Viewer.getJmolVersion()).append("\n");
            if (c == 'R') {
                oC.append("REMARK   6 Jmol data min = {-180 -180 -180} max = {180 180 180} unScaledXyz = xyz * {1 1 1} + {0 0 0} plotScale = {100 100 100}\n");
            } else {
                oC.append("REMARK   6 Jmol data min = {-1 -1 -1} max = {1 1 1} unScaledXyz = xyz * {0.1 0.1 0.1} + {0 0 0} plotScale = {100 100 100}\n");
            }
        }
        P3 p3 = new P3();
        int n4 = 0;
        while (n4 < bioModel.bioPolymerCount) {
            this.getPdbData(bioModel.bioPolymers[n4], c, c2, n2, n, bioModel.bsAtoms, bS, bl2, bl, n4 == 0, labelTokenArray, oC, sB, bS2, p3);
            ++n4;
        }
    }

    int calculateAllstruts(Viewer viewer, ModelSet modelSet, BS bS, BS bS2) {
        BS bS3;
        viewer.setModelVisibility();
        modelSet.makeConnections2(0.0f, Float.MAX_VALUE, 32768, 12291, bS, bS2, null, false, false, 0.0f);
        int n = bS.nextSetBit(0);
        if (n < 0) {
            return 0;
        }
        Model model = modelSet.am[modelSet.at[n].mi];
        if (!model.isBioModel) {
            return 0;
        }
        Lst<Atom> lst = new Lst<Atom>();
        if (bS.equals(bS2)) {
            bS3 = bS;
        } else {
            bS3 = BSUtil.copy(bS);
            bS3.or(bS2);
        }
        Atom[] atomArray = modelSet.at;
        bS3.and(viewer.getModelUndeletedAtomsBitSet(model.modelIndex));
        int n2 = bS3.nextSetBit(0);
        while (n2 >= 0) {
            Atom atom = atomArray[n2];
            if (atom.checkVisible() && atom.atomID == 2 && atom.group.groupID != 5 && atomArray[n2].group.leadAtomIndex >= 0) {
                lst.addLast(atomArray[n2]);
            }
            n2 = bS3.nextSetBit(n2 + 1);
        }
        if (lst.size() == 0) {
            return 0;
        }
        Lst<Atom[]> lst2 = BioExt.calculateStruts(modelSet, bS, bS2, lst, viewer.getFloat(0x22000040), viewer.getInt(553648184), viewer.getBoolean(603979955));
        short s = (short)(viewer.getFloat(570425406) * 2000.0f);
        int n3 = 0;
        while (n3 < lst2.size()) {
            Atom[] atomArray2 = (Atom[])lst2.get(n3);
            modelSet.bondAtoms(atomArray2[0], atomArray2[1], 32768, s, null, 0.0f, false, true);
            ++n3;
        }
        return lst2.size();
    }

    private static Lst<Atom[]> calculateStruts(ModelSet modelSet, BS bS, BS bS2, Lst<Atom> lst, float f, int n, boolean bl) {
        float f2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Lst<Atom[]> lst2 = new Lst<Atom[]>();
        float f3 = f * f;
        int n9 = lst.size();
        int n10 = 3;
        BS bS3 = new BS();
        BS bS4 = new BS();
        BS bS5 = new BS();
        Atom atom = (Atom)lst.get(0);
        int n11 = modelSet.getBioPolymerCountInModel(atom.mi);
        int[][] nArray = new int[n11][n10 * 2];
        int n12 = 0;
        while (n12 < n9) {
            atom = (Atom)lst.get(n12);
            n8 = atom.group.getBioPolymerIndexInModel();
            n7 = atom.group.getMonomerIndex();
            n6 = n7;
            if (n6 < n10) {
                nArray[n8][n6] = n12 + 1;
            }
            if ((n6 = ((Monomer)atom.group).getBioPolymerLength() - n7 - 1) < n10) {
                nArray[n8][n10 + n6] = n12 + 1;
            }
            ++n12;
        }
        float[] fArray = new float[n9 * (n9 - 1) / 2];
        n8 = 0;
        while (n8 < n9) {
            atom = (Atom)lst.get(n8);
            n7 = n8 + 1;
            while (n7 < n9) {
                n6 = BioExt.strutPoint(n8, n7, n9);
                Atom atom2 = (Atom)lst.get(n7);
                n5 = atom.getResno();
                n4 = atom.group.getBioPolymerIndexInModel();
                n3 = atom2.getResno();
                n2 = atom2.group.getBioPolymerIndexInModel();
                if (n4 == n2 && Math.abs(n3 - n5) < n) {
                    bS5.set(n6);
                }
                if ((f2 = (fArray[n6] = atom.distanceSquared(atom2))) >= f3) {
                    bS4.set(n6);
                }
                ++n7;
            }
            ++n8;
        }
        n8 = 5;
        while (--n8 >= 0) {
            f3 = (f - (float)n8) * (f - (float)n8);
            n7 = 0;
            while (n7 < n9) {
                if (bl || !bS3.get(n7)) {
                    n6 = n7 + 1;
                    while (n6 < n9) {
                        n5 = BioExt.strutPoint(n7, n6, n9);
                        if (!(bS4.get(n5) || bS5.get(n5) || !bl && bS3.get(n6) || !(fArray[n5] <= f3))) {
                            BioExt.setStrut(n7, n6, n9, lst, bS, bS2, lst2, bS3, bS4, bS5, n);
                        }
                        ++n6;
                    }
                }
                ++n7;
            }
        }
        n8 = 0;
        while (n8 < n11) {
            n7 = 0;
            while (n7 < n10 * 2) {
                n6 = nArray[n8][n7] - 1;
                if (n6 >= 0 && bS3.get(n6)) {
                    n5 = 0;
                    while (n5 < n10) {
                        n4 = n7 / n10 * n10 + n5;
                        n6 = nArray[n8][n4] - 1;
                        if (n6 >= 0) {
                            bS3.set(n6);
                        }
                        nArray[n8][n4] = -1;
                        ++n5;
                    }
                }
                ++n7;
            }
            if (nArray[n8][0] != -1 || nArray[n8][n10] != -1) {
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                f2 = Float.MAX_VALUE;
                float f4 = Float.MAX_VALUE;
                int n13 = 0;
                while (n13 < n9) {
                    int n14 = 0;
                    while (n14 < n10 * 2) {
                        int n15;
                        int n16 = nArray[n8][n14] - 1;
                        if (n16 == -2) {
                            n14 = (n14 / n10 + 1) * n10 - 1;
                        } else if (n13 != n16 && n16 != -1 && !bS5.get(n15 = BioExt.strutPoint(n16, n13, n9)) && !(fArray[n15] > (n14 < n10 ? f2 : f4))) {
                            if (n14 < n10) {
                                if (bS4.get(n15)) {
                                    n7 = 1;
                                }
                                n4 = n13;
                                n5 = n16;
                                f2 = fArray[n15];
                            } else {
                                if (bS4.get(n15)) {
                                    n6 = 1;
                                }
                                n2 = n13;
                                n3 = n16;
                                f4 = fArray[n15];
                            }
                        }
                        ++n14;
                    }
                    ++n13;
                }
                if (n7 != 0) {
                    BioExt.setStrut(n5, n4, n9, lst, bS, bS2, lst2, bS3, bS4, bS5, n);
                }
                if (n6 != 0) {
                    BioExt.setStrut(n3, n2, n9, lst, bS, bS2, lst2, bS3, bS4, bS5, n);
                }
            }
            ++n8;
        }
        return lst2;
    }

    private static int strutPoint(int n, int n2, int n3) {
        return n2 < n ? n2 * (2 * n3 - n2 - 1) / 2 + n - n2 - 1 : n * (2 * n3 - n - 1) / 2 + n2 - n - 1;
    }

    private static void setStrut(int n, int n2, int n3, Lst<Atom> lst, BS bS, BS bS2, Lst<Atom[]> lst2, BS bS3, BS bS4, BS bS5, int n4) {
        Atom atom = (Atom)lst.get(n);
        Atom atom2 = (Atom)lst.get(n2);
        if (!bS.get(atom.i) || !bS2.get(atom2.i)) {
            return;
        }
        lst2.addLast(new Atom[]{atom, atom2});
        bS3.set(n);
        bS3.set(n2);
        int n5 = Math.max(0, n - n4);
        while (n5 <= n + n4 && n5 < n3) {
            int n6 = Math.max(0, n2 - n4);
            while (n6 <= n2 + n4 && n6 < n3) {
                int n7;
                if (n5 != n6 && !bS5.get(n7 = BioExt.strutPoint(n5, n6, n3))) {
                    bS4.set(n7);
                }
                ++n6;
            }
            ++n5;
        }
    }

    boolean mutate(Viewer viewer, BS bS, String string, String[] stringArray) {
        boolean bl;
        int n = bS.nextSetBit(0);
        if (stringArray == null) {
            return BioExt.mutateAtom(viewer, n, string);
        }
        boolean bl2 = bl = string == null;
        if (bl) {
            string = stringArray[0];
        }
        Group group = null;
        boolean bl3 = true;
        int n2 = n;
        int n3 = 0;
        while (n2 >= 0) {
            block6: {
                block7: {
                    Group group2 = viewer.ms.at[n2].group;
                    if (group2 == group) break block6;
                    group = group2;
                    if (bl) break block7;
                    if ((string = stringArray[n3++ % stringArray.length]).equals("UNK")) break block6;
                    string = "==" + string;
                }
                BioExt.mutateAtom(viewer, n2, string);
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        return bl3;
    }

    private static boolean mutateAtom(Viewer viewer, int n, String string) {
        ModelSet modelSet = viewer.ms;
        short s = modelSet.at[n].mi;
        if (modelSet.isTrajectory(s)) {
            return false;
        }
        String[] stringArray = viewer.fm.getFileInfo();
        Group group = modelSet.at[n].group;
        if (!(group instanceof AminoMonomer)) {
            return false;
        }
        ((BioModel)modelSet.am[s]).isMutated = true;
        AminoMonomer aminoMonomer = (AminoMonomer)group;
        int n2 = modelSet.ac;
        BS bS = new BS();
        aminoMonomer.setAtomBits(bS);
        Atom[] atomArray = BioExt.getMutationBackbone(aminoMonomer, null);
        string = PT.esc(string);
        String string2 = "try{\n  var atoms0 = {*}\n  var res0 = " + BS.escape(bS, '(', ')') + "\n" + "  load mutate " + string + "\n" + "  var res1 = {!atoms0};var r1 = res1[1];var r0 = res1[0]\n" + "  if ({r1 & within(group, r0)}){\n" + "    var haveHs = ({_H & connected(res0)} != 0)\n" + "    if (!haveHs) {delete _H & res1}\n" + "    var sm = '[*.N][*.CA][*.C][*.O]'\n" + "    var keyatoms = res1.find(sm)\n" + "    var x = compare(res1,res0,sm,'BONDS')\n" + "    if(x){\n" + "      print 'mutating ' + res0[1].label('%n%r') + ' to ' + " + string + ".trim('=')\n" + "      rotate branch @x\n" + "      compare res1 res0 SMARTS @sm rotate translate 0\n" + "      var c = {!res0 & connected(res0)}\n" + "      var N2 = {*.N & c}\n" + "      var C0 = {*.C & c}\n" + "      var angleH = ({*.H and res0} ? angle({*.C and res0},{*.CA and res0},{*.N and res0},{*.H and res0}) : 1000)\n" + "      delete res0\n" + "      if (N2) {\n" + "        delete (*.OXT,*.HXT) and res1\n" + "        connect {N2} {keyatoms & *.C}\n" + "      }\n" + "      if (C0) {\n" + "        var h1 = {*.H and res1}\n" + "        var n = (h1 ? 0 + {res1 and _H & connected(*.N)} : 0)\n" + "        switch (n) {\n" + "        case 0:\n" + "          break\n" + "        case 1:\n" + "          delete h1\n" + "          break\n" + "        default:\n" + "          var x = angle({*.C and res1},{*.CA and res1},{*.N and res1},h1)\n" + "          rotate branch {*.CA and res1} {*.N and res1} @{angleH-x}\n" + "          delete *.H2 and res1\n" + "          delete *.H3 and res1\n" + "          break\n" + "        }\n" + "        connect {C0} {keyatoms & *.N}\n" + "      }\n" + "    }\n" + "  }\n" + "}catch(e){print e}\n";
        try {
            if (Logger.debugging) {
                Logger.debug(string2);
            }
            viewer.eval.runScript(string2);
        }
        catch (Exception exception) {
            if (!Viewer.isJS) {
                exception.printStackTrace();
            }
            System.out.println(exception);
        }
        modelSet = viewer.ms;
        if (modelSet.ac == n2) {
            return false;
        }
        SB sB = modelSet.am[s].loadScript;
        String string3 = PT.rep(sB.toString(), "load mutate ", "mutate ({" + n + "})");
        sB.setLength(0);
        sB.append(string3);
        group = modelSet.at[modelSet.ac - 1].group;
        if (group != modelSet.at[n2 + 1].group || !(group instanceof AminoMonomer)) {
            BS bS2 = new BS();
            group.setAtomBits(bS2);
            viewer.deleteAtoms(bS2, false);
            return false;
        }
        AminoMonomer aminoMonomer2 = (AminoMonomer)group;
        BioExt.getMutationBackbone(aminoMonomer2, atomArray);
        BioExt.replaceMutatedMonomer(viewer, aminoMonomer, aminoMonomer2);
        viewer.fm.setFileInfo(stringArray);
        return true;
    }

    private static void replaceMutatedMonomer(Viewer viewer, AminoMonomer aminoMonomer, AminoMonomer aminoMonomer2) {
        aminoMonomer2.setResno(aminoMonomer.getResno());
        aminoMonomer2.chain.groupCount = 0;
        aminoMonomer2.chain = aminoMonomer.chain;
        aminoMonomer2.chain.model.groupCount = -1;
        aminoMonomer2.proteinStructure = aminoMonomer.proteinStructure;
        viewer.shm.replaceGroup(aminoMonomer, aminoMonomer2);
        Group[] groupArray = aminoMonomer.chain.groups;
        int n = groupArray.length;
        while (--n >= 0) {
            if (groupArray[n] != aminoMonomer) continue;
            groupArray[n] = aminoMonomer2;
            break;
        }
        aminoMonomer2.bioPolymer = aminoMonomer.bioPolymer;
        if (aminoMonomer2.bioPolymer != null) {
            Monomer[] monomerArray = aminoMonomer2.bioPolymer.monomers;
            int n2 = monomerArray.length;
            while (--n2 >= 0) {
                if (monomerArray[n2] != aminoMonomer) continue;
                monomerArray[n2] = aminoMonomer2;
                break;
            }
        }
    }

    private static Atom[] getMutationBackbone(AminoMonomer aminoMonomer, Atom[] atomArray) {
        Atom[] atomArray2 = new Atom[]{aminoMonomer.getCarbonylCarbonAtom(), aminoMonomer.getCarbonylOxygenAtom(), aminoMonomer.getLeadAtom(), aminoMonomer.getNitrogenAtom(), aminoMonomer.getExplicitNH()};
        if (atomArray == null) {
            if (atomArray2[3].getCovalentHydrogenCount() > 1) {
                atomArray2[4] = null;
            }
        } else {
            int n = 0;
            while (n < 5) {
                Atom atom = atomArray[n];
                Atom atom2 = atomArray2[n];
                if (atom != null && atom2 != null) {
                    atom2.setT(atom);
                }
                ++n;
            }
        }
        return atomArray2;
    }

    String getFullPDBHeader(Map<String, Object> map) {
        String string = this.vwr.getCurrentFileAsString("biomodel");
        int n = string.length();
        int n2 = pdbRecords.length;
        block4: while (--n2 >= 0) {
            String string2 = pdbRecords[n2];
            int n3 = string.startsWith(string2) ? 0 : string.indexOf("\n" + string2);
            switch (n3) {
                case -1: {
                    break;
                }
                case 0: {
                    map.put("fileHeader", "");
                    return "";
                }
                default: {
                    if (n3 >= n) continue block4;
                    n = ++n3;
                }
            }
        }
        string = string.substring(0, n);
        map.put("fileHeader", string);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean getAminoAcidValenceAndCharge(String string, String string2, int[] nArray) {
        int n = nArray[4];
        nArray[4] = 0;
        if (string == null) return false;
        if (string.length() == 0) return false;
        if (string.length() > 3) return false;
        if (string2.equals("CA")) return false;
        if (string2.equals("CB")) {
            return false;
        }
        char c = string2.charAt(0);
        char c2 = string2.length() == 1 ? (char)'\u0000' : string2.charAt(1);
        boolean bl = false;
        int n2 = nArray[3];
        block0 : switch (string.length()) {
            case 3: {
                if (string2.length() == 1) {
                    switch (c) {
                        case 'N': {
                            if (n2 > 1) {
                                return false;
                            }
                            nArray[1] = 1;
                            break block0;
                        }
                        case 'O': {
                            if (n == 1) {
                                return true;
                            }
                            bl = "HOH;DOD;WAT".indexOf(string) < 0;
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                String string3 = String.valueOf(string) + c;
                boolean bl2 = bl = aaSp2.indexOf(string3) >= 0;
                if (aaPlus.indexOf(string3) >= 0) {
                    nArray[1] = 1;
                    break;
                }
                if (c != 'O' || c2 != 'X') break;
                nArray[1] = -1;
                break;
            }
            case 1: 
            case 2: {
                if (string2.length() > 2 && string2.charAt(2) == '\'') {
                    return false;
                }
                switch (c) {
                    case 'C': {
                        if (c2 != '7') break;
                        return false;
                    }
                    case 'N': {
                        switch (c2) {
                            case '1': 
                            case '3': {
                                if (naNoH.indexOf("" + string.charAt(string.length() - 1) + c2) < 0) break;
                                nArray[0] = nArray[0] - 1;
                                break;
                            }
                            case '7': {
                                nArray[0] = nArray[0] - 1;
                            }
                        }
                        break;
                    }
                }
                bl = true;
                break;
            }
        }
        if (!bl) return true;
        nArray[4] = aaSp21.indexOf(String.valueOf(string) + string2) >= 0 ? 0 : 1;
        switch (c) {
            case 'N': {
                nArray[2] = 2;
                if (n != 2) return true;
                if (n2 != 1) return true;
                nArray[4] = nArray[4] + 1;
                return true;
            }
            case 'C': {
                nArray[2] = 2;
                nArray[0] = nArray[0] - 1;
                return true;
            }
            case 'O': {
                if (n == 2 && n2 == 1) {
                    nArray[4] = nArray[4] - 1;
                }
                nArray[0] = nArray[0] - 1;
                return true;
            }
        }
        return true;
    }
}

