/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionWithCallSelectorAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.VariableAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public final class QualifiedExpressionTranslator {
    private QualifiedExpressionTranslator() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtQualifiedExpression expression2, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        KtExpression selector;
        JsExpression receiver2 = QualifiedExpressionTranslator.translateReceiver(expression2, context);
        if (forceOrderOfEvaluation && receiver2 != null) {
            receiver2 = context.defineTemporary(receiver2);
        }
        if ((selector = PsiUtils.getSelector(expression2)) instanceof KtSimpleNameExpression) {
            return VariableAccessTranslator.newInstance(context, (KtSimpleNameExpression)selector, receiver2);
        }
        if (selector instanceof KtCallExpression) {
            return new QualifiedExpressionWithCallSelectorAccessTranslator((KtCallExpression)selector, receiver2, context);
        }
        throw new AssertionError((Object)("Unexpected qualified expression: " + expression2.getText()));
    }

    @NotNull
    public static JsNode translateQualifiedExpression(@NotNull KtQualifiedExpression expression2, @NotNull TranslationContext context) {
        ResolvedCall<? extends CallableDescriptor> call2 = CallUtilKt.getResolvedCall(expression2, context.bindingContext());
        JsExpression receiver2 = null;
        if (call2 != null) {
            receiver2 = QualifiedExpressionTranslator.translateReceiver(expression2, context);
        }
        KtExpression selector = PsiUtils.getSelector(expression2);
        return QualifiedExpressionTranslator.dispatchToCorrectTranslator(receiver2, selector, context);
    }

    @NotNull
    private static JsNode dispatchToCorrectTranslator(@Nullable JsExpression receiver2, @NotNull KtExpression selector, @NotNull TranslationContext context) {
        if (ReferenceTranslator.canBePropertyAccess(selector, context)) {
            assert (selector instanceof KtSimpleNameExpression) : "Selectors for properties must be simple names.";
            return VariableAccessTranslator.newInstance(context, (KtSimpleNameExpression)selector, receiver2).translateAsGet();
        }
        if (selector instanceof KtCallExpression) {
            return QualifiedExpressionTranslator.invokeCallExpressionTranslator(receiver2, (KtCallExpression)selector, context);
        }
        if (selector instanceof KtSimpleNameExpression) {
            return ReferenceTranslator.translateSimpleName((KtSimpleNameExpression)selector, context);
        }
        throw new AssertionError((Object)("Unexpected qualified expression: " + selector.getText()));
    }

    @NotNull
    static JsNode invokeCallExpressionTranslator(@Nullable JsExpression receiver2, @NotNull KtCallExpression selector, @NotNull TranslationContext context) {
        try {
            return CallExpressionTranslator.translate(selector, receiver2, context);
        }
        catch (RuntimeException e) {
            throw ErrorReportingUtils.reportErrorWithLocation(selector, e);
        }
    }

    @Nullable
    private static JsExpression translateReceiver(@NotNull KtQualifiedExpression expression2, @NotNull TranslationContext context) {
        KtExpression receiverExpression = expression2.getReceiverExpression();
        if (QualifiedExpressionTranslator.isFullQualifierForExpression(receiverExpression, context)) {
            return null;
        }
        return Translation.translateAsExpression(receiverExpression, context);
    }

    private static boolean isFullQualifierForExpression(@Nullable KtExpression receiverExpression, @NotNull TranslationContext context) {
        DeclarationDescriptor descriptorForReferenceExpression;
        if (receiverExpression == null) {
            return false;
        }
        if (receiverExpression instanceof KtReferenceExpression && (descriptorForReferenceExpression = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), (KtReferenceExpression)receiverExpression)) instanceof PackageViewDescriptor) {
            return true;
        }
        if (receiverExpression instanceof KtQualifiedExpression) {
            return QualifiedExpressionTranslator.isFullQualifierForExpression(((KtQualifiedExpression)receiverExpression).getSelectorExpression(), context);
        }
        return false;
    }
}

