11.2 MIDI Out

# MIDI Out

In addition to receiving MIDI events we can also send out MIDI events to
trigger and control external hardware synths, keyboards and other
devices. Sonic Pi provides a full set of fns for sending various MIDI messages such as:

1. Note on - `midi_note_on`
2. Note off - `midi_note_off`
3. Control change - `midi_cc`
4. Pitch bend - `midi_pitch_bend`
5. Clock ticks - `midi_clock_tick`

There are many other supported MIDI messages too - check out the API
documentation for all the other fns that start with `midi_`.

## Connecting to a MIDI Device

In order to send a MIDI message to an external device, we must first
have connected it. Check out the subsection 'Connecting a MIDI Controller' in
section 11.1 for further details. Note that if you're using USB,
connecting to a device which you're sending to (rather than receiving
from) is the same procedure. However, if you're using the classic DIN
connectors, make sure you connect to the MIDI out port of your
computer. You should see your MIDI device listed in the preferences
pane.

## Sending MIDI events

The many `midi_*` fns work just like `play`, `sample` and `synth` in
that they send a message at the current (logical) time. For example, to
spread out calls to the `midi_*` fns you need to use `sleep` just like
you did with `play`. Let's take a look:

```
midi_note_on :e3, 50
```

This will send a MIDI note on event to the connected MIDI device with
velocity 50. (Note that Sonic Pi will automatically convert notes in the
form `:e3` to their corresponding MIDI number such as 52 in this case.)

If your connected MIDI device is a synthesiser, you should be able to
hear it playing a note. To disable it use `midi_note_off`:

```
midi_note_off :e3
```

## Selecting a MIDI device

By default, Sonic Pi will send each MIDI message to all connected
devices on all MIDI channels. This is to make it easy to work with a
single connected device without having to configure anything. However,
sometimes a MIDI device will treat MIDI channels in a special way
(perhaps each note has a separate channel) and also you may wish to
connect more than one MIDI device at the same time. In more complicated
setups, you may wish to be more selective about which MIDI device
receives which message(s) and on which channel.

We can specify which device to send to using the `port:` opt, using the
device name as displayed in the preferences:

```
midi_note_on :e3, port: "moog_minitaur"
```

We can also specify which channel to send to using the `channel:` opt
(using a value in the range 1-16):

```
midi_note_on :e3, channel: 3
```

Of course we can also specify both at the same time to send to a
specific device on a specific channel:

```
midi_note_on :e3, port: "moog_minitaur", channel: 5
```

## MIDI Studio

Finally, a really fun thing to do is to connect the audio output of your
MIDI synthesiser to one of the audio inputs of your soundcard. You can
then control your synth with code using the `midi_*` fns and also
manipulate the audio using `live_audio` and FX:

```
with_fx :reverb, room: 1 do
  live_audio :moog
end

live_loop :moog_trigger do
  use_real_time
  midi (octs :e1, 3).tick, sustain: 0.1
  sleep 0.125
end
```

(The fn `midi` is available as a handy shortcut to sending both note on
and note off events with a single command. Check out its documentation
for further information).
