/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.MathUtils;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class QuadMesh
implements PrimitiveList {
    protected float[] points = null;
    protected int[] quads = null;
    private ParameterList.FloatParameter normals = this.uvs = new ParameterList.FloatParameter();
    private ParameterList.FloatParameter uvs;
    private byte[] faceShaders = null;

    public void writeObj(String string) {
        try {
            int n;
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(String.format("o object\n", new Object[0]));
            for (n = 0; n < this.points.length; n += 3) {
                fileWriter.write(String.format("v %g %g %g\n", Float.valueOf(this.points[n]), Float.valueOf(this.points[n + 1]), Float.valueOf(this.points[n + 2])));
            }
            fileWriter.write("s off\n");
            for (n = 0; n < this.quads.length; n += 4) {
                fileWriter.write(String.format("f %d %d %d %d\n", this.quads[n] + 1, this.quads[n + 1] + 1, this.quads[n + 2] + 1, this.quads[n + 3] + 1));
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        int[] nArray;
        ParameterList.FloatParameter floatParameter;
        Object object = parameterList.getIntArray("quads");
        if (object != null) {
            this.quads = object;
        }
        if (this.quads == null) {
            UI.printError(UI.Module.GEOM, "Unable to update mesh - quad indices are missing", new Object[0]);
            return false;
        }
        if (this.quads.length % 4 != 0) {
            UI.printWarning(UI.Module.GEOM, "Quad index data is not a multiple of 4 - some quads may be missing", new Object[0]);
        }
        parameterList.setFaceCount(this.quads.length / 4);
        object = parameterList.getPointArray("points");
        if (object != null) {
            if (object.interp != ParameterList.InterpolationType.VERTEX) {
                UI.printError(UI.Module.GEOM, "Point interpolation type must be set to \"vertex\" - was \"%s\"", object.interp.name().toLowerCase(Locale.ENGLISH));
            } else {
                this.points = object.data;
            }
        }
        if (this.points == null) {
            UI.printError(UI.Module.GEOM, "Unabled to update mesh - vertices are missing", new Object[0]);
            return false;
        }
        parameterList.setVertexCount(this.points.length / 3);
        parameterList.setFaceVertexCount(4 * (this.quads.length / 4));
        object = parameterList.getVectorArray("normals");
        if (object != null) {
            this.normals = object;
        }
        if ((floatParameter = parameterList.getTexCoordArray("uvs")) != null) {
            this.uvs = floatParameter;
        }
        if ((nArray = parameterList.getIntArray("faceshaders")) != null && nArray.length == this.quads.length / 4) {
            this.faceShaders = new byte[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n > 255) {
                    UI.printWarning(UI.Module.GEOM, "Shader index too large on quad %d", i);
                }
                this.faceShaders[i] = (byte)(n & 0xFF);
            }
        }
        return true;
    }

    public float getPrimitiveBound(int n, int n2) {
        int n3 = 4 * n;
        int n4 = 3 * this.quads[n3 + 0];
        int n5 = 3 * this.quads[n3 + 1];
        int n6 = 3 * this.quads[n3 + 2];
        int n7 = 3 * this.quads[n3 + 3];
        int n8 = n2 >>> 1;
        if ((n2 & 1) == 0) {
            return MathUtils.min(this.points[n4 + n8], this.points[n5 + n8], this.points[n6 + n8], this.points[n7 + n8]);
        }
        return MathUtils.max(this.points[n4 + n8], this.points[n5 + n8], this.points[n6 + n8], this.points[n7 + n8]);
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox();
        if (matrix4 == null) {
            for (int i = 0; i < this.points.length; i += 3) {
                boundingBox.include(this.points[i], this.points[i + 1], this.points[i + 2]);
            }
        } else {
            for (int i = 0; i < this.points.length; i += 3) {
                float f = this.points[i];
                float f2 = this.points[i + 1];
                float f3 = this.points[i + 2];
                float f4 = matrix4.transformPX(f, f2, f3);
                float f5 = matrix4.transformPY(f, f2, f3);
                float f6 = matrix4.transformPZ(f, f2, f3);
                boundingBox.include(f4, f5, f6);
            }
        }
        return boundingBox;
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        int n2 = 4 * n;
        int n3 = 3 * this.quads[n2 + 0];
        int n4 = 3 * this.quads[n2 + 1];
        int n5 = 3 * this.quads[n2 + 2];
        int n6 = 3 * this.quads[n2 + 3];
        float[] fArray = new float[]{this.points[n5 + 0] - this.points[n6 + 0] - this.points[n4 + 0] + this.points[n3 + 0], this.points[n5 + 1] - this.points[n6 + 1] - this.points[n4 + 1] + this.points[n3 + 1], this.points[n5 + 2] - this.points[n6 + 2] - this.points[n4 + 2] + this.points[n3 + 2]};
        float[] fArray2 = new float[]{this.points[n4 + 0] - this.points[n3 + 0], this.points[n4 + 1] - this.points[n3 + 1], this.points[n4 + 2] - this.points[n3 + 2]};
        float[] fArray3 = new float[]{this.points[n6 + 0] - this.points[n3 + 0], this.points[n6 + 1] - this.points[n3 + 1], this.points[n6 + 2] - this.points[n3 + 2]};
        float[] fArray4 = new float[]{ray.ox - this.points[n3 + 0], ray.oy - this.points[n3 + 1], ray.oz - this.points[n3 + 2]};
        float[] fArray5 = new float[]{ray.dx, ray.dy, ray.dz};
        float f = Math.abs(ray.dx);
        float f2 = Math.abs(ray.dy);
        float f3 = Math.abs(ray.dz);
        int n7 = 0;
        int n8 = 1;
        int n9 = 2;
        if (!(f > f2) || !(f > f3)) {
            if (f2 > f3) {
                n7 = 1;
                n8 = 0;
            } else {
                n7 = 2;
                n9 = 0;
            }
        }
        float f4 = fArray3[n7] * fArray5[n9] - fArray3[n9] * fArray5[n7];
        float f5 = fArray3[n8] * fArray5[n7] - fArray3[n7] * fArray5[n8];
        float f6 = fArray3[n9] * fArray5[n8] - fArray3[n8] * fArray5[n9];
        float f7 = fArray4[n7] * fArray5[n9] - fArray4[n9] * fArray5[n7];
        float f8 = fArray4[n8] * fArray5[n7] - fArray4[n7] * fArray5[n8];
        float f9 = fArray4[n9] * fArray5[n8] - fArray4[n8] * fArray5[n9];
        float f10 = fArray2[n8] * fArray5[n9] - fArray2[n9] * fArray5[n8];
        float f11 = fArray2[n9] * fArray5[n7] - fArray2[n7] * fArray5[n9];
        float f12 = fArray2[n7] * fArray5[n8] - fArray2[n8] * fArray5[n7];
        float f13 = fArray[n7] * f10 + fArray[n8] * f11 + fArray[n9] * f12;
        if (f13 == 0.0f) {
            float f14;
            float f15;
            float f16 = fArray3[n7] * f9 + fArray3[n8] * f7 + fArray3[n9] * f8;
            float f17 = fArray2[n7] * f6 + fArray2[n8] * f4 + fArray2[n9] * f5;
            float f18 = -f16 / f17;
            if (f18 >= 0.0f && f18 <= 1.0f && (f15 = (f18 * f12 + f8) / f5) >= 0.0f && f15 <= 1.0f && ray.isInside(f14 = (fArray2[n7] * f18 + fArray3[n7] * f15 - fArray4[n7]) / fArray5[n7])) {
                ray.setMax(f14);
                intersectionState.setIntersection(n, f18, f15);
            }
        } else {
            float f19;
            float f20;
            float f21;
            float f22 = fArray[n7] * f9 + fArray[n8] * f7 + fArray[n9] * f8 + fArray2[n7] * f6 + fArray2[n8] * f4 + fArray2[n9] * f5;
            float f23 = fArray3[n7] * f9 + fArray3[n8] * f7 + fArray3[n9] * f8;
            float f24 = f22 * f22 - 4.0f * f13 * f23;
            if (f23 * (f13 + f22 + f23) > 0.0f && (f24 < 0.0f || f13 * f23 < 0.0f || f22 / f13 > 0.0f || f22 / f13 < -2.0f)) {
                return;
            }
            float f25 = f22 > 0.0f ? -0.5f * (f22 + (float)Math.sqrt(f24)) : -0.5f * (f22 - (float)Math.sqrt(f24));
            float f26 = fArray[n7] * fArray5[n8] - fArray[n8] * fArray5[n7];
            float f27 = f25 / f13;
            if (f27 >= 0.0f && f27 <= 1.0f && (f21 = -(f27 * f12 + f8) / (f20 = f27 * f26 - f5)) >= 0.0f && f21 <= 1.0f && ray.isInside(f19 = (fArray[n7] * f27 * f21 + fArray2[n7] * f27 + fArray3[n7] * f21 - fArray4[n7]) / fArray5[n7])) {
                ray.setMax(f19);
                intersectionState.setIntersection(n, f27, f21);
            }
            if ((f27 = f23 / f25) >= 0.0f && f27 <= 1.0f && (f21 = -(f27 * f12 + f8) / (f20 = f27 * f26 - f5)) >= 0.0f && f21 <= 1.0f && ray.isInside(f19 = (fArray[n7] * f27 * f21 + fArray2[n7] * f27 + fArray3[n7] * f21 - fArray4[n7]) / fArray5[n7])) {
                ray.setMax(f19);
                intersectionState.setIntersection(n, f27, f21);
            }
        }
    }

    public int getNumPrimitives() {
        return this.quads.length / 4;
    }

    public void prepareShadingState(ShadingState shadingState) {
        Object object;
        shadingState.init();
        Instance instance = shadingState.getInstance();
        int n = shadingState.getPrimitiveID();
        float f = shadingState.getU();
        float f2 = shadingState.getV();
        shadingState.getRay().getPoint(shadingState.getPoint());
        int n2 = 4 * n;
        int n3 = this.quads[n2 + 0];
        int n4 = this.quads[n2 + 1];
        int n5 = this.quads[n2 + 2];
        int n6 = this.quads[n2 + 3];
        Point3 point3 = this.getPoint(n3);
        Point3 point32 = this.getPoint(n4);
        Point3 point33 = this.getPoint(n5);
        Point3 point34 = this.getPoint(n5);
        float f3 = (1.0f - f2) * (point32.x - point3.x) + f2 * (point33.x - point34.x);
        float f4 = (1.0f - f2) * (point32.y - point3.y) + f2 * (point33.y - point34.y);
        float f5 = (1.0f - f2) * (point32.z - point3.z) + f2 * (point33.z - point34.z);
        float f6 = (1.0f - f) * (point34.x - point3.x) + f * (point33.x - point32.x);
        float f7 = (1.0f - f) * (point34.y - point3.y) + f * (point33.y - point32.y);
        float f8 = (1.0f - f) * (point34.z - point3.z) + f * (point33.z - point32.z);
        float f9 = f4 * f8 - f5 * f7;
        float f10 = f5 * f6 - f3 * f8;
        float f11 = f3 * f7 - f4 * f6;
        Vector3 vector3 = new Vector3(f9, f10, f11);
        vector3 = shadingState.transformNormalObjectToWorld(vector3);
        vector3.normalize();
        shadingState.getGeoNormal().set(vector3);
        float f12 = (1.0f - f) * (1.0f - f2);
        float f13 = f * (1.0f - f2);
        float f14 = (1.0f - f) * f2;
        float f15 = f * f2;
        switch (this.normals.interp) {
            case NONE: 
            case FACE: {
                shadingState.getNormal().set(vector3);
                break;
            }
            case VERTEX: {
                int n7 = 3 * n3;
                int n8 = 3 * n4;
                int n9 = 3 * n5;
                int n10 = 3 * n6;
                float[] fArray = this.normals.data;
                shadingState.getNormal().x = f12 * fArray[n7 + 0] + f13 * fArray[n8 + 0] + f15 * fArray[n9 + 0] + f14 * fArray[n10 + 0];
                shadingState.getNormal().y = f12 * fArray[n7 + 1] + f13 * fArray[n8 + 1] + f15 * fArray[n9 + 1] + f14 * fArray[n10 + 1];
                shadingState.getNormal().z = f12 * fArray[n7 + 2] + f13 * fArray[n8 + 2] + f15 * fArray[n9 + 2] + f14 * fArray[n10 + 2];
                shadingState.getNormal().set(shadingState.transformNormalObjectToWorld(shadingState.getNormal()));
                shadingState.getNormal().normalize();
                break;
            }
            case FACEVARYING: {
                int n7 = 3 * n2;
                float[] fArray = this.normals.data;
                shadingState.getNormal().x = f12 * fArray[n7 + 0] + f13 * fArray[n7 + 3] + f15 * fArray[n7 + 6] + f14 * fArray[n7 + 9];
                shadingState.getNormal().y = f12 * fArray[n7 + 1] + f13 * fArray[n7 + 4] + f15 * fArray[n7 + 7] + f14 * fArray[n7 + 10];
                shadingState.getNormal().z = f12 * fArray[n7 + 2] + f13 * fArray[n7 + 5] + f15 * fArray[n7 + 8] + f14 * fArray[n7 + 11];
                shadingState.getNormal().set(shadingState.transformNormalObjectToWorld(shadingState.getNormal()));
                shadingState.getNormal().normalize();
                break;
            }
        }
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        float f19 = 0.0f;
        float f20 = 0.0f;
        float f21 = 0.0f;
        float f22 = 0.0f;
        float f23 = 0.0f;
        switch (this.uvs.interp) {
            case NONE: 
            case FACE: {
                shadingState.getUV().x = 0.0f;
                shadingState.getUV().y = 0.0f;
                break;
            }
            case VERTEX: {
                int n11 = 2 * n3;
                int n12 = 2 * n4;
                int n13 = 2 * n5;
                int n14 = 2 * n6;
                object = this.uvs.data;
                f16 = object[n11 + 0];
                f17 = object[n11 + 1];
                f18 = object[n12 + 0];
                f19 = object[n12 + 1];
                f20 = object[n13 + 0];
                f21 = object[n13 + 1];
                f20 = object[n14 + 0];
                f21 = object[n14 + 1];
                break;
            }
            case FACEVARYING: {
                int n11 = n2 << 1;
                float[] fArray = this.uvs.data;
                f16 = fArray[n11 + 0];
                f17 = fArray[n11 + 1];
                f18 = fArray[n11 + 2];
                f19 = fArray[n11 + 3];
                f20 = fArray[n11 + 4];
                f21 = fArray[n11 + 5];
                f22 = fArray[n11 + 6];
                f23 = fArray[n11 + 7];
                break;
            }
        }
        if (this.uvs.interp != ParameterList.InterpolationType.NONE) {
            shadingState.getUV().x = f12 * f16 + f13 * f18 + f15 * f20 + f14 * f22;
            shadingState.getUV().y = f12 * f17 + f13 * f19 + f15 * f21 + f14 * f23;
            float f24 = f16 - f20;
            float f25 = f18 - f20;
            float f26 = f17 - f21;
            float f27 = f19 - f21;
            object = Point3.sub(point3, point33, new Vector3());
            Vector3 vector32 = Point3.sub(point32, point33, new Vector3());
            float f28 = f24 * f27 - f26 * f25;
            if (f28 == 0.0f) {
                shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
            } else {
                float f29 = 1.0f / f28;
                Vector3 vector33 = new Vector3();
                vector33.x = (-f25 * object.x + f24 * vector32.x) * f29;
                vector33.y = (-f25 * object.y + f24 * vector32.y) * f29;
                vector33.z = (-f25 * object.z + f24 * vector32.z) * f29;
                vector33 = shadingState.transformVectorObjectToWorld(vector33);
                shadingState.setBasis(OrthoNormalBasis.makeFromWV(shadingState.getNormal(), vector33));
            }
        } else {
            shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
        }
        int n15 = this.faceShaders == null ? 0 : this.faceShaders[n] & 0xFF;
        shadingState.setShader(instance.getShader(n15));
        shadingState.setModifier(instance.getModifier(n15));
    }

    protected Point3 getPoint(int n) {
        return new Point3(this.points[n *= 3], this.points[n + 1], this.points[n + 2]);
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

