/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.image;

import com.sun.media.jai.codec.FileSeekableStream;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.optional.image.Draw;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.Rotate;
import org.apache.tools.ant.types.optional.image.Scale;
import org.apache.tools.ant.types.optional.image.TransformOperation;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.StringUtils;

@Deprecated
public class Image
extends MatchingTask {
    protected Vector<ImageOperation> instructions = new Vector();
    protected boolean overwrite = false;
    protected Vector<FileSet> filesets = new Vector();
    protected File srcDir = null;
    protected File destDir = null;
    protected String str_encoding = "JPEG";
    protected boolean garbage_collect = false;
    private boolean failonerror = true;
    private Mapper mapperElement = null;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setEncoding(String encoding) {
        this.str_encoding = encoding;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setGc(boolean gc) {
        this.garbage_collect = gc;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void addImageOperation(ImageOperation instr) {
        this.instructions.add(instr);
    }

    public void addRotate(Rotate instr) {
        this.instructions.add(instr);
    }

    public void addScale(Scale instr) {
        this.instructions.add(instr);
    }

    public void addDraw(Draw instr) {
        this.instructions.add(instr);
    }

    public void add(ImageOperation instr) {
        this.addImageOperation(instr);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public int processDir(File srcDir, String[] srcNames, File dstDir, FileNameMapper mapper) {
        int writeCount = 0;
        for (String srcName : srcNames) {
            File srcFile = new File(srcDir, srcName).getAbsoluteFile();
            String[] dstNames = mapper.mapFileName(srcName);
            if (dstNames == null) {
                this.log(srcFile + " skipped, don't know how to handle it", 3);
                continue;
            }
            for (String dstName : dstNames) {
                File dstFile = new File(dstDir, dstName).getAbsoluteFile();
                if (dstFile.exists()) {
                    if (!this.overwrite && srcFile.lastModified() <= dstFile.lastModified()) {
                        this.log(srcFile + " omitted as " + dstFile + " is up to date.", 3);
                        continue;
                    }
                    if (!srcFile.equals(dstFile)) {
                        dstFile.delete();
                    }
                }
                this.processFile(srcFile, dstFile);
                ++writeCount;
            }
        }
        if (this.garbage_collect) {
            System.gc();
        }
        return writeCount;
    }

    @Deprecated
    public void processFile(File file) {
        this.processFile(file, new File(this.destDir == null ? this.srcDir : this.destDir, file.getName()));
    }

    public void processFile(File file, File newFile) {
        try {
            this.log("Processing File: " + file.getAbsolutePath());
            RenderedOp image = null;
            try (FileSeekableStream input = new FileSeekableStream(file);){
                image = JAI.create((String)"stream", (Object)input);
                for (ImageOperation instr : this.instructions) {
                    if (instr instanceof TransformOperation) {
                        image = ((TransformOperation)instr).executeTransformOperation((PlanarImage)image);
                        continue;
                    }
                    this.log("Not a TransformOperation: " + (Object)((Object)instr));
                }
            }
            File dstParent = newFile.getParentFile();
            if (!(dstParent.isDirectory() || dstParent.mkdirs() || dstParent.isDirectory())) {
                throw new BuildException("Failed to create parent directory %s", new Object[]{dstParent});
            }
            if (this.overwrite && newFile.exists() && !newFile.equals(file)) {
                newFile.delete();
            }
            OutputStream stream = Files.newOutputStream(newFile.toPath(), new OpenOption[0]);
            Object object = null;
            try {
                JAI.create((String)"encode", (RenderedImage)image, (Object)stream, (Object)this.str_encoding.toUpperCase(Locale.ENGLISH), null);
                stream.flush();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    Image.$closeResource((Throwable)object, stream);
                }
            }
        }
        catch (IOException | RuntimeException err) {
            if (!file.equals(newFile)) {
                newFile.delete();
            }
            if (!this.failonerror) {
                this.log("Error processing file:  " + err);
            }
            throw new BuildException((Throwable)err);
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        try {
            IdentityMapper mapper;
            File dest = this.destDir != null ? this.destDir : this.srcDir;
            int writeCount = 0;
            Object object = mapper = this.mapperElement == null ? new IdentityMapper() : this.mapperElement.getImplementation();
            if (this.srcDir != null) {
                writeCount += this.processDir(this.srcDir, super.getDirectoryScanner(this.srcDir).getIncludedFiles(), dest, (FileNameMapper)mapper);
            }
            for (FileSet fs : this.filesets) {
                writeCount += this.processDir(fs.getDir(this.getProject()), fs.getDirectoryScanner(this.getProject()).getIncludedFiles(), dest, (FileNameMapper)mapper);
            }
            if (writeCount > 0) {
                this.log("Processed " + writeCount + (writeCount == 1 ? " image." : " images."));
            }
        }
        catch (Exception err) {
            this.log(StringUtils.getStackTrace((Throwable)err), 0);
            throw new BuildException(err.getMessage());
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.srcDir == null && this.filesets.isEmpty()) {
            throw new BuildException("Specify at least one source--a srcDir or a fileset.");
        }
        if (this.srcDir == null && this.destDir == null) {
            throw new BuildException("Specify the destDir, or the srcDir.");
        }
        if ("jpg".equalsIgnoreCase(this.str_encoding)) {
            this.str_encoding = "JPEG";
        } else if ("tif".equalsIgnoreCase(this.str_encoding)) {
            this.str_encoding = "TIFF";
        }
    }
}

