/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.RegionReference;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LocalBreaker;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.PositionIterator;

public class StaticContentLayoutManager
extends BlockStackingLayoutManager {
    private RegionReference targetRegion;
    private Block targetBlock;
    private SideRegion regionFO;
    private int contentAreaIPD;
    private int contentAreaBPD = -1;

    public StaticContentLayoutManager(PageSequenceLayoutManager pslm, StaticContent node, SideRegion reg) {
        super(node);
        this.setParent(pslm);
        this.regionFO = reg;
        this.targetRegion = this.getCurrentPV().getRegionReference(this.regionFO.getNameId());
    }

    public StaticContentLayoutManager(PageSequenceLayoutManager pslm, StaticContent node, Block block) {
        super(node);
        this.setParent(pslm);
        this.targetBlock = block;
    }

    @Override
    public List getNextKnuthElements(LayoutContext context, int alignment) {
        throw new IllegalStateException();
    }

    @Override
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.flush();
        this.targetRegion = null;
    }

    @Override
    public void addChildArea(Area childArea) {
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            this.targetBlock.addBlock((Block)childArea);
        } else {
            this.targetRegion.addBlock((Block)childArea);
        }
    }

    @Override
    public Area getParentArea(Area childArea) {
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            return this.targetBlock;
        }
        return this.targetRegion;
    }

    public void doLayout() {
        int targetIPD = 0;
        int targetBPD = 0;
        int targetAlign = 9;
        boolean autoHeight = false;
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            targetIPD = this.targetBlock.getIPD();
            targetBPD = this.targetBlock.getBPD();
            if (targetBPD == 0) {
                autoHeight = true;
            }
            targetAlign = 13;
        } else {
            targetIPD = this.targetRegion.getIPD();
            targetBPD = this.targetRegion.getBPD();
            targetAlign = this.regionFO.getDisplayAlign();
        }
        this.setContentAreaIPD(targetIPD);
        this.setContentAreaBPD(targetBPD);
        StaticContentBreaker breaker = new StaticContentBreaker(this, targetIPD, targetAlign);
        breaker.doLayout(targetBPD, autoHeight);
        if (breaker.isOverflow() && !autoHeight) {
            String page = this.getPSLM().getCurrentPage().getPageViewport().getPageNumberString();
            BlockLevelEventProducer eventProducer = BlockLevelEventProducer.Provider.get(this.getStaticContentFO().getUserAgent().getEventBroadcaster());
            boolean canRecover = this.regionFO.getOverflow() != 42;
            boolean needClip = this.regionFO.getOverflow() == 57 || this.regionFO.getOverflow() == 42;
            eventProducer.staticRegionOverflow(this, this.regionFO.getName(), page, breaker.getOverflowAmount(), needClip, canRecover, this.getStaticContentFO().getLocator());
        }
    }

    protected StaticContent getStaticContentFO() {
        return (StaticContent)this.fobj;
    }

    @Override
    public int getContentAreaIPD() {
        return this.contentAreaIPD;
    }

    @Override
    protected void setContentAreaIPD(int contentAreaIPD) {
        this.contentAreaIPD = contentAreaIPD;
    }

    @Override
    public int getContentAreaBPD() {
        return this.contentAreaBPD;
    }

    private void setContentAreaBPD(int contentAreaBPD) {
        this.contentAreaBPD = contentAreaBPD;
    }

    @Override
    public Keep getKeepTogether() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    private class StaticContentBreaker
    extends LocalBreaker {
        public StaticContentBreaker(StaticContentLayoutManager lm, int ipd, int displayAlign) {
            super(lm, ipd, displayAlign);
        }

        @Override
        protected void observeElementList(List elementList) {
            String elementListID = StaticContentLayoutManager.this.getStaticContentFO().getFlowName();
            String pageSequenceID = ((PageSequence)this.lm.getParent().getFObj()).getId();
            if (pageSequenceID != null && pageSequenceID.length() > 0) {
                elementListID = elementListID + "-" + pageSequenceID;
            }
            ElementListObserver.observe(elementList, "static-content", elementListID);
        }
    }
}

