/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Color;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.entity.AnnotationPropertyComparator;
import org.protege.editor.owl.model.util.LiteralChecker;
import org.protege.editor.owl.ui.list.AbstractAnnotationsList;
import org.protege.editor.owl.ui.renderer.AnnotationRenderingStyle;
import org.protege.editor.owl.ui.renderer.ISBN10LinkExtractor;
import org.protege.editor.owl.ui.renderer.InlineAnnotationRendering;
import org.protege.editor.owl.ui.renderer.InlineDatatypeRendering;
import org.protege.editor.owl.ui.renderer.InlineThumbnailRendering;
import org.protege.editor.owl.ui.renderer.LinkExtractor;
import org.protege.editor.owl.ui.renderer.PubMedLinkExtractor;
import org.protege.editor.owl.ui.renderer.WikipediaLinkExtractor;
import org.protege.editor.owl.ui.renderer.layout.HTTPLink;
import org.protege.editor.owl.ui.renderer.layout.IconBox;
import org.protege.editor.owl.ui.renderer.layout.Link;
import org.protege.editor.owl.ui.renderer.layout.LinkSpan;
import org.protege.editor.owl.ui.renderer.layout.OWLEntityLink;
import org.protege.editor.owl.ui.renderer.layout.Page;
import org.protege.editor.owl.ui.renderer.layout.PageCellRenderer;
import org.protege.editor.owl.ui.renderer.layout.Paragraph;
import org.protege.editor.owl.ui.renderer.layout.Span;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.EscapeUtils;

public class OWLAnnotationCellRenderer2
extends PageCellRenderer {
    public static final Color ANNOTATION_PROPERTY_FOREGROUND = new Color(65, 108, 226);
    private OWLEditorKit editorKit;
    private Pattern URL_PATTERN = Pattern.compile("\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\\b");
    private OWLOntology ontology;
    private InlineAnnotationRendering inlineAnnotationRendering = InlineAnnotationRendering.RENDER_COMPOUND_ANNOTATIONS_INLINE;
    private InlineDatatypeRendering datatypeRendering = InlineDatatypeRendering.RENDER_DATATYPE_INLINE;
    private AnnotationRenderingStyle annotationRenderingStyle = AnnotationRenderingStyle.COMFORTABLE;
    private InlineThumbnailRendering thumbnailRendering = InlineThumbnailRendering.DISPLAY_THUMBNAILS_INLINE;
    private final List<LinkExtractor> linkExtractors = Arrays.asList(PubMedLinkExtractor.createExtractor(), ISBN10LinkExtractor.createExtractor(), WikipediaLinkExtractor.createExtractor());

    public OWLAnnotationCellRenderer2(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
    }

    public void setInlineAnnotationRendering(InlineAnnotationRendering inlineAnnotationRendering) {
        if (this.inlineAnnotationRendering != inlineAnnotationRendering) {
            this.inlineAnnotationRendering = inlineAnnotationRendering;
            this.invalidateCache();
        }
    }

    public void setInlineDatatypeRendering(InlineDatatypeRendering datatypeRendering) {
        if (this.datatypeRendering != datatypeRendering) {
            this.datatypeRendering = datatypeRendering;
            this.invalidateCache();
        }
    }

    public void setAnnotationRenderingStyle(AnnotationRenderingStyle annotationRenderingStyle) {
        if (this.annotationRenderingStyle != annotationRenderingStyle) {
            this.annotationRenderingStyle = annotationRenderingStyle;
            this.invalidateCache();
        }
    }

    public void setReferenceOntology(OWLOntology ontology) {
        this.ontology = ontology;
    }

    public void clearReferenceOntology() {
        this.ontology = null;
    }

    public boolean isReferenceOntologyActive() {
        return this.ontology != null && this.ontology.equals(this.editorKit.getOWLModelManager().getActiveOntology());
    }

    @Override
    protected Object getValueKey(Object value) {
        OWLAnnotation annotation = null;
        if (value instanceof OWLAnnotationAssertionAxiom) {
            OWLAnnotationAssertionAxiom axiom = (OWLAnnotationAssertionAxiom)value;
            if (axiom.getAnnotations().isEmpty()) {
                return axiom.getAnnotation();
            }
            return axiom;
        }
        if (value instanceof AbstractAnnotationsList.AnnotationsListItem) {
            annotation = ((AbstractAnnotationsList.AnnotationsListItem)value).getAnnotation();
        } else if (value instanceof OWLAnnotation) {
            annotation = (OWLAnnotation)value;
        }
        return annotation;
    }

    @Override
    protected void fillPage(Page page, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color foreground = isSelected ? table.getSelectionForeground() : table.getForeground();
        Color background = isSelected ? table.getSelectionBackground() : table.getBackground();
        this.renderCellValue(page, value, foreground, background, isSelected);
    }

    @Override
    protected int getMaxAvailablePageWidth(Page page, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return table.getColumnModel().getColumn(column).getWidth();
    }

    @Override
    protected void fillPage(Page page, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color foreground = isSelected ? list.getSelectionForeground() : list.getForeground();
        Color background = isSelected ? list.getSelectionBackground() : list.getBackground();
        this.renderCellValue(page, value, foreground, background, isSelected);
    }

    @Override
    protected int getMaxAvailablePageWidth(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Insets insets = list.getInsets();
        int componentWidth = list.getWidth();
        JViewport vp = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, list);
        if (vp != null) {
            componentWidth = vp.getViewRect().width;
        }
        return componentWidth - list.getInsets().left - list.getInsets().right - insets.left + insets.right - 20;
    }

    private void renderCellValue(Page page, Object value, Color foreground, Color background, boolean isSelected) {
        OWLAnnotation annotation = this.extractOWLAnnotationFromCellValue(value);
        if (annotation != null) {
            this.renderAnnotationProperty(page, annotation, foreground, background, isSelected);
            this.renderAnnotationValue(page, annotation, foreground, background, isSelected);
            if (this.inlineAnnotationRendering == InlineAnnotationRendering.RENDER_COMPOUND_ANNOTATIONS_INLINE && value instanceof HasAnnotations) {
                Page subAnnotationPage = new Page();
                for (OWLAnnotation anno : ((HasAnnotations)value).getAnnotations()) {
                    this.renderCellValue(subAnnotationPage, anno, foreground, background, isSelected);
                }
                subAnnotationPage.setMarginLeft(40);
                subAnnotationPage.setOpacity(0.6);
                page.add(subAnnotationPage);
            }
        }
        switch (this.annotationRenderingStyle) {
            case COMFORTABLE: {
                page.setMargin(2);
                page.setMarginBottom(6);
                break;
            }
            case COSY: {
                page.setMargin(1);
                page.setMarginBottom(3);
                break;
            }
            case COMPACT: {
                page.setMargin(0);
                page.setMarginBottom(1);
            }
        }
    }

    protected OWLAnnotation extractOWLAnnotationFromCellValue(Object value) {
        OWLAnnotation annotation = null;
        if (value instanceof OWLAnnotationAssertionAxiom) {
            annotation = ((OWLAnnotationAssertionAxiom)value).getAnnotation();
        } else if (value instanceof AbstractAnnotationsList.AnnotationsListItem) {
            annotation = ((AbstractAnnotationsList.AnnotationsListItem)value).getAnnotation();
        } else if (value instanceof OWLAnnotation) {
            annotation = (OWLAnnotation)value;
        }
        return annotation;
    }

    private void applyGlobalFormattingToAnnotationValueParagraphs(List<Paragraph> valueRenderingParagraphs) {
        for (Paragraph paragraph : valueRenderingParagraphs) {
            paragraph.setTabCount(0);
            paragraph.setMarginBottom(2);
        }
    }

    private Paragraph renderAnnotationProperty(Page page, OWLAnnotation annotation, Color defaultForeground, Color defaultBackground, boolean isSelected) {
        OWLAnnotationProperty property = annotation.getProperty();
        String rendering = this.editorKit.getOWLModelManager().getRendering((OWLObject)property);
        Paragraph paragraph = page.addParagraph(rendering);
        Color foreground = this.getAnnotationPropertyForeground(defaultForeground, isSelected);
        paragraph.setForeground(foreground);
        if (annotation.getValue() instanceof OWLLiteral) {
            OWLLiteral literalValue = (OWLLiteral)annotation.getValue();
            paragraph.append("    ", foreground);
            this.appendTag(paragraph, literalValue, foreground, isSelected);
        }
        switch (this.annotationRenderingStyle) {
            case COMFORTABLE: {
                paragraph.setMarginBottom(4);
                break;
            }
            case COSY: {
                paragraph.setMarginBottom(2);
                break;
            }
            case COMPACT: {
                paragraph.setMarginBottom(1);
            }
        }
        return paragraph;
    }

    private Color getAnnotationPropertyForeground(Color defaultForeground, boolean isSelected) {
        return isSelected ? defaultForeground : ANNOTATION_PROPERTY_FOREGROUND;
    }

    private List<Paragraph> renderAnnotationValue(final Page page, OWLAnnotation annotation, final Color defaultForeground, final Color defaultBackground, final boolean isSelected) {
        OWLAnnotationValue annotationValue = annotation.getValue();
        List paragraphs = (List)annotationValue.accept((OWLAnnotationValueVisitorEx)new OWLAnnotationValueVisitorEx<List<Paragraph>>(){

            public List<Paragraph> visit(IRI iri) {
                return OWLAnnotationCellRenderer2.this.renderIRI(page, iri, defaultForeground, defaultBackground, isSelected, OWLAnnotationCellRenderer2.this.hasFocus());
            }

            public List<Paragraph> visit(OWLAnonymousIndividual individual) {
                return OWLAnnotationCellRenderer2.this.renderAnonymousIndividual(page, individual, defaultForeground, defaultBackground, isSelected);
            }

            public List<Paragraph> visit(OWLLiteral literal) {
                boolean inLexicalSpace = LiteralChecker.isLiteralIsInLexicalSpace(literal);
                Color foreground = defaultForeground;
                if (!inLexicalSpace) {
                    foreground = Color.RED;
                }
                return OWLAnnotationCellRenderer2.this.renderLiteral(page, literal, foreground, defaultBackground, isSelected);
            }
        });
        this.applyGlobalFormattingToAnnotationValueParagraphs(paragraphs);
        return paragraphs;
    }

    private List<Paragraph> renderIRI(Page page, IRI iri, Color defaultForeground, Color defaultBackgound, boolean isSelected, boolean hasFocus) {
        OWLModelManager modelManager = this.editorKit.getOWLModelManager();
        Set<OWLEntity> entities = modelManager.getOWLEntityFinder().getEntities(iri);
        List<Paragraph> paragraphs = entities.isEmpty() ? this.renderExternalIRI(page, iri) : this.renderEntities(page, entities);
        return paragraphs;
    }

    private boolean isLinkableAddress(IRI iri) {
        String scheme = iri.getScheme();
        return scheme != null && scheme.startsWith("http");
    }

    private List<Paragraph> renderExternalIRI(Page page, IRI iri) {
        ArrayList<Paragraph> paragraphs;
        block7: {
            paragraphs = new ArrayList<Paragraph>();
            String iriString = iri.toString();
            if (this.isLinkableAddress(iri)) {
                try {
                    if (this.isImageAddress(iri) && this.isDisplayThumbnails()) {
                        IconBox iconBox = this.getImageBox(iri);
                        page.add(iconBox);
                        break block7;
                    }
                    paragraphs.add(page.addParagraph(iriString, new HTTPLink(iri.toURI())));
                }
                catch (IllegalArgumentException | MalformedURLException e) {
                    paragraphs.add(page.addParagraph(iriString));
                }
            } else {
                Optional<Link> link = this.extractLink(iriString);
                if (link.isPresent()) {
                    paragraphs.add(page.addParagraph(iriString, link.get()));
                } else {
                    paragraphs.add(page.addParagraph(iriString));
                }
            }
        }
        return paragraphs;
    }

    private Optional<Link> extractLink(String iriString) {
        for (LinkExtractor extractor : this.linkExtractors) {
            Optional<Link> link = extractor.extractLink(iriString);
            if (!link.isPresent()) continue;
            return link;
        }
        return Optional.empty();
    }

    private boolean isDisplayThumbnails() {
        return this.thumbnailRendering != InlineThumbnailRendering.DO_NOT_DISPLAY_THUMBNAILS_INLINE;
    }

    public void setThumbnailRendering(InlineThumbnailRendering thumbnailRendering) {
        this.thumbnailRendering = thumbnailRendering;
        this.invalidateCache();
    }

    private IconBox getImageBox(IRI iri) throws MalformedURLException, IllegalArgumentException {
        ImageIcon imageIcon = new ImageIcon(iri.toURI().toURL());
        imageIcon.getImageLoadStatus();
        IconBox iconBox = new IconBox(imageIcon, new HTTPLink(iri.toURI()));
        iconBox.setMaxHeight(50);
        return iconBox;
    }

    private boolean isImageAddress(IRI iri) {
        String iriString = iri.toString().toLowerCase();
        return iriString.endsWith(".png") || iriString.endsWith(".jpg") || iriString.endsWith(".jpeg") || iriString.endsWith(".gif");
    }

    private List<Paragraph> renderEntities(Page page, Set<OWLEntity> entities) {
        ArrayList<Paragraph> paragraphs = new ArrayList<Paragraph>();
        for (OWLEntity entity : entities) {
            Icon icon = this.getIcon((OWLObject)entity);
            OWLModelManager modelManager = this.editorKit.getOWLModelManager();
            String entityRendering = modelManager.getRendering((OWLObject)entity);
            String paraText = entityRendering.isEmpty() ? entity.getIRI().toString() : entityRendering;
            Paragraph paragraph = new Paragraph(paraText, new OWLEntityLink(this.editorKit, entity));
            paragraph.setIcon(icon);
            page.add(paragraph);
            paragraphs.add(paragraph);
        }
        return paragraphs;
    }

    private Icon getIcon(OWLObject entity) {
        return this.editorKit.getOWLWorkspace().getOWLIconProvider().getIcon(entity);
    }

    private List<Paragraph> renderLiteral(Page page, OWLLiteral literal, Color foreground, Color background, boolean isSelected) {
        if (this.isLiteralRenderableAsIRI(literal)) {
            return this.renderIRI(page, IRI.create((String)literal.getLiteral()), foreground, background, isSelected, this.hasFocus());
        }
        String rendering = EscapeUtils.unescapeString((String)literal.getLiteral()).trim();
        ArrayList<Paragraph> result = new ArrayList<Paragraph>();
        if (rendering.length() > 0) {
            List<LinkSpan> linkSpans = this.extractLinks(rendering);
            Paragraph literalParagraph = new Paragraph(rendering, linkSpans);
            literalParagraph.setForeground(foreground);
            page.add(literalParagraph);
            result.add(literalParagraph);
            Paragraph tagParagraph = literalParagraph;
            tagParagraph.append("    ", foreground);
            page.add(tagParagraph);
            result.add(tagParagraph);
            tagParagraph.setMarginTop(2);
            tagParagraph.setTabCount(2);
        }
        return result;
    }

    private boolean isLiteralRenderableAsIRI(OWLLiteral literal) {
        String candidateIri = literal.getLiteral();
        if (candidateIri.contains(" ")) {
            return false;
        }
        if (candidateIri.startsWith("http://")) {
            return true;
        }
        if (candidateIri.startsWith("https://")) {
            return true;
        }
        for (LinkExtractor extractor : this.linkExtractors) {
            if (!extractor.extractLink(candidateIri).isPresent()) continue;
            return true;
        }
        return false;
    }

    private void appendTag(Paragraph tagParagraph, OWLLiteral literal, Color foreground, boolean isSelected) {
        Color tagValueColor;
        Color tagColor = isSelected ? foreground : Color.GRAY;
        Color color = tagValueColor = isSelected ? foreground : Color.GRAY;
        if (literal.hasLang()) {
            tagParagraph.append("[language: ", tagColor);
            tagParagraph.append(literal.getLang(), tagValueColor);
            tagParagraph.append("]", tagColor);
        } else if (this.datatypeRendering == InlineDatatypeRendering.RENDER_DATATYPE_INLINE && !literal.isRDFPlainLiteral()) {
            tagParagraph.append("[type: ", tagColor);
            tagParagraph.append(this.editorKit.getOWLModelManager().getRendering((OWLObject)literal.getDatatype()), tagValueColor);
            tagParagraph.append("]", tagColor);
        }
    }

    private List<LinkSpan> extractLinks(String s) {
        Matcher matcher = this.URL_PATTERN.matcher(s);
        ArrayList<LinkSpan> result = new ArrayList<LinkSpan>();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String url = s.substring(start, end);
            try {
                result.add(new LinkSpan(new HTTPLink(new URI(url)), new Span(start, end)));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private List<Paragraph> renderAnonymousIndividual(Page page, OWLAnonymousIndividual individual, Color foreground, Color background, boolean selected) {
        OWLModelManager modelManager = this.editorKit.getOWLModelManager();
        page.addParagraph("[", foreground).setOpacity(0.6);
        Page typesPage = new Page();
        page.add(typesPage);
        typesPage.setMarginLeft(40);
        typesPage.setMarginBottom(7);
        Comparator<OWLObject> c = this.editorKit.getModelManager().getOWLObjectComparator();
        OWLOntology ont = modelManager.getActiveOntology();
        ont.getClassAssertionAxioms((OWLIndividual)individual).stream().filter(ax -> !ax.getClassExpression().isAnonymous()).map(ax -> ax.getClassExpression().asOWLClass()).sorted(c).forEach(cls -> this.renderEntities(typesPage, Collections.singleton(cls)));
        AnnotationPropertyComparator propertyComparator = AnnotationPropertyComparator.withDefaultOrdering(c);
        Comparator<OWLObject> valueComparator = this.editorKit.getOWLModelManager().getOWLObjectComparator();
        Comparator<OWLAnnotationAssertionAxiom> annotationAssertionAxiomComparator = Comparator.comparing(OWLAnnotationAssertionAxiom::getProperty, propertyComparator).thenComparing(OWLAnnotationAssertionAxiom::getValue, valueComparator);
        ont.getAnnotationAssertionAxioms((OWLAnnotationSubject)individual).stream().sorted(annotationAssertionAxiomComparator).forEach(ax -> {
            Page annotationsPage = new Page();
            this.renderCellValue(annotationsPage, ax.getAnnotation(), foreground, background, selected);
            page.add(annotationsPage);
            annotationsPage.setMarginLeft(40);
        });
        page.addParagraph("]", foreground).setOpacity(0.6);
        return Collections.emptyList();
    }
}

